/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.eventhandler.Event;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.shadowmage.ancientwarfare.core.api.ModuleStatus;
import net.shadowmage.ancientwarfare.core.config.AWLog;
import net.shadowmage.ancientwarfare.core.util.StringTools;
import net.shadowmage.ancientwarfare.structure.api.IStructurePluginLookup;
import net.shadowmage.ancientwarfare.structure.api.IStructurePluginManager;
import net.shadowmage.ancientwarfare.structure.api.StructureContentPlugin;
import net.shadowmage.ancientwarfare.structure.api.StructurePluginRegistrationEvent;
import net.shadowmage.ancientwarfare.structure.api.TemplateParsingException;
import net.shadowmage.ancientwarfare.structure.api.TemplateRule;
import net.shadowmage.ancientwarfare.structure.api.TemplateRuleBlock;
import net.shadowmage.ancientwarfare.structure.api.TemplateRuleEntity;
import net.shadowmage.ancientwarfare.structure.template.load.TemplateParser;
import net.shadowmage.ancientwarfare.structure.template.plugin.default_plugins.StructurePluginModDefault;
import net.shadowmage.ancientwarfare.structure.template.plugin.default_plugins.StructurePluginVanillaHandler;

public class StructurePluginManager
implements IStructurePluginManager,
IStructurePluginLookup {
    private final List<StructureContentPlugin> loadedContentPlugins = new ArrayList<StructureContentPlugin>();
    private final HashMap<Class<? extends Entity>, Class<? extends TemplateRuleEntity>> entityRules = new HashMap();
    private final HashMap<Block, Class<? extends TemplateRuleBlock>> blockRules = new HashMap();
    private final HashMap<Class<? extends TemplateRule>, String> idByRuleClass = new HashMap();
    private final HashMap<String, Class<? extends TemplateRule>> ruleByID = new HashMap();
    private final HashMap<Block, String> pluginByBlock = new HashMap();
    public static final StructurePluginManager INSTANCE = new StructurePluginManager();

    private StructurePluginManager() {
    }

    public void loadPlugins() {
        this.addPlugin(new StructurePluginVanillaHandler());
        for (ModContainer container : Loader.instance().getActiveModList()) {
            if (this.isDefaultMods(container.getModId()) || MinecraftForge.EVENT_BUS.post((Event)new StructurePluginRegistrationEvent(this, container.getModId()))) continue;
            this.addPlugin(new StructurePluginModDefault(container.getModId()));
        }
        if (ModuleStatus.npcsLoaded) {
            this.loadNpcPlugin();
        }
        if (ModuleStatus.vehiclesLoaded) {
            this.loadVehiclePlugin();
        }
        if (ModuleStatus.automationLoaded) {
            this.loadAutomationPlugin();
        }
        for (StructureContentPlugin plugin : this.loadedContentPlugins) {
            plugin.addHandledBlocks(this);
            plugin.addHandledEntities(this);
        }
    }

    private boolean isDefaultMods(String modid) {
        return modid.equals("mcp") || modid.equals("FML") || modid.equals("Forge") || modid.startsWith("AncientWarfare");
    }

    private void loadNpcPlugin() {
        try {
            Object e;
            Class<?> clz = Class.forName("net.shadowmage.ancientwarfare.structure.template.plugin.default_plugins.StructurePluginNpcs");
            if (clz != null && (e = clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])) instanceof StructureContentPlugin) {
                this.addPlugin((StructureContentPlugin)e);
                AWLog.log("Loaded NPC Module Structure Plugin");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadVehiclePlugin() {
        try {
            Object e;
            Class<?> clz = Class.forName("net.shadowmage.ancientwarfare.structure.template.plugin.default_plugins.StructurePluginVehicles");
            if (clz != null && (e = clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])) instanceof StructureContentPlugin) {
                this.addPlugin((StructureContentPlugin)e);
                AWLog.log("Loaded Vehicle Module Structure Plugin");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadAutomationPlugin() {
        try {
            Object e;
            Class<?> clz = Class.forName("net.shadowmage.ancientwarfare.structure.template.plugin.default_plugins.StructurePluginAutomation");
            if (clz != null && (e = clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])) instanceof StructureContentPlugin) {
                this.addPlugin((StructureContentPlugin)e);
                AWLog.log("Loaded Automation Module Structure Plugin");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addPlugin(StructureContentPlugin plugin) {
        this.loadedContentPlugins.add(plugin);
    }

    public String getPluginNameFor(Block block) {
        return this.pluginByBlock.get(block);
    }

    @Override
    public String getPluginNameFor(Class<? extends TemplateRule> ruleClass) {
        return this.idByRuleClass.get(ruleClass);
    }

    public Class<? extends TemplateRule> getRuleByName(String name) {
        return this.ruleByID.get(name);
    }

    public TemplateRuleBlock getRuleForBlock(World world, Block block, int turns, int x, int y, int z) {
        Class<? extends TemplateRuleBlock> clz = this.blockRules.get(block);
        if (clz != null) {
            int meta = world.func_72805_g(x, y, z);
            try {
                return clz.getConstructor(World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Block.class, Integer.TYPE, Integer.TYPE).newInstance(world, x, y, z, block, meta, turns);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public TemplateRuleEntity getRuleForEntity(World world, Entity entity, int turns, int x, int y, int z) {
        Class<? extends TemplateRuleEntity> entityRuleClass;
        Class<?> entityClass = entity.getClass();
        if (this.entityRules.containsKey(entityClass) && (entityRuleClass = this.entityRules.get(entityClass)) != null) {
            try {
                return entityRuleClass.getConstructor(World.class, Entity.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE).newInstance(world, entity, turns, x, y, z);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public void registerEntityHandler(String pluginName, Class<? extends Entity> entityClass, Class<? extends TemplateRuleEntity> ruleClass) {
        if (this.ruleByID.containsKey(pluginName)) {
            if (!this.ruleByID.get(pluginName).equals(ruleClass)) {
                Class<? extends TemplateRule> clz = this.ruleByID.get(pluginName);
                throw new IllegalArgumentException("Attempt to overwrite " + clz + " with " + ruleClass + " by " + pluginName + " for entityClass: " + entityClass);
            }
        } else {
            this.ruleByID.put(pluginName, ruleClass);
        }
        this.entityRules.put(entityClass, ruleClass);
        if (!this.idByRuleClass.containsKey(ruleClass)) {
            this.idByRuleClass.put(ruleClass, pluginName);
        }
    }

    @Override
    public void registerBlockHandler(String pluginName, Block block, Class<? extends TemplateRuleBlock> ruleClass) {
        if (this.ruleByID.containsKey(pluginName)) {
            if (!this.ruleByID.get(pluginName).equals(ruleClass)) {
                Class<? extends TemplateRule> clz = this.ruleByID.get(pluginName);
                throw new IllegalArgumentException("Attempt to overwrite " + clz + " with " + ruleClass + " by " + pluginName + " for block: " + block);
            }
        } else {
            this.ruleByID.put(pluginName, ruleClass);
        }
        if (this.idByRuleClass.containsKey(ruleClass)) {
            this.pluginByBlock.put(block, this.idByRuleClass.get(ruleClass));
        } else {
            this.idByRuleClass.put(ruleClass, pluginName);
            this.pluginByBlock.put(block, pluginName);
        }
        this.blockRules.put(block, ruleClass);
    }

    @Override
    public void registerPlugin(StructureContentPlugin plugin) {
        this.addPlugin(plugin);
    }

    public static final TemplateRule getRule(List<String> ruleData, String ruleType) throws TemplateParsingException.TemplateRuleParsingException {
        Class<? extends TemplateRule> clz;
        Iterator<String> it = ruleData.iterator();
        String name = null;
        int ruleNumber = -1;
        ArrayList<String> ruleDataPackage = new ArrayList<String>();
        while (it.hasNext()) {
            ++TemplateParser.lineNumber;
            String line = it.next();
            if (line.startsWith(ruleType + ":")) continue;
            if (line.startsWith(":end" + ruleType)) break;
            if (line.startsWith("plugin=")) {
                name = StringTools.safeParseString("=", line);
            }
            if (line.startsWith("number=")) {
                ruleNumber = StringTools.safeParseInt("=", line);
            }
            if (!line.startsWith("data:")) continue;
            while (it.hasNext() && !(line = it.next()).startsWith(":enddata")) {
                ruleDataPackage.add(line);
            }
        }
        if ((clz = INSTANCE.getRuleByName(name)) == null) {
            throw new TemplateParsingException.TemplateRuleParsingException("Not enough data to create template rule.\nMissing plugin for name: " + name + "\n" + "name: " + name + "\n" + "number:" + ruleNumber + "\n" + "ruleDataPackage.size:" + ruleDataPackage.size() + "\n");
        }
        if (name == null || ruleNumber < 0 || ruleDataPackage.isEmpty()) {
            throw new TemplateParsingException.TemplateRuleParsingException("Not enough data to create template rule.\nname: " + name + "\n" + "number:" + ruleNumber + "\n" + "ruleDataPackage.size:" + ruleDataPackage.size() + "\n" + "ruleClass: " + clz);
        }
        try {
            TemplateRule rule = clz.getConstructor(new Class[0]).newInstance(new Object[0]);
            rule.parseRule(ruleNumber, ruleDataPackage);
            return rule;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final void writeRuleLines(TemplateRule rule, BufferedWriter out, String ruleType) throws IOException {
        if (rule == null) {
            return;
        }
        String id = INSTANCE.getPluginNameFor(rule.getClass());
        if (id == null) {
            return;
        }
        out.write(ruleType + ":");
        out.newLine();
        out.write("plugin=" + id);
        out.newLine();
        out.write("number=" + rule.ruleNumber);
        out.newLine();
        out.write("data:");
        out.newLine();
        rule.writeRule(out);
        out.write(":enddata");
        out.newLine();
        out.write(":end" + ruleType);
        out.newLine();
        out.newLine();
    }
}

