/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.gui;

import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.StatCollector;
import net.minecraft.world.biome.BiomeGenBase;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.Listener;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.Checkbox;
import net.shadowmage.ancientwarfare.core.gui.elements.CompositeScrolled;
import net.shadowmage.ancientwarfare.core.gui.elements.GuiElement;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import net.shadowmage.ancientwarfare.core.gui.elements.Text;
import net.shadowmage.ancientwarfare.structure.config.AWStructureStatics;
import net.shadowmage.ancientwarfare.structure.gui.GuiStructureScanner;

public class GuiStructureBiomeSelection
extends GuiContainerBase {
    private final GuiStructureScanner parent;
    private Checkbox whiteList;
    private Text searchBox;
    private CompositeScrolled area;
    private Listener listener;

    public GuiStructureBiomeSelection(GuiStructureScanner parent) {
        super((ContainerBase)((Object)parent.getContainer()));
        this.parent = parent;
        this.shouldCloseOnVanillaKeys = false;
    }

    @Override
    public void initElements() {
        this.addGuiElement(new Label(8, 8, StatCollector.func_74838_a((String)"guistrings.select_biomes") + ":"));
        this.whiteList = new Checkbox(8, 20, 16, 16, "guistrings.biome_whitelist"){

            @Override
            public void onToggled() {
                ((GuiStructureBiomeSelection)GuiStructureBiomeSelection.this).parent.validator.setBiomeWhiteList(this.checked());
            }
        };
        this.whiteList.setChecked(this.parent.validator.isBiomeWhiteList());
        this.addGuiElement(this.whiteList);
        this.searchBox = new Text(80, 8, 170, "", this){

            @Override
            protected void handleKeyInput(int keyCode, char ch) {
                String old = this.getText();
                super.handleKeyInput(keyCode, ch);
                String text = this.getText();
                if (!text.equals(old)) {
                    GuiStructureBiomeSelection.this.refreshGui();
                }
            }
        };
        this.addGuiElement(this.searchBox);
        this.area = new CompositeScrolled(this, 0, 40, 256, 200);
        this.addGuiElement(this.area);
        Button button = new Button(193, 20, 55, 12, "guistrings.done"){

            @Override
            protected void onPressed() {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)GuiStructureBiomeSelection.this.parent);
            }
        };
        this.addGuiElement(button);
        this.listener = new Listener(4){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                if (widget.isMouseOverElement(evt.mx, evt.my)) {
                    Set<String> biomeNames = ((GuiStructureBiomeSelection)GuiStructureBiomeSelection.this).parent.validator.getBiomeList();
                    if (((BiomeCheck)widget).checked()) {
                        biomeNames.add(((BiomeCheck)widget).name);
                    } else {
                        biomeNames.remove(((BiomeCheck)widget).name);
                    }
                    ((GuiStructureBiomeSelection)GuiStructureBiomeSelection.this).parent.validator.setBiomeList(biomeNames);
                }
                return true;
            }
        };
        this.refreshBiomeList();
    }

    private void refreshBiomeList() {
        int totalHeight = 3;
        Set<String> biomeNames = this.parent.validator.getBiomeList();
        this.area.clearElements();
        for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
            String name;
            if (biome == null || !(name = AWStructureStatics.getBiomeName(biome)).contains(this.searchBox.getText())) continue;
            BiomeCheck box = new BiomeCheck(totalHeight, name);
            this.area.addGuiElement(box);
            totalHeight += 16;
            if (biomeNames.contains(name)) {
                box.setChecked(true);
            }
            box.addNewListener(this.listener);
        }
        this.area.setAreaSize(totalHeight);
    }

    @Override
    public void setupElements() {
        this.whiteList.setChecked(this.parent.validator.isBiomeWhiteList());
        this.refreshBiomeList();
    }

    private class BiomeCheck
    extends Checkbox {
        private final String name;

        public BiomeCheck(int topLeftY, String label) {
            super(8, topLeftY, 16, 16, label);
            this.name = label;
        }
    }
}

