/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.gui;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ModContainer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.EntityList;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.CompositeScrolled;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import net.shadowmage.ancientwarfare.core.gui.elements.Text;
import net.shadowmage.ancientwarfare.core.gui.elements.Tooltip;
import net.shadowmage.ancientwarfare.structure.config.AWStructureStatics;
import net.shadowmage.ancientwarfare.structure.tile.SpawnerSettings;

public class GuiSpawnerAdvancedEntitySelection
extends GuiContainerBase {
    private final GuiContainerBase parent;
    private final SpawnerSettings.EntitySpawnSettings settings;
    private CompositeScrolled area;
    private Label selectionLabel;
    private Text search;

    public GuiSpawnerAdvancedEntitySelection(GuiContainerBase parent, SpawnerSettings.EntitySpawnSettings settings) {
        super((ContainerBase)((Object)parent.getContainer()));
        this.parent = parent;
        this.settings = settings;
    }

    @Override
    protected boolean onGuiCloseRequested() {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)this.parent);
        return false;
    }

    @Override
    public void initElements() {
        this.area = new CompositeScrolled(this, 0, 42, 256, 200);
        this.addGuiElement(this.area);
        Label label = new Label(8, 6, "guistrings.spawner.select_entity");
        this.addGuiElement(label);
        Button button = new Button(this.field_146999_f - 8 - 55, 6, 55, 12, "guistrings.done"){

            @Override
            protected void onPressed() {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)GuiSpawnerAdvancedEntitySelection.this.parent);
            }
        };
        this.addGuiElement(button);
        this.selectionLabel = new Label(8, 18, this.settings.getEntityName());
        this.addGuiElement(this.selectionLabel);
        this.search = new Text(8, 30, 240, "", this){

            @Override
            protected void handleKeyInput(int keyCode, char ch) {
                String old = this.getText();
                super.handleKeyInput(keyCode, ch);
                String text = this.getText();
                if (!text.equals(old)) {
                    GuiSpawnerAdvancedEntitySelection.this.refreshGui();
                }
            }
        };
        this.addGuiElement(this.search);
    }

    @Override
    public void setupElements() {
        this.area.clearElements();
        UnmodifiableIterator itr = Iterators.filter(EntityList.field_75625_b.keySet().iterator(), (Predicate)new Predicate<String>(){

            public boolean apply(String txt) {
                if (txt == null || txt.isEmpty() || AWStructureStatics.excludedSpawnerEntities.contains(txt)) {
                    return false;
                }
                return GuiSpawnerAdvancedEntitySelection.this.search.getText().isEmpty() || txt.contains(GuiSpawnerAdvancedEntitySelection.this.search.getText());
            }
        });
        int totalHeight = 8;
        while (itr.hasNext()) {
            ModContainer modContainer;
            final String name = itr.next().toString();
            Button button = new Button(8, totalHeight, 232, 12, "entity." + name + ".name"){

                @Override
                protected void onPressed() {
                    GuiSpawnerAdvancedEntitySelection.this.settings.setEntityToSpawn(name);
                    GuiSpawnerAdvancedEntitySelection.this.selectionLabel.setText(GuiSpawnerAdvancedEntitySelection.this.settings.getEntityName());
                    GuiSpawnerAdvancedEntitySelection.this.refreshGui();
                }
            };
            String mod = "Minecraft";
            String[] temp = name.split("\\.", 2);
            if (temp.length > 1 && (modContainer = FMLCommonHandler.instance().findContainerFor((Object)temp[0])) != null) {
                mod = modContainer.getName();
            }
            Tooltip tip = new Tooltip(50, 20);
            tip.addTooltipElement(new Label(0, 0, mod));
            if (temp.length > 1) {
                tip.addTooltipElement(new Label(0, 10, temp[1]));
            } else {
                tip.addTooltipElement(new Label(0, 10, name));
            }
            button.setTooltip(tip);
            this.area.addGuiElement(button);
            totalHeight += 12;
        }
        this.area.setAreaSize(totalHeight);
    }
}

