/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.gates.types;

import cpw.mods.fml.common.ObfuscationReflectionHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.world.IBlockAccess;
import net.shadowmage.ancientwarfare.core.api.AWBlocks;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.structure.entity.EntityGate;
import net.shadowmage.ancientwarfare.structure.entity.RotateBoundingBox;
import net.shadowmage.ancientwarfare.structure.gates.types.Gate;

public class GateRotatingBridge
extends Gate {
    public GateRotatingBridge(int id, String tex) {
        super(id, tex);
        this.setName("gateDrawbridge");
        this.moveSpeed = 1.0f;
        this.canSoldierInteract = false;
        this.setIcon("gateWoodRotating");
    }

    @Override
    public void setCollisionBoundingBox(EntityGate gate) {
        if (gate.pos1 == null || gate.pos2 == null) {
            return;
        }
        BlockPosition min = BlockTools.getMin(gate.pos1, gate.pos2);
        BlockPosition max = BlockTools.getMax(gate.pos1, gate.pos2);
        if (gate.edgePosition == 0.0f) {
            gate.field_70121_D.func_72324_b((double)min.x, (double)min.y, (double)min.z, (double)(max.x + 1), (double)(max.y + 1), (double)(max.z + 1));
        } else if (gate.edgePosition < gate.edgeMax) {
            if (!(gate.field_70121_D instanceof RotateBoundingBox)) {
                try {
                    ObfuscationReflectionHelper.setPrivateValue(Entity.class, (Object)gate, (Object)((Object)new RotateBoundingBox(gate.gateOrientation, min, max.offset(1, 1, 1))), (String[])new String[]{"boundingBox", "field_70121_D"});
                }
                catch (Exception ignored) {
                    ignored.printStackTrace();
                }
            }
            if (gate.field_70121_D instanceof RotateBoundingBox) {
                ((RotateBoundingBox)gate.field_70121_D).rotate((float)gate.getOpeningStatus() * this.getMoveSpeed());
            }
        } else {
            int heightAdj = max.y - min.y;
            BlockPosition pos3 = max.moveUp(-heightAdj).moveForward(gate.gateOrientation, heightAdj);
            max = BlockTools.getMax(min, pos3).offset(1, 1, 1);
            min = BlockTools.getMin(min, pos3);
            gate.field_70121_D.func_72324_b((double)min.x, (double)min.y, (double)min.z, (double)max.x, (double)max.y, (double)max.z);
        }
    }

    @Override
    public boolean canActivate(EntityGate gate, boolean open) {
        if (gate.pos1 == null || gate.pos2 == null) {
            return false;
        }
        if (!open) {
            return super.canActivate(gate, false);
        }
        BlockPosition min = BlockTools.getMin(gate.pos1, gate.pos2);
        BlockPosition max = BlockTools.getMax(gate.pos1, gate.pos2);
        int heightAdj = max.y - min.y;
        BlockPosition pos3 = max.moveUp(-heightAdj).moveForward(gate.gateOrientation, heightAdj);
        max = BlockTools.getMax(min, pos3);
        min = BlockTools.getMin(min, pos3);
        for (int x = min.x; x <= max.x; ++x) {
            for (int z = min.z; z <= max.z; ++z) {
                Block id = gate.field_70170_p.func_147439_a(x, min.y, z);
                if (id.isAir((IBlockAccess)gate.field_70170_p, x, min.y, z) || id == AWBlocks.gateProxy) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void setInitialBounds(EntityGate gate, BlockPosition pos1, BlockPosition pos2) {
        BlockPosition min = BlockTools.getMin(pos1, pos2);
        BlockPosition max = BlockTools.getMax(pos1, pos2);
        boolean wideOnXAxis = min.x != max.x;
        float width = wideOnXAxis ? (float)(max.x - min.x + 1) : (float)(max.z - min.z + 1);
        float xOffset = wideOnXAxis ? width * 0.5f : 0.5f;
        float zOffset = wideOnXAxis ? 0.5f : width * 0.5f;
        gate.pos1 = min;
        gate.pos2 = max;
        gate.edgeMax = 90.0f;
        gate.func_70107_b((float)min.x + xOffset, min.y, (float)min.z + zOffset);
    }

    @Override
    public void onGateStartOpen(EntityGate gate) {
        if (gate.field_70170_p.field_72995_K) {
            return;
        }
        BlockPosition min = BlockTools.getMin(gate.pos1, gate.pos2).offset(0, 1, 0);
        BlockPosition max = BlockTools.getMax(gate.pos1, gate.pos2);
        this.removeBetween(gate.field_70170_p, min, max);
    }

    @Override
    public void onGateFinishOpen(EntityGate gate) {
        BlockPosition min = BlockTools.getMin(gate.pos1, gate.pos2);
        BlockPosition max = BlockTools.getMax(gate.pos1, gate.pos2);
        int heightAdj = max.y - min.y;
        BlockPosition pos3 = max.moveUp(-heightAdj).moveForward(gate.gateOrientation, heightAdj);
        max = BlockTools.getMax(min, pos3);
        min = BlockTools.getMin(min, pos3);
        this.placeBetween(gate, min, max);
    }

    @Override
    public void onGateStartClose(EntityGate gate) {
        BlockPosition min = BlockTools.getMin(gate.pos1, gate.pos2);
        BlockPosition max = BlockTools.getMax(gate.pos1, gate.pos2);
        boolean widestOnXAxis = gate.pos1.x != gate.pos2.x;
        int heightAdj = max.y - min.y;
        BlockPosition pos3 = max.moveUp(-heightAdj).moveForward(gate.gateOrientation, heightAdj);
        max = BlockTools.getMax(min, pos3);
        min = BlockTools.getMin(min, pos3);
        for (int x = min.x; x <= max.x; ++x) {
            for (int y = min.y; y <= max.y; ++y) {
                for (int z = min.z; z <= max.z; ++z) {
                    Block id;
                    if (widestOnXAxis && z == gate.pos1.z || !widestOnXAxis && x == gate.pos1.x || (id = gate.field_70170_p.func_147439_a(x, y, z)) != AWBlocks.gateProxy) continue;
                    gate.field_70170_p.func_147468_f(x, y, z);
                }
            }
        }
    }

    @Override
    public void onGateFinishClose(EntityGate gate) {
        super.onGateFinishClose(gate);
    }
}

