/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.container;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.network.PacketGui;
import net.shadowmage.ancientwarfare.structure.container.ContainerSpawnerAdvancedInventoryBase;
import net.shadowmage.ancientwarfare.structure.tile.SpawnerSettings;
import net.shadowmage.ancientwarfare.structure.tile.TileAdvancedSpawner;

public class ContainerSpawnerAdvancedInventoryBlock
extends ContainerSpawnerAdvancedInventoryBase {
    private TileAdvancedSpawner spawner;

    public ContainerSpawnerAdvancedInventoryBlock(EntityPlayer player, int x, int y, int z) {
        super(player, x, y, z);
        TileEntity te = player.field_70170_p.func_147438_o(x, y, z);
        if (!player.field_70170_p.field_72995_K && te instanceof TileAdvancedSpawner) {
            this.spawner = (TileAdvancedSpawner)te;
            this.settings = this.spawner.getSettings();
        } else {
            this.settings = SpawnerSettings.getDefaultSettings();
        }
        this.inventory = this.settings.getInventory();
        this.addSettingsInventorySlots();
        this.addPlayerSlots(8, 70, 8);
    }

    @Override
    public boolean func_75145_c(EntityPlayer var1) {
        return this.spawner.func_145835_a(var1.field_70165_t, var1.field_70163_u, var1.field_70161_v) <= 64.0;
    }

    @Override
    public void sendInitData() {
        if (!this.player.field_70170_p.field_72995_K) {
            this.sendSettingsToClient();
        }
    }

    private void sendSettingsToClient() {
        NBTTagCompound tag = new NBTTagCompound();
        this.settings.writeToNBT(tag);
        PacketGui pkt = new PacketGui();
        pkt.setTag("spawnerSettings", tag);
        NetworkHandler.sendToPlayer((EntityPlayerMP)this.player, pkt);
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        if (tag.func_74764_b("spawnerSettings")) {
            if (this.player.field_70170_p.field_72995_K) {
                this.settings.readFromNBT(tag.func_74775_l("spawnerSettings"));
                this.refreshGui();
            } else {
                this.spawner.func_145839_a(tag);
                this.player.field_70170_p.func_147471_g(this.spawner.field_145851_c, this.spawner.field_145848_d, this.spawner.field_145849_e);
            }
        }
    }
}

