/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.container;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.shadowmage.ancientwarfare.core.inventory.ItemSlotFilter;
import net.shadowmage.ancientwarfare.core.inventory.SlotFiltered;
import net.shadowmage.ancientwarfare.structure.container.ContainerStructureSelectionBase;
import net.shadowmage.ancientwarfare.structure.tile.TileDraftingStation;

public class ContainerDraftingStation
extends ContainerStructureSelectionBase {
    public boolean isStarted = false;
    public boolean isFinished = false;
    private int remainingTime;
    private int totalTime;
    public final List<ItemStack> neededResources = new ArrayList<ItemStack>();
    private final TileDraftingStation tile;

    public ContainerDraftingStation(EntityPlayer player, int x, int y, int z) {
        super(player);
        this.tile = (TileDraftingStation)player.field_70170_p.func_147438_o(x, y, z);
        if (this.tile == null) {
            throw new IllegalArgumentException("No drafting station");
        }
        this.structureName = this.tile.getCurrentTemplateName();
        this.neededResources.addAll(this.tile.getNeededResources());
        this.isStarted = this.tile.isStarted();
        this.isFinished = this.tile.isFinished();
        this.remainingTime = this.tile.getRemainingTime();
        this.totalTime = this.tile.getTotalTime();
        int y2 = 94;
        for (int y1 = 0; y1 < 3; ++y1) {
            for (int x1 = 0; x1 < 9; ++x1) {
                int slotNum = y1 * 9 + x1;
                int xp = 8 + x1 * 18;
                int yp = y2 + y1 * 18;
                this.func_75146_a(new Slot((IInventory)this.tile.inputSlots, slotNum, xp, yp));
            }
        }
        this.func_75146_a(new SlotFiltered((IInventory)this.tile.outputSlot, 0, 80, 60, ItemSlotFilter.FALSE));
        this.addPlayerSlots(156);
    }

    @Override
    public boolean func_75145_c(EntityPlayer var1) {
        return this.tile.func_145835_a(var1.field_70165_t, var1.field_70163_u, var1.field_70161_v) <= 64.0;
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer par1EntityPlayer, int slotClickedIndex) {
        ItemStack slotStackCopy = null;
        Slot theSlot = this.func_75139_a(slotClickedIndex);
        if (theSlot != null && theSlot.func_75216_d()) {
            ItemStack slotStack = theSlot.func_75211_c();
            slotStackCopy = slotStack.func_77946_l();
            int playerSlotStart = this.tile.inputSlots.func_70302_i_();
            int playerSlotEnd = playerSlotStart + this.playerSlots;
            if (slotClickedIndex < playerSlotStart ? !this.func_75135_a(slotStack, playerSlotStart, playerSlotEnd, false) : slotClickedIndex < playerSlotEnd && !this.func_75135_a(slotStack, 0, playerSlotStart, false)) {
                return null;
            }
            if (slotStack.field_77994_a == 0) {
                theSlot.func_75215_d(null);
            } else {
                theSlot.func_75218_e();
            }
            if (slotStack.field_77994_a == slotStackCopy.field_77994_a) {
                return null;
            }
            theSlot.func_82870_a(par1EntityPlayer, slotStack);
        }
        return slotStackCopy;
    }

    @Override
    public void sendInitData() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("isStarted", this.isStarted);
        tag.func_74757_a("isFinished", this.isFinished);
        tag.func_74768_a("remainingTime", this.remainingTime);
        tag.func_74768_a("totalTime", this.totalTime);
        if (this.structureName != null) {
            tag.func_74778_a("structName", this.structureName);
        }
        tag.func_74782_a("resourceList", (NBTBase)this.getResourceListTag(this.neededResources));
        this.sendDataToClient(tag);
    }

    private NBTTagList getResourceListTag(List<ItemStack> resources) {
        NBTTagList list = new NBTTagList();
        for (ItemStack item : resources) {
            NBTTagCompound tag = new NBTTagCompound();
            item.func_77955_b(tag);
            list.func_74742_a((NBTBase)tag);
        }
        return list;
    }

    private void readResourceList(NBTTagList list, List<ItemStack> resources) {
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)tag);
            if (stack == null) continue;
            resources.add(stack);
        }
    }

    public void handleStopInput() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("stop", true);
        this.sendDataToServer(tag);
    }

    public void handleStartInput() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("start", true);
        this.sendDataToServer(tag);
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        if (tag.func_74764_b("structName")) {
            if (this.player.field_70170_p.field_72995_K) {
                this.structureName = tag.func_74779_i("structName");
            } else {
                this.tile.setTemplate(tag.func_74779_i("structName"));
            }
        } else if (tag.func_74764_b("clearName")) {
            this.structureName = null;
        }
        if (tag.func_74764_b("isStarted")) {
            this.isStarted = tag.func_74767_n("isStarted");
        }
        if (tag.func_74764_b("isFinished")) {
            this.isFinished = tag.func_74767_n("isFinished");
        }
        if (tag.func_74764_b("remainingTime")) {
            this.remainingTime = tag.func_74762_e("remainingTime");
        }
        if (tag.func_74764_b("totalTime")) {
            this.totalTime = tag.func_74762_e("totalTime");
        }
        if (tag.func_74764_b("resourceList")) {
            this.neededResources.clear();
            this.readResourceList(tag.func_150295_c("resourceList", 10), this.neededResources);
        }
        if (tag.func_74764_b("stop")) {
            this.tile.stopCurrentWork();
        } else if (tag.func_74764_b("start")) {
            this.tile.tryStart();
        }
        this.refreshGui();
    }

    public void func_75142_b() {
        super.func_75142_b();
        String tileName = this.tile.getCurrentTemplateName();
        NBTTagCompound tag = null;
        if (this.structureName == null && tileName != null || tileName == null && this.structureName != null) {
            tag = new NBTTagCompound();
            this.structureName = tileName;
            if (this.structureName == null) {
                tag.func_74757_a("clearName", true);
            } else {
                tag.func_74778_a("structName", this.structureName);
            }
        } else if (this.structureName != null && !this.structureName.equals(tileName)) {
            this.structureName = tileName;
            tag = new NBTTagCompound();
            tag.func_74778_a("structName", this.structureName);
        }
        if (this.tile.isFinished() != this.isFinished) {
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            this.isFinished = this.tile.isFinished();
            tag.func_74757_a("isFinished", this.isFinished);
        }
        if (this.tile.isStarted() != this.isStarted) {
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            this.isStarted = this.tile.isStarted();
            tag.func_74757_a("isStarted", this.isStarted);
        }
        if (this.tile.getRemainingTime() != this.remainingTime) {
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            this.remainingTime = this.tile.getRemainingTime();
            tag.func_74768_a("remainingTime", this.remainingTime);
        }
        if (this.tile.getTotalTime() != this.totalTime) {
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            this.totalTime = this.tile.getTotalTime();
            tag.func_74768_a("totalTime", this.totalTime);
        }
        if (!this.neededResources.equals(this.tile.getNeededResources())) {
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            this.neededResources.clear();
            this.neededResources.addAll(this.tile.getNeededResources());
            NBTTagList list = this.getResourceListTag(this.neededResources);
            tag.func_74782_a("resourceList", (NBTBase)list);
        }
        if (tag != null) {
            this.sendDataToClient(tag);
        }
    }
}

