/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.command;

import java.io.File;
import java.util.List;
import java.util.Locale;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.shadowmage.ancientwarfare.structure.config.AWStructureStatics;
import net.shadowmage.ancientwarfare.structure.item.ItemStructureScanner;
import net.shadowmage.ancientwarfare.structure.item.ItemStructureSettings;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplateManager;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBuilder;
import net.shadowmage.ancientwarfare.structure.template.load.TemplateLoader;

public class CommandStructure
extends CommandBase {
    public String func_71517_b() {
        return "awstructure";
    }

    public String func_71518_a(ICommandSender var1) {
        return "command.aw.structure.usage";
    }

    public void func_71515_b(ICommandSender var1, String[] var2) {
        ItemStack stack;
        if (var2.length == 0) {
            throw new WrongUsageException(this.func_71518_a(var1), new Object[0]);
        }
        String cmd = var2[0];
        if (cmd.toLowerCase(Locale.ENGLISH).equals("delete")) {
            if (var2.length < 2) {
                throw new WrongUsageException(this.func_71518_a(var1), new Object[0]);
            }
            String name = var2[1];
            boolean flag = StructureTemplateManager.INSTANCE.removeTemplate(name);
            if (flag) {
                boolean shouldDelete;
                ChatComponentTranslation txt = new ChatComponentTranslation("command.aw.structure.template_removed", new Object[]{name});
                var1.func_145747_a((IChatComponent)txt);
                if (var2.length >= 3 && (shouldDelete = var2[2].toLowerCase(Locale.ENGLISH).equals("true"))) {
                    txt = this.deleteTemplateFile(name) ? new ChatComponentTranslation("command.aw.structure.file_deleted", new Object[]{name}) : new ChatComponentTranslation("command.aw.structure.file_not_found", new Object[]{name});
                    var1.func_145747_a((IChatComponent)txt);
                }
            } else {
                var1.func_145747_a((IChatComponent)new ChatComponentTranslation("command.aw.structure.not_found", new Object[]{name}));
            }
        } else if (cmd.toLowerCase(Locale.ENGLISH).equals("build")) {
            ChatComponentTranslation txt;
            StructureTemplate template;
            if (var2.length < 5) {
                throw new WrongUsageException(this.func_71518_a(var1), new Object[0]);
            }
            int x = CommandBase.func_71526_a((ICommandSender)var1, (String)var2[2]);
            int y = CommandBase.func_71526_a((ICommandSender)var1, (String)var2[3]);
            int z = CommandBase.func_71526_a((ICommandSender)var1, (String)var2[4]);
            int face = 0;
            if (var2.length > 5) {
                String dl = var2[5].toLowerCase(Locale.ENGLISH);
                face = dl.equals("north") ? 2 : (dl.equals("east") ? 3 : (dl.equals("south") ? 0 : (dl.equals("west") ? 1 : CommandBase.func_71526_a((ICommandSender)var1, (String)var2[5]))));
            }
            if ((template = StructureTemplateManager.INSTANCE.getTemplate(var2[1])) == null) {
                txt = new ChatComponentTranslation("command.aw.structure.not_found", new Object[]{var2[1]});
            } else {
                StructureBuilder builder = new StructureBuilder(var1.func_130014_f_(), template, face, x, y, z);
                builder.instantConstruction();
                txt = new ChatComponentTranslation("command.aw.structure.built", new Object[]{var2[1], x, y, z});
            }
            var1.func_145747_a((IChatComponent)txt);
        } else if (cmd.toLowerCase(Locale.ENGLISH).equals("save") && var1 instanceof EntityLivingBase && (stack = ((EntityLivingBase)var1).func_70694_bm()) != null) {
            ItemStructureSettings settings = ItemStructureSettings.getSettingsFor(stack);
            if (settings.hasPos1() && settings.hasPos2() && settings.hasBuildKey() && (settings.hasName() || var2.length > 1)) {
                String name = settings.hasName() ? settings.name() : var2[1];
                NBTTagCompound tagCompound = new NBTTagCompound();
                if (ItemStructureScanner.scanStructure(var1.func_130014_f_(), settings.pos1(), settings.pos2(), settings.buildKey(), settings.face(), name, true, tagCompound)) {
                    var1.func_145747_a((IChatComponent)new ChatComponentTranslation("command.aw.structure.exported", new Object[]{var2[1]}));
                }
            } else {
                var1.func_145747_a((IChatComponent)new ChatComponentTranslation("command.aw.structure.incomplete_data", new Object[0]));
            }
        }
    }

    private boolean deleteTemplateFile(String name) {
        String path = TemplateLoader.includeDirectory + name + "." + AWStructureStatics.templateExtension;
        File file = new File(path);
        if (file.exists()) {
            file.delete();
            return true;
        }
        return false;
    }

    public int func_82362_a() {
        return 2;
    }

    public List func_71516_a(ICommandSender var1, String[] var2) {
        if (var2.length == 1) {
            return CommandBase.func_71530_a((String[])var2, (String[])new String[]{"build", "delete", "save"});
        }
        if (var2.length > 5 && var2[0].toLowerCase(Locale.ENGLISH).equals("build")) {
            return CommandBase.func_71530_a((String[])var2, (String[])new String[]{"north", "east", "south", "west"});
        }
        return null;
    }
}

