/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.block;

import cpw.mods.fml.common.registry.GameData;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.shadowmage.ancientwarfare.core.config.AWLog;
import net.shadowmage.ancientwarfare.core.util.StringTools;

public class BlockDataManager {
    private HashMap<Block, String> blockToName = new HashMap();
    private HashMap<String, Block> blockNameToBlock = new HashMap();
    private HashMap<String, Block> blockUnlocalizedNameToBlock = new HashMap();
    private HashMap<Block, BlockInfo> blockInfoMap = new HashMap();
    public static final BlockDataManager INSTANCE = new BlockDataManager();

    private BlockDataManager() {
    }

    public void load() {
        this.loadBlockNamesAndIDs(StringTools.getResourceLines("/assets/ancientwarfare/resources/block_name_id.csv"));
        this.loadBlockRotations(StringTools.getResourceLines("/assets/ancientwarfare/resources/block_rotations.csv"));
        this.loadBlockPriorities(StringTools.getResourceLines("/assets/ancientwarfare/resources/block_priorities.csv"));
        this.loadBlockItems(StringTools.getResourceLines("/assets/ancientwarfare/resources/block_items.csv"));
        Iterable blocks = GameData.getBlockRegistry().typeSafeIterable();
        for (Block block : blocks) {
            if (block == null) {
                return;
            }
            this.blockUnlocalizedNameToBlock.put(block.func_149739_a(), block);
        }
    }

    private void loadBlockNamesAndIDs(List<String> lines) {
        for (String line : lines) {
            String[] bits = line.split(",", -1);
            String name = bits[0];
            int id = StringTools.safeParseInt(bits[1]);
            Block block = Block.func_149684_b((String)name);
            if (block == null) {
                AWLog.logError("ERROR parsing block name from name mapping: " + name + " id: " + id + " found: " + block);
                continue;
            }
            this.blockNameToBlock.put(name, block);
            this.blockToName.put(block, name);
        }
    }

    private void loadBlockRotations(List<String> lines) {
        for (String line : lines) {
            String[] bits = line.split(",", -1);
            String name = bits[0];
            Block block = this.blockNameToBlock.get(name);
            byte[] rotations = new byte[16];
            for (int i = 0; i < 16; ++i) {
                String rot = bits[i + 1];
                rotations[i] = rot.equals("") || rot.isEmpty() ? (byte)i : StringTools.safeParseByte(bits[i + 1]);
            }
            BlockInfo info = this.blockInfoMap.get(block);
            if (info == null) {
                info = new BlockInfo();
                this.blockInfoMap.put(block, info);
            }
            info.setRotations(rotations);
        }
    }

    private void loadBlockItems(List<String> lines) {
        for (String line : lines) {
            String[] bits = line.split(",", -1);
            String blockName = bits[0];
            Block block = this.blockNameToBlock.get(blockName);
            BlockInfo info = this.blockInfoMap.get(block);
            if (info == null) {
                info = new BlockInfo();
                this.blockInfoMap.put(block, info);
            }
            int blockMeta = StringTools.safeParseInt(bits[1]);
            String itemName = bits[2];
            int itemDamage = StringTools.safeParseInt(bits[3]);
            int itemQuantity = StringTools.safeParseInt(bits[4]);
            if (blockMeta == -1) {
                blockMeta = 0;
                info.singleItem = true;
            }
            if (itemName.equals("null")) {
                if (info.singleItem) {
                    for (int i = 0; i < 16; ++i) {
                        info.noItemFlags[i] = true;
                    }
                    continue;
                }
                info.noItemFlags[blockMeta] = true;
                continue;
            }
            Item item = (Item)Item.field_150901_e.func_82594_a(itemName);
            if (item != null) {
                info.metaStacks[blockMeta] = new ItemStack(item, itemQuantity, itemDamage);
                continue;
            }
            Block block2 = this.blockNameToBlock.get("minecraft:" + itemName);
            info.metaStacks[blockMeta] = new ItemStack(block2, itemQuantity, itemDamage);
        }
    }

    private void loadBlockPriorities(List<String> lines) {
        for (String line : lines) {
            String[] bits = line.split(",", -1);
            String blockName = bits[0];
            int priority = StringTools.safeParseInt(bits[1]);
            Block block = this.blockNameToBlock.get(blockName);
            BlockInfo info = this.blockInfoMap.get(block);
            if (info == null) {
                info = new BlockInfo();
                this.blockInfoMap.put(block, info);
            }
            info.buildPriority = (byte)priority;
        }
    }

    public int getRotatedMeta(Block block, int meta, int turns) {
        BlockInfo info = this.blockInfoMap.get(block);
        if (info != null) {
            int rm = meta;
            for (int i = 0; i < turns; ++i) {
                rm = info.getRotatedMeta(rm);
            }
            return rm;
        }
        return meta;
    }

    public int getPriorityForBlock(Block block) {
        BlockInfo info = this.blockInfoMap.get(block);
        if (info != null) {
            return info.buildPriority;
        }
        return 0;
    }

    public String getNameForBlock(Block block) {
        String name = Block.field_149771_c.func_148750_c((Object)block);
        if (name == null && (name = this.blockToName.get(block)) == null) {
            throw new RuntimeException("Could not locate block name for: " + block.func_149739_a());
        }
        return name;
    }

    public Block getBlockForName(String name) {
        Block b = Block.func_149684_b((String)name);
        if (b == null) {
            if (this.blockNameToBlock.containsKey(name)) {
                return this.blockNameToBlock.get(name);
            }
            if (this.blockUnlocalizedNameToBlock.containsKey(name)) {
                return this.blockUnlocalizedNameToBlock.get(name);
            }
            return Blocks.field_150350_a;
        }
        return b;
    }

    public ItemStack getInventoryStackForBlock(Block block, int meta) {
        BlockInfo info = this.blockInfoMap.get(block);
        if (info != null) {
            return info.getStackFor(block, meta);
        }
        return new ItemStack(block, 1, meta);
    }

    private class BlockInfo {
        boolean singleItem = false;
        boolean hasRotation = false;
        ItemStack[] metaStacks = new ItemStack[16];
        boolean[] noItemFlags = new boolean[16];
        byte[] rotations = new byte[16];
        byte buildPriority = 0;

        private BlockInfo() {
        }

        public void setRotations(byte[] rotations) {
            this.rotations = rotations;
            this.hasRotation = true;
        }

        public int getRotatedMeta(int meta) {
            if (!this.hasRotation) {
                return meta;
            }
            return this.rotations[meta];
        }

        public ItemStack getStackFor(Block block, int meta) {
            if (this.singleItem && this.metaStacks[0] != null) {
                return this.metaStacks[0].func_77946_l();
            }
            if (this.noItemFlags[meta]) {
                return null;
            }
            if (this.metaStacks[meta] != null) {
                return this.metaStacks[meta].func_77946_l();
            }
            return new ItemStack(Item.func_150898_a((Block)block), 1, meta);
        }
    }
}

