/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.api;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.structure.api.NBTTools;
import net.shadowmage.ancientwarfare.structure.api.TemplateParsingException;
import net.shadowmage.ancientwarfare.structure.api.TemplateRule;

public abstract class TemplateRuleEntity
extends TemplateRule {
    private int x;
    private int y;
    private int z;

    public TemplateRuleEntity(World world, Entity entity, int turns, int x, int y, int z) {
    }

    public TemplateRuleEntity() {
    }

    @Override
    public final void writeRule(BufferedWriter out) throws IOException {
        out.write("position=" + NBTTools.getCSVStringForArray(new int[]{this.x, this.y, this.z}));
        out.newLine();
        super.writeRule(out);
    }

    @Override
    public final void parseRule(int ruleNumber, List<String> lines) throws TemplateParsingException.TemplateRuleParsingException {
        this.ruleNumber = ruleNumber;
        for (String line : lines) {
            if (!line.toLowerCase(Locale.ENGLISH).startsWith("position=")) continue;
            int[] pos = NBTTools.safeParseIntArray("=", line);
            this.x = pos[0];
            this.y = pos[1];
            this.z = pos[2];
            break;
        }
        NBTTagCompound tag = this.readTag(lines);
        this.parseRuleData(tag);
    }

    public final void setPosition(BlockPosition pos) {
        this.x = pos.x;
        this.y = pos.y;
        this.z = pos.z;
    }

    public final BlockPosition getPosition() {
        return new BlockPosition(this.x, this.y, this.z);
    }
}

