/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.trade;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.npc.trade.POTradeDepositEntry;
import net.shadowmage.ancientwarfare.npc.trade.POTradeWithdrawEntry;

public class POTradeRestockData {
    private BlockPosition withdrawPoint;
    private int withdrawSide;
    private List<POTradeWithdrawEntry> withdrawList = new ArrayList<POTradeWithdrawEntry>();
    private BlockPosition depositPoint;
    private int depositSide;
    private List<POTradeDepositEntry> depositList = new ArrayList<POTradeDepositEntry>();

    public BlockPosition getDepositPoint() {
        return this.depositPoint;
    }

    public BlockPosition getWithdrawPoint() {
        return this.withdrawPoint;
    }

    public int getDepositSide() {
        return this.depositSide;
    }

    public int getWithdrawSide() {
        return this.withdrawSide;
    }

    public void deleteDepositPoint() {
        this.depositPoint = null;
    }

    public void deleteWithdrawPoint() {
        this.withdrawPoint = null;
    }

    public List<POTradeWithdrawEntry> getWithdrawList() {
        return this.withdrawList;
    }

    public List<POTradeDepositEntry> getDepositList() {
        return this.depositList;
    }

    public void addDepositEntry() {
        this.depositList.add(new POTradeDepositEntry());
    }

    public void addWithdrawEntry() {
        this.withdrawList.add(new POTradeWithdrawEntry());
    }

    public void removeDepositEntry(int index) {
        this.depositList.remove(index);
    }

    public void removeWithdrawEntry(int index) {
        this.withdrawList.remove(index);
    }

    public void setDepositPoint(BlockPosition pos, int side) {
        this.depositPoint = pos;
        this.depositSide = side;
    }

    public void setWithdrawPoint(BlockPosition pos, int side) {
        this.withdrawPoint = pos;
        this.withdrawSide = side;
    }

    public void doDeposit(IInventory storage, IInventory deposit, int side) {
        for (POTradeDepositEntry aDeposit : this.depositList) {
            aDeposit.process(storage, deposit, side);
        }
    }

    public void doWithdraw(IInventory storage, IInventory withdraw, int side) {
        for (POTradeWithdrawEntry aWithdraw : this.withdrawList) {
            aWithdraw.process(storage, withdraw, side);
        }
    }

    public void readFromNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("withdrawPoint")) {
            this.withdrawPoint = new BlockPosition(tag.func_74775_l("withdrawPoint"));
            this.withdrawSide = tag.func_74762_e("withdrawSide");
        }
        if (tag.func_74764_b("depositPoint")) {
            this.depositPoint = new BlockPosition(tag.func_74775_l("depositPoint"));
            this.depositSide = tag.func_74762_e("depositSide");
        }
        NBTTagList deposit = tag.func_150295_c("depositList", 10);
        for (int i = 0; i < deposit.func_74745_c(); ++i) {
            POTradeDepositEntry de = new POTradeDepositEntry();
            de.readFromNBT(deposit.func_150305_b(i));
            this.depositList.add(de);
        }
        NBTTagList withdraw = tag.func_150295_c("withdrawList", 10);
        for (int i = 0; i < withdraw.func_74745_c(); ++i) {
            POTradeWithdrawEntry we = new POTradeWithdrawEntry();
            we.readFromNBT(withdraw.func_150305_b(i));
            this.withdrawList.add(we);
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        if (this.withdrawPoint != null) {
            tag.func_74782_a("withdrawPoint", (NBTBase)this.withdrawPoint.writeToNBT(new NBTTagCompound()));
            tag.func_74768_a("withdrawSide", this.withdrawSide);
        }
        if (this.depositPoint != null) {
            tag.func_74782_a("depositPoint", (NBTBase)this.depositPoint.writeToNBT(new NBTTagCompound()));
            tag.func_74768_a("depositSide", this.depositSide);
        }
        NBTTagList depositTagList = new NBTTagList();
        for (POTradeDepositEntry aDeposit : this.depositList) {
            depositTagList.func_74742_a((NBTBase)aDeposit.writeToNBT(new NBTTagCompound()));
        }
        tag.func_74782_a("depositList", (NBTBase)depositTagList);
        NBTTagList withdrawTagList = new NBTTagList();
        for (POTradeWithdrawEntry aWithdraw : this.withdrawList) {
            withdrawTagList.func_74742_a((NBTBase)aWithdraw.writeToNBT(new NBTTagCompound()));
        }
        tag.func_74782_a("withdrawList", (NBTBase)withdrawTagList);
        return tag;
    }
}

