/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.orders;

import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.interfaces.INBTSerialable;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.npc.block.BlockTownHall;
import net.shadowmage.ancientwarfare.npc.config.AWNPCStatics;
import net.shadowmage.ancientwarfare.npc.item.ItemUpkeepOrder;

public class UpkeepOrder
implements INBTSerialable {
    BlockPosition upkeepPosition;
    int upkeepDimension;
    int blockSide;
    int upkeepAmount = 6000;

    public void changeBlockSide() {
        ++this.blockSide;
        if (this.blockSide > 5) {
            this.blockSide = 0;
        }
    }

    public void removeUpkeepPoint() {
        this.upkeepPosition = null;
        this.blockSide = 0;
        this.upkeepDimension = 0;
        this.upkeepAmount = 6000;
    }

    public void setUpkeepAmount(int amt) {
        this.upkeepAmount = amt;
    }

    public void setBlockSide(int side) {
        this.blockSide = side;
    }

    public int getUpkeepBlockSide() {
        return this.blockSide;
    }

    public int getUpkeepDimension() {
        return this.upkeepDimension;
    }

    public BlockPosition getUpkeepPosition() {
        return this.upkeepPosition;
    }

    public Block getBlock() {
        return this.upkeepPosition == null ? null : this.upkeepPosition.get(this.upkeepDimension);
    }

    public final int getUpkeepAmount() {
        return this.upkeepAmount;
    }

    public boolean addUpkeepPosition(World world, BlockPosition pos) {
        if (pos != null && world.func_147438_o(pos.x, pos.y, pos.z) instanceof IInventory) {
            if (!AWNPCStatics.npcAllowUpkeepAnyInventory && !(world.func_147439_a(pos.x, pos.y, pos.z) instanceof BlockTownHall)) {
                return false;
            }
            this.upkeepPosition = pos;
            this.upkeepDimension = world.field_73011_w.field_76574_g;
            this.blockSide = 0;
            this.upkeepAmount = 6000;
            return true;
        }
        return false;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("upkeepPosition")) {
            this.upkeepPosition = new BlockPosition(tag.func_74775_l("upkeepPosition"));
            this.upkeepDimension = tag.func_74762_e("dim");
            this.blockSide = tag.func_74762_e("side");
            this.upkeepAmount = tag.func_74762_e("upkeepAmount");
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        if (this.upkeepPosition != null) {
            tag.func_74782_a("upkeepPosition", (NBTBase)this.upkeepPosition.writeToNBT(new NBTTagCompound()));
            tag.func_74768_a("dim", this.upkeepDimension);
            tag.func_74768_a("side", this.blockSide);
            tag.func_74768_a("upkeepAmount", this.upkeepAmount);
        }
        return tag;
    }

    public String toString() {
        return "Upkeep Orders[" + this.upkeepPosition + "]";
    }

    public static UpkeepOrder getUpkeepOrder(ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof ItemUpkeepOrder) {
            UpkeepOrder order = new UpkeepOrder();
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("orders")) {
                order.readFromNBT(stack.func_77978_p().func_74775_l("orders"));
            }
            return order;
        }
        return null;
    }

    public void write(ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof ItemUpkeepOrder) {
            stack.func_77983_a("orders", (NBTBase)this.writeToNBT(new NBTTagCompound()));
        }
    }
}

