/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.orders;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.interfaces.INBTSerialable;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.core.util.OrderingList;
import net.shadowmage.ancientwarfare.npc.item.ItemCombatOrder;

public class CombatOrder
extends OrderingList<BlockPosition>
implements INBTSerialable {
    int patrolDimensionId = 0;

    public void addPatrolPoint(World world, BlockPosition point) {
        if (world.field_73011_w.field_76574_g != this.patrolDimensionId) {
            this.clear();
            this.patrolDimensionId = world.field_73011_w.field_76574_g;
        }
        this.add(point);
    }

    public int getPatrolDimension() {
        return this.patrolDimensionId;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.clear();
        this.patrolDimensionId = tag.func_74762_e("dim");
        if (tag.func_74764_b("pointList")) {
            NBTTagList list = tag.func_150295_c("pointList", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                this.add(new BlockPosition(list.func_150305_b(i)));
            }
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("dim", this.patrolDimensionId);
        if (!this.isEmpty()) {
            NBTTagList list = new NBTTagList();
            for (BlockPosition point : this.points) {
                list.func_74742_a((NBTBase)point.writeToNBT(new NBTTagCompound()));
            }
            tag.func_74782_a("pointList", (NBTBase)list);
        }
        return tag;
    }

    public static CombatOrder getCombatOrder(ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof ItemCombatOrder) {
            CombatOrder order = new CombatOrder();
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("orders")) {
                order.readFromNBT(stack.func_77978_p().func_74775_l("orders"));
            }
            return order;
        }
        return null;
    }

    public void write(ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof ItemCombatOrder) {
            stack.func_77983_a("orders", (NBTBase)this.writeToNBT(new NBTTagCompound()));
        }
    }
}

