/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.util;

import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import org.lwjgl.opengl.GL11;

public class RenderTools {
    public static void setFullColorLightmap() {
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)0.0f, (float)240.0f);
    }

    public static void renderQuarteredTexture(int textureWidth, int textureHeight, int texStartX, int texStartY, int texUsedWidth, int texUsedHeight, int renderStartX, int renderStartY, int renderWidth, int renderHeight) {
        float perX = 1.0f / (float)textureWidth;
        float perY = 1.0f / (float)textureHeight;
        float texMinX = (float)texStartX * perX;
        float texMinY = (float)texStartY * perY;
        float texMaxX = (float)(texStartX + texUsedWidth) * perX;
        float texMaxY = (float)(texStartY + texUsedHeight) * perY;
        float halfWidth = (float)renderWidth / 2.0f * perX;
        float halfHeight = (float)renderHeight / 2.0f * perY;
        float halfRenderWidth = (float)renderWidth * 0.5f;
        float halfRenderHeight = (float)renderHeight * 0.5f;
        RenderTools.renderTexturedQuad(renderStartX, renderStartY, (float)renderStartX + halfRenderWidth, (float)renderStartY + halfRenderHeight, texMinX, texMinY, texMinX + halfWidth, texMinY + halfHeight);
        RenderTools.renderTexturedQuad((float)renderStartX + halfRenderWidth, renderStartY, (float)renderStartX + halfRenderWidth * 2.0f, (float)renderStartY + halfRenderHeight, texMaxX - halfWidth, texMinY, texMaxX, texMinY + halfHeight);
        RenderTools.renderTexturedQuad(renderStartX, (float)renderStartY + halfRenderHeight, (float)renderStartX + halfRenderWidth, (float)renderStartY + halfRenderHeight * 2.0f, texMinX, texMaxY - halfHeight, texMinX + halfWidth, texMaxY);
        RenderTools.renderTexturedQuad((float)renderStartX + halfRenderWidth, (float)renderStartY + halfRenderHeight, (float)renderStartX + halfRenderWidth * 2.0f, (float)renderStartY + halfRenderHeight * 2.0f, texMaxX - halfWidth, texMaxY - halfHeight, texMaxX, texMaxY);
    }

    public static void renderTexturedQuad(float x1, float y1, float x2, float y2, float u1, float v1, float u2, float v2) {
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)u1, (float)v1);
        GL11.glVertex2f((float)x1, (float)y1);
        GL11.glTexCoord2f((float)u1, (float)v2);
        GL11.glVertex2f((float)x1, (float)y2);
        GL11.glTexCoord2f((float)u2, (float)v2);
        GL11.glVertex2f((float)x2, (float)y2);
        GL11.glTexCoord2f((float)u2, (float)v1);
        GL11.glVertex2f((float)x2, (float)y1);
        GL11.glEnd();
    }

    public static void drawOutlinedBoundingBox2(AxisAlignedBB bb, float r, float g, float b, float width) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)0.4f);
        GL11.glBindTexture((int)3553, (int)0);
        float hw = width / 2.0f;
        RenderTools.drawCuboid((float)bb.field_72340_a, (float)bb.field_72338_b - hw, (float)bb.field_72339_c - hw, (float)bb.field_72336_d, (float)bb.field_72338_b + hw, (float)bb.field_72339_c + hw);
        RenderTools.drawCuboid((float)bb.field_72340_a, (float)bb.field_72337_e - hw, (float)bb.field_72339_c - hw, (float)bb.field_72336_d, (float)bb.field_72337_e + hw, (float)bb.field_72339_c + hw);
        RenderTools.drawCuboid((float)bb.field_72340_a, (float)bb.field_72338_b - hw, (float)bb.field_72334_f - hw, (float)bb.field_72336_d, (float)bb.field_72338_b + hw, (float)bb.field_72334_f + hw);
        RenderTools.drawCuboid((float)bb.field_72340_a, (float)bb.field_72337_e - hw, (float)bb.field_72334_f - hw, (float)bb.field_72336_d, (float)bb.field_72337_e + hw, (float)bb.field_72334_f + hw);
        RenderTools.drawCuboid((float)bb.field_72340_a - hw, (float)bb.field_72338_b, (float)bb.field_72339_c - hw, (float)bb.field_72340_a + hw, (float)bb.field_72337_e, (float)bb.field_72339_c + hw);
        RenderTools.drawCuboid((float)bb.field_72336_d - hw, (float)bb.field_72338_b, (float)bb.field_72339_c - hw, (float)bb.field_72336_d + hw, (float)bb.field_72337_e, (float)bb.field_72339_c + hw);
        RenderTools.drawCuboid((float)bb.field_72340_a - hw, (float)bb.field_72338_b, (float)bb.field_72334_f - hw, (float)bb.field_72340_a + hw, (float)bb.field_72337_e, (float)bb.field_72334_f + hw);
        RenderTools.drawCuboid((float)bb.field_72336_d - hw, (float)bb.field_72338_b, (float)bb.field_72334_f - hw, (float)bb.field_72336_d + hw, (float)bb.field_72337_e, (float)bb.field_72334_f + hw);
        RenderTools.drawCuboid((float)bb.field_72340_a - hw, (float)bb.field_72338_b - hw, (float)bb.field_72339_c, (float)bb.field_72340_a + hw, (float)bb.field_72338_b + hw, (float)bb.field_72334_f);
        RenderTools.drawCuboid((float)bb.field_72340_a - hw, (float)bb.field_72337_e - hw, (float)bb.field_72339_c, (float)bb.field_72340_a + hw, (float)bb.field_72337_e + hw, (float)bb.field_72334_f);
        RenderTools.drawCuboid((float)bb.field_72336_d - hw, (float)bb.field_72338_b - hw, (float)bb.field_72339_c, (float)bb.field_72336_d + hw, (float)bb.field_72338_b + hw, (float)bb.field_72334_f);
        RenderTools.drawCuboid((float)bb.field_72336_d - hw, (float)bb.field_72337_e - hw, (float)bb.field_72339_c, (float)bb.field_72336_d + hw, (float)bb.field_72337_e + hw, (float)bb.field_72334_f);
        GL11.glDisable((int)3042);
    }

    public static void drawCuboid(float x, float y, float z, float mx, float my, float mz) {
        GL11.glBegin((int)7);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)x, (float)my, (float)mz);
        GL11.glVertex3f((float)x, (float)y, (float)mz);
        GL11.glVertex3f((float)mx, (float)y, (float)mz);
        GL11.glVertex3f((float)mx, (float)my, (float)mz);
        GL11.glNormal3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)mx, (float)my, (float)mz);
        GL11.glVertex3f((float)mx, (float)y, (float)mz);
        GL11.glVertex3f((float)mx, (float)y, (float)z);
        GL11.glVertex3f((float)mx, (float)my, (float)z);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)x, (float)my, (float)z);
        GL11.glVertex3f((float)x, (float)my, (float)mz);
        GL11.glVertex3f((float)mx, (float)my, (float)mz);
        GL11.glVertex3f((float)mx, (float)my, (float)z);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
        GL11.glVertex3f((float)x, (float)my, (float)z);
        GL11.glVertex3f((float)mx, (float)my, (float)z);
        GL11.glVertex3f((float)mx, (float)y, (float)z);
        GL11.glVertex3f((float)x, (float)y, (float)z);
        GL11.glNormal3f((float)-1.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)x, (float)y, (float)mz);
        GL11.glVertex3f((float)x, (float)my, (float)mz);
        GL11.glVertex3f((float)x, (float)my, (float)z);
        GL11.glVertex3f((float)x, (float)y, (float)z);
        GL11.glNormal3f((float)0.0f, (float)-1.0f, (float)0.0f);
        GL11.glVertex3f((float)x, (float)y, (float)z);
        GL11.glVertex3f((float)mx, (float)y, (float)z);
        GL11.glVertex3f((float)mx, (float)y, (float)mz);
        GL11.glVertex3f((float)x, (float)y, (float)mz);
        GL11.glEnd();
    }

    public static void renderOrientationPoints(float colorMult) {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glPointSize((float)3.0f);
        GL11.glColor4f((float)colorMult, (float)colorMult, (float)colorMult, (float)1.0f);
        GL11.glBegin((int)0);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glEnd();
        GL11.glColor4f((float)colorMult, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glBegin((int)1);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glEnd();
        GL11.glBegin((int)0);
        GL11.glVertex3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glEnd();
        GL11.glColor4f((float)0.0f, (float)colorMult, (float)0.0f, (float)1.0f);
        GL11.glBegin((int)1);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glEnd();
        GL11.glBegin((int)0);
        GL11.glVertex3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glEnd();
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)colorMult, (float)1.0f);
        GL11.glBegin((int)1);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glEnd();
        GL11.glBegin((int)0);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glEnd();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    public static void drawOutlinedBoundingBox(AxisAlignedBB bb, float r, float g, float b) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)0.4f);
        GL11.glLineWidth((float)8.0f);
        GL11.glDisable((int)3553);
        GL11.glDepthMask((boolean)false);
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78371_b(3);
        tess.func_78377_a(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c);
        tess.func_78377_a(bb.field_72336_d, bb.field_72338_b, bb.field_72339_c);
        tess.func_78377_a(bb.field_72336_d, bb.field_72338_b, bb.field_72334_f);
        tess.func_78377_a(bb.field_72340_a, bb.field_72338_b, bb.field_72334_f);
        tess.func_78377_a(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c);
        tess.func_78381_a();
        tess.func_78371_b(3);
        tess.func_78377_a(bb.field_72340_a, bb.field_72337_e, bb.field_72339_c);
        tess.func_78377_a(bb.field_72336_d, bb.field_72337_e, bb.field_72339_c);
        tess.func_78377_a(bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
        tess.func_78377_a(bb.field_72340_a, bb.field_72337_e, bb.field_72334_f);
        tess.func_78377_a(bb.field_72340_a, bb.field_72337_e, bb.field_72339_c);
        tess.func_78381_a();
        tess.func_78371_b(1);
        tess.func_78377_a(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c);
        tess.func_78377_a(bb.field_72340_a, bb.field_72337_e, bb.field_72339_c);
        tess.func_78377_a(bb.field_72336_d, bb.field_72338_b, bb.field_72339_c);
        tess.func_78377_a(bb.field_72336_d, bb.field_72337_e, bb.field_72339_c);
        tess.func_78377_a(bb.field_72336_d, bb.field_72338_b, bb.field_72334_f);
        tess.func_78377_a(bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
        tess.func_78377_a(bb.field_72340_a, bb.field_72338_b, bb.field_72334_f);
        tess.func_78377_a(bb.field_72340_a, bb.field_72337_e, bb.field_72334_f);
        tess.func_78381_a();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static AxisAlignedBB adjustBBForPlayerPos(AxisAlignedBB bb, EntityPlayer player, float partialTick) {
        double x = RenderTools.getRenderOffsetX(player, partialTick);
        double y = RenderTools.getRenderOffsetY(player, partialTick);
        double z = RenderTools.getRenderOffsetZ(player, partialTick);
        return bb.func_72317_d(-x, -y, -z);
    }

    public static double getRenderOffsetX(EntityPlayer player, float partialTick) {
        return player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTick;
    }

    public static double getRenderOffsetY(EntityPlayer player, float partialTick) {
        return player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTick;
    }

    public static double getRenderOffsetZ(EntityPlayer player, float partialTick) {
        return player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTick;
    }
}

