/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.inventory;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.shadowmage.ancientwarfare.core.inventory.ItemQuantityMap;

public class InventorySlotlessBasic {
    private final int totalSize;
    private int currentSize;
    private final ItemQuantityMap itemMap = new ItemQuantityMap();

    public InventorySlotlessBasic(int totalSize) {
        this.totalSize = totalSize;
    }

    public void getItems(ItemQuantityMap map) {
        map.addAll(this.itemMap);
    }

    public int getQuantityStored(ItemStack filter) {
        return this.itemMap.getCount(filter);
    }

    public int getAvailableSpaceFor(ItemStack filter) {
        return this.totalSize - this.currentSize;
    }

    public int extractItem(ItemStack filter, int amount) {
        if (amount <= 0 || filter == null) {
            return 0;
        }
        int count = this.itemMap.getCount(filter);
        amount = amount > count ? count : amount;
        this.itemMap.decreaseCount(filter, amount);
        this.currentSize -= amount;
        return amount;
    }

    public int insertItem(ItemStack filter, int amount) {
        if (amount <= 0 || filter == null) {
            return 0;
        }
        if (amount > this.totalSize - this.currentSize) {
            amount = this.totalSize - this.currentSize;
        }
        this.itemMap.addCount(filter, amount);
        this.currentSize += amount;
        return amount;
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.itemMap.readFromNBT(tag.func_74775_l("itemMap"));
        this.currentSize = this.itemMap.getTotalItemCount();
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74782_a("itemMap", (NBTBase)this.itemMap.writeToNBT(new NBTTagCompound()));
        return tag;
    }
}

