/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.gui.elements;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.shadowmage.ancientwarfare.core.gui.elements.GuiElement;
import org.lwjgl.opengl.GL11;

public class Tooltip {
    private List<GuiElement> children = new ArrayList<GuiElement>();
    int width;
    int height;

    public Tooltip(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void renderTooltip(int mouseX, int mouseY, float partialTick) {
        int width = Minecraft.func_71410_x().field_71443_c;
        int height = Minecraft.func_71410_x().field_71440_d;
        if (mouseX + this.width > width) {
            mouseX -= 28 + this.width;
        }
        if (mouseY + this.height + 6 > height) {
            mouseY = height - this.height - 6;
        }
        Tooltip.pushViewport(mouseX - 4, mouseY - 4, this.width + 8, this.height + 8);
        for (GuiElement element : this.children) {
            element.updateGuiPosition(mouseX, mouseY);
        }
        GL11.glDisable((int)2929);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)32826);
        this.drawBackground(mouseX, mouseY);
        RenderHelper.func_74518_a();
        for (GuiElement element : this.children) {
            element.render(-1000, -1000, partialTick);
        }
        Tooltip.disableViewport();
    }

    public final void addTooltipElement(GuiElement element) {
        if (this.width < element.width) {
            this.width = element.width + 2;
        }
        if (this.height < element.height) {
            this.height = element.height + 2;
        }
        this.children.add(element);
    }

    private void drawBackground(int mouseX, int mouseY) {
        int color1 = -267386864;
        this.drawGradientRect(mouseX - 3, mouseY - 4, mouseX + this.width + 3, mouseY - 3, color1, color1);
        this.drawGradientRect(mouseX - 3, mouseY + this.height + 3, mouseX + this.width + 3, mouseY + this.height + 4, color1, color1);
        this.drawGradientRect(mouseX - 3, mouseY - 3, mouseX + this.width + 3, mouseY + this.height + 3, color1, color1);
        this.drawGradientRect(mouseX - 4, mouseY - 3, mouseX - 3, mouseY + this.height + 3, color1, color1);
        this.drawGradientRect(mouseX + this.width + 3, mouseY - 3, mouseX + this.width + 4, mouseY + this.height + 3, color1, color1);
        int color2 = 0x505000FF;
        int color3 = (color2 & 0xFEFEFE) >> 1 | color2 & 0xFF000000;
        this.drawGradientRect(mouseX - 3, mouseY - 3 + 1, mouseX - 3 + 1, mouseY + this.height + 3 - 1, color2, color3);
        this.drawGradientRect(mouseX + this.width + 2, mouseY - 3 + 1, mouseX + this.width + 3, mouseY + this.height + 3 - 1, color2, color3);
        this.drawGradientRect(mouseX - 3, mouseY - 3, mouseX + this.width + 3, mouseY - 3 + 1, color2, color2);
        this.drawGradientRect(mouseX - 3, mouseY + this.height + 2, mouseX + this.width + 3, mouseY + this.height + 3, color3, color3);
    }

    private void drawGradientRect(int par1, int par2, int par3, int par4, int par5, int par6) {
        float f = (float)(par5 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(par5 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(par5 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(par5 & 0xFF) / 255.0f;
        float f4 = (float)(par6 >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(par6 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(par6 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(par6 & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glShadeModel((int)7425);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78369_a(f1, f2, f3, f);
        tessellator.func_78377_a((double)par3, (double)par2, 0.0);
        tessellator.func_78377_a((double)par1, (double)par2, 0.0);
        tessellator.func_78369_a(f5, f6, f7, f4);
        tessellator.func_78377_a((double)par1, (double)par4, 0.0);
        tessellator.func_78377_a((double)par3, (double)par4, 0.0);
        tessellator.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    private static void pushViewport(int x, int y, int w, int h) {
        int tlx = x;
        int tly = y;
        int brx = x + w;
        int bry = y + h;
        x = tlx;
        y = tly;
        w = brx - tlx;
        h = bry - tly;
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution scaledRes = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        int guiScale = scaledRes.func_78325_e();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)(x * guiScale), (int)(mc.field_71440_d - y * guiScale - h * guiScale), (int)(w * guiScale), (int)(h * guiScale));
    }

    private static void disableViewport() {
        GL11.glScissor((int)0, (int)0, (int)Minecraft.func_71410_x().field_71443_c, (int)Minecraft.func_71410_x().field_71440_d);
        GL11.glDisable((int)3089);
    }
}

