/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.worksite;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHugeMushroom;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import net.shadowmage.ancientwarfare.automation.tile.TreeFinder;
import net.shadowmage.ancientwarfare.automation.tile.worksite.TileWorksiteUserBlocks;
import net.shadowmage.ancientwarfare.core.block.BlockRotationHandler;
import net.shadowmage.ancientwarfare.core.interfaces.IWorkSite;
import net.shadowmage.ancientwarfare.core.inventory.ItemSlotFilter;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public class WorkSiteMushroomFarm
extends TileWorksiteUserBlocks {
    private final Set<BlockPosition> blocksToHarvest = new HashSet<BlockPosition>();
    private final Set<BlockPosition> blocksToPlantMushroom = new HashSet<BlockPosition>();
    private final Set<BlockPosition> blocksToPlantNetherWart = new HashSet<BlockPosition>();
    private int mushroomCount;
    private int netherWartCount;

    public WorkSiteMushroomFarm() {
        this.inventory = new TileWorksiteUserBlocks.SlotListener(30);
        InventoryTools.IndexHelper helper = new InventoryTools.IndexHelper();
        int[] topIndices = helper.getIndiceArrayForSpread(27);
        int[] frontIndices = helper.getIndiceArrayForSpread(3);
        this.inventory.setAccessibleSideDefault(BlockRotationHandler.RelativeSide.TOP, BlockRotationHandler.RelativeSide.TOP, topIndices);
        this.inventory.setAccessibleSideDefault(BlockRotationHandler.RelativeSide.FRONT, BlockRotationHandler.RelativeSide.FRONT, frontIndices);
        ItemSlotFilter filter = new ItemSlotFilter(){

            public boolean apply(ItemStack stack) {
                if (stack == null || stack.func_77973_b() == Items.field_151075_bm) {
                    return true;
                }
                Block block = Block.func_149634_a((Item)stack.func_77973_b());
                return WorkSiteMushroomFarm.this.isFarmable(block);
            }
        };
        this.inventory.setFilterForSlots(filter, frontIndices);
    }

    @Override
    protected boolean isFarmable(Block block, int x, int y, int z) {
        if (super.isFarmable(block, x, y, z)) {
            EnumPlantType type = ((IPlantable)block).getPlantType((IBlockAccess)this.field_145850_b, x, y, z);
            return type == EnumPlantType.Cave || type == EnumPlantType.Nether;
        }
        return false;
    }

    @Override
    public void onBoundsAdjusted() {
        this.validateCollection(this.blocksToPlantMushroom);
        this.validateCollection(this.blocksToHarvest);
        this.validateCollection(this.blocksToPlantNetherWart);
    }

    @Override
    protected void countResources() {
        this.mushroomCount = 0;
        this.netherWartCount = 0;
        for (int i = 27; i < this.func_70302_i_(); ++i) {
            ItemStack item = this.func_70301_a(i);
            if (item == null) continue;
            if (item.func_77973_b() == Items.field_151075_bm) {
                this.netherWartCount += item.field_77994_a;
                continue;
            }
            Block block = Block.func_149634_a((Item)item.func_77973_b());
            if (!this.isFarmable(block)) continue;
            this.mushroomCount += item.field_77994_a;
        }
    }

    @Override
    protected int[] getIndicesForPickup() {
        return this.inventory.getRawIndicesCombined(BlockRotationHandler.RelativeSide.FRONT, BlockRotationHandler.RelativeSide.TOP);
    }

    @Override
    protected boolean processWork() {
        block8: {
            block9: {
                block7: {
                    BlockPosition pos;
                    if (this.blocksToHarvest.isEmpty()) break block7;
                    Iterator<BlockPosition> it = this.blocksToHarvest.iterator();
                    while (it.hasNext() && (pos = it.next()) != null) {
                        it.remove();
                        Block block = this.field_145850_b.func_147439_a(pos.x, pos.y, pos.z);
                        if (!(block instanceof BlockHugeMushroom) && !this.isFarmable(block, pos.x, pos.y, pos.z)) continue;
                        return this.harvestBlock(pos.x, pos.y, pos.z, BlockRotationHandler.RelativeSide.FRONT, BlockRotationHandler.RelativeSide.TOP);
                    }
                    break block8;
                }
                if (this.mushroomCount <= 0 || this.blocksToPlantMushroom.isEmpty()) break block9;
                Iterator<BlockPosition> it = this.blocksToPlantMushroom.iterator();
                for (int i = 27; i < this.func_70302_i_(); ++i) {
                    BlockPosition pos;
                    Block block;
                    ItemStack item = this.func_70301_a(i);
                    if (item == null || !this.isFarmable(block = Block.func_149634_a((Item)item.func_77973_b()))) continue;
                    while (it.hasNext() && (pos = it.next()) != null) {
                        it.remove();
                        if (!this.tryPlace(item, pos.x, pos.y, pos.z, ForgeDirection.UP)) continue;
                        --this.mushroomCount;
                        if (item.field_77994_a <= 0) {
                            this.func_70299_a(i, null);
                        }
                        return true;
                    }
                    return false;
                }
                break block8;
            }
            if (this.netherWartCount <= 0 || this.blocksToPlantNetherWart.isEmpty()) break block8;
            Iterator<BlockPosition> it = this.blocksToPlantNetherWart.iterator();
            for (int i = 27; i < this.func_70302_i_(); ++i) {
                BlockPosition pos;
                ItemStack item = this.func_70301_a(i);
                if (item == null || item.func_77973_b() != Items.field_151075_bm) continue;
                while (it.hasNext() && (pos = it.next()) != null) {
                    it.remove();
                    if (!this.tryPlace(item, pos.x, pos.y, pos.z, ForgeDirection.UP)) continue;
                    --this.netherWartCount;
                    if (item.field_77994_a <= 0) {
                        this.func_70299_a(i, null);
                    }
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public IWorkSite.WorkType getWorkType() {
        return IWorkSite.WorkType.FARMING;
    }

    @Override
    public boolean onBlockClicked(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            NetworkHandler.INSTANCE.openGui(player, 28, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return true;
    }

    @Override
    protected void scanBlockPosition(BlockPosition pos) {
        block9: {
            Block block;
            block7: {
                block8: {
                    block = this.field_145850_b.func_147439_a(pos.x, pos.y, pos.z);
                    if (!block.isReplaceable((IBlockAccess)this.field_145850_b, pos.x, pos.y, pos.z)) break block7;
                    if (!Blocks.field_150388_bm.func_149742_c(this.field_145850_b, pos.x, pos.y, pos.z)) break block8;
                    this.blocksToPlantNetherWart.add(pos);
                    break block9;
                }
                if (!Blocks.field_150338_P.func_149742_c(this.field_145850_b, pos.x, pos.y, pos.z)) break block9;
                this.blocksToPlantMushroom.add(pos);
                break block9;
            }
            if (block == Blocks.field_150388_bm) {
                if (this.field_145850_b.func_72805_g(pos.x, pos.y, pos.z) >= 3) {
                    this.blocksToHarvest.add(pos);
                }
            } else if (block instanceof BlockHugeMushroom && !this.blocksToHarvest.contains(pos)) {
                TreeFinder.DEFAULT.findAttachedTreeBlocks(block, this.field_145850_b, pos, this.blocksToHarvest);
            } else if (this.isFarmable(block, pos.x, pos.y, pos.z)) {
                HashSet<BlockPosition> harvestSet = new HashSet<BlockPosition>();
                TreeFinder.DEFAULT.findAttachedTreeBlocks(block, this.field_145850_b, pos, harvestSet);
                for (BlockPosition tp : harvestSet) {
                    if (this.isTarget(tp) || this.blocksToHarvest.contains(tp)) continue;
                    this.blocksToHarvest.add(tp);
                }
            }
        }
    }

    @Override
    protected boolean hasWorksiteWork() {
        return this.mushroomCount > 0 && !this.blocksToPlantMushroom.isEmpty() || this.netherWartCount > 0 && !this.blocksToPlantNetherWart.isEmpty() || !this.blocksToHarvest.isEmpty();
    }
}

