/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.worksite;

import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.common.Optional;
import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.scoreboard.Team;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.shadowmage.ancientwarfare.automation.config.AWAutomationStatics;
import net.shadowmage.ancientwarfare.automation.item.ItemWorksiteUpgrade;
import net.shadowmage.ancientwarfare.core.AncientWarfareCore;
import net.shadowmage.ancientwarfare.core.block.BlockRotationHandler;
import net.shadowmage.ancientwarfare.core.config.AWCoreStatics;
import net.shadowmage.ancientwarfare.core.interfaces.IInteractableTile;
import net.shadowmage.ancientwarfare.core.interfaces.IOwnable;
import net.shadowmage.ancientwarfare.core.interfaces.ITorque;
import net.shadowmage.ancientwarfare.core.interfaces.IWorkSite;
import net.shadowmage.ancientwarfare.core.interfaces.IWorker;
import net.shadowmage.ancientwarfare.core.upgrade.WorksiteUpgrade;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

@Optional.Interface(iface="cofh.api.energy.IEnergyHandler", modid="CoFHCore", striprefs=true)
public abstract class TileWorksiteBase
extends TileEntity
implements IWorkSite,
IInteractableTile,
IOwnable,
BlockRotationHandler.IRotatableTile,
IEnergyHandler {
    private String owningPlayer = "";
    private UUID ownerId;
    private EntityPlayer owner;
    private double efficiencyBonusFactor = 0.0;
    private EnumSet<WorksiteUpgrade> upgrades = EnumSet.noneOf(WorksiteUpgrade.class);
    private ForgeDirection orientation = ForgeDirection.NORTH;
    private final ITorque.TorqueCell torqueCell = new ITorque.TorqueCell(32.0, 0.0, AWCoreStatics.energyPerWorkUnit * 3.0, 1.0);
    private int workRetryDelay = 20;

    @Optional.Method(modid="CoFHCore")
    public final int getEnergyStored(ForgeDirection from) {
        return (int)(this.getTorqueStored(from) * AWAutomationStatics.torqueToRf);
    }

    @Optional.Method(modid="CoFHCore")
    public final int getMaxEnergyStored(ForgeDirection from) {
        return (int)(this.getMaxTorque(from) * AWAutomationStatics.torqueToRf);
    }

    @Optional.Method(modid="CoFHCore")
    public final boolean canConnectEnergy(ForgeDirection from) {
        return this.canOutputTorque(from) || this.canInputTorque(from);
    }

    @Optional.Method(modid="CoFHCore")
    public final int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Optional.Method(modid="CoFHCore")
    public final int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (!this.canInputTorque(from)) {
            return 0;
        }
        if (simulate) {
            return Math.min(maxReceive, (int)(AWAutomationStatics.torqueToRf * this.getMaxTorqueInput(from)));
        }
        return (int)(AWAutomationStatics.torqueToRf * this.addTorque(from, (double)maxReceive * AWAutomationStatics.rfToTorque));
    }

    @Override
    public final EnumSet<WorksiteUpgrade> getUpgrades() {
        return this.upgrades;
    }

    @Override
    public EnumSet<WorksiteUpgrade> getValidUpgrades() {
        return EnumSet.of(WorksiteUpgrade.ENCHANTED_TOOLS_1, WorksiteUpgrade.ENCHANTED_TOOLS_2, WorksiteUpgrade.TOOL_QUALITY_1, WorksiteUpgrade.TOOL_QUALITY_2, WorksiteUpgrade.TOOL_QUALITY_3);
    }

    @Override
    public void onBlockBroken() {
        for (WorksiteUpgrade ug : this.upgrades) {
            InventoryTools.dropItemInWorld(this.field_145850_b, ItemWorksiteUpgrade.getStack(ug), this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.efficiencyBonusFactor = 0.0;
        this.upgrades.clear();
    }

    @Override
    public void addUpgrade(WorksiteUpgrade upgrade) {
        this.upgrades.add(upgrade);
        this.updateEfficiency();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
    }

    @Override
    public void removeUpgrade(WorksiteUpgrade upgrade) {
        this.upgrades.remove((Object)upgrade);
        this.updateEfficiency();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
    }

    public int getFortune() {
        return this.getUpgrades().contains((Object)WorksiteUpgrade.ENCHANTED_TOOLS_2) ? 2 : (this.getUpgrades().contains((Object)WorksiteUpgrade.ENCHANTED_TOOLS_1) ? 1 : 0);
    }

    protected abstract boolean processWork();

    protected abstract boolean hasWorksiteWork();

    protected abstract void updateWorksite();

    public final boolean canUpdate() {
        return true;
    }

    public final void func_145845_h() {
        if (!this.func_145830_o() || this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.workRetryDelay > 0) {
            --this.workRetryDelay;
        } else {
            boolean hasWork;
            this.field_145850_b.field_72984_F.func_76320_a("Check For Work");
            double ePerUse = IWorkSite.WorksiteImplementation.getEnergyPerActivation(this.efficiencyBonusFactor);
            boolean bl = hasWork = this.getTorqueStored(ForgeDirection.UNKNOWN) >= ePerUse && this.hasWorksiteWork();
            if (hasWork) {
                this.field_145850_b.field_72984_F.func_76318_c("Process Work");
                if (this.processWork()) {
                    this.torqueCell.setEnergy(this.torqueCell.getEnergy() - ePerUse);
                    this.func_70296_d();
                } else {
                    this.workRetryDelay = 20;
                }
            }
            this.field_145850_b.field_72984_F.func_76319_b();
        }
        this.field_145850_b.field_72984_F.func_76320_a("WorksiteBaseUpdate");
        this.updateWorksite();
        this.field_145850_b.field_72984_F.func_76319_b();
    }

    protected final void updateEfficiency() {
        this.efficiencyBonusFactor = IWorkSite.WorksiteImplementation.getEfficiencyFactor(this.upgrades);
    }

    @Override
    public final Team getTeam() {
        if (this.owningPlayer != null) {
            return this.field_145850_b.func_96441_U().func_96509_i(this.owningPlayer);
        }
        return null;
    }

    @Override
    public final String getOwnerName() {
        return this.owningPlayer;
    }

    public final EntityPlayer getOwnerAsPlayer() {
        if (!this.isOwnerReal()) {
            this.owner = AncientWarfareCore.proxy.getFakePlayer(this.func_145831_w(), this.owningPlayer, this.ownerId);
        }
        return this.owner;
    }

    private boolean isOwnerReal() {
        return this.owner != null && this.owner.func_70089_S() && !this.owner.func_85032_ar();
    }

    @Override
    public final boolean isOwner(EntityPlayer player) {
        if (player == null || player.func_146103_bH() == null) {
            return false;
        }
        if (this.isOwnerReal()) {
            return player.func_146103_bH().equals((Object)this.owner.func_146103_bH());
        }
        if (this.ownerId != null) {
            return player.func_110124_au().equals(this.ownerId);
        }
        return player.func_70005_c_().equals(this.owningPlayer);
    }

    @Override
    public final void setOwner(EntityPlayer player) {
        if (player == null) {
            this.owningPlayer = "";
            this.owner = null;
            this.ownerId = null;
        } else {
            this.owner = player;
            this.owningPlayer = player.func_70005_c_();
            this.ownerId = player.func_110124_au();
        }
    }

    @Override
    public final float getClientOutputRotation(ForgeDirection from, float delta) {
        return 0.0f;
    }

    @Override
    public final boolean useOutputRotation(ForgeDirection from) {
        return false;
    }

    @Override
    public final double getMaxTorqueOutput(ForgeDirection from) {
        return 0.0;
    }

    @Override
    public final boolean canOutputTorque(ForgeDirection towards) {
        return false;
    }

    @Override
    public final double drainTorque(ForgeDirection from, double energy) {
        return 0.0;
    }

    @Override
    public final void addEnergyFromWorker(IWorker worker) {
        this.addTorque(ForgeDirection.UNKNOWN, AWCoreStatics.energyPerWorkUnit * (double)worker.getWorkEffectiveness(this.getWorkType()) * AWAutomationStatics.hand_cranked_generator_output);
    }

    @Override
    public final void addEnergyFromPlayer(EntityPlayer player) {
        this.addTorque(ForgeDirection.UNKNOWN, AWCoreStatics.energyPerWorkUnit * AWAutomationStatics.hand_cranked_generator_output);
    }

    @Override
    public final double addTorque(ForgeDirection from, double energy) {
        return this.torqueCell.addEnergy(energy);
    }

    @Override
    public final double getMaxTorque(ForgeDirection from) {
        return this.torqueCell.getMaxEnergy();
    }

    @Override
    public final double getTorqueStored(ForgeDirection from) {
        return this.torqueCell.getEnergy();
    }

    @Override
    public final double getMaxTorqueInput(ForgeDirection from) {
        return this.torqueCell.getMaxTickInput();
    }

    @Override
    public final boolean canInputTorque(ForgeDirection from) {
        return true;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public String toString() {
        return "Worksite Base[" + this.torqueCell.getEnergy() + "]";
    }

    @Override
    public boolean hasWork() {
        return this.torqueCell.getEnergy() < this.torqueCell.getMaxEnergy() && this.field_145850_b.func_94577_B(this.field_145851_c, this.field_145848_d, this.field_145849_e) == 0;
    }

    @Override
    public final ForgeDirection getPrimaryFacing() {
        return this.orientation;
    }

    @Override
    public final void setPrimaryFacing(ForgeDirection face) {
        this.orientation = face;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74780_a("storedEnergy", this.torqueCell.getEnergy());
        if (this.owningPlayer != null) {
            tag.func_74778_a("owner", this.owningPlayer);
            if (this.ownerId == null && this.func_145830_o()) {
                this.getOwnerAsPlayer();
                if (this.isOwnerReal()) {
                    this.ownerId = this.owner.func_110124_au();
                }
            }
        }
        if (this.ownerId != null) {
            tag.func_74778_a("ownerId", this.ownerId.toString());
        }
        if (!this.getUpgrades().isEmpty()) {
            int[] ug = new int[this.getUpgrades().size()];
            int i = 0;
            for (WorksiteUpgrade u : this.getUpgrades()) {
                ug[i] = u.ordinal();
                ++i;
            }
            tag.func_74783_a("upgrades", ug);
        }
        tag.func_74768_a("orientation", this.orientation.ordinal());
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.torqueCell.setEnergy(tag.func_74769_h("storedEnergy"));
        if (tag.func_74764_b("owner")) {
            this.owningPlayer = tag.func_74779_i("owner");
        }
        if (tag.func_74764_b("ownerId")) {
            this.ownerId = UUID.fromString(tag.func_74779_i("ownerId"));
        }
        if (tag.func_74764_b("upgrades")) {
            NBTBase upgradeTag = tag.func_74781_a("upgrades");
            if (upgradeTag instanceof NBTTagIntArray) {
                int[] ug;
                for (int anUg : ug = tag.func_74759_k("upgrades")) {
                    this.upgrades.add(WorksiteUpgrade.values()[anUg]);
                }
            } else if (upgradeTag instanceof NBTTagList) {
                NBTTagList list = (NBTTagList)upgradeTag;
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    String st = list.func_150307_f(i);
                    try {
                        int ug = Integer.parseInt(st);
                        this.upgrades.add(WorksiteUpgrade.values()[ug]);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        if (tag.func_74764_b("orientation")) {
            this.orientation = ForgeDirection.values()[tag.func_74762_e("orientation")];
        }
        this.updateEfficiency();
    }

    protected NBTTagCompound getDescriptionPacketTag(NBTTagCompound tag) {
        int[] ugs = new int[this.upgrades.size()];
        int i = 0;
        for (WorksiteUpgrade ug : this.upgrades) {
            ugs[i] = ug.ordinal();
            ++i;
        }
        tag.func_74783_a("upgrades", ugs);
        tag.func_74768_a("orientation", this.orientation.ordinal());
        return tag;
    }

    public final Packet func_145844_m() {
        NBTTagCompound tag = this.getDescriptionPacketTag(new NBTTagCompound());
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.upgrades.clear();
        if (pkt.func_148857_g().func_74764_b("upgrades")) {
            int[] ugs;
            for (int ug : ugs = pkt.func_148857_g().func_74759_k("upgrades")) {
                this.upgrades.add(WorksiteUpgrade.values()[ug]);
            }
        }
        this.updateEfficiency();
        this.orientation = ForgeDirection.values()[pkt.func_148857_g().func_74762_e("orientation")];
        this.func_70296_d();
    }
}

