/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraftforge.common.ForgeChunkManager;
import net.shadowmage.ancientwarfare.automation.container.ContainerChunkLoaderDeluxe;
import net.shadowmage.ancientwarfare.automation.tile.TileChunkLoaderSimple;
import net.shadowmage.ancientwarfare.core.interfaces.IInteractableTile;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;

public class TileChunkLoaderDeluxe
extends TileChunkLoaderSimple
implements IInteractableTile {
    private final Set<ChunkCoordIntPair> ccipSet = new HashSet<ChunkCoordIntPair>();
    private final List<ContainerChunkLoaderDeluxe> viewers = new ArrayList<ContainerChunkLoaderDeluxe>();

    @Override
    public boolean onBlockClicked(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            NetworkHandler.INSTANCE.openGui(player, 23, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return true;
    }

    public void addViewer(ContainerChunkLoaderDeluxe viewer) {
        this.viewers.add(viewer);
    }

    public void removeViewer(ContainerChunkLoaderDeluxe viewer) {
        this.viewers.remove((Object)viewer);
    }

    public void addOrRemoveChunk(ChunkCoordIntPair ccip) {
        if (this.ccipSet.contains(ccip)) {
            this.ccipSet.remove(ccip);
            ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkCoordIntPair)ccip);
        } else {
            this.ccipSet.add(ccip);
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkCoordIntPair)ccip);
        }
        this.func_70296_d();
        this.informViewers();
    }

    private void informViewers() {
        for (ContainerChunkLoaderDeluxe viewer : this.viewers) {
            viewer.onChunkLoaderSetUpdated(this.ccipSet);
        }
    }

    public Set<ChunkCoordIntPair> getForcedChunks() {
        return new HashSet<ChunkCoordIntPair>(this.ccipSet);
    }

    @Override
    protected void forceTicketChunks() {
        int cx = this.field_145851_c >> 4;
        int cz = this.field_145849_e >> 4;
        ChunkCoordIntPair ccip1 = new ChunkCoordIntPair(cx, cz);
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkCoordIntPair)ccip1);
        for (ChunkCoordIntPair ccip : this.ccipSet) {
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkCoordIntPair)ccip);
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagList list = tag.func_150295_c("chunkList", 10);
        this.ccipSet.clear();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound ccipTag = list.func_150305_b(i);
            ChunkCoordIntPair ccip = new ChunkCoordIntPair(ccipTag.func_74762_e("x"), ccipTag.func_74762_e("z"));
            this.ccipSet.add(ccip);
        }
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        NBTTagList list = new NBTTagList();
        for (ChunkCoordIntPair ccip : this.ccipSet) {
            NBTTagCompound ccipTag = new NBTTagCompound();
            ccipTag.func_74768_a("x", ccip.field_77276_a);
            ccipTag.func_74768_a("z", ccip.field_77275_b);
            list.func_74742_a((NBTBase)ccipTag);
        }
        tag.func_74782_a("chunkList", (NBTBase)list);
    }
}

