/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.render;

import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import net.shadowmage.ancientwarfare.automation.tile.torque.TileTorqueBase;
import net.shadowmage.ancientwarfare.core.interfaces.ITorque;
import net.shadowmage.ancientwarfare.core.model.ModelBaseAW;
import net.shadowmage.ancientwarfare.core.model.ModelLoader;
import net.shadowmage.ancientwarfare.core.model.ModelPiece;
import org.lwjgl.opengl.GL11;

public class RenderTileHandEngine
extends TileEntitySpecialRenderer
implements IItemRenderer {
    private final ResourceLocation texture;
    private final ModelBaseAW model;
    private final ModelPiece outputGear;
    private final ModelPiece inputGear;

    public RenderTileHandEngine() {
        ModelLoader loader = new ModelLoader();
        this.model = loader.loadModel(((Object)((Object)this)).getClass().getResourceAsStream("/assets/ancientwarfare/models/automation/hand_engine.m2f"));
        this.outputGear = this.model.getPiece("outputGear");
        this.inputGear = this.model.getPiece("inputGear");
        this.texture = new ResourceLocation("ancientwarfare", "textures/model/automation/hand_engine.png");
    }

    public void func_147500_a(TileEntity te, double x, double y, double z, float delta) {
        GL11.glPushMatrix();
        this.func_147499_a(this.texture);
        GL11.glTranslated((double)(x + 0.5), (double)y, (double)(z + 0.5));
        TileTorqueBase handEngine = (TileTorqueBase)te;
        float outRotation = -handEngine.getClientOutputRotation(handEngine.getPrimaryFacing(), delta);
        float inRotation = -handEngine.getClientOutputRotation(ForgeDirection.UP, delta);
        this.renderModel(inRotation, outRotation, ((TileTorqueBase)te).getPrimaryFacing().ordinal());
        GL11.glPopMatrix();
    }

    protected void renderModel(float inR, float outR, int face) {
        float[] rot = ITorque.forgeDiretctionToRotationMatrix[face];
        if (rot[0] != 0.0f) {
            GL11.glRotatef((float)rot[0], (float)1.0f, (float)0.0f, (float)0.0f);
        } else if (rot[1] != 0.0f) {
            GL11.glRotatef((float)rot[1], (float)0.0f, (float)1.0f, (float)0.0f);
        }
        this.outputGear.setRotation(0.0f, 0.0f, outR);
        this.inputGear.setRotation(0.0f, inR, 0.0f);
        this.model.renderModel();
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        GL11.glPushMatrix();
        this.func_147499_a(this.texture);
        GL11.glTranslated((double)0.5, (double)0.0, (double)0.5);
        this.renderModel(0.0f, 0.0f, 2);
        GL11.glPopMatrix();
    }
}

