/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.shadowmage.ancientwarfare.automation.container.ContainerWarehouseControl;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.TileWarehouseBase;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.Listener;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.Checkbox;
import net.shadowmage.ancientwarfare.core.gui.elements.CompositeItemSlots;
import net.shadowmage.ancientwarfare.core.gui.elements.CompositeScrolled;
import net.shadowmage.ancientwarfare.core.gui.elements.GuiElement;
import net.shadowmage.ancientwarfare.core.gui.elements.ItemSlot;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import net.shadowmage.ancientwarfare.core.gui.elements.Text;
import net.shadowmage.ancientwarfare.core.inventory.ItemQuantityMap;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public class GuiWarehouseControl
extends GuiContainerBase<ContainerWarehouseControl> {
    private CompositeScrolled area;
    private Text input;
    private InventoryTools.ComparatorItemStack.SortType sortType = InventoryTools.ComparatorItemStack.SortType.NAME;
    private InventoryTools.ComparatorItemStack.SortOrder sortOrder = InventoryTools.ComparatorItemStack.SortOrder.DESCENDING;
    private final InventoryTools.ComparatorItemStack sorter = new InventoryTools.ComparatorItemStack(this.sortType, this.sortOrder);
    private Label storedLabel;

    public GuiWarehouseControl(ContainerBase par1Container) {
        super(par1Container, 178, 240);
    }

    @Override
    public void initElements() {
        Button sortChange = new Button(8, 8, 110, 12, "guistrings.automation." + this.sortType.toString()){

            @Override
            protected void onPressed() {
                GuiWarehouseControl.this.sortType = GuiWarehouseControl.this.sortType.next();
                this.setText("guistrings.automation." + GuiWarehouseControl.this.sortType.toString());
                GuiWarehouseControl.this.refreshGui();
            }
        };
        this.addGuiElement(sortChange);
        Checkbox sortOrderBox = new Checkbox(122, 6, 16, 16, "guistrings.automation.descending"){

            @Override
            public void onToggled() {
                super.onToggled();
                GuiWarehouseControl.this.sortOrder = this.checked() ? InventoryTools.ComparatorItemStack.SortOrder.ASCENDING : InventoryTools.ComparatorItemStack.SortOrder.DESCENDING;
                String name = GuiWarehouseControl.this.sortOrder.name().toLowerCase(Locale.ENGLISH);
                this.label = StatCollector.func_74838_a((String)("guistrings.automation." + name));
                GuiWarehouseControl.this.refreshGui();
            }
        };
        this.addGuiElement(sortOrderBox);
        this.input = new Text(8, 24, 162, "", this){

            @Override
            public void onTextUpdated(String oldText, String newText) {
                if (!oldText.equals(newText)) {
                    GuiWarehouseControl.this.refreshGui();
                }
            }
        };
        this.addGuiElement(this.input);
        this.area = new CompositeItemSlots(this, 0, 38, 178, 96, this);
        Listener l = new Listener(8){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                if (evt.mButton == 0 && widget.isMouseOverElement(evt.mx, evt.my) && !GuiWarehouseControl.this.area.isMouseOverSubElement(evt.mx, evt.my)) {
                    ((ContainerWarehouseControl)((Object)GuiWarehouseControl.this.getContainer())).handleClientRequestSpecific(null, GuiScreen.func_146272_n());
                }
                return true;
            }
        };
        this.area.addNewListener(l);
        this.addGuiElement(this.area);
        Button b = new Button(8, 220, 40, 12, "guistrings.automation.adjust_bounds"){

            @Override
            protected void onPressed() {
                NetworkHandler.INSTANCE.openGui(GuiWarehouseControl.this.player, 46, ((TileWarehouseBase)((ContainerWarehouseControl)((Object)GuiWarehouseControl.this.getContainer())).tileEntity).field_145851_c, ((TileWarehouseBase)((ContainerWarehouseControl)((Object)GuiWarehouseControl.this.getContainer())).tileEntity).field_145848_d, ((TileWarehouseBase)((ContainerWarehouseControl)((Object)GuiWarehouseControl.this.getContainer())).tileEntity).field_145849_e);
            }
        };
        this.addGuiElement(b);
        this.storedLabel = new Label(52, 221, StatCollector.func_74837_a((String)"guistrings.warehouse.storage", (Object[])new Object[]{((ContainerWarehouseControl)((Object)this.getContainer())).currentStored, ((ContainerWarehouseControl)((Object)this.getContainer())).maxStorage}));
        this.addGuiElement(this.storedLabel);
    }

    @Override
    public void setupElements() {
        this.area.clearElements();
        this.addInventoryViewElements();
        this.storedLabel.setText(StatCollector.func_74837_a((String)"guistrings.warehouse.storage", (Object[])new Object[]{((ContainerWarehouseControl)((Object)this.getContainer())).currentStored, ((ContainerWarehouseControl)((Object)this.getContainer())).maxStorage}));
    }

    private void addInventoryViewElements() {
        ArrayList<ItemStack> displayStacks = new ArrayList<ItemStack>();
        for (ItemQuantityMap.ItemHashEntry entry : ((ContainerWarehouseControl)((Object)this.getContainer())).itemMap.keySet()) {
            ItemStack stack = entry.getItemStack();
            stack.field_77994_a = ((ContainerWarehouseControl)((Object)this.getContainer())).itemMap.getCount(entry);
            displayStacks.add(stack);
        }
        this.sortItems(displayStacks);
        int x = 0;
        int y = 0;
        int totalSize = 8;
        for (ItemStack displayStack : displayStacks) {
            ItemSlot slot = new ItemSlot(4 + x * 18, 3 + y * 18, displayStack, this){

                @Override
                public void onSlotClicked(ItemStack stack) {
                    ((ContainerWarehouseControl)((Object)GuiWarehouseControl.this.getContainer())).handleClientRequestSpecific(this.getStack(), GuiScreen.func_146272_n());
                }
            };
            this.area.addGuiElement(slot);
            if (++x < 9) continue;
            x = 0;
            ++y;
            totalSize += 18;
        }
        this.area.setAreaSize(totalSize + 8);
    }

    private void sortItems(List<ItemStack> items) {
        this.sorter.setSortType(this.sortType);
        this.sorter.setSortOrder(this.sortOrder);
        this.sorter.setTextInput(this.input.getText());
        Collections.sort(items, this.sorter);
    }
}

