/*
 * Decompiled with CFR 0.152.
 */
package Reika.GeoStrata.API;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class RockGetter {
    private static Class modClass;
    private static Block[] geoBlocks;
    private static ArrayList<Block> rockBlocks;
    private static Class typeRegistry;
    private static Class shapeRegistry;
    private static Method getStackByShape;
    private static Method getBlockByShape;
    private static boolean init;

    public static ItemStack getRockItem(String type, String shape) {
        if (!init) {
            return null;
        }
        try {
            Object rtype = Enum.valueOf(typeRegistry, type.toUpperCase());
            Object rshape = Enum.valueOf(shapeRegistry, shape.toUpperCase());
            return (ItemStack)getStackByShape.invoke(rtype, rshape);
        }
        catch (IllegalArgumentException e) {
            System.out.println("Invalid enum parameter!");
            System.out.println("Valid rock types: ");
            T[] types = typeRegistry.getEnumConstants();
            for (int i = 0; i < types.length; ++i) {
                System.out.println("\t" + ((Enum)types[i]).name());
            }
            System.out.println("");
            System.out.println("Valid rock shapes: ");
            T[] shapes = shapeRegistry.getEnumConstants();
            for (int i = 0; i < shapes.length; ++i) {
                System.out.println("\t" + ((Enum)shapes[i]).name());
            }
            e.printStackTrace();
            return null;
        }
        catch (Exception e) {
            System.out.println("GeoStrata rock type " + type + " and shape " + shape + " threw exception while fetching!");
            e.printStackTrace();
            return null;
        }
    }

    public static Block getRockBlock(String type, String shape) {
        if (!init) {
            return null;
        }
        try {
            Object rtype = Enum.valueOf(typeRegistry, type.toUpperCase());
            Object rshape = Enum.valueOf(shapeRegistry, shape.toUpperCase());
            return (Block)getBlockByShape.invoke(rtype, rshape);
        }
        catch (IllegalArgumentException e) {
            System.out.println("Invalid enum parameter!");
            System.out.println("Valid rock types: ");
            T[] types = typeRegistry.getEnumConstants();
            for (int i = 0; i < types.length; ++i) {
                System.out.println("\t" + ((Enum)types[i]).name());
            }
            System.out.println("");
            System.out.println("Valid rock shapes: ");
            T[] shapes = shapeRegistry.getEnumConstants();
            for (int i = 0; i < shapes.length; ++i) {
                System.out.println("\t" + ((Enum)shapes[i]).name());
            }
            e.printStackTrace();
            return null;
        }
        catch (Exception e) {
            System.out.println("GeoStrata rock type " + type + " and shape " + shape + " threw exception while fetching!");
            e.printStackTrace();
            return null;
        }
    }

    public static Block getSmoothRock(String type) {
        return RockGetter.getRockBlock(type, "SMOOTH");
    }

    public static Collection<Block> getAllBlocksFor(String type) {
        if (!init) {
            return null;
        }
        Object rtype = null;
        ArrayList<Block> c = new ArrayList<Block>();
        try {
            rtype = Enum.valueOf(typeRegistry, type.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            System.out.println("Invalid rock type " + type + "!");
            System.out.println("Valid rock types: ");
            T[] types = typeRegistry.getEnumConstants();
            for (int i = 0; i < types.length; ++i) {
                System.out.println("\t" + ((Enum)types[i]).name());
            }
            return null;
        }
        T[] shapes = shapeRegistry.getEnumConstants();
        for (int i = 0; i < shapes.length; ++i) {
            try {
                Block b = (Block)getBlockByShape.invoke(rtype, shapes[i]);
                if (c.contains(b)) continue;
                c.add(b);
                continue;
            }
            catch (Exception e) {
                System.out.println("GeoStrata rock type " + type + " and shape " + shapes[i] + " threw exception while fetching its blocks!");
                e.printStackTrace();
                return null;
            }
        }
        return c;
    }

    public static boolean isGeoStrataRock(Block b) {
        if (!init) {
            return false;
        }
        return rockBlocks.contains(b);
    }

    static {
        init = false;
        try {
            modClass = Class.forName("Reika.GeoStrata.GeoStrata", false, RockGetter.class.getClassLoader());
            geoBlocks = (Block[])modClass.getField("blocks").get(null);
            rockBlocks = (ArrayList)modClass.getField("rockBlocks").get(null);
            typeRegistry = Class.forName("Reika.GeoStrata.Registry.RockTypes");
            shapeRegistry = Class.forName("Reika.GeoStrata.Registry.RockShapes");
            getStackByShape = typeRegistry.getMethod("getItem", shapeRegistry);
            getBlockByShape = typeRegistry.getMethod("getID", shapeRegistry);
            init = true;
        }
        catch (ClassNotFoundException e) {
            System.out.println("GeoStrata class not found!");
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            System.out.println("GeoStrata class not read correctly!");
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            System.out.println("GeoStrata class not read correctly!");
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            System.out.println("GeoStrata class not read correctly!");
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            System.out.println("GeoStrata class not read correctly!");
            e.printStackTrace();
        }
        catch (SecurityException e) {
            System.out.println("GeoStrata class not read correctly!");
            e.printStackTrace();
        }
    }
}

