/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModRegistry;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.DragonAPIInit;
import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Interfaces.Registry.OreType;
import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.MekanismHandler;
import Reika.DragonAPI.ModInteract.RecipeHandlers.ModOreCompat;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public enum ModOreList implements OreType
{
    TIN("Tin", 11720169, OreType.OreRarity.COMMON, "ingotTin", 1, "oreTin", "oreCassiterite"),
    COPPER("Copper", 12348417, OreType.OreRarity.EVERYWHERE, "ingotCopper", 1, "oreCopper", "oreTetrahedrite"),
    LEAD("Lead", 6911383, OreType.OreRarity.AVERAGE, "ingotLead", 1, "oreLead"),
    NICKEL("Nickel", 13683885, OreType.OreRarity.SCATTERED, "ingotNickel", 1, "oreNickel", "orePentlandite"),
    SILVER("Silver", 10801370, OreType.OreRarity.AVERAGE, "ingotSilver", 1, "oreSilver"),
    GALENA("Galena", 8351381, OreType.OreRarity.SCATTERED, "dustGalena", 1, "oreGalena"),
    ALUMINUM("Aluminum", 0xF1F1F1, OreType.OreRarity.COMMON, ModOreList.getAluminumName(), 1, "oreAluminum", "oreAluminium", "oreNaturalAluminum"),
    IRIDIUM("Iridium", 12706515, OreType.OreRarity.RARE, "ingotIridium", 1, "oreIridium"),
    FIRESTONE("Firestone", 14784054, OreType.OreRarity.RARE, "shardFirestone", 1, "oreFirestone"),
    CERTUSQUARTZ("Certus Quartz", 12898047, OreType.OreRarity.AVERAGE, "crystalCertusQuartz", 2, "oreCertusQuartz"),
    URANIUM("Uranium", 5046016, OreType.OreRarity.SCATTERED, "ingotUranium", 1, "oreUranium", "oreYellorite", "oreUraninite"),
    CINNABAR("Mercury", 0x811A1A, OreType.OreRarity.SCATTERED, "itemQuicksilver", 1, "oreCinnabar"),
    AMBER("Amber", 11632407, OreType.OreRarity.SCATTERED, "gemAmber", 1, "oreAmber"),
    INFUSEDAIR("Air Infused", 11045938, OreType.OreRarity.SCATTERED, "shardAir", 2, "oreInfusedAir"),
    INFUSEDFIRE("Fire Infused", 11870464, OreType.OreRarity.SCATTERED, "shardFire", 2, "oreInfusedFire"),
    INFUSEDWATER("Water Infused", 31897, OreType.OreRarity.AVERAGE, "shardWater", 2, "oreInfusedWater"),
    INFUSEDEARTH("Earth Infused", 33280, OreType.OreRarity.SCATTERED, "shardEarth", 2, "oreInfusedEarth"),
    INFUSEDENTROPY("Entropy Infused", 0x555576, OreType.OreRarity.SCARCE, "shardEntropy", 2, "oreInfusedEntropy"),
    INFUSEDORDER("Order Infused", 0xDCDCFF, OreType.OreRarity.SCARCE, "shardOrder", 2, "oreInfusedOrder"),
    APATITE("Apatite", 3315397, OreType.OreRarity.COMMON, "gemApatite", 3, "oreApatite"),
    SALTPETER("Saltpeter", 0xFFFFFF, OreType.OreRarity.AVERAGE, "dustSaltpeter", 2, "oreSaltpeter"),
    TUNGSTEN("Tungsten", 0x1E1E1E, OreType.OreRarity.COMMON, "dustTungsten", 1, "oreTungsten", "oreTungstate"),
    NIKOLITE("Nikolite", 2993080, OreType.OreRarity.COMMON, "dustElectrotine", 5, "oreNikolite", "oreElectrotine"),
    PERIDOT("Peridot", 50198, OreType.OreRarity.SCARCE, "gemPeridot", 1, "orePeridot"),
    RUBY("Ruby", 0xBC0000, OreType.OreRarity.SCARCE, "gemRuby", 1, "oreRuby"),
    SAPPHIRE("Sapphire", 6570, OreType.OreRarity.SCARCE, "gemSapphire", 1, "oreSapphire"),
    MONAZIT("Monazit", 3960380, OreType.OreRarity.AVERAGE, "ForciciumItem", 4, "MonazitOre"),
    FORCE("Force", 16762624, OreType.OreRarity.AVERAGE, "gemForce", 3, "oreForce"),
    NETHERCOAL("Nether Coal", 0x262626, OreType.OreRarity.EVERYWHERE, "itemCoal", 1, "oreNetherCoal"),
    NETHERIRON("Nether Iron", 14200209, OreType.OreRarity.COMMON, "ingotIron", 1, "oreNetherIron"),
    NETHERGOLD("Nether Gold", 14066688, OreType.OreRarity.AVERAGE, "ingotGold", 1, "oreNetherGold"),
    NETHERREDSTONE("Nether Redstone", 0xBC0000, OreType.OreRarity.COMMON, "dustRedstone", 4, "oreNetherRedstone"),
    NETHERLAPIS("Nether Lapis", 2837503, OreType.OreRarity.AVERAGE, "dyeBlue", 6, "oreNetherLapis"),
    NETHERDIAMOND("Nether Diamond", 6881251, OreType.OreRarity.SCARCE, "gemDiamond", 1, "oreNetherDiamond"),
    NETHEREMERALD("Nether Emerald", 1235712, OreType.OreRarity.SCARCE, "gemEmerald", 1, "oreNetherEmerald"),
    NETHERTIN("Nether Tin", 11128034, OreType.OreRarity.COMMON, "ingotTin", 1, "oreNetherTin"),
    NETHERCOPPER("Nether Copper", 13141260, OreType.OreRarity.COMMON, "ingotCopper", 1, "oreNetherCopper"),
    NETHERLEAD("Nether Lead", 7306659, OreType.OreRarity.AVERAGE, "ingotLead", 1, "oreNetherLead"),
    NETHERNICKEL("Nether Nickel", 11972229, OreType.OreRarity.AVERAGE, "ingotNickel", 1, "oreNetherNickel"),
    NETHERSILVER("Nether Silver", 11003116, OreType.OreRarity.AVERAGE, "ingotSilver", 1, "oreNetherSilver"),
    NETHERNIKOLITE("Nether Nikolite", 11003116, OreType.OreRarity.AVERAGE, "dustNikolite", 5, "oreNetherNikolite"),
    COBALT("Cobalt", 1847461, OreType.OreRarity.SCARCE, "ingotCobalt", 1, "oreCobalt"),
    ARDITE("Ardite", 16026112, OreType.OreRarity.SCARCE, "ingotArdite", 1, "oreArdite"),
    PLATINUM("Platinum", 41179, OreType.OreRarity.RARE, "ingotPlatinum", 1, "orePlatinum", "oreCooperite"),
    NETHERPLATINUM("Nether Platinum", 561886, OreType.OreRarity.RARE, "ingotPlatinum", 1, "oreNetherPlatinum"),
    ZINC("Zinc", 0x9B9B9B, OreType.OreRarity.COMMON, "ingotZinc", 1, "oreZinc", "oreSphalerite"),
    OSMIUM("Osmium", 11055335, OreType.OreRarity.COMMON, "ingotOsmium", 1, "oreOsmium"),
    NETHERPIGIRON("Pig Iron", 12956586, OreType.OreRarity.SCATTERED, "ingotSteel", 1, "oreNetherSteel"),
    SULFUR("Sulfur", 0xFFFF00, OreType.OreRarity.COMMON, "dustSulfur", 3, "oreSulfur"),
    PITCHBLENDE("Pitchblende", 5131899, OreType.OreRarity.AVERAGE, "ingotUranium", 1, "orePitchblende"),
    CADMIUM("Cadmium", 8890088, OreType.OreRarity.AVERAGE, "ingotCadmium", 1, "oreCadmium"),
    INDIUM("Indium", 11780056, OreType.OreRarity.SCATTERED, "ingotIndium", 1, "oreIndium"),
    FLUORITE("Fluorite", 14668970, OreType.OreRarity.EVERYWHERE, "gemFluorite", 6, "oreFluorite"),
    BAUXITE("Bauxite", 7484203, OreType.OreRarity.AVERAGE, "dustBauxite", 1, "oreBauxite"),
    SODALITE("Sodalite", 1260717, OreType.OreRarity.EVERYWHERE, "dyeBlue", 1, "oreSodalite"),
    PYRITE("Pyrite", 14791985, OreType.OreRarity.COMMON, "dustPyrite", 1, "orePyrite"),
    AMMONIUM("Ammonium Chloride", 16775648, OreType.OreRarity.SCATTERED, "dustAmmonium", 1, "oreAmmonium"),
    CALCITE("Calcite", 16738816, OreType.OreRarity.SCATTERED, "gemCalcite", 1, "oreCalcite"),
    CHIMERITE("Chimerite", 13362677, OreType.OreRarity.SCATTERED, "gemChimerite", 2, "oreChimerite"),
    VINTEUM("Vinteum", 5274556, OreType.OreRarity.SCATTERED, "dustVinteum", 1, "oreVinteum"),
    BLUETOPAZ("Blue Topaz", 9613808, OreType.OreRarity.SCATTERED, "gemBlueTopaz", 1, "oreBlueTopaz"),
    MOONSTONE("Moonstone", 6656717, OreType.OreRarity.RARE, "gemMoonstone", 1, "oreMoonstone"),
    SUNSTONE("Sunstone", 13717766, OreType.OreRarity.RARE, "gemSunstone", 1, "oreSunstone"),
    TITANIUM("Titanium", 8427415, OreType.OreRarity.SCARCE, "ingotTitanium", 1, "oreTitanium"),
    MAGMANITE("Magmanite", 16342272, OreType.OreRarity.SCATTERED, "dropMagma", 1, "oreMagmanite"),
    MAGNETITE("Magnetite", 0x44442D, OreType.OreRarity.AVERAGE, "gemMagnetite", 1, "oreMagnetite"),
    ESSENCE("Essence", 1409557, OreType.OreRarity.AVERAGE, "itemEssence", 4, "oreEssence", "oreNetherEssence", "oreEndEssence"),
    MIMICHITE("Mimichite", 8978687, OreType.OreRarity.SCATTERED, "gemMimichite", 1, "oreMimichite"),
    NETHERURANIUM("Nether Uranium", 43520, OreType.OreRarity.SCARCE, "ingotUranium", 1, "oreNetherUranium"),
    QUANTUM("Quantum", 6006338, OreType.OreRarity.SCATTERED, "dustQuantum", 2, "oreQuantum"),
    NETHERIRIDIUM("Nether Iridium", 11990727, OreType.OreRarity.RARE, "ingotIridium", 1, "oreNetherIridium"),
    DARKIRON("Dark Iron", 5177553, OreType.OreRarity.AVERAGE, "ingotFzDarkIron", 1, "oreFzDarkIron"),
    CHROMITE("Chromite", 9756917, OreType.OreRarity.AVERAGE, "ingotChrome", 1, "oreChromite"),
    NETHERSAPPHIRE("Nether Sapphire", 2423, OreType.OreRarity.SCARCE, "gemSapphire", 1, "oreNetherSapphire"),
    NETHERPERIDOT("Nether Peridot", 41992, OreType.OreRarity.SCARCE, "gemPeridot", 1, "oreNetherGreenSapphire", "oreNetherPeridot"),
    NETHERTITANIUM("Nether Titanium", 41992, OreType.OreRarity.SCATTERED, "ingotTitanium", 1, "oreNetherTitanium"),
    NETHERSULFUR("Nether Sulfur", 41992, OreType.OreRarity.COMMON, "dustSulfur", 3, "oreNetherSulfur"),
    NETHEROSMIUM("Nether Osmium", 10002647, OreType.OreRarity.AVERAGE, "ingotOsmium", 1, "oreNetherOsmium"),
    SILICON("Silicon", 0x777777, OreType.OreRarity.AVERAGE, "itemSilicon", 1, "oreSilicon"),
    RUTILE("Rutile", 6381143, OreType.OreRarity.SCATTERED, "ingotRutile", 1, "oreRutile"),
    AMETHYST("Amethyst", 0xFF00FF, OreType.OreRarity.RARE, "gemAmethyst", 1, "oreAmethyst"),
    TESLATITE("Teslatite", 3113457, OreType.OreRarity.COMMON, "dustTeslatite", 3, "oreTeslatite"),
    MANA("Mana", 7396092, OreType.OreRarity.SCARCE, "ingotMana", 1, "oreMana"),
    NETHERSALTPETER("Nether Saltpeter", 0xDDDDDD, OreType.OreRarity.SCARCE, "dustSaltpeter", 4, "oreNetherSaltpeter"),
    THORIUM("Thorium", 0x595959, OreType.OreRarity.SCARCE, "dustThorium", 1, "oreThorium", "oreThorite", "oreThorianite"),
    DRACONIUM("Draconium", 10420706, OreType.OreRarity.SCATTERED, "dustDraconium", 2, "oreDraconium"),
    ENDIUM("Endium", 3613526, OreType.OreRarity.SCATTERED, "ingotEndium", 1, "oreEndium", "oreHeeEndium"),
    DILITHIUM("Dilithium", 13089463, OreType.OreRarity.SCATTERED, "dustDilithium", 1, "oreDilithium"),
    EXIMITE("Eximite", 8149654, OreType.OreRarity.SCARCE, "ingotEximite", 1, "oreEximite"),
    MEUTOITE("Meutoite", 6247017, OreType.OreRarity.SCARCE, "ingotMeutoite", 1, "oreMeutoite");

    private final ArrayList<ItemStack> ores = new ArrayList();
    public final String displayName;
    private String[] oreLabel;
    public final int dropCount;
    public final int oreColor;
    private String product;
    private boolean init;
    public final OreType.OreRarity rarity;
    private final MultiMap<String, ItemStack> perName = new MultiMap();
    public static final ModOreList[] oreList;
    private static final ItemHashMap<ModOreList> oreMappings;
    private static final HashMap<String, ModOreList> oreNames;
    private static final HashMap<String, ModOreList> enumNames;

    private ModOreList(String n2, int color, OreType.OreRarity r, String prod, int count, String ... ore) {
        this.dropCount = count;
        this.oreColor = color;
        this.displayName = n2;
        this.product = prod;
        this.oreLabel = new String[ore.length];
        for (int i = 0; i < ore.length; ++i) {
            this.oreLabel[i] = ore[i];
        }
        this.rarity = r;
        DragonAPICore.log("Adding ore entries for " + this.toString() + " (Ore Names: " + Arrays.toString(ore) + ")");
    }

    private static String getAluminumName() {
        return ModList.GREGTECH.isLoaded() ? "dustAluminum" : "ingotAluminum";
    }

    public static void initializeAll() {
        if (!DragonAPIInit.canLoadHandlers()) {
            throw new MisuseException("Initialized registry enum too early! Wait until postInit!");
        }
        for (int i = 0; i < oreList.length; ++i) {
            oreList[i].initialize();
        }
    }

    public void addOreDictName(String s) {
        if (!ReikaArrayHelper.arrayContains(this.oreLabel, s, false)) {
            this.oreLabel = Arrays.copyOf(this.oreLabel, this.oreLabel.length + 1);
            this.oreLabel[this.oreLabel.length - 1] = s;
        }
        this.initialize();
    }

    public void initialize() {
        DragonAPICore.log("Loading ore type " + this);
        this.ores.clear();
        for (int i = 0; i < this.oreLabel.length; ++i) {
            String label = this.oreLabel[i];
            oreNames.put(label, this);
            ArrayList toadd = OreDictionary.getOres((String)label);
            if (!toadd.isEmpty()) {
                Iterator it = toadd.iterator();
                while (it.hasNext()) {
                    ItemStack is = (ItemStack)it.next();
                    if (is.func_77973_b() != null) continue;
                    it.remove();
                }
                DragonAPICore.log("\tDetected the following blocks for " + this + " from OreDict \"" + label + "\": " + toadd.toString());
                for (ItemStack is : toadd) {
                    if (ReikaItemHelper.isBlock(is)) {
                        if (!ReikaItemHelper.collectionContainsItemStack(this.ores, is)) {
                            this.ores.add(is);
                        }
                        this.perName.addValue(label, is);
                        continue;
                    }
                    DragonAPICore.log("\t" + is + " is not an ore block, but was OreDict fetched by \"" + label + "\"!");
                }
                continue;
            }
            DragonAPICore.log("\tNo ore blocks detected for \"" + label + "\"");
        }
        DragonAPICore.log("\tAdding special blocks for " + this + ":");
        Collection<ItemStack> c = ModOreCompat.instance.load(this);
        if (c.isEmpty()) {
            DragonAPICore.log("\tNo special blocks found.");
        } else {
            DragonAPICore.log("\t" + c.size() + " special blocks found: " + c);
            for (ItemStack is : c) {
                if (ReikaItemHelper.collectionContainsItemStack(this.ores, is)) continue;
                this.ores.add(is);
            }
        }
        if (!this.existsInGame()) {
            DragonAPICore.log("\tNo ore blocks detected for " + this);
        }
        this.loadCache();
    }

    private final void loadCache() {
        for (int i = 0; i < this.ores.size(); ++i) {
            ItemStack is = this.ores.get(i);
            oreMappings.put(is, this);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.displayName);
        return sb.toString();
    }

    public boolean isThaumcraft() {
        return this.name().contains("INFUSED") || this.name().equals("CINNABAR") || this.name().equals("AMBER");
    }

    public boolean isNetherOres() {
        return this.name().startsWith("NETHER");
    }

    public boolean isGregtech() {
        switch (this) {
            case BAUXITE: 
            case GALENA: 
            case PYRITE: 
            case SODALITE: 
            case TUNGSTEN: 
            case ZINC: {
                return true;
            }
        }
        return false;
    }

    public static boolean isModOre(ItemStack is) {
        return ModOreList.getModOreFromOre(is) != null;
    }

    public static boolean isModOre(Block b, int meta) {
        return ModOreList.getModOreFromOre(b, meta) != null;
    }

    public static ModOreList getModOreFromOre(Block b, int meta) {
        return ModOreList.getModOreFromOre(new ItemStack(b, 1, meta));
    }

    public static ModOreList getModOreFromOre(ItemStack is) {
        if (is == null || is.func_77973_b() == null) {
            return null;
        }
        if (ReikaItemHelper.matchStackWithBlock(is, MekanismHandler.getInstance().oreID)) {
            return MekanismHandler.getInstance().getModOre(is.func_77973_b(), is.func_77960_j());
        }
        return oreMappings.get(is);
    }

    public static ModOreList getEntryFromDamage(int dmg) {
        if (ReikaMathLibrary.isValueInsideBoundsIncl(0, oreList.length - 1, dmg)) {
            return oreList[dmg];
        }
        return null;
    }

    @Override
    public String[] getOreDictNames() {
        String[] arr = new String[this.oreLabel.length];
        System.arraycopy(this.oreLabel, 0, arr, 0, this.oreLabel.length);
        return arr;
    }

    @Override
    public String getProductOreDictName() {
        return this.product;
    }

    @Override
    public int getDropCount() {
        return this.dropCount;
    }

    public boolean isIngotType() {
        return this.product.contains("ingot");
    }

    public boolean isDustType() {
        return this.product.contains("dust");
    }

    public boolean isGemType() {
        return this.product.contains("gem") || this.product.contains("crystal");
    }

    public String getTypeName() {
        if (this.isIngotType()) {
            return "Ingot";
        }
        if (this.isDustType()) {
            return "Dust";
        }
        if (this.isGemType()) {
            return "Gem";
        }
        return "Item";
    }

    public static ArrayList<ItemStack> getAllRegisteredOreBlocks() {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        for (int i = 0; i < oreList.length; ++i) {
            li.addAll(ModOreList.oreList[i].ores);
        }
        return li;
    }

    @Override
    public ItemStack getFirstOreBlock() {
        if (!this.existsInGame()) {
            return null;
        }
        return this.ores.get(0);
    }

    public ItemStack getRandomOreBlock() {
        if (!this.existsInGame()) {
            return null;
        }
        int s = this.ores.size();
        int index = new Random().nextInt(s);
        return this.ores.get(index);
    }

    @Override
    public Collection<ItemStack> getAllOreBlocks() {
        return Collections.unmodifiableCollection(this.ores);
    }

    @Override
    public boolean existsInGame() {
        return !this.ores.isEmpty();
    }

    @Override
    public OreType.OreRarity getRarity() {
        return this.rarity;
    }

    public boolean isNether() {
        if (this.isNetherOres()) {
            return true;
        }
        if (this == ARDITE || this == COBALT) {
            return true;
        }
        if (this == SUNSTONE) {
            return true;
        }
        if (this == FIRESTONE) {
            return true;
        }
        if (this == PYRITE) {
            return true;
        }
        if (this == AMMONIUM) {
            return true;
        }
        return this == THORIUM;
    }

    public boolean isEnd() {
        return this == SODALITE;
    }

    @Override
    public EnumSet<OreType.OreLocation> getOreLocations() {
        if (this == MIMICHITE) {
            return EnumSet.of(OreType.OreLocation.OVERWORLD, OreType.OreLocation.NETHER, OreType.OreLocation.END);
        }
        if (this == PITCHBLENDE) {
            return EnumSet.of(OreType.OreLocation.OVERWORLD, OreType.OreLocation.END);
        }
        return this.isEnd() ? EnumSet.of(OreType.OreLocation.END) : (this.isNether() ? EnumSet.of(OreType.OreLocation.NETHER) : EnumSet.of(OreType.OreLocation.OVERWORLD));
    }

    public boolean isArsMagica() {
        switch (this) {
            case CHIMERITE: 
            case VINTEUM: 
            case BLUETOPAZ: 
            case MOONSTONE: 
            case SUNSTONE: {
                return true;
            }
        }
        return false;
    }

    public boolean isMetallurgy() {
        switch (this) {
            default: 
        }
        return false;
    }

    @Override
    public boolean canGenerateIn(Block b) {
        for (OreType.OreLocation loc : this.getOreLocations()) {
            if (loc.genBlock != b) continue;
            return true;
        }
        return false;
    }

    public Collection<ItemStack> getGennableIn(Block b) {
        for (int i = 0; i < this.ores.size(); ++i) {
            ItemStack is = this.ores.get(i);
            Block block = Block.func_149634_a((Item)is.func_77973_b());
        }
        return null;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public boolean contains(ItemStack is) {
        return ReikaItemHelper.collectionContainsItemStack(this.getAllOreBlocks(), is);
    }

    public static ModList getOreModFromItemStack(ItemStack is) {
        if (ReikaBlockHelper.isOre(is)) {
            if (ReikaItemHelper.isBlock(is)) {
                Block b = Block.func_149634_a((Item)is.func_77973_b());
                GameRegistry.UniqueIdentifier dat = GameRegistry.findUniqueIdentifierFor((Block)b);
                if (dat != null) {
                    String modName = dat.name;
                    String id = dat.modId;
                    ModList mod = ModList.getModFromID(id);
                    return mod;
                }
            } else {
                DragonAPICore.logError("\t" + is + " is not an ore block, but was registered as an ore block! This is a bug in its parent mod!");
            }
        }
        return null;
    }

    public static boolean isModOreType(String s) {
        return oreNames.containsKey(s);
    }

    public static ModOreList getByOreName(String s) {
        return oreNames.get(s);
    }

    public static ModOreList getByDrop(ItemStack is) {
        int[] ids = OreDictionary.getOreIDs((ItemStack)is);
        for (int i = 0; i < ids.length; ++i) {
            String s = OreDictionary.getOreName((int)ids[i]);
            ModOreList ore = oreNames.get(s);
            if (ore == null) continue;
            return ore;
        }
        return null;
    }

    public static ModOreList getByEnumName(String name) {
        return enumNames.get(name);
    }

    @Override
    public int getDisplayColor() {
        return this.oreColor;
    }

    static {
        oreList = ModOreList.values();
        oreMappings = new ItemHashMap();
        oreNames = new HashMap();
        enumNames = new HashMap();
        for (int i = 0; i < oreList.length; ++i) {
            enumNames.put(oreList[i].name(), oreList[i]);
        }
    }
}

