/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.ItemHandlers;

import Reika.DragonAPI.Base.ModHandlerBase;
import Reika.DragonAPI.Instantiable.Data.KeyedItemStack;
import Reika.DragonAPI.Interfaces.Registry.OreType;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaOreHelper;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.ModOreList;
import cpw.mods.fml.common.Loader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public final class GregOreHandler
extends ModHandlerBase {
    private static final GregOreHandler instance = new GregOreHandler();
    private boolean allOres = true;
    private final HashSet<KeyedItemStack> oreSet = new HashSet();

    private GregOreHandler() {
        if (this.hasMod()) {
            for (CounterpartOres ore : CounterpartOres.oreList) {
                this.allOres &= ore.init();
                for (ItemStack is : ore.ores) {
                    this.oreSet.add(new KeyedItemStack(is).setSimpleHash(true));
                }
            }
        } else {
            this.noMod();
        }
    }

    public static GregOreHandler getInstance() {
        return instance;
    }

    @Override
    public boolean initializedProperly() {
        return this.allOres;
    }

    @Override
    public ModList getMod() {
        return ModList.GREGTECH;
    }

    public boolean isGregOre(Block b) {
        String n = Block.field_149771_c.func_148750_c((Object)b);
        return n.startsWith("gt.") && (n.startsWith("gt.blockores") || n.startsWith("gt.meta.ore.") || n.startsWith("gt.block.rockores"));
    }

    public boolean isHandledGregOre(ItemStack is) {
        return this.oreSet.contains(new KeyedItemStack(is).setSimpleHash(true));
    }

    public boolean isGreg6() {
        return Loader.isModLoaded((String)"gregapi_post");
    }

    public static enum CounterpartOres {
        CASSITERITE(ModOreList.TIN, 2.0, new String[0]),
        PYRITE(ReikaOreHelper.IRON, 0.3333333333333333, new String[0]),
        LIMONITE(ReikaOreHelper.IRON, 0.25, "YellowLimonite", "BrownLimonite"),
        HEMATITE(ReikaOreHelper.IRON, 0.4, new String[0]),
        MAGNETITE(ReikaOreHelper.IRON, 0.42857142857142855, new String[0]),
        MINERALSAND(ReikaOreHelper.IRON, 0.21428571428571427, "BasalticMineralSand", "GraniticMineralSand"),
        GARNIERITE(ModOreList.NICKEL, 1.0, new String[0]),
        PENTLANDITE(ModOreList.NICKEL, 0.5294117647058824, new String[0]),
        CHALCOPYRITE(ModOreList.COPPER, 0.25, new String[0]),
        KESTERITE(ModOreList.COPPER, 0.25, new String[0]),
        STANNITE(ModOreList.COPPER, 0.25, new String[0]),
        MALACHITE(ModOreList.COPPER, 0.2, new String[0]),
        TETRAHEDRITE(ModOreList.COPPER, 0.375, new String[0]),
        SCHEELITE(ModOreList.TUNGSTEN, 0.16666666666666666, new String[0]),
        WOLFRAMITE(ModOreList.TUNGSTEN, 0.16666666666666666, new String[0]),
        FERBERITE(ModOreList.TUNGSTEN, 0.16666666666666666, new String[0]),
        HUEBNERITE(ModOreList.TUNGSTEN, 0.16666666666666666, new String[0]),
        STOLZITE(ModOreList.TUNGSTEN, 0.16666666666666666, new String[0]),
        TUNGSTATE(ModOreList.TUNGSTEN, 0.14285714285714285, new String[0]),
        RUSSELITE(ModOreList.TUNGSTEN, 0.1111111111111111, new String[0]),
        PINALITE(ModOreList.TUNGSTEN, 0.09090909090909091, new String[0]),
        URANINITE(ModOreList.URANIUM, 1.0, new String[0]),
        PITCHBLENDE(ModOreList.URANIUM, 0.6, new String[0]),
        BROMARGYRITE(ModOreList.SILVER, 0.5, new String[0]),
        COOPERITE(ModOreList.PLATINUM, 0.5, new String[0]);

        public final OreType counterpart;
        public final double yieldFraction;
        private final HashSet<String> internalNames;
        private final Collection<ItemStack> ores = new ArrayList<ItemStack>();
        public static final CounterpartOres[] oreList;

        private CounterpartOres(OreType ore, double f, String ... n2) {
            this.counterpart = ore;
            this.yieldFraction = f;
            this.internalNames = ReikaJavaLibrary.makeSetFromArray(n2);
            if (this.internalNames.isEmpty()) {
                this.internalNames.add(ReikaStringParser.capFirstChar(this.name()));
            }
        }

        public boolean init() {
            this.ores.clear();
            for (String s : this.internalNames) {
                for (ItemStack is : OreDictionary.getOres((String)s)) {
                    if (!ModList.GREGTECH.modLabel.equals(ReikaItemHelper.getRegistrantMod(is))) continue;
                    this.ores.add(is);
                }
            }
            return !this.ores.isEmpty();
        }

        public Collection<ItemStack> getAllOreBlocks() {
            return Collections.unmodifiableCollection(this.ores);
        }

        public String toString() {
            return this.name() + " (~" + this.counterpart.toString() + " x " + this.yieldFraction + ") < " + this.internalNames;
        }

        static {
            oreList = CounterpartOres.values();
        }
    }
}

