/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.Bees;

import Reika.DragonAPI.Auxiliary.Trackers.ReflectiveFailureTracker;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.Bees.BeeAlleleRegistry;
import Reika.DragonAPI.ModInteract.Bees.BeeEvent;
import Reika.DragonAPI.ModInteract.ItemHandlers.ForestryHandler;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.common.eventhandler.Event;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.IAlleleGrowth;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.ITreeRoot;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleArea;
import forestry.api.genetics.IAlleleBoolean;
import forestry.api.genetics.IAlleleFloat;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IAlleleTolerance;
import forestry.api.genetics.IChromosome;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.EnumButterflyChromosome;
import forestry.api.lepidopterology.EnumFlutterType;
import forestry.api.lepidopterology.IButterflyGenome;
import forestry.api.lepidopterology.IButterflyRoot;
import forestry.api.multiblock.IAlvearyController;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import org.apache.commons.lang3.text.WordUtils;

public class ReikaBeeHelper {
    private static Field beeHealth;
    private static final HashSet<String> allBees;

    public static void buildSpeciesList() {
        allBees.clear();
        for (IAllele ia : AlleleManager.alleleRegistry.getRegisteredAlleles((IChromosomeType)EnumBeeChromosome.SPECIES)) {
            if (ia == null || ia.getUID() == null) continue;
            allBees.add(ia.getUID());
        }
    }

    public static Set<String> getAllBeeSpecies() {
        if (allBees.isEmpty()) {
            ReikaBeeHelper.buildSpeciesList();
        }
        return Collections.unmodifiableSet(allBees);
    }

    public static String getRandomBeeSpecies() {
        return ReikaJavaLibrary.getRandomCollectionEntry(DragonAPICore.rand, ReikaBeeHelper.getAllBeeSpecies());
    }

    public static final ItemStack getBeeItem(String bee, EnumBeeType type) {
        return ReikaBeeHelper.getBeeItem(ReikaWorldHelper.getBasicReferenceWorld(), bee, type);
    }

    public static final ItemStack getBeeItem(World world, String bee, EnumBeeType type) {
        IBeeRoot root = BeeManager.beeRoot;
        return root.getMemberStack((IIndividual)root.getBee(world, root.templateAsGenome(root.getTemplate(bee))), type.ordinal());
    }

    public static final ItemStack getTreeItem(String Tree, EnumGermlingType type) {
        return ReikaBeeHelper.getTreeItem(ReikaWorldHelper.getBasicReferenceWorld(), Tree, type);
    }

    public static final ItemStack getTreeItem(World world, String Tree, EnumGermlingType type) {
        ITreeRoot root = TreeManager.treeRoot;
        return root.getMemberStack((IIndividual)root.getTree(world, root.templateAsGenome(root.getTemplate(Tree))), type.ordinal());
    }

    public static final ItemStack getButterflyItem(String Butterfly, EnumFlutterType type) {
        IButterflyRoot root = ButterflyManager.butterflyRoot;
        return root.getMemberStack((IIndividual)root.templateAsIndividual(root.getTemplate(Butterfly)), type.ordinal());
    }

    public static void analyzeBee(ItemStack is) {
        IIndividual bee;
        if (is != null && (bee = AlleleManager.alleleRegistry.getIndividual(is)) != null) {
            bee.analyze();
            ReikaBeeHelper.saveBee(bee, is);
        }
    }

    public static void ageBee(World world, ItemStack is, float modifier) {
        IIndividual bee;
        if (is != null && (bee = AlleleManager.alleleRegistry.getIndividual(is)) instanceof IBee) {
            ((IBee)bee).age(world, modifier);
            ReikaBeeHelper.saveBee(bee, is);
        }
    }

    public static void rejuvenateBee(IAlvearyController iac, ItemStack is) {
        IIndividual bee;
        if (is != null && (bee = AlleleManager.alleleRegistry.getIndividual(is)) instanceof IBee) {
            int max = ((IBee)bee).getMaxHealth();
            ReikaBeeHelper.setBeeHealth(iac, (IBee)bee, max);
            ReikaBeeHelper.saveBee(bee, is);
        }
    }

    private static void setBeeHealth(IAlvearyController iac, IBee bee, int health) {
        try {
            beeHealth.set(bee, health);
            MinecraftForge.EVENT_BUS.post((Event)new BeeEvent.BeeSetHealthEvent((IBeeHousing)iac, iac.getBeekeepingLogic(), bee));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void rejuvenateBee(IBeeHousing te, IBeekeepingLogic lgc, ItemStack is) {
        IIndividual bee;
        if (is != null && (bee = AlleleManager.alleleRegistry.getIndividual(is)) instanceof IBee) {
            int max = ((IBee)bee).getMaxHealth();
            ReikaBeeHelper.setBeeHealth(te, lgc, (IBee)bee, max);
            ReikaBeeHelper.saveBee(bee, is);
        }
    }

    private static void setBeeHealth(IBeeHousing te, IBeekeepingLogic lgc, IBee bee, int health) {
        try {
            beeHealth.set(bee, health);
            MinecraftForge.EVENT_BUS.post((Event)new BeeEvent.BeeSetHealthEvent(te, lgc, bee));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isBee(ItemStack is) {
        return is.func_77973_b() == ForestryHandler.ItemEntry.DRONE.getItem() || is.func_77973_b() == ForestryHandler.ItemEntry.PRINCESS.getItem() || is.func_77973_b() == ForestryHandler.ItemEntry.QUEEN.getItem();
    }

    public static void setPristine(ItemStack is, boolean flag) {
        IIndividual bee = AlleleManager.alleleRegistry.getIndividual(is);
        if (bee instanceof IBee) {
            ((IBee)bee).setIsNatural(flag);
            ReikaBeeHelper.saveBee(bee, is);
        }
    }

    private static void saveBee(IIndividual bee, ItemStack is) {
        NBTTagCompound tag = new NBTTagCompound();
        bee.writeToNBT(tag);
        is.field_77990_d = tag;
    }

    private static void saveBee(IGenome bee, ItemStack is) {
        NBTTagCompound tag = new NBTTagCompound();
        bee.writeToNBT(tag);
        if (is.field_77990_d == null) {
            is.field_77990_d = new NBTTagCompound();
        }
        is.field_77990_d.func_74782_a("Genome", (NBTBase)tag);
    }

    public static int getToleranceValue(EnumTolerance t) {
        return t == EnumTolerance.NONE ? 0 : ReikaMathLibrary.getWithinBoundsElse(Character.getNumericValue(t.name().charAt(t.name().length() - 1)), 0, 5, 0);
    }

    public static BeeAlleleRegistry.Tolerance getToleranceType(EnumTolerance t) {
        if (t == EnumTolerance.NONE) {
            return BeeAlleleRegistry.Tolerance.NONE;
        }
        String s = t.name().substring(0, t.name().indexOf(95));
        return BeeAlleleRegistry.Tolerance.valueOf(s);
    }

    public static EnumTolerance getOneBetterTolerance(EnumTolerance t) {
        BeeAlleleRegistry.Tolerance type = ReikaBeeHelper.getToleranceType(t);
        int val = ReikaBeeHelper.getToleranceValue(t);
        if (val > 0 && val < 5) {
            return ReikaBeeHelper.getTolerance(type, ++val);
        }
        return null;
    }

    public static EnumTolerance getTolerance(BeeAlleleRegistry.Tolerance type, int val) {
        String s = val > 0 ? type.name() + "_" + val : type.name();
        return EnumTolerance.valueOf((String)s);
    }

    public static void setGene(ItemStack queen, IBeeGenome ibg, EnumBeeChromosome gene, IAllele value, boolean inactive) {
        boolean ana = AlleleManager.alleleRegistry.getIndividual(queen).isAnalyzed();
        IChromosome[] ic = ibg.getChromosomes();
        IAllele[] arr = BeeManager.beeRoot.getDefaultTemplate();
        IAllele[] arr2 = BeeManager.beeRoot.getDefaultTemplate();
        for (int i = 0; i < arr.length; ++i) {
            if (ic[i] == null) continue;
            arr[i] = ic[i].getActiveAllele();
            arr2[i] = ic[i].getInactiveAllele();
        }
        arr[gene.ordinal()] = value;
        if (inactive) {
            arr2[gene.ordinal()] = value;
        }
        IBeeGenome repl = BeeManager.beeRoot.templateAsGenome(arr, arr2);
        ReikaBeeHelper.saveBee((IGenome)repl, queen);
        if (ana) {
            ReikaBeeHelper.analyzeBee(queen);
        }
    }

    public static void setGene(ItemStack queen, ITreeGenome ibg, EnumTreeChromosome gene, IAllele value, boolean inactive) {
        boolean ana = AlleleManager.alleleRegistry.getIndividual(queen).isAnalyzed();
        IChromosome[] ic = ibg.getChromosomes();
        IAllele[] arr = TreeManager.treeRoot.getDefaultTemplate();
        IAllele[] arr2 = TreeManager.treeRoot.getDefaultTemplate();
        for (int i = 0; i < arr.length; ++i) {
            if (ic[i] == null) continue;
            arr[i] = ic[i].getActiveAllele();
            arr2[i] = ic[i].getInactiveAllele();
        }
        arr[gene.ordinal()] = value;
        if (inactive) {
            arr2[gene.ordinal()] = value;
        }
        ITreeGenome repl = TreeManager.treeRoot.templateAsGenome(arr, arr2);
        ReikaBeeHelper.saveBee((IGenome)repl, queen);
        if (ana) {
            ReikaBeeHelper.analyzeBee(queen);
        }
    }

    public static void setGene(ItemStack queen, IButterflyGenome ibg, EnumButterflyChromosome gene, IAllele value, boolean inactive) {
        boolean ana = AlleleManager.alleleRegistry.getIndividual(queen).isAnalyzed();
        IChromosome[] ic = ibg.getChromosomes();
        IAllele[] arr = ButterflyManager.butterflyRoot.getDefaultTemplate();
        IAllele[] arr2 = ButterflyManager.butterflyRoot.getDefaultTemplate();
        for (int i = 0; i < arr.length; ++i) {
            if (ic[i] == null) continue;
            arr[i] = ic[i].getActiveAllele();
            arr2[i] = ic[i].getInactiveAllele();
        }
        arr[gene.ordinal()] = value;
        if (inactive) {
            arr2[gene.ordinal()] = value;
        }
        IButterflyGenome repl = ButterflyManager.butterflyRoot.templateAsGenome(arr, arr2);
        ReikaBeeHelper.saveBee((IGenome)repl, queen);
        if (ana) {
            ReikaBeeHelper.analyzeBee(queen);
        }
    }

    public static BeeAlleleRegistry.BeeGene getGeneEnum(EnumBeeChromosome gene, IBeeGenome ibg) {
        switch (gene) {
            case EFFECT: {
                return BeeAlleleRegistry.getEnum(ibg.getActiveAllele((IChromosomeType)gene), BeeAlleleRegistry.Effect.class);
            }
            case FERTILITY: {
                return BeeAlleleRegistry.getEnum(ibg.getActiveAllele((IChromosomeType)gene), BeeAlleleRegistry.Fertility.class);
            }
            case FLOWERING: {
                return BeeAlleleRegistry.getEnum(ibg.getActiveAllele((IChromosomeType)gene), BeeAlleleRegistry.Flowering.class);
            }
            case FLOWER_PROVIDER: {
                return BeeAlleleRegistry.getEnum(ibg.getActiveAllele((IChromosomeType)gene), BeeAlleleRegistry.Flower.class);
            }
            case HUMIDITY_TOLERANCE: {
                return ReikaBeeHelper.getToleranceType(ibg.getToleranceHumid());
            }
            case TEMPERATURE_TOLERANCE: {
                return ReikaBeeHelper.getToleranceType(ibg.getToleranceTemp());
            }
            case LIFESPAN: {
                return BeeAlleleRegistry.getEnum(ibg.getActiveAllele((IChromosomeType)gene), BeeAlleleRegistry.Life.class);
            }
            case SPEED: {
                return BeeAlleleRegistry.getEnum(ibg.getActiveAllele((IChromosomeType)gene), BeeAlleleRegistry.Speeds.class);
            }
            case TERRITORY: {
                return BeeAlleleRegistry.getEnum(ibg.getActiveAllele((IChromosomeType)gene), BeeAlleleRegistry.Territory.class);
            }
        }
        return null;
    }

    public static IAllele getToleranceGene(EnumTolerance t) {
        return ReikaBeeHelper.getToleranceGene(ReikaBeeHelper.getToleranceType(t), ReikaBeeHelper.getToleranceValue(t));
    }

    public static IAllele getToleranceGene(BeeAlleleRegistry.Tolerance d, int i) {
        String s = i > 0 ? String.format("%s%d", d.tag, Math.min(Math.abs(i), 5)) : BeeAlleleRegistry.Tolerance.NONE.tag;
        return AlleleManager.alleleRegistry.getAllele(s);
    }

    public static void runProductionCycle(IBeeHousing ibh) {
        ItemStack[] ret;
        IIndividual bee;
        ItemStack is;
        if (ibh.getBeekeepingLogic().canWork() && (is = ibh.getBeeInventory().getQueen()) != null && (bee = AlleleManager.alleleRegistry.getIndividual(is)) instanceof IBee && (ret = ((IBee)bee).produceStacks(ibh)) != null) {
            for (int i = 0; i < ret.length; ++i) {
                ItemStack in = ret[i];
                ibh.getBeeInventory().addProduct(in, false);
            }
        }
    }

    public static IAlleleBoolean getBooleanAllele(boolean value) {
        return (IAlleleBoolean)AlleleManager.alleleRegistry.getAllele("forestry.bool" + WordUtils.capitalize((String)Boolean.toString(value)));
    }

    public static void setBeeMate(IBee ii, IBee repl) {
        ii.mate((IIndividual)repl);
    }

    public static ArrayList<String> getGenesAsStringList(ItemStack is) {
        IIndividual ii = AlleleManager.alleleRegistry.getIndividual(is);
        return ii != null ? ReikaBeeHelper.getGenesAsStringList(ii.getGenome()) : new ArrayList<String>();
    }

    public static ArrayList<String> getGenesAsStringList(IGenome ig) {
        ArrayList<String> li;
        block3: {
            block2: {
                li = new ArrayList<String>();
                if (!(ig instanceof IBeeGenome)) break block2;
                IAlleleBeeSpecies sp1 = (IAlleleBeeSpecies)ig.getPrimary();
                IAlleleBeeSpecies sp2 = (IAlleleBeeSpecies)ig.getSecondary();
                EnumBeeChromosome[] order = new EnumBeeChromosome[]{EnumBeeChromosome.SPECIES, EnumBeeChromosome.LIFESPAN, EnumBeeChromosome.SPEED, EnumBeeChromosome.FLOWERING, EnumBeeChromosome.FLOWER_PROVIDER, EnumBeeChromosome.FERTILITY, EnumBeeChromosome.TERRITORY, EnumBeeChromosome.EFFECT, EnumBeeChromosome.NOCTURNAL, EnumBeeChromosome.TOLERANT_FLYER, EnumBeeChromosome.CAVE_DWELLING};
                for (int i = 0; i < order.length; ++i) {
                    IAllele ia1 = ig.getActiveAllele((IChromosomeType)order[i]);
                    IAllele ia2 = ig.getInactiveAllele((IChromosomeType)order[i]);
                    li.add(ReikaBeeHelper.getGeneDisplay(ia1, order[i], true, true) + " / " + ReikaBeeHelper.getGeneDisplay(ia2, order[i], false, false));
                    if (order[i] != EnumBeeChromosome.EFFECT) continue;
                    String t1 = ReikaBeeHelper.getTemperatureDisplay(sp1, (IAlleleTolerance)ig.getActiveAllele((IChromosomeType)EnumBeeChromosome.TEMPERATURE_TOLERANCE), true, true);
                    String t2 = ReikaBeeHelper.getTemperatureDisplay(sp2, (IAlleleTolerance)ig.getInactiveAllele((IChromosomeType)EnumBeeChromosome.TEMPERATURE_TOLERANCE), false, false);
                    li.add(t1 + " / " + t2);
                    String h1 = ReikaBeeHelper.getHumidityDisplay(sp1, (IAlleleTolerance)ig.getActiveAllele((IChromosomeType)EnumBeeChromosome.HUMIDITY_TOLERANCE), true, true);
                    String h2 = ReikaBeeHelper.getHumidityDisplay(sp2, (IAlleleTolerance)ig.getInactiveAllele((IChromosomeType)EnumBeeChromosome.HUMIDITY_TOLERANCE), false, false);
                    li.add(h1 + " / " + h2);
                }
                break block3;
            }
            if (!(ig instanceof ITreeGenome)) break block3;
            IAlleleTreeSpecies sp1 = (IAlleleTreeSpecies)ig.getPrimary();
            IAlleleTreeSpecies sp2 = (IAlleleTreeSpecies)ig.getSecondary();
            EnumTreeChromosome[] order = new EnumTreeChromosome[]{EnumTreeChromosome.SPECIES, EnumTreeChromosome.FERTILITY, EnumTreeChromosome.MATURATION, EnumTreeChromosome.HEIGHT, EnumTreeChromosome.GIRTH, EnumTreeChromosome.YIELD, EnumTreeChromosome.SAPPINESS, EnumTreeChromosome.FIREPROOF, EnumTreeChromosome.EFFECT, EnumTreeChromosome.GROWTH, EnumTreeChromosome.PLANT, EnumTreeChromosome.FRUITS};
            for (int i = 0; i < order.length; ++i) {
                IAllele ia1 = ig.getActiveAllele((IChromosomeType)order[i]);
                IAllele ia2 = ig.getInactiveAllele((IChromosomeType)order[i]);
                li.add(ReikaBeeHelper.getGeneDisplay((ITreeGenome)ig, ia1, order[i], true, true) + " / " + ReikaBeeHelper.getGeneDisplay((ITreeGenome)ig, ia2, order[i], false, false));
            }
        }
        return li;
    }

    public static String getTemperatureDisplay(IAlleleBeeSpecies bee, IAlleleTolerance tol, boolean title, boolean primary) {
        EnumChatFormatting ec = primary ? EnumChatFormatting.GREEN : EnumChatFormatting.RED;
        String ret = ec + AlleleManager.climateHelper.toDisplay(bee.getTemperature()) + "/" + tol.getName() + EnumChatFormatting.RESET;
        if (title) {
            ret = EnumChatFormatting.LIGHT_PURPLE + "Temperature: " + EnumChatFormatting.RESET + ret;
        }
        return ret;
    }

    public static String getHumidityDisplay(IAlleleBeeSpecies bee, IAlleleTolerance tol, boolean title, boolean primary) {
        EnumChatFormatting ec = primary ? EnumChatFormatting.GREEN : EnumChatFormatting.RED;
        String ret = ec + AlleleManager.climateHelper.toDisplay(bee.getHumidity()) + "/" + tol.getName() + EnumChatFormatting.RESET;
        if (title) {
            ret = EnumChatFormatting.LIGHT_PURPLE + "Humidity: " + EnumChatFormatting.RESET + ret;
        }
        return ret;
    }

    public static String getGeneDisplay(ITreeGenome itg, IAllele gene, EnumTreeChromosome type, boolean title, boolean primary) {
        EnumChatFormatting ec = primary ? EnumChatFormatting.GREEN : EnumChatFormatting.RED;
        String tag = "";
        String val = gene.getName();
        switch (type) {
            case EFFECT: {
                tag = "for.gui.effect";
                break;
            }
            case MATURATION: {
                tag = "for.gui.maturity";
                val = val + " (" + ((IAlleleInteger)gene).getValue() + " growth ticks)";
                break;
            }
            case FERTILITY: {
                tag = "for.gui.fertility";
                val = val + " (" + ((IAlleleFloat)gene).getValue() + " %/leaf)";
                break;
            }
            case HEIGHT: {
                tag = "for.gui.height";
                val = val + " (" + ((IAlleleFloat)gene).getValue() + "x)";
                break;
            }
            case YIELD: {
                tag = "for.gui.yield";
                val = val + " (" + ((IAlleleFloat)gene).getValue() + "x)";
                break;
            }
            case SAPPINESS: {
                tag = "for.gui.sappiness";
                val = val + " (" + ((IAlleleFloat)gene).getValue() + "x)";
                break;
            }
            case GIRTH: {
                tag = "for.gui.girth";
                val = ((IAlleleInteger)gene).getValue() + "x" + ((IAlleleInteger)gene).getValue();
                break;
            }
            case SPECIES: {
                tag = "for.gui.species";
                break;
            }
            case FRUITS: {
                tag = "for.gui.fruits";
                val = StatCollector.func_74838_a((String)("for." + ((IAlleleFruit)gene).getProvider().getDescription()));
                break;
            }
            case PLANT: {
                tag = "for.gui.native";
                val = StatCollector.func_74838_a((String)(primary ? itg.getPrimary().getPlantType().toString() : itg.getSecondary().getPlantType().toString()));
                break;
            }
            case GROWTH: {
                tag = "for.gui.growth";
                val = StatCollector.func_74838_a((String)((IAlleleGrowth)gene).getProvider().getDescription());
                break;
            }
            case TERRITORY: {
                tag = "for.gui.area";
                IAlleleArea ia = (IAlleleArea)gene;
                val = val + " (" + ia.getValue()[0] + "x" + ia.getValue()[1] + "x" + ia.getValue()[2] + ")";
                break;
            }
            case FIREPROOF: {
                tag = "for.gui.fireproof";
                val = StatCollector.func_74838_a((String)(((IAlleleBoolean)gene).getValue() ? "for.yes" : "for.no"));
                break;
            }
        }
        return title ? EnumChatFormatting.LIGHT_PURPLE + StatCollector.func_74838_a((String)tag) + ": " + EnumChatFormatting.RESET + ec + val + EnumChatFormatting.RESET : ec + val + EnumChatFormatting.RESET;
    }

    public static String getGeneDisplay(IAllele gene, EnumBeeChromosome type, boolean title, boolean primary) {
        EnumChatFormatting ec = primary ? EnumChatFormatting.GREEN : EnumChatFormatting.RED;
        String tag = "";
        String val = gene.getName();
        switch (type) {
            case EFFECT: {
                tag = "for.gui.effect";
                break;
            }
            case FERTILITY: {
                tag = "for.gui.fertility";
                val = val + " (" + ((IAlleleInteger)gene).getValue() + ")";
                break;
            }
            case FLOWERING: {
                tag = "for.gui.pollination";
                val = val + " (" + ((IAlleleInteger)gene).getValue() * 20 * 60 / 550 + "/min)";
                break;
            }
            case FLOWER_PROVIDER: {
                tag = "for.gui.flowers";
                break;
            }
            case HUMIDITY_TOLERANCE: {
                tag = "for.gui.tolerance";
                break;
            }
            case TEMPERATURE_TOLERANCE: {
                tag = "for.gui.tolerance";
                break;
            }
            case LIFESPAN: {
                tag = "for.gui.life";
                val = val + " (" + ((IAlleleInteger)gene).getValue() + ")";
                break;
            }
            case SPECIES: {
                tag = "for.gui.species";
                break;
            }
            case SPEED: {
                tag = "for.gui.worker";
                val = val + " (" + ((IAlleleFloat)gene).getValue() + "x)";
                break;
            }
            case TERRITORY: {
                tag = "for.gui.area";
                IAlleleArea ia = (IAlleleArea)gene;
                val = val + " (" + ia.getValue()[0] + "x" + ia.getValue()[1] + "x" + ia.getValue()[2] + ")";
                break;
            }
            case NOCTURNAL: {
                tag = "for.gui.nocturnal";
                val = StatCollector.func_74838_a((String)(((IAlleleBoolean)gene).getValue() ? "for.yes" : "for.no"));
                break;
            }
            case CAVE_DWELLING: {
                tag = "for.gui.cave";
                val = StatCollector.func_74838_a((String)(((IAlleleBoolean)gene).getValue() ? "for.yes" : "for.no"));
                break;
            }
            case TOLERANT_FLYER: {
                tag = "for.gui.flyer";
                val = StatCollector.func_74838_a((String)(((IAlleleBoolean)gene).getValue() ? "for.yes" : "for.no"));
                break;
            }
        }
        return title ? EnumChatFormatting.LIGHT_PURPLE + StatCollector.func_74838_a((String)tag) + ": " + EnumChatFormatting.RESET + ec + val + EnumChatFormatting.RESET : ec + val + EnumChatFormatting.RESET;
    }

    public static IBeeRoot getBeeRoot() {
        return (IBeeRoot)AlleleManager.alleleRegistry.getSpeciesRoot("rootBees");
    }

    public static ITreeRoot getTreeRoot() {
        return (ITreeRoot)AlleleManager.alleleRegistry.getSpeciesRoot("rootTrees");
    }

    public static boolean isPristine(ItemStack is) {
        IIndividual bee = AlleleManager.alleleRegistry.getIndividual(is);
        return bee instanceof IBee && ((IBee)bee).isNatural();
    }

    public static IGenome getGenome(ItemStack is) {
        IIndividual bee = AlleleManager.alleleRegistry.getIndividual(is);
        return bee instanceof IBee ? ((IBee)bee).getGenome() : null;
    }

    public static IBee getBee(ItemStack is) {
        IIndividual bee = AlleleManager.alleleRegistry.getIndividual(is);
        return bee instanceof IBee ? (IBee)bee : null;
    }

    public static IAlleleSpecies getSpecies(ItemStack is) {
        IGenome ig = ReikaBeeHelper.getGenome(is);
        return ig != null ? ig.getPrimary() : null;
    }

    public static float getTemperatureRangeCenter(EnumTemperature t) {
        switch (t) {
            case ICY: {
                return -0.1f;
            }
            case COLD: {
                return 0.175f;
            }
            case NORMAL: {
                return 0.6f;
            }
            case WARM: {
                return 0.925f;
            }
            case HOT: {
                return 1.1f;
            }
            case HELLISH: {
                return 2.0f;
            }
        }
        return Float.NaN;
    }

    public static float getHumidityRangeCenter(EnumHumidity h) {
        switch (h) {
            case ARID: {
                return 0.15f;
            }
            case NORMAL: {
                return 0.5f;
            }
            case DAMP: {
                return 1.0f;
            }
        }
        return Float.NaN;
    }

    public static boolean isTree(ItemStack is) {
        return is.func_77973_b() == ForestryHandler.ItemEntry.SAPLING.getItem();
    }

    public static int[] getFinalTerritory(IBeeGenome ibg, IBeeHousing ibh) {
        float f = 1.0f;
        for (IBeeModifier ibm : ibh.getBeeModifiers()) {
            f *= ibm.getTerritoryModifier(ibg, f);
        }
        int[] ret = ibg.getTerritory();
        int i = 0;
        while (i < ret.length) {
            int n = i++;
            ret[n] = (int)((float)ret[n] * f);
        }
        return ret;
    }

    static {
        allBees = new HashSet();
        if (ModList.FORESTRY.isLoaded()) {
            try {
                beeHealth = Class.forName("forestry.core.genetics.IndividualLiving").getDeclaredField("health");
                beeHealth.setAccessible(true);
            }
            catch (Exception e) {
                DragonAPICore.logError("Could not find forestry bee life parameter!");
                ReflectiveFailureTracker.instance.logModReflectiveFailure(ModList.FORESTRY, e);
                e.printStackTrace();
            }
        }
    }
}

