/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.Bees;

import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.ModInteract.Bees.BeeAlleleRegistry;
import Reika.DragonAPI.ModInteract.Bees.BeeTraits;
import Reika.DragonAPI.ModInteract.Bees.ReikaBeeHelper;
import Reika.DragonAPI.ModList;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeMutation;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.IIconProvider;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public abstract class BeeSpecies
implements IAlleleBeeSpecies,
IIconProvider {
    protected final Random rand = new Random();
    private static final IBeeRoot beeRoot = ReikaBeeHelper.getBeeRoot();
    private final IIcon[][] icons = new IIcon[EnumBeeType.VALUES.length][3];
    private final HashMap<ItemStack, Float> specials = new HashMap();
    private final HashMap<ItemStack, Float> products = new HashMap();
    private final IClassification branch;
    private final String scientific;
    private final String genus;
    private final String creator;
    private final String uid;
    private final String name;
    private boolean isRegistered = false;
    private final IAllele[] template = new IAllele[EnumBeeChromosome.values().length];

    protected BeeSpecies(String name, String uid, String latinName, String creator, IClassification g) {
        this.branch = g;
        this.name = name;
        this.creator = creator;
        String[] s = latinName.split(" ");
        if (s.length < 2) {
            throw new RuntimeException("Bee latin names must be at least two words (genus and species)!");
        }
        this.genus = s[0];
        String scn = s[1];
        for (int i = 2; i < s.length; ++i) {
            scn = scn + " " + s[i];
        }
        this.scientific = scn;
        this.uid = uid;
    }

    public void register() {
        System.arraycopy(this.getSpeciesTemplate(), 0, this.template, 0, this.template.length);
        AlleleManager.alleleRegistry.registerAllele((IAllele)this, new IChromosomeType[]{EnumBeeChromosome.SPECIES});
        beeRoot.registerTemplate(this.template);
        AlleleManager.alleleRegistry.getClassification("family.apidae").addMemberGroup(this.branch);
        this.isRegistered = true;
    }

    public final String getUnlocalizedName() {
        return this.uid;
    }

    public final String getBinomial() {
        return this.scientific;
    }

    public final String getAuthority() {
        return this.creator;
    }

    public final String getUID() {
        return this.uid;
    }

    public final String getName() {
        return this.name;
    }

    public final void addSpecialty(ItemStack item, float chance) {
        this.specials.put(item, Float.valueOf(chance / 100.0f));
    }

    public final void addProduct(ItemStack item, float chance) {
        this.products.put(item, Float.valueOf(chance / 100.0f));
    }

    public final IClassification getBranch() {
        return this.branch;
    }

    public final Map<ItemStack, Float> getProductChances() {
        return Collections.unmodifiableMap(this.products);
    }

    public final Map<ItemStack, Float> getSpecialtyChances() {
        return Collections.unmodifiableMap(this.specials);
    }

    public abstract boolean isTolerantFlyer();

    public final ItemStack getBeeItem(World world, EnumBeeType type) {
        return beeRoot.getMemberStack((IIndividual)beeRoot.getBee(world, beeRoot.templateAsGenome(this.template)), type.ordinal());
    }

    public final void addBreeding(String parent1, String parent2, int chance) {
        IAlleleBeeSpecies p1 = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.species" + parent1);
        IAlleleBeeSpecies p2 = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.species" + parent2);
        if (p1 == null) {
            throw new MisuseException("Error breeding from " + parent1 + ": You cannot breed a bee from null!");
        }
        if (p2 == null) {
            throw new MisuseException("Error breeding from " + parent2 + ": You cannot breed a bee from null!");
        }
        this.addBreeding(p1, p2, chance);
    }

    public final void addBreeding(String parent1, ModList mod1, String parent2, ModList mod2, int chance) {
        IAlleleBeeSpecies p1 = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele(mod1.modLabel.toLowerCase(Locale.ENGLISH) + ".species" + parent1);
        IAlleleBeeSpecies p2 = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele(mod2.modLabel.toLowerCase(Locale.ENGLISH) + ".species" + parent2);
        if (p1 == null) {
            throw new MisuseException("Error breeding from " + parent1 + ": You cannot breed a bee from null!");
        }
        if (p2 == null) {
            throw new MisuseException("Error breeding from " + parent2 + ": You cannot breed a bee from null!");
        }
        this.addBreeding(p1, p2, chance);
    }

    public final void addBreeding(String parent1, ModList mod1, BeeSpecies parent2, int chance) {
        IAlleleBeeSpecies p1 = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele(mod1.modLabel.toLowerCase(Locale.ENGLISH) + ".species" + parent1);
        if (p1 == null) {
            throw new MisuseException("Error breeding from " + parent1 + ": You cannot breed a bee from null!");
        }
        this.addBreeding(p1, (IAlleleBeeSpecies)parent2, chance);
    }

    public final void addBreeding(String parent1, BeeSpecies parent2, int chance) {
        IAlleleBeeSpecies p1 = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.species" + parent1);
        if (p1 == null) {
            throw new MisuseException("Error breeding from " + parent1 + ": You cannot breed a bee from null!");
        }
        this.addBreeding(p1, (IAlleleBeeSpecies)parent2, chance);
    }

    public final void addBreeding(BeeSpecies parent1, BeeSpecies parent2, int chance) {
        this.addBreeding((IAlleleBeeSpecies)parent1, (IAlleleBeeSpecies)parent2, chance);
    }

    private final void addBreeding(IAlleleBeeSpecies p1, IAlleleBeeSpecies p2, int chance) {
        if (!this.isRegistered) {
            throw new MisuseException("You must register a bee before adding breeding pairs!");
        }
        if (p1 == null || p2 == null) {
            throw new MisuseException("You cannot breed a bee from null!");
        }
        beeRoot.registerMutation((IMutation)new BeeBreeding(p1, p2, chance, this));
    }

    public abstract IAllele getFlowerAllele();

    public abstract IAllele getEffectAllele();

    public abstract BeeAlleleRegistry.Speeds getProductionSpeed();

    public abstract BeeAlleleRegistry.Fertility getFertility();

    public abstract BeeAlleleRegistry.Flowering getFloweringRate();

    public abstract BeeAlleleRegistry.Life getLifespan();

    public abstract BeeAlleleRegistry.Territory getTerritorySize();

    public abstract boolean isCaveDwelling();

    public abstract int getTemperatureTolerance();

    public abstract int getHumidityTolerance();

    public abstract BeeAlleleRegistry.Tolerance getHumidityToleranceDir();

    public abstract BeeAlleleRegistry.Tolerance getTemperatureToleranceDir();

    public abstract int getOutlineColor();

    public int getIconColour(int renderpass) {
        switch (renderpass) {
            case 0: {
                return this.getOutlineColor();
            }
            case 1: {
                return this.getBeeStripeColor();
            }
            case 2: {
                return 0xFFFFFF;
            }
        }
        return 0xFFFFFF;
    }

    public int getBeeStripeColor() {
        return 0xFFFF00;
    }

    private final IAllele getGeneForBoolean(boolean b) {
        String s = b ? "forestry.boolTrue" : "forestry.boolFalse";
        return AlleleManager.alleleRegistry.getAllele(s);
    }

    private final IAllele getGeneForInt(int i) {
        return AlleleManager.alleleRegistry.getAllele(String.format("i%dd", i));
    }

    protected final IAllele[] getSpeciesTemplate() {
        IAllele[] alleles = beeRoot.getDefaultTemplate();
        alleles[EnumBeeChromosome.SPECIES.ordinal()] = this;
        alleles[EnumBeeChromosome.FLOWER_PROVIDER.ordinal()] = this.getFlowerAllele();
        alleles[EnumBeeChromosome.SPEED.ordinal()] = this.getProductionSpeed().getAllele();
        alleles[EnumBeeChromosome.LIFESPAN.ordinal()] = this.getLifespan().getAllele();
        alleles[EnumBeeChromosome.TERRITORY.ordinal()] = this.getTerritorySize().getAllele();
        alleles[EnumBeeChromosome.FLOWERING.ordinal()] = this.getFloweringRate().getAllele();
        alleles[EnumBeeChromosome.FERTILITY.ordinal()] = this.getFertility().getAllele();
        alleles[EnumBeeChromosome.EFFECT.ordinal()] = this.getEffectAllele();
        alleles[EnumBeeChromosome.NOCTURNAL.ordinal()] = this.getGeneForBoolean(this.isNocturnal());
        alleles[EnumBeeChromosome.CAVE_DWELLING.ordinal()] = this.getGeneForBoolean(this.isCaveDwelling());
        alleles[EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()] = ReikaBeeHelper.getToleranceGene(this.getTemperatureToleranceDir(), this.getTemperatureTolerance());
        alleles[EnumBeeChromosome.HUMIDITY_TOLERANCE.ordinal()] = ReikaBeeHelper.getToleranceGene(this.getHumidityToleranceDir(), this.getHumidityTolerance());
        alleles[EnumBeeChromosome.TOLERANT_FLYER.ordinal()] = this.getGeneForBoolean(this.isTolerantFlyer());
        return alleles;
    }

    public final IBeeRoot getRoot() {
        return beeRoot;
    }

    @SideOnly(value=Side.CLIENT)
    public final IIconProvider getIconProvider() {
        return this;
    }

    public final void registerIcons(IIconRegister ico) {
        String iconType = this.getIconCategory();
        String mod = this.getIconMod();
        String body = this.simplifiedIconSystem() ? "/body" : "/body1";
        IIcon body1 = ico.func_94245_a(mod + ":bees/" + iconType + body);
        IIcon larva = ico.func_94245_a(mod + ":bees/" + iconType + "/" + EnumBeeType.LARVAE.name().toLowerCase(Locale.ENGLISH) + ".body");
        for (int i = 0; i < EnumBeeType.VALUES.length; ++i) {
            if (EnumBeeType.VALUES[i] == EnumBeeType.NONE) continue;
            String type = EnumBeeType.VALUES[i].name().toLowerCase(Locale.ENGLISH);
            String out = EnumBeeType.VALUES[i] != EnumBeeType.LARVAE && this.simplifiedIconSystem() ? "outline" : type + ".outline";
            this.icons[i][0] = ico.func_94245_a(mod + ":bees/" + iconType + "/" + out);
            this.icons[i][1] = EnumBeeType.VALUES[i] == EnumBeeType.LARVAE ? larva : body1;
            String clas = this.simplifiedIconSystem() ? type : type + ".body2";
            this.icons[i][2] = ico.func_94245_a(mod + ":bees/" + iconType + "/" + clas);
        }
    }

    protected String getIconMod() {
        return "forestry";
    }

    protected String getIconCategory() {
        return "default";
    }

    protected boolean simplifiedIconSystem() {
        return false;
    }

    public final IIcon getIcon(EnumBeeType type, int renderPass) {
        return this.icons[type.ordinal()][renderPass];
    }

    public int getComplexity() {
        return 0;
    }

    public float getResearchSuitability(ItemStack is) {
        return 0.0f;
    }

    public ItemStack[] getResearchBounty(World paramWorld, GameProfile f, IIndividual paramIIndividual, int paramInt) {
        return new ItemStack[0];
    }

    @SideOnly(value=Side.CLIENT)
    public final IIcon getIcon(short ps) {
        return ReikaTextureHelper.getMissingIcon();
    }

    public final String getEntityTexture() {
        return "";
    }

    private static final class BeeBreeding
    implements IBeeMutation {
        public final IAlleleBeeSpecies parent1;
        public final IAlleleBeeSpecies parent2;
        public final int chance;
        private final BeeSpecies bee;

        private BeeBreeding(IAlleleBeeSpecies p1, IAlleleBeeSpecies p2, int chance, BeeSpecies bee) {
            this.parent1 = p1;
            this.parent2 = p2;
            this.chance = chance;
            this.bee = bee;
        }

        public IAlleleSpecies getAllele0() {
            return this.parent1;
        }

        public IAlleleSpecies getAllele1() {
            return this.parent2;
        }

        public IAllele[] getTemplate() {
            return this.bee.template;
        }

        public float getBaseChance() {
            return this.chance;
        }

        public Collection getSpecialConditions() {
            return new ArrayList();
        }

        public boolean isPartner(IAllele ia) {
            return this.parent1.getUID().equals(ia.getUID()) || this.parent2.getUID().equals(ia.getUID());
        }

        public IAllele getPartner(IAllele ia) {
            IAlleleBeeSpecies val = this.parent1;
            if (val.getUID().equals(ia.getUID())) {
                val = this.parent2;
            }
            return val;
        }

        public boolean isSecret() {
            return this.bee.isSecret();
        }

        public IBeeRoot getRoot() {
            return this.bee.getRoot();
        }

        public final float getChance(IBeeHousing ibh, IAlleleBeeSpecies ia1, IAlleleBeeSpecies ia2, IBeeGenome ig1, IBeeGenome ig2) {
            return this.isValidParents((IAllele)ia1, (IAllele)ia2) ? (float)this.chance : 0.0f;
        }

        private boolean isValidParents(IAllele ia1, IAllele ia2) {
            if (ia1.getUID().equals(this.parent1.getUID()) && ia2.getUID().equals(this.parent2.getUID())) {
                return true;
            }
            return ia1.getUID().equals(this.parent2.getUID()) && ia2.getUID().equals(this.parent1.getUID());
        }
    }

    public static class BeeBranch
    implements IClassification {
        public final String displayName;
        public final String description;
        private final String uid;
        private final String latinName;

        public BeeBranch(String id, String n, String latin, String desc) {
            this.displayName = n;
            this.description = desc;
            this.latinName = latin;
            this.uid = id;
        }

        public final IClassification.EnumClassLevel getLevel() {
            return IClassification.EnumClassLevel.GENUS;
        }

        public final String getUID() {
            return this.uid;
        }

        public final String getName() {
            return this.displayName;
        }

        public final String getScientific() {
            return this.latinName;
        }

        public final String getDescription() {
            return this.description;
        }

        public IClassification[] getMemberGroups() {
            return new IClassification[0];
        }

        public void addMemberGroup(IClassification icl) {
        }

        public IAlleleSpecies[] getMemberSpecies() {
            return new IAlleleSpecies[0];
        }

        public void addMemberSpecies(IAlleleSpecies ias) {
        }

        public IClassification getParent() {
            return null;
        }

        public void setParent(IClassification icl) {
        }
    }

    public static abstract class TraitsBee
    extends BeeSpecies {
        protected final BeeTraits traits;

        protected TraitsBee(String name, String uid, String latinName, String creator, IClassification g, BeeTraits traits) {
            super(name, uid, latinName, creator, g);
            this.traits = traits;
        }

        public final EnumTemperature getTemperature() {
            return this.traits.temperature;
        }

        public final EnumHumidity getHumidity() {
            return this.traits.humidity;
        }

        @Override
        public final BeeAlleleRegistry.Speeds getProductionSpeed() {
            return this.traits.speed;
        }

        @Override
        public final BeeAlleleRegistry.Fertility getFertility() {
            return this.traits.fertility;
        }

        @Override
        public final BeeAlleleRegistry.Flowering getFloweringRate() {
            return this.traits.flowering;
        }

        @Override
        public final BeeAlleleRegistry.Life getLifespan() {
            return this.traits.lifespan;
        }

        @Override
        public final BeeAlleleRegistry.Territory getTerritorySize() {
            return this.traits.area;
        }

        @Override
        public final boolean isCaveDwelling() {
            return this.traits.isCaveDwelling;
        }

        @Override
        public final int getTemperatureTolerance() {
            return this.traits.tempTol;
        }

        @Override
        public final int getHumidityTolerance() {
            return this.traits.humidTol;
        }

        @Override
        public final BeeAlleleRegistry.Tolerance getHumidityToleranceDir() {
            return this.traits.humidDir;
        }

        @Override
        public final BeeAlleleRegistry.Tolerance getTemperatureToleranceDir() {
            return this.traits.tempDir;
        }

        public final boolean isNocturnal() {
            return this.traits.isNocturnal;
        }

        @Override
        public final boolean isTolerantFlyer() {
            return this.traits.isTolerant;
        }
    }
}

