/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries;

import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class ReikaSpawnerHelper {
    public static String getMobSpawnerMobName(TileEntityMobSpawner spw) {
        return spw.func_145881_a().func_98276_e();
    }

    public static void setMobSpawnerMob(TileEntityMobSpawner spw, String name) {
        spw.func_145881_a().func_98272_a(name);
    }

    public static String getSpawnerTypeName(World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityMobSpawner)) {
            return null;
        }
        return ReikaSpawnerHelper.getMobSpawnerMobName((TileEntityMobSpawner)te);
    }

    public static int getSpawnerTypeID(World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityMobSpawner)) {
            return -1;
        }
        TileEntityMobSpawner spw = (TileEntityMobSpawner)te;
        String name = ReikaSpawnerHelper.getMobSpawnerMobName(spw);
        return ReikaEntityHelper.mobNameToID(name);
    }

    public static void addMobNBTToItem(ItemStack is, TileEntityMobSpawner spw) {
        if (is == null) {
            return;
        }
        String name = ReikaSpawnerHelper.getMobSpawnerMobName(spw);
        ReikaSpawnerHelper.setSpawnerItemNBT(is, name, false);
    }

    public static void setSpawnerFromItemNBT(ItemStack is, TileEntityMobSpawner spw, boolean keepLogic) {
        if (is == null) {
            return;
        }
        if (is.field_77990_d == null) {
            return;
        }
        if (!is.field_77990_d.func_74764_b("Spawner")) {
            return;
        }
        String name = is.field_77990_d.func_74779_i("Spawner");
        if (keepLogic && is.field_77990_d.func_74764_b("logic")) {
            ConstructableSpawnerLogic lgc = new ConstructableSpawnerLogic((TileEntity)spw);
            lgc.func_98270_a(is.field_77990_d.func_74775_l("logic"));
            ReikaSpawnerHelper.setSpawnerLogic(spw, lgc);
        }
        ReikaSpawnerHelper.setMobSpawnerMob(spw, name);
    }

    private static void setSpawnerLogic(TileEntityMobSpawner spw, MobSpawnerBaseLogic lgc) {
        NBTTagCompound tag = new NBTTagCompound();
        spw.func_145841_b(tag);
        lgc.func_98280_b(tag);
        spw.func_145839_a(tag);
    }

    public static void generateSpawnerTooltip(ItemStack is, List li) {
        if (is.field_77990_d.func_74764_b("Spawner")) {
            li.add("Spawns " + ReikaEntityHelper.getEntityDisplayName(is.field_77990_d.func_74779_i("Spawner")));
        } else {
            li.add("No entity data");
        }
        if (is.field_77990_d.func_74764_b("logic")) {
            if (GuiScreen.func_146272_n()) {
                TemporarySpawnerLogic lgc = new TemporarySpawnerLogic();
                lgc.func_98270_a(is.field_77990_d.func_74775_l("logic"));
                li.add("Min Delay: " + EnumChatFormatting.WHITE + lgc.field_98283_g + " ticks");
                li.add("Max Delay: " + EnumChatFormatting.WHITE + lgc.field_98293_h + " ticks");
                li.add("Max Near Mobs: " + EnumChatFormatting.WHITE + lgc.field_98292_k);
                li.add("Spawn Count: " + EnumChatFormatting.WHITE + lgc.field_98294_i);
                li.add("Spawn Range: " + EnumChatFormatting.WHITE + lgc.field_98290_m + "m");
                li.add("Activation Range: " + EnumChatFormatting.WHITE + lgc.field_98289_l + "m");
            } else {
                li.add(EnumChatFormatting.LIGHT_PURPLE + "Hold LSHIFT for spawner parameters");
            }
        } else {
            li.add("Default spawn parameters");
        }
    }

    public static void setSpawnerItemNBT(ItemStack is, String mob, boolean force) {
        if (is.field_77990_d == null) {
            is.func_77982_d(new NBTTagCompound());
        }
        if (force || !is.field_77990_d.func_74764_b("Spawner")) {
            is.field_77990_d.func_74778_a("Spawner", mob);
        }
    }

    public static void setSpawnerItemNBT(ItemStack is, int minDelay, int maxDelay, int maxNear, int spawnCount, int spawnRange, int activeRange, boolean force) {
        ReikaSpawnerHelper.setSpawnerItemNBT(is, new TemporarySpawnerLogic(minDelay, maxDelay, maxNear, spawnCount, spawnRange, activeRange), force, true);
    }

    public static void setSpawnerItemNBT(ItemStack is, MobSpawnerBaseLogic lgc, boolean force, boolean keepLogic) {
        if (is.field_77990_d == null) {
            is.func_77982_d(new NBTTagCompound());
        }
        if (force || !is.field_77990_d.func_74764_b("Spawner")) {
            is.field_77990_d.func_74778_a("Spawner", lgc.func_98276_e());
        }
        if (keepLogic && (force || !is.field_77990_d.func_74764_b("logic"))) {
            NBTTagCompound tag = new NBTTagCompound();
            lgc.func_98280_b(tag);
            is.field_77990_d.func_74782_a("logic", (NBTBase)tag);
        }
    }

    public static void forceSpawn(TileEntityMobSpawner spw, int num, PotionEffect ... potions) {
        World world = spw.field_145850_b;
        if (world.field_72995_K) {
            return;
        }
        String name = ReikaSpawnerHelper.getMobSpawnerMobName(spw);
        for (int i = 0; i < num; ++i) {
            Entity e = EntityList.func_75620_a((String)name, (World)world);
            double ex = ReikaRandomHelper.getRandomPlusMinus((double)spw.field_145851_c + 0.5, 3.5);
            double ez = ReikaRandomHelper.getRandomPlusMinus((double)spw.field_145849_e + 0.5, 3.5);
            double ey = ReikaRandomHelper.getRandomPlusMinus((double)spw.field_145848_d + 0.5, 1.5);
            e.func_70080_a(ex, ey, ez, 0.0f, 0.0f);
            if (e instanceof EntityLivingBase && potions != null) {
                for (int m = 0; m < potions.length; ++m) {
                    ((EntityLivingBase)e).func_70690_d(potions[m]);
                }
            }
            if (e instanceof EntityLivingBase && e.field_70170_p != null) {
                ((EntityLiving)e).func_110161_a((IEntityLivingData)null);
            }
            world.func_72838_d(e);
        }
    }

    public static String getSpawnerFromItemNBT(ItemStack is) {
        if (is == null) {
            return null;
        }
        if (is.field_77990_d == null) {
            return null;
        }
        if (!is.field_77990_d.func_74764_b("Spawner")) {
            return null;
        }
        String name = is.field_77990_d.func_74779_i("Spawner");
        return name;
    }

    public static boolean hasCustomLogic(TileEntityMobSpawner spw) {
        MobSpawnerBaseLogic lgc = spw.func_145881_a();
        return !ReikaSpawnerHelper.isDefaultParams(lgc);
    }

    private static boolean isDefaultParams(MobSpawnerBaseLogic lgc) {
        TemporarySpawnerLogic lgc2 = new TemporarySpawnerLogic();
        return lgc.field_98283_g == lgc2.field_98283_g && lgc.field_98293_h == lgc2.field_98293_h && lgc.field_98292_k == lgc2.field_98292_k && lgc.field_98294_i == lgc2.field_98294_i && lgc.field_98290_m == lgc2.field_98290_m && lgc.field_98289_l == lgc2.field_98289_l;
    }

    private static class ConstructableSpawnerLogic
    extends MobSpawnerBaseLogic {
        private final WorldLocation location;

        private ConstructableSpawnerLogic(TileEntity te) {
            this.location = new WorldLocation(te);
        }

        public void func_98267_a(int val) {
            this.func_98271_a().func_147452_c(this.func_98275_b(), this.func_98274_c(), this.func_98266_d(), Blocks.field_150474_ac, val, 0);
        }

        public World func_98271_a() {
            return this.location.getWorld();
        }

        public int func_98275_b() {
            return this.location.xCoord;
        }

        public int func_98274_c() {
            return this.location.yCoord;
        }

        public int func_98266_d() {
            return this.location.zCoord;
        }
    }

    private static class TemporarySpawnerLogic
    extends MobSpawnerBaseLogic {
        private TemporarySpawnerLogic() {
        }

        private TemporarySpawnerLogic(int minDelay, int maxDelay, int maxNear, int spawnCount, int spawnRange, int activeRange) {
            this.field_98293_h = maxDelay;
            this.field_98283_g = minDelay;
            this.field_98292_k = maxNear;
            this.field_98294_i = spawnCount;
            this.field_98290_m = spawnRange;
            this.field_98289_l = activeRange;
        }

        public void func_98267_a(int p_98267_1_) {
        }

        public World func_98271_a() {
            return null;
        }

        public int func_98275_b() {
            return 0;
        }

        public int func_98274_c() {
            return 0;
        }

        public int func_98266_d() {
            return 0;
        }
    }
}

