/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries;

import Reika.DragonAPI.DragonAPICore;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ReikaEnchantmentHelper
extends DragonAPICore {
    public static final Comparator<Enchantment> enchantmentNameSorter = new EnchantmentNameComparator();
    public static final Comparator<Enchantment> enchantmentTypeSorter = new EnchantmentTypeComparator();

    public static HashMap<Enchantment, Integer> getEnchantments(ItemStack is) {
        Map enchants = EnchantmentHelper.func_82781_a((ItemStack)is);
        if (enchants == null) {
            return null;
        }
        HashMap<Enchantment, Integer> ench = new HashMap<Enchantment, Integer>();
        for (Integer id : enchants.keySet()) {
            Enchantment e = Enchantment.field_77331_b[id];
            int level = (Integer)enchants.get(id);
            ench.put(e, level);
        }
        return ench;
    }

    public static void applyEnchantment(ItemStack is, Enchantment e, int level) {
        if (is.func_77973_b() == Items.field_151134_bR) {
            Items.field_151134_bR.func_92115_a(is, new EnchantmentData(e, level));
        } else {
            is.func_77966_a(e, level);
        }
    }

    public static void applyEnchantments(ItemStack is, HashMap<Enchantment, Integer> en) {
        if (en == null) {
            return;
        }
        for (Enchantment e : en.keySet()) {
            int level = en.get(e);
            if (level <= 0) continue;
            ReikaEnchantmentHelper.applyEnchantment(is, e, level);
        }
    }

    public static int getEnchantmentLevel(Enchantment e, ItemStack is) {
        if (is == null) {
            return 0;
        }
        Map enchants = EnchantmentHelper.func_82781_a((ItemStack)is);
        if (enchants == null) {
            return 0;
        }
        if (enchants.containsKey(e.field_77352_x)) {
            int level = (Integer)enchants.get(e.field_77352_x);
            return level;
        }
        return 0;
    }

    public static boolean hasEnchantment(Enchantment e, ItemStack is) {
        if (is == null) {
            return false;
        }
        Map enchants = EnchantmentHelper.func_82781_a((ItemStack)is);
        if (enchants == null) {
            return false;
        }
        return enchants.containsKey(e.field_77352_x);
    }

    public static float getEfficiencyMultiplier(int level) {
        return (float)Math.pow(1.3, level);
    }

    public static boolean areCompatible(Collection<Enchantment> enchantments) {
        Iterator<Enchantment> it = enchantments.iterator();
        Iterator<Enchantment> it2 = enchantments.iterator();
        while (it.hasNext()) {
            Enchantment e = it.next();
            while (it2.hasNext()) {
                Enchantment e2 = it2.next();
                if (ReikaEnchantmentHelper.areEnchantsCompatible(e, e2)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isCompatible(Collection<Enchantment> enchantments, Enchantment addition) {
        Iterator<Enchantment> it = enchantments.iterator();
        Iterator<Enchantment> it2 = enchantments.iterator();
        while (it.hasNext()) {
            Enchantment e = it.next();
            if (ReikaEnchantmentHelper.areEnchantsCompatible(e, addition)) continue;
            return false;
        }
        return true;
    }

    public static boolean areEnchantsCompatible(Enchantment e, Enchantment e2) {
        return e.func_77326_a(e2);
    }

    public static boolean hasEnchantments(ItemStack is) {
        Map map = EnchantmentHelper.func_82781_a((ItemStack)is);
        return map != null && !map.isEmpty();
    }

    public static void addEnchantment(NBTTagCompound tag, Enchantment enchantment, int level, boolean append) {
        if (!tag.func_150297_b("ench", 9)) {
            tag.func_74782_a("ench", (NBTBase)new NBTTagList());
        }
        NBTTagList li = tag.func_150295_c("ench", 10);
        if (!append) {
            for (NBTTagCompound in : li.field_74747_a) {
                short type = in.func_74765_d("id");
                if (type != enchantment.field_77352_x) continue;
                in.func_74777_a("lvl", (short)((byte)level));
                return;
            }
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74777_a("id", (short)enchantment.field_77352_x);
        nbt.func_74777_a("lvl", (short)((byte)level));
        li.func_74742_a((NBTBase)nbt);
    }

    public static void removeEnchantments(ItemStack is, Collection<Enchantment> c) {
        for (Enchantment e : c) {
            ReikaEnchantmentHelper.removeEnchantment(is, e);
        }
    }

    public static void removeEnchantment(ItemStack is, Enchantment e) {
        NBTTagList li = is.func_77986_q();
        if (li == null) {
            return;
        }
        Iterator it = li.field_74747_a.iterator();
        while (it.hasNext()) {
            NBTTagCompound tag = (NBTTagCompound)it.next();
            short s = tag.func_74765_d("id");
            if (s != e.field_77352_x) continue;
            it.remove();
        }
        if (li.field_74747_a.isEmpty()) {
            is.field_77990_d.func_82580_o("ench");
        }
    }

    public static ItemStack getBasicItemForEnchant(Enchantment e) {
        switch (e.field_77351_y) {
            case all: {
                return new ItemStack(Items.field_151046_w);
            }
            case armor: {
                return new ItemStack((Item)Items.field_151163_ad);
            }
            case armor_feet: {
                return new ItemStack((Item)Items.field_151167_ab);
            }
            case armor_head: {
                return new ItemStack((Item)Items.field_151028_Y);
            }
            case armor_legs: {
                return new ItemStack((Item)Items.field_151165_aa);
            }
            case armor_torso: {
                return new ItemStack((Item)Items.field_151030_Z);
            }
            case bow: {
                return new ItemStack((Item)Items.field_151031_f);
            }
            case breakable: {
                return new ItemStack(Items.field_151005_D);
            }
            case digger: {
                return new ItemStack(Items.field_151037_a);
            }
            case fishing_rod: {
                return new ItemStack((Item)Items.field_151112_aM);
            }
            case weapon: {
                return new ItemStack(Items.field_151040_l);
            }
        }
        return new ItemStack(Blocks.field_150346_d);
    }

    public static ItemStack getEnchantedBook(Enchantment e, int lvl) {
        ItemStack is = new ItemStack((Item)Items.field_151134_bR);
        HashMap<Enchantment, Integer> map = new HashMap<Enchantment, Integer>();
        map.put(e, lvl);
        ReikaEnchantmentHelper.applyEnchantments(is, map);
        return is;
    }

    public static Enchantment getRandomEnchantment(EnumEnchantmentType cat, boolean modded) {
        int idx = rand.nextInt(Enchantment.field_77331_b.length);
        Enchantment e = Enchantment.field_77331_b[idx];
        while (e == null || cat != null && e.field_77351_y != cat || !modded && !ReikaEnchantmentHelper.isVanillaEnchant(e)) {
            idx = rand.nextInt(Enchantment.field_77331_b.length);
            e = Enchantment.field_77331_b[idx];
        }
        return e;
    }

    public static boolean isVanillaEnchant(Enchantment e) {
        return e.getClass().getName().startsWith("net.minecraft");
    }

    public static Enchantment getEnchantmentByName(String s) {
        for (int i = 0; i < Enchantment.field_77331_b.length; ++i) {
            Enchantment e = Enchantment.field_77331_b[i];
            if (e == null) continue;
            String n = e.func_77320_a();
            if (n.startsWith("enchantment.")) {
                n = n.substring("enchantment.".length());
            }
            if (!n.equalsIgnoreCase(s)) continue;
            return e;
        }
        return null;
    }

    private static class EnchantmentNameComparator
    implements Comparator<Enchantment> {
        private EnchantmentNameComparator() {
        }

        @Override
        public int compare(Enchantment o1, Enchantment o2) {
            return o1.func_77316_c(1).compareToIgnoreCase(o2.func_77316_c(1));
        }
    }

    private static class EnchantmentTypeComparator
    implements Comparator<Enchantment> {
        private EnchantmentTypeComparator() {
        }

        @Override
        public int compare(Enchantment o1, Enchantment o2) {
            return o1.field_77351_y.ordinal() - o2.field_77351_y.ordinal();
        }
    }
}

