/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries.IO;

import Reika.DragonAPI.Auxiliary.Trackers.TickRegistry;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.IO.Shaders.ShaderProgram;
import Reika.DragonAPI.IO.Shaders.ShaderRegistry;
import Reika.DragonAPI.Instantiable.CubePoints;
import Reika.DragonAPI.Instantiable.Effects.ReikaModelledBreakFX;
import Reika.DragonAPI.Instantiable.Rendering.TessellatorVertexList;
import Reika.DragonAPI.Interfaces.TextureFetcher;
import Reika.DragonAPI.Interfaces.TileEntity.RenderFetcher;
import Reika.DragonAPI.Interfaces.TileModel;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.World.ReikaBiomeHelper;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.culling.Frustrum;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.shader.TesselatorVertexState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ScreenShotHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Matrix4f;

public final class ReikaRenderHelper
extends DragonAPICore {
    private static final RenderBlocks rb = new RenderBlocks();
    private static boolean entityLighting;
    private static boolean generalLighting;
    private static ScratchFramebuffer tempBuffer;
    private static ScratchScaledResolution resolution;
    private static int frame;
    private static float ptick;
    public static ICamera renderFrustrum;
    public static double thirdPersonDistance;

    public static RenderDistance getRenderDistance() {
        float r = Minecraft.func_71410_x().field_71474_y.field_151451_c;
        if (r > 8.0f) {
            return RenderDistance.FAR;
        }
        if (r > 4.0f) {
            return RenderDistance.NORMAL;
        }
        if (r > 2.0f) {
            return RenderDistance.SHORT;
        }
        return RenderDistance.TINY;
    }

    public static float biomeToColorMultiplier(World world, int x, int y, int z, Material mat, int bit) {
        int[] color = ReikaBiomeHelper.biomeToRGB((IBlockAccess)world, x, y, z, mat);
        float mult = ReikaColorAPI.RGBtoColorMultiplier(color, bit);
        return mult;
    }

    public static void renderCircle(double r, double x, double y, double z, int rgba, int step) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator var5 = Tessellator.field_78398_a;
        if (var5.field_78415_z) {
            var5.func_78381_a();
        }
        var5.func_78371_b(2);
        var5.func_78384_a(rgba, rgba >> 24 & 0xFF);
        for (int i = 0; i < 360; i += step) {
            double a = Math.toRadians(i);
            var5.func_78377_a(x + r * Math.cos(a), y, z + r * Math.sin(a));
        }
        var5.func_78381_a();
        GL11.glEnable((int)2884);
        GL11.glEnable((int)2929);
    }

    public static void renderVCircle(double r, double x, double y, double z, int rgba, double phi, int step) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator var5 = Tessellator.field_78398_a;
        var5.func_78371_b(2);
        var5.func_78384_a(rgba, rgba >> 24 & 0xFF);
        for (int i = 0; i < 360; i += step) {
            int sign = 1;
            double h = r * Math.cos(ReikaPhysicsHelper.degToRad(i));
            if (i >= 180) {
                sign = -1;
            }
            var5.func_78377_a(x - Math.sin(Math.toRadians(phi)) * (double)sign * Math.sqrt(r * r - h * h), y + r * Math.cos(Math.toRadians(i)), z + r * Math.sin(Math.toRadians(i)) * Math.cos(Math.toRadians(phi)));
        }
        var5.func_78381_a();
        GL11.glEnable((int)2884);
        GL11.glEnable((int)2929);
    }

    public static void renderLine(double x1, double y1, double z1, double x2, double y2, double z2, int rgba) {
        GL11.glEnable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator var5 = Tessellator.field_78398_a;
        if (var5.field_78415_z) {
            var5.func_78381_a();
        }
        var5.func_78371_b(2);
        var5.func_78384_a(rgba & 0xFFFFFF, rgba >> 24 & 0xFF);
        var5.func_78377_a(x1, y1, z1);
        var5.func_78377_a(x2, y2, z2);
        var5.func_78381_a();
        GL11.glDisable((int)32826);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)2929);
    }

    public static void renderTube(double x1, double y1, double z1, double x2, double y2, double z2, int c1, int c2, double r1, double r2, int sides) {
        Tessellator v5 = Tessellator.field_78398_a;
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dz = z2 - z1;
        GL11.glPushMatrix();
        GL11.glTranslated((double)x1, (double)y1, (double)z1);
        double f7 = Math.sqrt(dx * dx + dz * dz);
        double f8 = Math.sqrt(dx * dx + dy * dy + dz * dz);
        double ang1 = -Math.atan2(dz, dx) * 180.0 / Math.PI - 90.0;
        double ang2 = -Math.atan2(f7, dy) * 180.0 / Math.PI - 90.0;
        GL11.glRotated((double)ang1, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)ang2, (double)1.0, (double)0.0, (double)0.0);
        v5.func_78371_b(5);
        v5.func_78380_c(240);
        for (int i = 0; i <= sides; ++i) {
            double f11a = r1 * Math.sin((double)(i % sides) * Math.PI * 2.0 / (double)sides) * 0.75;
            double f12a = r1 * Math.cos((double)(i % sides) * Math.PI * 2.0 / (double)sides) * 0.75;
            double f11b = r2 * Math.sin((double)(i % sides) * Math.PI * 2.0 / (double)sides) * 0.75;
            double f12b = r2 * Math.cos((double)(i % sides) * Math.PI * 2.0 / (double)sides) * 0.75;
            double f13 = i % sides * 1 / sides;
            v5.func_78384_a(c1 & 0xFFFFFF, c1 >> 24 & 0xFF);
            v5.func_78377_a(f11a, f12a, 0.0);
            v5.func_78384_a(c2 & 0xFFFFFF, c2 >> 24 & 0xFF);
            v5.func_78377_a(f11b, f12b, f8);
        }
        v5.func_78381_a();
        GL11.glPopMatrix();
    }

    public static void disableLighting() {
        Minecraft.func_71410_x().field_71460_t.func_78483_a(1.0);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
    }

    public static void enableLighting() {
        ReikaRenderHelper.enableEntityLighting();
        RenderHelper.func_74519_b();
        GL11.glEnable((int)2896);
    }

    public static void disableEntityLighting() {
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
    }

    public static void enableEntityLighting() {
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        GL11.glEnable((int)3553);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
    }

    public static void pushTESRLightingState() {
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        entityLighting = GL11.glGetBoolean((int)3553);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
        generalLighting = GL11.glGetBoolean((int)2896);
        GL11.glDisable((int)2896);
        if (entityLighting) {
            ReikaRenderHelper.disableEntityLighting();
        }
    }

    public static void popTESRLightingState() {
        if (entityLighting) {
            ReikaRenderHelper.enableEntityLighting();
        }
        if (generalLighting) {
            GL11.glEnable((int)2896);
        }
    }

    public static void prepareGeoDraw(boolean alpha) {
        ReikaRenderHelper.disableLighting();
        GL11.glDisable((int)3553);
        if (alpha) {
            GL11.glEnable((int)3042);
        }
    }

    public static void exitGeoDraw() {
        ReikaRenderHelper.enableLighting();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static void renderRectangle(int r, int g, int b, int a, double x1, double y1, double z1, double x2, double y2, double z2) {
        Tessellator v5 = Tessellator.field_78398_a;
        v5.func_78382_b();
        v5.func_78370_a(r, g, b, a);
        v5.func_78377_a(x1, y1, z1);
        v5.func_78377_a(x2, y1, z2);
        v5.func_78377_a(x2, y2, z2);
        v5.func_78377_a(x1, y2, z1);
        v5.func_78381_a();
    }

    public static boolean addModelledBlockParticles(String basedir, World world, int x, int y, int z, Block b, EffectRenderer eff, List<double[]> allowedRegions, Class mod) {
        RenderFetcher te;
        TextureFetcher r;
        TileEntity t;
        String name = null;
        if (world.func_147439_a(x, y, z) == b && (t = world.func_147438_o(x, y, z)) instanceof RenderFetcher && (r = (te = (RenderFetcher)t).getRenderer()) != null) {
            name = r.getImageFileName(te);
        }
        if (name == null) {
            return false;
        }
        String file = basedir + name;
        for (int i = 0; i < 48; ++i) {
            double overy;
            int k = rand.nextInt(allowedRegions.size());
            double[] p = allowedRegions.get(k);
            double px = p[0] + rand.nextDouble() * (p[2] - p[0]);
            double py = p[1] + rand.nextDouble() * (p[3] - p[1]);
            double overx = px + 0.03125 - p[2];
            if (overx > 0.0) {
                px -= overx;
            }
            if ((overy = py + 0.03125 - p[2]) > 0.0) {
                py -= overy;
            }
            eff.func_78873_a((EntityFX)new ReikaModelledBreakFX(world, (double)x + rand.nextDouble(), (double)y + rand.nextDouble(), (double)z + rand.nextDouble(), -1.0 + rand.nextDouble() * 2.0, 2.0, -1.0 + rand.nextDouble() * 2.0, b, 0, world.func_72805_g(x, y, z), file, px, py, mod));
        }
        return true;
    }

    public static boolean addModelledBlockParticles(String basedir, World world, MovingObjectPosition mov, Block b, EffectRenderer eff, List<double[]> allowedRegions, Class mod) {
        RenderFetcher te;
        TextureFetcher r;
        TileEntity t;
        if (mov == null) {
            return false;
        }
        int x = mov.field_72311_b;
        int y = mov.field_72312_c;
        int z = mov.field_72309_d;
        String name = null;
        if (world.func_147439_a(x, y, z) == b && (t = world.func_147438_o(x, y, z)) instanceof RenderFetcher && (r = (te = (RenderFetcher)t).getRenderer()) != null) {
            name = r.getImageFileName(te);
        }
        int j = 1 + rand.nextInt(2);
        String file = basedir + name;
        for (int i = 0; i < j; ++i) {
            double overy;
            int k = rand.nextInt(allowedRegions.size());
            double[] p = allowedRegions.get(k);
            double px = p[0] + rand.nextDouble() * (p[2] - p[0]);
            double py = p[1] + rand.nextDouble() * (p[3] - p[1]);
            double overx = px + 0.03125 - p[2];
            if (overx > 0.0) {
                px -= overx;
            }
            if ((overy = py + 0.03125 - p[2]) > 0.0) {
                py -= overy;
            }
            eff.func_78873_a((EntityFX)new ReikaModelledBreakFX(world, (double)x + rand.nextDouble(), (double)y + rand.nextDouble(), (double)z + rand.nextDouble(), -1.0 + rand.nextDouble() * 2.0, 2.0, -1.0 + rand.nextDouble() * 2.0, b, 0, world.func_72805_g(x, y, z), file, px, py, mod));
        }
        return true;
    }

    public static boolean addModelledBlockParticlesDirect(String texture, World world, int x, int y, int z, Block b, EffectRenderer eff, List<double[]> allowedRegions, Class mod) {
        for (int i = 0; i < 48; ++i) {
            double overy;
            int k = rand.nextInt(allowedRegions.size());
            double[] p = allowedRegions.get(k);
            double px = p[0] + rand.nextDouble() * (p[2] - p[0]);
            double py = p[1] + rand.nextDouble() * (p[3] - p[1]);
            double overx = px + 0.03125 - p[2];
            if (overx > 0.0) {
                px -= overx;
            }
            if ((overy = py + 0.03125 - p[2]) > 0.0) {
                py -= overy;
            }
            eff.func_78873_a((EntityFX)new ReikaModelledBreakFX(world, (double)x + rand.nextDouble(), (double)y + rand.nextDouble(), (double)z + rand.nextDouble(), -1.0 + rand.nextDouble() * 2.0, 2.0, -1.0 + rand.nextDouble() * 2.0, b, 0, world.func_72805_g(x, y, z), texture, px, py, mod));
        }
        return true;
    }

    public static boolean addModelledBlockParticlesDirect(String texture, World world, MovingObjectPosition mov, Block b, EffectRenderer eff, List<double[]> allowedRegions, Class mod) {
        if (mov == null) {
            return false;
        }
        int x = mov.field_72311_b;
        int y = mov.field_72312_c;
        int z = mov.field_72309_d;
        int j = 1 + rand.nextInt(2);
        for (int i = 0; i < j; ++i) {
            double overy;
            int k = rand.nextInt(allowedRegions.size());
            double[] p = allowedRegions.get(k);
            double px = p[0] + rand.nextDouble() * (p[2] - p[0]);
            double py = p[1] + rand.nextDouble() * (p[3] - p[1]);
            double overx = px + 0.03125 - p[2];
            if (overx > 0.0) {
                px -= overx;
            }
            if ((overy = py + 0.03125 - p[2]) > 0.0) {
                py -= overy;
            }
            eff.func_78873_a((EntityFX)new ReikaModelledBreakFX(world, (double)x + rand.nextDouble(), (double)y + rand.nextDouble(), (double)z + rand.nextDouble(), -1.0 + rand.nextDouble() * 2.0, 2.0, -1.0 + rand.nextDouble() * 2.0, b, 0, world.func_72805_g(x, y, z), texture, px, py, mod));
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static void spawnDropParticles(World world, int x, int y, int z, Block b, int meta) {
        int n = 12 + rand.nextInt(12);
        ReikaRenderHelper.spawnDropParticles(world, x, y, z, b, meta, n);
    }

    @SideOnly(value=Side.CLIENT)
    public static void spawnDropParticles(World world, int x, int y, int z, Block b, int meta, int n) {
        for (int i = 0; i < n; ++i) {
            double vx = ReikaRandomHelper.getRandomPlusMinus(0.0, 0.25);
            double vz = ReikaRandomHelper.getRandomPlusMinus(0.0, 0.25);
            double vy = ReikaRandomHelper.getRandomBetween(0.125, 1.0);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)new ReikaModelledBreakFX(world, (double)x + rand.nextDouble(), (double)y + rand.nextDouble(), (double)z + rand.nextDouble(), vx, vy, vz, b, meta, 0));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static TesselatorVertexState getTessellatorState() {
        EntityLivingBase e = Minecraft.func_71410_x().field_71451_h;
        TesselatorVertexState st = Tessellator.field_78398_a.func_147564_a((float)e.field_70165_t, (float)e.field_70163_u, (float)e.field_70161_v);
        return st;
    }

    @SideOnly(value=Side.CLIENT)
    public static void rerenderAllChunks() {
        Minecraft.func_71410_x().field_71438_f.func_72712_a();
    }

    @SideOnly(value=Side.CLIENT)
    public static void rerenderAllChunksLazily() {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        EntityClientPlayerMP ep = Minecraft.func_71410_x().field_71439_g;
        int r = 192;
        int x1 = MathHelper.func_76128_c((double)(ep.field_70165_t - (double)r));
        int x2 = MathHelper.func_76128_c((double)(ep.field_70165_t + (double)r));
        int z1 = MathHelper.func_76128_c((double)(ep.field_70161_v - (double)r));
        int z2 = MathHelper.func_76128_c((double)(ep.field_70161_v + (double)r));
        world.func_147458_c(x1, 0, z1, x2, world.field_73011_w.getHeight() - 1, z2);
    }

    public static int getFPS() {
        return Minecraft.field_71470_ab;
    }

    public static int getRealFOV() {
        float base = Minecraft.func_71410_x().field_71474_y.field_74334_X;
        float diff = (30.0f - base) / 40.0f * 15.0f;
        float ang = base + diff;
        return (int)ang;
    }

    public static void renderEnchantedModel(TileEntity tile, TileModel model, ArrayList li, float rotation) {
        int x = tile.field_145851_c;
        int y = tile.field_145848_d;
        int z = tile.field_145849_e;
        float f9 = (float)(System.nanoTime() / 100000000L % 64L) / 64.0f;
        ReikaTextureHelper.bindEnchantmentTexture();
        GL11.glEnable((int)3042);
        ReikaGLHelper.BlendMode.OVERLAYDARK.apply();
        float f10 = 0.5f;
        GL11.glColor4f((float)f10, (float)f10, (float)f10, (float)1.0f);
        GL11.glMatrixMode((int)5890);
        GL11.glTranslated((double)f9, (double)f9, (double)f9);
        GL11.glMatrixMode((int)5888);
        GL11.glDepthFunc((int)515);
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)0.0f, (float)2.0f, (float)2.0f);
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        float f11 = 0.76f;
        GL11.glColor4f((float)(0.5f * f11), (float)(0.25f * f11), (float)(0.8f * f11), (float)1.0f);
        GL11.glRotatef((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)2896);
        double d = 1.0125;
        int p = 2;
        GL11.glTranslated((double)0.0, (double)p, (double)0.0);
        GL11.glScaled((double)d, (double)d, (double)d);
        GL11.glTranslated((double)0.0, (double)(-p), (double)0.0);
        model.renderAll(tile, li);
        GL11.glTranslated((double)0.0, (double)p, (double)0.0);
        GL11.glScaled((double)(1.0 / d), (double)(1.0 / d), (double)(1.0 / d));
        GL11.glTranslated((double)0.0, (double)(-p), (double)0.0);
        GL11.glMatrixMode((int)5890);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3008);
        GL11.glPopMatrix();
        GL11.glDepthFunc((int)515);
        ReikaGLHelper.BlendMode.DEFAULT.apply();
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static int getGUIScale() {
        Minecraft mc = Minecraft.func_71410_x();
        if (resolution == null || resolution.width != mc.field_71443_c || resolution.height != mc.field_71440_d) {
            resolution = new ScratchScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        }
        return resolution.func_78325_e();
    }

    public static boolean prepareAmbientOcclusion(IBlockAccess iba, int x, int y, int z, Block b, RenderBlocks rb, ForgeDirection dir, float red, float green, float blue) {
        rb.field_147863_w = true;
        boolean flag = false;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        boolean flag1 = true;
        int l = b.func_149677_c(iba, x, y, z);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(983055);
        if (rb.func_147745_b(b).func_94215_i().equals("grass_top")) {
            flag1 = false;
        } else if (rb.func_147744_b()) {
            flag1 = false;
        }
        switch (dir) {
            case DOWN: {
                if (rb.field_147855_j <= 0.0) {
                    --y;
                }
                rb.field_147831_S = b.func_149677_c(iba, x - 1, y, z);
                rb.field_147825_U = b.func_149677_c(iba, x, y, z - 1);
                rb.field_147828_V = b.func_149677_c(iba, x, y, z + 1);
                rb.field_147835_X = b.func_149677_c(iba, x + 1, y, z);
                rb.field_147886_y = iba.func_147439_a(x - 1, y, z).func_149685_I();
                rb.field_147814_A = iba.func_147439_a(x, y, z - 1).func_149685_I();
                rb.field_147815_B = iba.func_147439_a(x, y, z + 1).func_149685_I();
                rb.field_147810_D = iba.func_147439_a(x + 1, y, z).func_149685_I();
                boolean flag2 = iba.func_147439_a(x + 1, y - 1, z).func_149751_l();
                boolean flag3 = iba.func_147439_a(x - 1, y - 1, z).func_149751_l();
                boolean flag4 = iba.func_147439_a(x, y - 1, z + 1).func_149751_l();
                boolean flag5 = iba.func_147439_a(x, y - 1, z - 1).func_149751_l();
                if (!flag5 && !flag3) {
                    rb.field_147888_x = rb.field_147886_y;
                    rb.field_147832_R = rb.field_147831_S;
                } else {
                    rb.field_147888_x = iba.func_147439_a(x - 1, y, z - 1).func_149685_I();
                    rb.field_147832_R = b.func_149677_c(iba, x - 1, y, z - 1);
                }
                if (!flag4 && !flag3) {
                    rb.field_147884_z = rb.field_147886_y;
                    rb.field_147826_T = rb.field_147831_S;
                } else {
                    rb.field_147884_z = iba.func_147439_a(x - 1, y, z + 1).func_149685_I();
                    rb.field_147826_T = b.func_149677_c(iba, x - 1, y, z + 1);
                }
                if (!flag5 && !flag2) {
                    rb.field_147816_C = rb.field_147810_D;
                    rb.field_147827_W = rb.field_147835_X;
                } else {
                    rb.field_147816_C = iba.func_147439_a(x + 1, y, z - 1).func_149685_I();
                    rb.field_147827_W = b.func_149677_c(iba, x + 1, y, z - 1);
                }
                if (!flag4 && !flag2) {
                    rb.field_147811_E = rb.field_147810_D;
                    rb.field_147834_Y = rb.field_147835_X;
                } else {
                    rb.field_147811_E = iba.func_147439_a(x + 1, y, z + 1).func_149685_I();
                    rb.field_147834_Y = b.func_149677_c(iba, x + 1, y, z + 1);
                }
                if (rb.field_147855_j <= 0.0) {
                    ++y;
                }
                int i1 = l;
                if (rb.field_147855_j <= 0.0 || !iba.func_147439_a(x, y - 1, z).func_149662_c()) {
                    i1 = b.func_149677_c(iba, x, y - 1, z);
                }
                float f7 = iba.func_147439_a(x, y - 1, z).func_149685_I();
                f3 = (rb.field_147884_z + rb.field_147886_y + rb.field_147815_B + f7) / 4.0f;
                f6 = (rb.field_147815_B + f7 + rb.field_147811_E + rb.field_147810_D) / 4.0f;
                f5 = (f7 + rb.field_147814_A + rb.field_147810_D + rb.field_147816_C) / 4.0f;
                f4 = (rb.field_147886_y + rb.field_147888_x + f7 + rb.field_147814_A) / 4.0f;
                rb.field_147864_al = rb.func_147778_a(rb.field_147826_T, rb.field_147831_S, rb.field_147828_V, i1);
                rb.field_147870_ao = rb.func_147778_a(rb.field_147828_V, rb.field_147834_Y, rb.field_147835_X, i1);
                rb.field_147876_an = rb.func_147778_a(rb.field_147825_U, rb.field_147835_X, rb.field_147827_W, i1);
                rb.field_147874_am = rb.func_147778_a(rb.field_147831_S, rb.field_147832_R, rb.field_147825_U, i1);
                if (flag1) {
                    rb.field_147850_ar = rb.field_147848_as = red * 0.5f;
                    rb.field_147852_aq = rb.field_147848_as;
                    rb.field_147872_ap = rb.field_147848_as;
                    rb.field_147858_av = rb.field_147856_aw = green * 0.5f;
                    rb.field_147860_au = rb.field_147856_aw;
                    rb.field_147846_at = rb.field_147856_aw;
                    rb.field_147839_az = rb.field_147833_aA = blue * 0.5f;
                    rb.field_147841_ay = rb.field_147833_aA;
                    rb.field_147854_ax = rb.field_147833_aA;
                } else {
                    rb.field_147848_as = 0.5f;
                    rb.field_147850_ar = 0.5f;
                    rb.field_147852_aq = 0.5f;
                    rb.field_147872_ap = 0.5f;
                    rb.field_147856_aw = 0.5f;
                    rb.field_147858_av = 0.5f;
                    rb.field_147860_au = 0.5f;
                    rb.field_147846_at = 0.5f;
                    rb.field_147833_aA = 0.5f;
                    rb.field_147839_az = 0.5f;
                    rb.field_147841_ay = 0.5f;
                    rb.field_147854_ax = 0.5f;
                }
                rb.field_147872_ap *= f3;
                rb.field_147846_at *= f3;
                rb.field_147854_ax *= f3;
                rb.field_147852_aq *= f4;
                rb.field_147860_au *= f4;
                rb.field_147841_ay *= f4;
                rb.field_147850_ar *= f5;
                rb.field_147858_av *= f5;
                rb.field_147839_az *= f5;
                rb.field_147848_as *= f6;
                rb.field_147856_aw *= f6;
                rb.field_147833_aA *= f6;
                flag = true;
            }
            case UP: {
                if (rb.field_147857_k >= 1.0) {
                    ++y;
                }
                rb.field_147880_aa = b.func_149677_c(iba, x - 1, y, z);
                rb.field_147885_ae = b.func_149677_c(iba, x + 1, y, z);
                rb.field_147878_ac = b.func_149677_c(iba, x, y, z - 1);
                rb.field_147887_af = b.func_149677_c(iba, x, y, z + 1);
                rb.field_147813_G = iba.func_147439_a(x - 1, y, z).func_149685_I();
                rb.field_147824_K = iba.func_147439_a(x + 1, y, z).func_149685_I();
                rb.field_147822_I = iba.func_147439_a(x, y, z - 1).func_149685_I();
                rb.field_147817_L = iba.func_147439_a(x, y, z + 1).func_149685_I();
                boolean flag2 = iba.func_147439_a(x + 1, y + 1, z).func_149751_l();
                boolean flag3 = iba.func_147439_a(x - 1, y + 1, z).func_149751_l();
                boolean flag4 = iba.func_147439_a(x, y + 1, z + 1).func_149751_l();
                boolean flag5 = iba.func_147439_a(x, y + 1, z - 1).func_149751_l();
                if (!flag5 && !flag3) {
                    rb.field_147812_F = rb.field_147813_G;
                    rb.field_147836_Z = rb.field_147880_aa;
                } else {
                    rb.field_147812_F = iba.func_147439_a(x - 1, y, z - 1).func_149685_I();
                    rb.field_147836_Z = b.func_149677_c(iba, x - 1, y, z - 1);
                }
                if (!flag5 && !flag2) {
                    rb.field_147823_J = rb.field_147824_K;
                    rb.field_147879_ad = rb.field_147885_ae;
                } else {
                    rb.field_147823_J = iba.func_147439_a(x + 1, y, z - 1).func_149685_I();
                    rb.field_147879_ad = b.func_149677_c(iba, x + 1, y, z - 1);
                }
                if (!flag4 && !flag3) {
                    rb.field_147821_H = rb.field_147813_G;
                    rb.field_147881_ab = rb.field_147880_aa;
                } else {
                    rb.field_147821_H = iba.func_147439_a(x - 1, y, z + 1).func_149685_I();
                    rb.field_147881_ab = b.func_149677_c(iba, x - 1, y, z + 1);
                }
                if (!flag4 && !flag2) {
                    rb.field_147818_M = rb.field_147824_K;
                    rb.field_147882_ag = rb.field_147885_ae;
                } else {
                    rb.field_147818_M = iba.func_147439_a(x + 1, y, z + 1).func_149685_I();
                    rb.field_147882_ag = b.func_149677_c(iba, x + 1, y, z + 1);
                }
                if (rb.field_147857_k >= 1.0) {
                    --y;
                }
                int i1 = l;
                if (rb.field_147857_k >= 1.0 || !iba.func_147439_a(x, y + 1, z).func_149662_c()) {
                    i1 = b.func_149677_c(iba, x, y + 1, z);
                }
                float f7 = iba.func_147439_a(x, y + 1, z).func_149685_I();
                f6 = (rb.field_147821_H + rb.field_147813_G + rb.field_147817_L + f7) / 4.0f;
                f3 = (rb.field_147817_L + f7 + rb.field_147818_M + rb.field_147824_K) / 4.0f;
                f4 = (f7 + rb.field_147822_I + rb.field_147824_K + rb.field_147823_J) / 4.0f;
                f5 = (rb.field_147813_G + rb.field_147812_F + f7 + rb.field_147822_I) / 4.0f;
                rb.field_147870_ao = rb.func_147778_a(rb.field_147881_ab, rb.field_147880_aa, rb.field_147887_af, i1);
                rb.field_147864_al = rb.func_147778_a(rb.field_147887_af, rb.field_147882_ag, rb.field_147885_ae, i1);
                rb.field_147874_am = rb.func_147778_a(rb.field_147878_ac, rb.field_147885_ae, rb.field_147879_ad, i1);
                rb.field_147876_an = rb.func_147778_a(rb.field_147880_aa, rb.field_147836_Z, rb.field_147878_ac, i1);
                rb.field_147850_ar = rb.field_147848_as = red;
                rb.field_147852_aq = rb.field_147848_as;
                rb.field_147872_ap = rb.field_147848_as;
                rb.field_147858_av = rb.field_147856_aw = green;
                rb.field_147860_au = rb.field_147856_aw;
                rb.field_147846_at = rb.field_147856_aw;
                rb.field_147839_az = rb.field_147833_aA = blue;
                rb.field_147841_ay = rb.field_147833_aA;
                rb.field_147854_ax = rb.field_147833_aA;
                rb.field_147872_ap *= f3;
                rb.field_147846_at *= f3;
                rb.field_147854_ax *= f3;
                rb.field_147852_aq *= f4;
                rb.field_147860_au *= f4;
                rb.field_147841_ay *= f4;
                rb.field_147850_ar *= f5;
                rb.field_147858_av *= f5;
                rb.field_147839_az *= f5;
                rb.field_147848_as *= f6;
                rb.field_147856_aw *= f6;
                rb.field_147833_aA *= f6;
                flag = true;
            }
            case NORTH: {
                if (rb.field_147851_l <= 0.0) {
                    --z;
                }
                rb.field_147819_N = iba.func_147439_a(x - 1, y, z).func_149685_I();
                rb.field_147814_A = iba.func_147439_a(x, y - 1, z).func_149685_I();
                rb.field_147822_I = iba.func_147439_a(x, y + 1, z).func_149685_I();
                rb.field_147820_O = iba.func_147439_a(x + 1, y, z).func_149685_I();
                rb.field_147883_ah = b.func_149677_c(iba, x - 1, y, z);
                rb.field_147825_U = b.func_149677_c(iba, x, y - 1, z);
                rb.field_147878_ac = b.func_149677_c(iba, x, y + 1, z);
                rb.field_147866_ai = b.func_149677_c(iba, x + 1, y, z);
                boolean flag2 = iba.func_147439_a(x + 1, y, z - 1).func_149751_l();
                boolean flag3 = iba.func_147439_a(x - 1, y, z - 1).func_149751_l();
                boolean flag4 = iba.func_147439_a(x, y + 1, z - 1).func_149751_l();
                boolean flag5 = iba.func_147439_a(x, y - 1, z - 1).func_149751_l();
                if (!flag3 && !flag5) {
                    rb.field_147888_x = rb.field_147819_N;
                    rb.field_147832_R = rb.field_147883_ah;
                } else {
                    rb.field_147888_x = iba.func_147439_a(x - 1, y - 1, z).func_149685_I();
                    rb.field_147832_R = b.func_149677_c(iba, x - 1, y - 1, z);
                }
                if (!flag3 && !flag4) {
                    rb.field_147812_F = rb.field_147819_N;
                    rb.field_147836_Z = rb.field_147883_ah;
                } else {
                    rb.field_147812_F = iba.func_147439_a(x - 1, y + 1, z).func_149685_I();
                    rb.field_147836_Z = b.func_149677_c(iba, x - 1, y + 1, z);
                }
                if (!flag2 && !flag5) {
                    rb.field_147816_C = rb.field_147820_O;
                    rb.field_147827_W = rb.field_147866_ai;
                } else {
                    rb.field_147816_C = iba.func_147439_a(x + 1, y - 1, z).func_149685_I();
                    rb.field_147827_W = b.func_149677_c(iba, x + 1, y - 1, z);
                }
                if (!flag2 && !flag4) {
                    rb.field_147823_J = rb.field_147820_O;
                    rb.field_147879_ad = rb.field_147866_ai;
                } else {
                    rb.field_147823_J = iba.func_147439_a(x + 1, y + 1, z).func_149685_I();
                    rb.field_147879_ad = b.func_149677_c(iba, x + 1, y + 1, z);
                }
                if (rb.field_147851_l <= 0.0) {
                    ++z;
                }
                int i1 = l;
                if (rb.field_147851_l <= 0.0 || !iba.func_147439_a(x, y, z - 1).func_149662_c()) {
                    i1 = b.func_149677_c(iba, x, y, z - 1);
                }
                float f7 = iba.func_147439_a(x, y, z - 1).func_149685_I();
                f3 = (rb.field_147819_N + rb.field_147812_F + f7 + rb.field_147822_I) / 4.0f;
                f4 = (f7 + rb.field_147822_I + rb.field_147820_O + rb.field_147823_J) / 4.0f;
                f5 = (rb.field_147814_A + f7 + rb.field_147816_C + rb.field_147820_O) / 4.0f;
                f6 = (rb.field_147888_x + rb.field_147819_N + rb.field_147814_A + f7) / 4.0f;
                rb.field_147864_al = rb.func_147778_a(rb.field_147883_ah, rb.field_147836_Z, rb.field_147878_ac, i1);
                rb.field_147874_am = rb.func_147778_a(rb.field_147878_ac, rb.field_147866_ai, rb.field_147879_ad, i1);
                rb.field_147876_an = rb.func_147778_a(rb.field_147825_U, rb.field_147827_W, rb.field_147866_ai, i1);
                rb.field_147870_ao = rb.func_147778_a(rb.field_147832_R, rb.field_147883_ah, rb.field_147825_U, i1);
                if (flag1) {
                    rb.field_147850_ar = rb.field_147848_as = red * 0.8f;
                    rb.field_147852_aq = rb.field_147848_as;
                    rb.field_147872_ap = rb.field_147848_as;
                    rb.field_147858_av = rb.field_147856_aw = green * 0.8f;
                    rb.field_147860_au = rb.field_147856_aw;
                    rb.field_147846_at = rb.field_147856_aw;
                    rb.field_147839_az = rb.field_147833_aA = blue * 0.8f;
                    rb.field_147841_ay = rb.field_147833_aA;
                    rb.field_147854_ax = rb.field_147833_aA;
                } else {
                    rb.field_147848_as = 0.8f;
                    rb.field_147850_ar = 0.8f;
                    rb.field_147852_aq = 0.8f;
                    rb.field_147872_ap = 0.8f;
                    rb.field_147856_aw = 0.8f;
                    rb.field_147858_av = 0.8f;
                    rb.field_147860_au = 0.8f;
                    rb.field_147846_at = 0.8f;
                    rb.field_147833_aA = 0.8f;
                    rb.field_147839_az = 0.8f;
                    rb.field_147841_ay = 0.8f;
                    rb.field_147854_ax = 0.8f;
                }
                rb.field_147872_ap *= f3;
                rb.field_147846_at *= f3;
                rb.field_147854_ax *= f3;
                rb.field_147852_aq *= f4;
                rb.field_147860_au *= f4;
                rb.field_147841_ay *= f4;
                rb.field_147850_ar *= f5;
                rb.field_147858_av *= f5;
                rb.field_147839_az *= f5;
                rb.field_147848_as *= f6;
                rb.field_147856_aw *= f6;
                rb.field_147833_aA *= f6;
                IIcon iicon = rb.func_147793_a(b, iba, x, y, z, 2);
                if (RenderBlocks.field_147843_b && iicon.func_94215_i().equals("grass_side") && !rb.func_147744_b()) {
                    rb.field_147872_ap *= red;
                    rb.field_147852_aq *= red;
                    rb.field_147850_ar *= red;
                    rb.field_147848_as *= red;
                    rb.field_147846_at *= green;
                    rb.field_147860_au *= green;
                    rb.field_147858_av *= green;
                    rb.field_147856_aw *= green;
                    rb.field_147854_ax *= blue;
                    rb.field_147841_ay *= blue;
                    rb.field_147839_az *= blue;
                    rb.field_147833_aA *= blue;
                }
                flag = true;
            }
            case SOUTH: {
                if (rb.field_147853_m >= 1.0) {
                    ++z;
                }
                rb.field_147830_P = iba.func_147439_a(x - 1, y, z).func_149685_I();
                rb.field_147829_Q = iba.func_147439_a(x + 1, y, z).func_149685_I();
                rb.field_147815_B = iba.func_147439_a(x, y - 1, z).func_149685_I();
                rb.field_147817_L = iba.func_147439_a(x, y + 1, z).func_149685_I();
                rb.field_147868_aj = b.func_149677_c(iba, x - 1, y, z);
                rb.field_147862_ak = b.func_149677_c(iba, x + 1, y, z);
                rb.field_147828_V = b.func_149677_c(iba, x, y - 1, z);
                rb.field_147887_af = b.func_149677_c(iba, x, y + 1, z);
                boolean flag2 = iba.func_147439_a(x + 1, y, z + 1).func_149751_l();
                boolean flag3 = iba.func_147439_a(x - 1, y, z + 1).func_149751_l();
                boolean flag4 = iba.func_147439_a(x, y + 1, z + 1).func_149751_l();
                boolean flag5 = iba.func_147439_a(x, y - 1, z + 1).func_149751_l();
                if (!flag3 && !flag5) {
                    rb.field_147884_z = rb.field_147830_P;
                    rb.field_147826_T = rb.field_147868_aj;
                } else {
                    rb.field_147884_z = iba.func_147439_a(x - 1, y - 1, z).func_149685_I();
                    rb.field_147826_T = b.func_149677_c(iba, x - 1, y - 1, z);
                }
                if (!flag3 && !flag4) {
                    rb.field_147821_H = rb.field_147830_P;
                    rb.field_147881_ab = rb.field_147868_aj;
                } else {
                    rb.field_147821_H = iba.func_147439_a(x - 1, y + 1, z).func_149685_I();
                    rb.field_147881_ab = b.func_149677_c(iba, x - 1, y + 1, z);
                }
                if (!flag2 && !flag5) {
                    rb.field_147811_E = rb.field_147829_Q;
                    rb.field_147834_Y = rb.field_147862_ak;
                } else {
                    rb.field_147811_E = iba.func_147439_a(x + 1, y - 1, z).func_149685_I();
                    rb.field_147834_Y = b.func_149677_c(iba, x + 1, y - 1, z);
                }
                if (!flag2 && !flag4) {
                    rb.field_147818_M = rb.field_147829_Q;
                    rb.field_147882_ag = rb.field_147862_ak;
                } else {
                    rb.field_147818_M = iba.func_147439_a(x + 1, y + 1, z).func_149685_I();
                    rb.field_147882_ag = b.func_149677_c(iba, x + 1, y + 1, z);
                }
                if (rb.field_147853_m >= 1.0) {
                    --z;
                }
                int i1 = l;
                if (rb.field_147853_m >= 1.0 || !iba.func_147439_a(x, y, z + 1).func_149662_c()) {
                    i1 = b.func_149677_c(iba, x, y, z + 1);
                }
                float f7 = iba.func_147439_a(x, y, z + 1).func_149685_I();
                f3 = (rb.field_147830_P + rb.field_147821_H + f7 + rb.field_147817_L) / 4.0f;
                f6 = (f7 + rb.field_147817_L + rb.field_147829_Q + rb.field_147818_M) / 4.0f;
                f5 = (rb.field_147815_B + f7 + rb.field_147811_E + rb.field_147829_Q) / 4.0f;
                f4 = (rb.field_147884_z + rb.field_147830_P + rb.field_147815_B + f7) / 4.0f;
                rb.field_147864_al = rb.func_147778_a(rb.field_147868_aj, rb.field_147881_ab, rb.field_147887_af, i1);
                rb.field_147870_ao = rb.func_147778_a(rb.field_147887_af, rb.field_147862_ak, rb.field_147882_ag, i1);
                rb.field_147876_an = rb.func_147778_a(rb.field_147828_V, rb.field_147834_Y, rb.field_147862_ak, i1);
                rb.field_147874_am = rb.func_147778_a(rb.field_147826_T, rb.field_147868_aj, rb.field_147828_V, i1);
                if (flag1) {
                    rb.field_147850_ar = rb.field_147848_as = red * 0.8f;
                    rb.field_147852_aq = rb.field_147848_as;
                    rb.field_147872_ap = rb.field_147848_as;
                    rb.field_147858_av = rb.field_147856_aw = green * 0.8f;
                    rb.field_147860_au = rb.field_147856_aw;
                    rb.field_147846_at = rb.field_147856_aw;
                    rb.field_147839_az = rb.field_147833_aA = blue * 0.8f;
                    rb.field_147841_ay = rb.field_147833_aA;
                    rb.field_147854_ax = rb.field_147833_aA;
                } else {
                    rb.field_147848_as = 0.8f;
                    rb.field_147850_ar = 0.8f;
                    rb.field_147852_aq = 0.8f;
                    rb.field_147872_ap = 0.8f;
                    rb.field_147856_aw = 0.8f;
                    rb.field_147858_av = 0.8f;
                    rb.field_147860_au = 0.8f;
                    rb.field_147846_at = 0.8f;
                    rb.field_147833_aA = 0.8f;
                    rb.field_147839_az = 0.8f;
                    rb.field_147841_ay = 0.8f;
                    rb.field_147854_ax = 0.8f;
                }
                rb.field_147872_ap *= f3;
                rb.field_147846_at *= f3;
                rb.field_147854_ax *= f3;
                rb.field_147852_aq *= f4;
                rb.field_147860_au *= f4;
                rb.field_147841_ay *= f4;
                rb.field_147850_ar *= f5;
                rb.field_147858_av *= f5;
                rb.field_147839_az *= f5;
                rb.field_147848_as *= f6;
                rb.field_147856_aw *= f6;
                rb.field_147833_aA *= f6;
                IIcon iicon = rb.func_147793_a(b, iba, x, y, z, 3);
                if (RenderBlocks.field_147843_b && iicon.func_94215_i().equals("grass_side") && !rb.func_147744_b()) {
                    rb.field_147872_ap *= red;
                    rb.field_147852_aq *= red;
                    rb.field_147850_ar *= red;
                    rb.field_147848_as *= red;
                    rb.field_147846_at *= green;
                    rb.field_147860_au *= green;
                    rb.field_147858_av *= green;
                    rb.field_147856_aw *= green;
                    rb.field_147854_ax *= blue;
                    rb.field_147841_ay *= blue;
                    rb.field_147839_az *= blue;
                    rb.field_147833_aA *= blue;
                }
                flag = true;
            }
            case WEST: {
                if (rb.field_147859_h <= 0.0) {
                    --x;
                }
                rb.field_147886_y = iba.func_147439_a(x, y - 1, z).func_149685_I();
                rb.field_147819_N = iba.func_147439_a(x, y, z - 1).func_149685_I();
                rb.field_147830_P = iba.func_147439_a(x, y, z + 1).func_149685_I();
                rb.field_147813_G = iba.func_147439_a(x, y + 1, z).func_149685_I();
                rb.field_147831_S = b.func_149677_c(iba, x, y - 1, z);
                rb.field_147883_ah = b.func_149677_c(iba, x, y, z - 1);
                rb.field_147868_aj = b.func_149677_c(iba, x, y, z + 1);
                rb.field_147880_aa = b.func_149677_c(iba, x, y + 1, z);
                boolean flag2 = iba.func_147439_a(x - 1, y + 1, z).func_149751_l();
                boolean flag3 = iba.func_147439_a(x - 1, y - 1, z).func_149751_l();
                boolean flag4 = iba.func_147439_a(x - 1, y, z - 1).func_149751_l();
                boolean flag5 = iba.func_147439_a(x - 1, y, z + 1).func_149751_l();
                if (!flag4 && !flag3) {
                    rb.field_147888_x = rb.field_147819_N;
                    rb.field_147832_R = rb.field_147883_ah;
                } else {
                    rb.field_147888_x = iba.func_147439_a(x, y - 1, z - 1).func_149685_I();
                    rb.field_147832_R = b.func_149677_c(iba, x, y - 1, z - 1);
                }
                if (!flag5 && !flag3) {
                    rb.field_147884_z = rb.field_147830_P;
                    rb.field_147826_T = rb.field_147868_aj;
                } else {
                    rb.field_147884_z = iba.func_147439_a(x, y - 1, z + 1).func_149685_I();
                    rb.field_147826_T = b.func_149677_c(iba, x, y - 1, z + 1);
                }
                if (!flag4 && !flag2) {
                    rb.field_147812_F = rb.field_147819_N;
                    rb.field_147836_Z = rb.field_147883_ah;
                } else {
                    rb.field_147812_F = iba.func_147439_a(x, y + 1, z - 1).func_149685_I();
                    rb.field_147836_Z = b.func_149677_c(iba, x, y + 1, z - 1);
                }
                if (!flag5 && !flag2) {
                    rb.field_147821_H = rb.field_147830_P;
                    rb.field_147881_ab = rb.field_147868_aj;
                } else {
                    rb.field_147821_H = iba.func_147439_a(x, y + 1, z + 1).func_149685_I();
                    rb.field_147881_ab = b.func_149677_c(iba, x, y + 1, z + 1);
                }
                if (rb.field_147859_h <= 0.0) {
                    ++x;
                }
                int i1 = l;
                if (rb.field_147859_h <= 0.0 || !iba.func_147439_a(x - 1, y, z).func_149662_c()) {
                    i1 = b.func_149677_c(iba, x - 1, y, z);
                }
                float f7 = iba.func_147439_a(x - 1, y, z).func_149685_I();
                f6 = (rb.field_147886_y + rb.field_147884_z + f7 + rb.field_147830_P) / 4.0f;
                f3 = (f7 + rb.field_147830_P + rb.field_147813_G + rb.field_147821_H) / 4.0f;
                f4 = (rb.field_147819_N + f7 + rb.field_147812_F + rb.field_147813_G) / 4.0f;
                f5 = (rb.field_147888_x + rb.field_147886_y + rb.field_147819_N + f7) / 4.0f;
                rb.field_147870_ao = rb.func_147778_a(rb.field_147831_S, rb.field_147826_T, rb.field_147868_aj, i1);
                rb.field_147864_al = rb.func_147778_a(rb.field_147868_aj, rb.field_147880_aa, rb.field_147881_ab, i1);
                rb.field_147874_am = rb.func_147778_a(rb.field_147883_ah, rb.field_147836_Z, rb.field_147880_aa, i1);
                rb.field_147876_an = rb.func_147778_a(rb.field_147832_R, rb.field_147831_S, rb.field_147883_ah, i1);
                if (flag1) {
                    rb.field_147850_ar = rb.field_147848_as = red * 0.6f;
                    rb.field_147852_aq = rb.field_147848_as;
                    rb.field_147872_ap = rb.field_147848_as;
                    rb.field_147858_av = rb.field_147856_aw = green * 0.6f;
                    rb.field_147860_au = rb.field_147856_aw;
                    rb.field_147846_at = rb.field_147856_aw;
                    rb.field_147839_az = rb.field_147833_aA = blue * 0.6f;
                    rb.field_147841_ay = rb.field_147833_aA;
                    rb.field_147854_ax = rb.field_147833_aA;
                } else {
                    rb.field_147848_as = 0.6f;
                    rb.field_147850_ar = 0.6f;
                    rb.field_147852_aq = 0.6f;
                    rb.field_147872_ap = 0.6f;
                    rb.field_147856_aw = 0.6f;
                    rb.field_147858_av = 0.6f;
                    rb.field_147860_au = 0.6f;
                    rb.field_147846_at = 0.6f;
                    rb.field_147833_aA = 0.6f;
                    rb.field_147839_az = 0.6f;
                    rb.field_147841_ay = 0.6f;
                    rb.field_147854_ax = 0.6f;
                }
                rb.field_147872_ap *= f3;
                rb.field_147846_at *= f3;
                rb.field_147854_ax *= f3;
                rb.field_147852_aq *= f4;
                rb.field_147860_au *= f4;
                rb.field_147841_ay *= f4;
                rb.field_147850_ar *= f5;
                rb.field_147858_av *= f5;
                rb.field_147839_az *= f5;
                rb.field_147848_as *= f6;
                rb.field_147856_aw *= f6;
                rb.field_147833_aA *= f6;
                IIcon iicon = rb.func_147793_a(b, iba, x, y, z, 4);
                if (RenderBlocks.field_147843_b && iicon.func_94215_i().equals("grass_side") && !rb.func_147744_b()) {
                    rb.field_147872_ap *= red;
                    rb.field_147852_aq *= red;
                    rb.field_147850_ar *= red;
                    rb.field_147848_as *= red;
                    rb.field_147846_at *= green;
                    rb.field_147860_au *= green;
                    rb.field_147858_av *= green;
                    rb.field_147856_aw *= green;
                    rb.field_147854_ax *= blue;
                    rb.field_147841_ay *= blue;
                    rb.field_147839_az *= blue;
                    rb.field_147833_aA *= blue;
                }
                flag = true;
            }
            case EAST: {
                if (rb.field_147861_i >= 1.0) {
                    ++x;
                }
                rb.field_147810_D = iba.func_147439_a(x, y - 1, z).func_149685_I();
                rb.field_147820_O = iba.func_147439_a(x, y, z - 1).func_149685_I();
                rb.field_147829_Q = iba.func_147439_a(x, y, z + 1).func_149685_I();
                rb.field_147824_K = iba.func_147439_a(x, y + 1, z).func_149685_I();
                rb.field_147835_X = b.func_149677_c(iba, x, y - 1, z);
                rb.field_147866_ai = b.func_149677_c(iba, x, y, z - 1);
                rb.field_147862_ak = b.func_149677_c(iba, x, y, z + 1);
                rb.field_147885_ae = b.func_149677_c(iba, x, y + 1, z);
                boolean flag2 = iba.func_147439_a(x + 1, y + 1, z).func_149751_l();
                boolean flag3 = iba.func_147439_a(x + 1, y - 1, z).func_149751_l();
                boolean flag4 = iba.func_147439_a(x + 1, y, z + 1).func_149751_l();
                boolean flag5 = iba.func_147439_a(x + 1, y, z - 1).func_149751_l();
                if (!flag3 && !flag5) {
                    rb.field_147816_C = rb.field_147820_O;
                    rb.field_147827_W = rb.field_147866_ai;
                } else {
                    rb.field_147816_C = iba.func_147439_a(x, y - 1, z - 1).func_149685_I();
                    rb.field_147827_W = b.func_149677_c(iba, x, y - 1, z - 1);
                }
                if (!flag3 && !flag4) {
                    rb.field_147811_E = rb.field_147829_Q;
                    rb.field_147834_Y = rb.field_147862_ak;
                } else {
                    rb.field_147811_E = iba.func_147439_a(x, y - 1, z + 1).func_149685_I();
                    rb.field_147834_Y = b.func_149677_c(iba, x, y - 1, z + 1);
                }
                if (!flag2 && !flag5) {
                    rb.field_147823_J = rb.field_147820_O;
                    rb.field_147879_ad = rb.field_147866_ai;
                } else {
                    rb.field_147823_J = iba.func_147439_a(x, y + 1, z - 1).func_149685_I();
                    rb.field_147879_ad = b.func_149677_c(iba, x, y + 1, z - 1);
                }
                if (!flag2 && !flag4) {
                    rb.field_147818_M = rb.field_147829_Q;
                    rb.field_147882_ag = rb.field_147862_ak;
                } else {
                    rb.field_147818_M = iba.func_147439_a(x, y + 1, z + 1).func_149685_I();
                    rb.field_147882_ag = b.func_149677_c(iba, x, y + 1, z + 1);
                }
                if (rb.field_147861_i >= 1.0) {
                    --x;
                }
                int i1 = l;
                if (rb.field_147861_i >= 1.0 || !iba.func_147439_a(x + 1, y, z).func_149662_c()) {
                    i1 = b.func_149677_c(iba, x + 1, y, z);
                }
                float f7 = iba.func_147439_a(x + 1, y, z).func_149685_I();
                f3 = (rb.field_147810_D + rb.field_147811_E + f7 + rb.field_147829_Q) / 4.0f;
                f4 = (rb.field_147816_C + rb.field_147810_D + rb.field_147820_O + f7) / 4.0f;
                f5 = (rb.field_147820_O + f7 + rb.field_147823_J + rb.field_147824_K) / 4.0f;
                f6 = (f7 + rb.field_147829_Q + rb.field_147824_K + rb.field_147818_M) / 4.0f;
                rb.field_147864_al = rb.func_147778_a(rb.field_147835_X, rb.field_147834_Y, rb.field_147862_ak, i1);
                rb.field_147870_ao = rb.func_147778_a(rb.field_147862_ak, rb.field_147885_ae, rb.field_147882_ag, i1);
                rb.field_147876_an = rb.func_147778_a(rb.field_147866_ai, rb.field_147879_ad, rb.field_147885_ae, i1);
                rb.field_147874_am = rb.func_147778_a(rb.field_147827_W, rb.field_147835_X, rb.field_147866_ai, i1);
                if (flag1) {
                    rb.field_147850_ar = rb.field_147848_as = red * 0.6f;
                    rb.field_147852_aq = rb.field_147848_as;
                    rb.field_147872_ap = rb.field_147848_as;
                    rb.field_147858_av = rb.field_147856_aw = green * 0.6f;
                    rb.field_147860_au = rb.field_147856_aw;
                    rb.field_147846_at = rb.field_147856_aw;
                    rb.field_147839_az = rb.field_147833_aA = blue * 0.6f;
                    rb.field_147841_ay = rb.field_147833_aA;
                    rb.field_147854_ax = rb.field_147833_aA;
                } else {
                    rb.field_147848_as = 0.6f;
                    rb.field_147850_ar = 0.6f;
                    rb.field_147852_aq = 0.6f;
                    rb.field_147872_ap = 0.6f;
                    rb.field_147856_aw = 0.6f;
                    rb.field_147858_av = 0.6f;
                    rb.field_147860_au = 0.6f;
                    rb.field_147846_at = 0.6f;
                    rb.field_147833_aA = 0.6f;
                    rb.field_147839_az = 0.6f;
                    rb.field_147841_ay = 0.6f;
                    rb.field_147854_ax = 0.6f;
                }
                rb.field_147872_ap *= f3;
                rb.field_147846_at *= f3;
                rb.field_147854_ax *= f3;
                rb.field_147852_aq *= f4;
                rb.field_147860_au *= f4;
                rb.field_147841_ay *= f4;
                rb.field_147850_ar *= f5;
                rb.field_147858_av *= f5;
                rb.field_147839_az *= f5;
                rb.field_147848_as *= f6;
                rb.field_147856_aw *= f6;
                rb.field_147833_aA *= f6;
                IIcon iicon = rb.func_147793_a(b, iba, x, y, z, 5);
                if (RenderBlocks.field_147843_b && iicon.func_94215_i().equals("grass_side") && !rb.func_147744_b()) {
                    rb.field_147872_ap *= red;
                    rb.field_147852_aq *= red;
                    rb.field_147850_ar *= red;
                    rb.field_147848_as *= red;
                    rb.field_147846_at *= green;
                    rb.field_147860_au *= green;
                    rb.field_147858_av *= green;
                    rb.field_147856_aw *= green;
                    rb.field_147854_ax *= blue;
                    rb.field_147841_ay *= blue;
                    rb.field_147839_az *= blue;
                    rb.field_147833_aA *= blue;
                }
                flag = true;
            }
        }
        rb.field_147863_w = false;
        return flag;
    }

    public static long getRenderFrame() {
        return frame;
    }

    public static float getPartialTickTime() {
        return ptick;
    }

    public static void renderTorch(IBlockAccess world, double x, double y, double z, IIcon ico, Tessellator v5, RenderBlocks rb, double h, double w) {
        ico = rb.func_147758_b(ico);
        double u = ico.func_94209_e();
        double v = ico.func_94206_g();
        double du = ico.func_94212_f();
        double dv = ico.func_94210_h();
        double d9 = ico.func_94214_a(7.0);
        double d10 = ico.func_94207_b(6.0);
        double d11 = ico.func_94214_a(9.0);
        double d12 = ico.func_94207_b(8.0);
        double d13 = ico.func_94214_a(7.0);
        double d14 = ico.func_94207_b(13.0);
        double d15 = ico.func_94214_a(9.0);
        double d16 = ico.func_94207_b(15.0);
        double xmin = (x += 0.5) - 0.5;
        double xmax = x + 0.5;
        double zmin = (z += 0.5) - 0.5;
        double zmax = z + 0.5;
        v5.func_78374_a(x - w, y + h, z - w, d9, d10);
        v5.func_78374_a(x - w, y + h, z + w, d9, d12);
        v5.func_78374_a(x + w, y + h, z + w, d11, d12);
        v5.func_78374_a(x + w, y + h, z - w, d11, d10);
        v5.func_78374_a(x + w, y, z - w, d15, d14);
        v5.func_78374_a(x + w, y, z + w, d15, d16);
        v5.func_78374_a(x - w, y, z + w, d13, d16);
        v5.func_78374_a(x - w, y, z - w, d13, d14);
        v5.func_78374_a(x - w, y + 1.0, zmin, u, v);
        v5.func_78374_a(x - w, y + 0.0, zmin, u, dv);
        v5.func_78374_a(x - w, y + 0.0, zmax, du, dv);
        v5.func_78374_a(x - w, y + 1.0, zmax, du, v);
        v5.func_78374_a(x + w, y + 1.0, zmax, u, v);
        v5.func_78374_a(x + w, y + 0.0, zmax, u, dv);
        v5.func_78374_a(x + w, y + 0.0, zmin, du, dv);
        v5.func_78374_a(x + w, y + 1.0, zmin, du, v);
        v5.func_78374_a(xmin, y + 1.0, z + w, u, v);
        v5.func_78374_a(xmin, y + 0.0, z + w, u, dv);
        v5.func_78374_a(xmax, y + 0.0, z + w, du, dv);
        v5.func_78374_a(xmax, y + 1.0, z + w, du, v);
        v5.func_78374_a(xmax, y + 1.0, z - w, u, v);
        v5.func_78374_a(xmax, y + 0.0, z - w, u, dv);
        v5.func_78374_a(xmin, y + 0.0, z - w, du, dv);
        v5.func_78374_a(xmin, y + 1.0, z - w, du, v);
    }

    public static void renderCrossTex(IBlockAccess world, int x, int y, int z, IIcon ico, Tessellator v5, RenderBlocks rb, double h) {
        ico = rb.func_147758_b(ico);
        float u = ico.func_94209_e();
        float du = ico.func_94212_f();
        float v = ico.func_94206_g();
        float dv = ico.func_94210_h();
        v5.func_78374_a((double)x, (double)y + h, (double)z, (double)u, (double)v);
        v5.func_78374_a((double)(x + 1), (double)y + h, (double)(z + 1), (double)du, (double)v);
        v5.func_78374_a((double)(x + 1), (double)y, (double)(z + 1), (double)du, (double)dv);
        v5.func_78374_a((double)x, (double)y, (double)z, (double)u, (double)dv);
        v5.func_78374_a((double)x, (double)y, (double)z, (double)u, (double)dv);
        v5.func_78374_a((double)(x + 1), (double)y, (double)(z + 1), (double)du, (double)dv);
        v5.func_78374_a((double)(x + 1), (double)y + h, (double)(z + 1), (double)du, (double)v);
        v5.func_78374_a((double)x, (double)y + h, (double)z, (double)u, (double)v);
        v5.func_78374_a((double)x, (double)y + h, (double)(z + 1), (double)u, (double)v);
        v5.func_78374_a((double)(x + 1), (double)y + h, (double)z, (double)du, (double)v);
        v5.func_78374_a((double)(x + 1), (double)y, (double)z, (double)du, (double)dv);
        v5.func_78374_a((double)x, (double)y, (double)(z + 1), (double)u, (double)dv);
        v5.func_78374_a((double)x, (double)y, (double)(z + 1), (double)u, (double)dv);
        v5.func_78374_a((double)(x + 1), (double)y, (double)z, (double)du, (double)dv);
        v5.func_78374_a((double)(x + 1), (double)y + h, (double)z, (double)du, (double)v);
        v5.func_78374_a((double)x, (double)y + h, (double)(z + 1), (double)u, (double)v);
    }

    public static void renderFlatInnerTextureOnSide(IBlockAccess world, int x, int y, int z, IIcon ico, Tessellator v5, RenderBlocks rb, ForgeDirection dir, double inset, boolean needAdj) {
        ico = rb.func_147758_b(ico);
        float u = ico.func_94209_e();
        float du = ico.func_94212_f();
        float v = ico.func_94206_g();
        float dv = ico.func_94210_h();
        if (needAdj) {
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            Block b = world.func_147439_a(dx, dy, dz);
            if (b == Blocks.field_150350_a) {
                return;
            }
            if (b.isAir(world, dx, dy, dz)) {
                return;
            }
            if (!b.func_149688_o().func_76220_a() || !b.isSideSolid(world, dx, dy, dz, dir.getOpposite())) {
                return;
            }
        }
        switch (dir) {
            case DOWN: {
                v5.func_78374_a((double)x, (double)y + inset, (double)(z + 1), (double)u, (double)dv);
                v5.func_78374_a((double)(x + 1), (double)y + inset, (double)(z + 1), (double)u, (double)v);
                v5.func_78374_a((double)(x + 1), (double)y + inset, (double)z, (double)du, (double)v);
                v5.func_78374_a((double)x, (double)y + inset, (double)z, (double)du, (double)dv);
                break;
            }
            case UP: {
                v5.func_78374_a((double)x, (double)(y + 1) - inset, (double)z, (double)du, (double)dv);
                v5.func_78374_a((double)(x + 1), (double)(y + 1) - inset, (double)z, (double)u, (double)dv);
                v5.func_78374_a((double)(x + 1), (double)(y + 1) - inset, (double)(z + 1), (double)u, (double)v);
                v5.func_78374_a((double)x, (double)(y + 1) - inset, (double)(z + 1), (double)du, (double)v);
                break;
            }
            case EAST: {
                v5.func_78374_a((double)(x + 1) - inset, (double)y, (double)(z + 1), (double)u, (double)dv);
                v5.func_78374_a((double)(x + 1) - inset, (double)(y + 1), (double)(z + 1), (double)u, (double)v);
                v5.func_78374_a((double)(x + 1) - inset, (double)(y + 1), (double)z, (double)du, (double)v);
                v5.func_78374_a((double)(x + 1) - inset, (double)y, (double)z, (double)du, (double)dv);
                break;
            }
            case WEST: {
                v5.func_78374_a((double)x + inset, (double)y, (double)z, (double)u, (double)dv);
                v5.func_78374_a((double)x + inset, (double)(y + 1), (double)z, (double)u, (double)v);
                v5.func_78374_a((double)x + inset, (double)(y + 1), (double)(z + 1), (double)du, (double)v);
                v5.func_78374_a((double)x + inset, (double)y, (double)(z + 1), (double)du, (double)dv);
                break;
            }
            case NORTH: {
                v5.func_78374_a((double)(x + 1), (double)y, (double)z + inset, (double)u, (double)dv);
                v5.func_78374_a((double)(x + 1), (double)(y + 1), (double)z + inset, (double)u, (double)v);
                v5.func_78374_a((double)x, (double)(y + 1), (double)z + inset, (double)du, (double)v);
                v5.func_78374_a((double)x, (double)y, (double)z + inset, (double)du, (double)dv);
                break;
            }
            case SOUTH: {
                v5.func_78374_a((double)x, (double)y, (double)(z + 1) - inset, (double)du, (double)dv);
                v5.func_78374_a((double)x, (double)(y + 1), (double)(z + 1) - inset, (double)du, (double)v);
                v5.func_78374_a((double)(x + 1), (double)(y + 1), (double)(z + 1) - inset, (double)u, (double)v);
                v5.func_78374_a((double)(x + 1), (double)y, (double)(z + 1) - inset, (double)u, (double)dv);
                break;
            }
        }
    }

    public static void renderCropTypeTex(IBlockAccess world, int x, int y, int z, IIcon ico, Tessellator v5, RenderBlocks rb, double space, double h) {
        ico = rb.func_147758_b(ico);
        float u = ico.func_94209_e();
        float du = ico.func_94212_f();
        float v = ico.func_94206_g();
        float dv = ico.func_94210_h();
        double d7 = (double)x + 0.5 - space;
        double d8 = (double)x + 0.5 + space;
        double d9 = (double)z + 0.5 - 0.5;
        double d10 = (double)z + 0.5 + 0.5;
        double dy = (double)y - 0.0625;
        v5.func_78374_a(d7, dy + h, d9, (double)u, (double)v);
        v5.func_78374_a(d7, dy + 0.0, d9, (double)u, (double)dv);
        v5.func_78374_a(d7, dy + 0.0, d10, (double)du, (double)dv);
        v5.func_78374_a(d7, dy + h, d10, (double)du, (double)v);
        v5.func_78374_a(d7, dy + h, d10, (double)u, (double)v);
        v5.func_78374_a(d7, dy + 0.0, d10, (double)u, (double)dv);
        v5.func_78374_a(d7, dy + 0.0, d9, (double)du, (double)dv);
        v5.func_78374_a(d7, dy + h, d9, (double)du, (double)v);
        v5.func_78374_a(d8, dy + h, d10, (double)u, (double)v);
        v5.func_78374_a(d8, dy + 0.0, d10, (double)u, (double)dv);
        v5.func_78374_a(d8, dy + 0.0, d9, (double)du, (double)dv);
        v5.func_78374_a(d8, dy + h, d9, (double)du, (double)v);
        v5.func_78374_a(d8, dy + h, d9, (double)u, (double)v);
        v5.func_78374_a(d8, dy + 0.0, d9, (double)u, (double)dv);
        v5.func_78374_a(d8, dy + 0.0, d10, (double)du, (double)dv);
        v5.func_78374_a(d8, dy + h, d10, (double)du, (double)v);
        d7 = (double)x + 0.5 - 0.5;
        d8 = (double)x + 0.5 + 0.5;
        d9 = (double)z + 0.5 - space;
        d10 = (double)z + 0.5 + space;
        v5.func_78374_a(d7, dy + h, d9, (double)u, (double)v);
        v5.func_78374_a(d7, dy + 0.0, d9, (double)u, (double)dv);
        v5.func_78374_a(d8, dy + 0.0, d9, (double)du, (double)dv);
        v5.func_78374_a(d8, dy + h, d9, (double)du, (double)v);
        v5.func_78374_a(d8, dy + h, d9, (double)u, (double)v);
        v5.func_78374_a(d8, dy + 0.0, d9, (double)u, (double)dv);
        v5.func_78374_a(d7, dy + 0.0, d9, (double)du, (double)dv);
        v5.func_78374_a(d7, dy + h, d9, (double)du, (double)v);
        v5.func_78374_a(d8, dy + h, d10, (double)u, (double)v);
        v5.func_78374_a(d8, dy + 0.0, d10, (double)u, (double)dv);
        v5.func_78374_a(d7, dy + 0.0, d10, (double)du, (double)dv);
        v5.func_78374_a(d7, dy + h, d10, (double)du, (double)v);
        v5.func_78374_a(d7, dy + h, d10, (double)u, (double)v);
        v5.func_78374_a(d7, dy + 0.0, d10, (double)u, (double)dv);
        v5.func_78374_a(d8, dy + 0.0, d10, (double)du, (double)dv);
        v5.func_78374_a(d8, dy + h, d10, (double)du, (double)v);
    }

    @SideOnly(value=Side.CLIENT)
    public static void setCameraPosition(EntityPlayer ep, double cx, double cy, double cz, double cxPrev, double cyPrev, double czPrev, double yaw, double yawPrev, double pitch, double pitchPrev, boolean setPos, boolean setAngs) {
        DragonAPICore.debug("Moving " + ep.func_70005_c_() + " camera to " + cx + "," + cy + "," + cz + " @ " + yaw + " / " + pitch);
        RenderManager rm = RenderManager.field_78727_a;
        if (setPos) {
            RenderManager.field_78725_b = cx;
            RenderManager.field_78726_c = cy;
            RenderManager.field_78723_d = cz;
            rm.field_78730_l = cx;
            rm.field_78731_m = cy;
            rm.field_78728_n = cz;
        }
        if (rm.field_147941_i != null) {
            if (setPos) {
                rm.field_147941_i.field_70165_t = cx;
                rm.field_147941_i.field_70163_u = cy;
                rm.field_147941_i.field_70161_v = cz;
                rm.field_147941_i.field_70142_S = cxPrev;
                rm.field_147941_i.field_70137_T = cyPrev;
                rm.field_147941_i.field_70136_U = czPrev;
                rm.field_147941_i.field_70169_q = cxPrev;
                rm.field_147941_i.field_70167_r = cyPrev;
                rm.field_147941_i.field_70166_s = czPrev;
            }
            rm.func_147938_a(rm.field_78722_g, rm.field_78724_e, Minecraft.func_71410_x().field_71466_p, (EntityLivingBase)ep, rm.field_147941_i, rm.field_78733_k, 0.0f);
        }
        if (setPos) {
            TileEntityRendererDispatcher.field_147554_b = cx;
            TileEntityRendererDispatcher.field_147555_c = cy;
            TileEntityRendererDispatcher.field_147552_d = cz;
        }
        EntityClientPlayerMP mcp = Minecraft.func_71410_x().field_71439_g;
        EntityLivingBase mcp2 = Minecraft.func_71410_x().field_71451_h;
        if (setPos) {
            mcp.field_70165_t = cx;
            mcp.field_70163_u = cy;
            mcp.field_70161_v = cz;
            mcp.field_70142_S = cxPrev;
            mcp.field_70137_T = cyPrev;
            mcp.field_70136_U = czPrev;
            mcp.field_70169_q = cxPrev;
            mcp.field_70167_r = cyPrev;
            mcp.field_70166_s = czPrev;
            mcp2.field_70165_t = cx;
            mcp2.field_70163_u = cy;
            mcp2.field_70161_v = cz;
            mcp2.field_70142_S = cxPrev;
            mcp2.field_70137_T = cyPrev;
            mcp2.field_70136_U = czPrev;
            mcp2.field_70169_q = cxPrev;
            mcp2.field_70167_r = cyPrev;
            mcp2.field_70166_s = czPrev;
        }
        if (setAngs) {
            mcp.field_70759_as = (float)yaw;
            mcp.field_70177_z = (float)yaw;
            mcp.field_70126_B = (float)yawPrev;
            mcp.field_70758_at = (float)yawPrev;
            mcp.field_71109_bG = (float)yaw;
            mcp.field_71107_bF = (float)yawPrev;
            mcp.field_70125_A = (float)pitch;
            mcp.field_70127_C = (float)pitchPrev;
            mcp2.field_70759_as = (float)yaw;
            mcp2.field_70177_z = (float)yaw;
            mcp2.field_70126_B = (float)yawPrev;
            mcp2.field_70758_at = (float)yawPrev;
            mcp2.field_70125_A = (float)pitch;
            mcp2.field_70127_C = (float)pitchPrev;
        }
        Minecraft.func_71410_x().field_71417_B.func_74372_a();
    }

    public static void renderBlockSubCube(int x, int y, int z, double dx, double dy, double dz, double s, Tessellator v5, RenderBlocks rb, Block b, int meta) {
        ReikaRenderHelper.renderBlockSubCube(x, y, z, dx, dy, dz, s, s, s, v5, rb, b, meta);
    }

    public static void renderBlockSubCube(int x, int y, int z, double dx, double dy, double dz, double sx, double sy, double sz, Tessellator v5, RenderBlocks rb, Block b, int meta) {
        boolean flag = rb.field_147837_f;
        rb.field_147837_f = true;
        rb.field_147859_h = dx / 16.0;
        rb.field_147855_j = dy / 16.0;
        rb.field_147851_l = dz / 16.0;
        rb.field_147861_i = rb.field_147859_h + sx / 16.0;
        rb.field_147857_k = rb.field_147855_j + sy / 16.0;
        rb.field_147853_m = rb.field_147851_l + sz / 16.0;
        rb.field_147849_o = true;
        rb.func_147751_a(b, x, y, z, 1.0f, 1.0f, 1.0f);
        rb.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        rb.field_147837_f = flag;
    }

    public static void renderBlockPieceNonCuboid(IBlockAccess iba, int x, int y, int z, Block b, Tessellator v5, CubePoints points) {
        v5.func_78372_c((float)x, (float)y, (float)z);
        ForgeDirection dir = ForgeDirection.DOWN;
        IIcon ico = b.func_149673_e(iba, x, y, z, dir.ordinal());
        points.x1y1z1.draw(v5, ico, dir);
        points.x2y1z1.draw(v5, ico, dir);
        points.x2y1z2.draw(v5, ico, dir);
        points.x1y1z2.draw(v5, ico, dir);
        dir = ForgeDirection.UP;
        ico = b.func_149673_e(iba, x, y, z, dir.ordinal());
        points.x1y2z2.draw(v5, ico, dir);
        points.x2y2z2.draw(v5, ico, dir);
        points.x2y2z1.draw(v5, ico, dir);
        points.x1y2z1.draw(v5, ico, dir);
        dir = ForgeDirection.WEST;
        ico = b.func_149673_e(iba, x, y, z, dir.ordinal());
        points.x1y1z2.draw(v5, ico, dir);
        points.x1y2z2.draw(v5, ico, dir);
        points.x1y2z1.draw(v5, ico, dir);
        points.x1y1z1.draw(v5, ico, dir);
        dir = ForgeDirection.EAST;
        ico = b.func_149673_e(iba, x, y, z, dir.ordinal());
        points.x2y1z1.draw(v5, ico, dir);
        points.x2y2z1.draw(v5, ico, dir);
        points.x2y2z2.draw(v5, ico, dir);
        points.x2y1z2.draw(v5, ico, dir);
        dir = ForgeDirection.NORTH;
        ico = b.func_149673_e(iba, x, y, z, dir.ordinal());
        points.x1y1z1.draw(v5, ico, dir);
        points.x1y2z1.draw(v5, ico, dir);
        points.x2y2z1.draw(v5, ico, dir);
        points.x2y1z1.draw(v5, ico, dir);
        dir = ForgeDirection.SOUTH;
        ico = b.func_149673_e(iba, x, y, z, dir.ordinal());
        points.x2y1z2.draw(v5, ico, dir);
        points.x2y2z2.draw(v5, ico, dir);
        points.x1y2z2.draw(v5, ico, dir);
        points.x1y1z2.draw(v5, ico, dir);
        v5.func_78372_c((float)(-x), (float)(-y), (float)(-z));
    }

    public static void renderBlockPieceNonCuboid(Block b, int meta, Tessellator v5, CubePoints points) {
        ForgeDirection dir = ForgeDirection.DOWN;
        IIcon ico = b.func_149691_a(dir.ordinal(), meta);
        points.x1y1z1.draw(v5, ico, dir);
        points.x2y1z1.draw(v5, ico, dir);
        points.x2y1z2.draw(v5, ico, dir);
        points.x1y1z2.draw(v5, ico, dir);
        dir = ForgeDirection.UP;
        ico = b.func_149691_a(dir.ordinal(), meta);
        points.x1y2z2.draw(v5, ico, dir);
        points.x2y2z2.draw(v5, ico, dir);
        points.x2y2z1.draw(v5, ico, dir);
        points.x1y2z1.draw(v5, ico, dir);
        dir = ForgeDirection.WEST;
        ico = b.func_149691_a(dir.ordinal(), meta);
        points.x1y1z2.draw(v5, ico, dir);
        points.x1y2z2.draw(v5, ico, dir);
        points.x1y2z1.draw(v5, ico, dir);
        points.x1y1z1.draw(v5, ico, dir);
        dir = ForgeDirection.EAST;
        ico = b.func_149691_a(dir.ordinal(), meta);
        points.x2y1z1.draw(v5, ico, dir);
        points.x2y2z1.draw(v5, ico, dir);
        points.x2y2z2.draw(v5, ico, dir);
        points.x2y1z2.draw(v5, ico, dir);
        dir = ForgeDirection.NORTH;
        ico = b.func_149691_a(dir.ordinal(), meta);
        points.x1y1z1.draw(v5, ico, dir);
        points.x1y2z1.draw(v5, ico, dir);
        points.x2y2z1.draw(v5, ico, dir);
        points.x2y1z1.draw(v5, ico, dir);
        dir = ForgeDirection.SOUTH;
        ico = b.func_149691_a(dir.ordinal(), meta);
        points.x2y1z2.draw(v5, ico, dir);
        points.x2y2z2.draw(v5, ico, dir);
        points.x1y2z2.draw(v5, ico, dir);
        points.x1y1z2.draw(v5, ico, dir);
    }

    public static void renderIconIn3D(TessellatorVertexList v5, IIcon ico, int x, int y, int z) {
        float f9;
        float f8;
        float f7;
        float t = 0.0625f;
        float w = ico.func_94211_a();
        float h = ico.func_94216_b();
        float maxu = ico.func_94212_f();
        float maxv = ico.func_94210_h();
        float minu = ico.func_94209_e();
        float minv = ico.func_94206_g();
        v5.addVertexWithUVColor(0.0, 0.0, 0.0, maxu, maxv, -1);
        v5.addVertexWithUVColor(1.0, 0.0, 0.0, minu, maxv, -1);
        v5.addVertexWithUVColor(1.0, 1.0, 0.0, minu, minv, -1);
        v5.addVertexWithUVColor(0.0, 1.0, 0.0, maxu, minv, -1);
        v5.addVertexWithUVColor(0.0, 1.0, 0.0f - t, maxu, minv, -6250336);
        v5.addVertexWithUVColor(1.0, 1.0, 0.0f - t, minu, minv, -6250336);
        v5.addVertexWithUVColor(1.0, 0.0, 0.0f - t, minu, maxv, -6250336);
        v5.addVertexWithUVColor(0.0, 0.0, 0.0f - t, maxu, maxv, -6250336);
        float f5 = 0.5f * (maxu - minu) / w;
        float f6 = 0.5f * (maxv - minv) / h;
        int k = 0;
        while ((float)k < w) {
            f7 = (float)k / w;
            f8 = maxu + (minu - maxu) * f7 - f5;
            v5.addVertexWithUVColor(f7, 0.0, 0.0f - t, f8, maxv, -4868683);
            v5.addVertexWithUVColor(f7, 0.0, 0.0, f8, maxv, -4868683);
            v5.addVertexWithUVColor(f7, 1.0, 0.0, f8, minv, -4868683);
            v5.addVertexWithUVColor(f7, 1.0, 0.0f - t, f8, minv, -4868683);
            ++k;
        }
        k = 0;
        while ((float)k < w) {
            f7 = (float)k / w;
            f8 = maxu + (minu - maxu) * f7 - f5;
            f9 = f7 + 1.0f / w;
            v5.addVertexWithUVColor(f9, 1.0, 0.0f - t, f8, minv, -4868683);
            v5.addVertexWithUVColor(f9, 1.0, 0.0, f8, minv, -4868683);
            v5.addVertexWithUVColor(f9, 0.0, 0.0, f8, maxv, -4868683);
            v5.addVertexWithUVColor(f9, 0.0, 0.0f - t, f8, maxv, -4868683);
            ++k;
        }
        k = 0;
        while ((float)k < h) {
            f7 = (float)k / h;
            f8 = maxv + (minv - maxv) * f7 - f6;
            f9 = f7 + 1.0f / h;
            v5.addVertexWithUVColor(0.0, f9, 0.0, maxu, f8, -4868683);
            v5.addVertexWithUVColor(1.0, f9, 0.0, minu, f8, -4868683);
            v5.addVertexWithUVColor(1.0, f9, 0.0f - t, minu, f8, -4868683);
            v5.addVertexWithUVColor(0.0, f9, 0.0f - t, maxu, f8, -4868683);
            ++k;
        }
        k = 0;
        while ((float)k < h) {
            f7 = (float)k / h;
            f8 = maxv + (minv - maxv) * f7 - f6;
            v5.addVertexWithUVColor(1.0, f7, 0.0, minu, f8, -4868683);
            v5.addVertexWithUVColor(0.0, f7, 0.0, maxu, f8, -4868683);
            v5.addVertexWithUVColor(0.0, f7, 0.0f - t, maxu, f8, -4868683);
            v5.addVertexWithUVColor(1.0, f7, 0.0f - t, minu, f8, -4868683);
            ++k;
        }
    }

    public static void renderFrameBufferToItself(Framebuffer fb, int w, int h, ShaderProgram p) {
        p.updateEnabled();
        if (!p.isEnabled()) {
            return;
        }
        if (tempBuffer == null) {
            tempBuffer = new ScratchFramebuffer(w, h, true);
            tempBuffer.func_147604_a(0.0f, 0.0f, 0.0f, 0.0f);
        }
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)2884);
        boolean flag = true;
        int pass = 0;
        while (flag) {
            tempBuffer.func_147613_a(w, h);
            ReikaRenderHelper.setRenderTarget(tempBuffer);
            flag = ShaderRegistry.runShader(p);
            fb.func_147615_c(w, h);
            ShaderRegistry.completeShader();
            ReikaRenderHelper.setRenderTarget(fb);
            tempBuffer.func_147615_c(w, h);
            ++pass;
        }
        GL11.glPopAttrib();
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
    }

    private static void exportFramebuffer(Framebuffer fb, int pass, ShaderProgram p) {
        if (!p.identifier.contains("reika")) {
            return;
        }
        try {
            File root = new File(Minecraft.func_71410_x().field_71412_D, "FramebufferExport");
            String name = pass == -1 ? p.identifier + "_end" : (pass == 0 ? p.identifier + "_begin" : p.identifier + "_c_pass_" + pass);
            name = name + ".png";
            File f = new File(new File(root, "screenshots"), name);
            if (f.exists()) {
                return;
            }
            ScreenShotHelper.func_148259_a((File)root, (String)name, (int)fb.field_147621_c, (int)fb.field_147618_d, (Framebuffer)fb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setRenderTarget(Framebuffer fb) {
        OpenGlHelper.func_153171_g((int)OpenGlHelper.field_153198_e, (int)(fb != null ? fb.field_147616_f : 0));
    }

    public static void renderTextureToFramebuffer(int texture, Framebuffer fb) {
        IntBuffer pixelBuffer = BufferUtils.createIntBuffer((int)(fb.field_147618_d * fb.field_147621_c));
        GL11.glBindTexture((int)3553, (int)texture);
        GL11.glGetTexImage((int)3553, (int)0, (int)32993, (int)33639, (IntBuffer)pixelBuffer);
        GL11.glBindTexture((int)3553, (int)fb.field_147617_g);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)fb.field_147621_c, (int)fb.field_147618_d, (int)0, (int)32993, (int)33639, (IntBuffer)pixelBuffer);
    }

    public static Matrix4f getModelviewMatrix() {
        return ReikaRenderHelper.getMatrix(2982);
    }

    public static Matrix4f getProjectionMatrix() {
        return ReikaRenderHelper.getMatrix(2983);
    }

    public static Matrix4f getTextureMatrix() {
        return ReikaRenderHelper.getMatrix(2984);
    }

    private static Matrix4f getMatrix(int id) {
        FloatBuffer buf = BufferUtils.createFloatBuffer((int)16);
        GL11.glGetFloat((int)id, (FloatBuffer)buf);
        buf.rewind();
        Matrix4f mat = new Matrix4f();
        mat.load(buf);
        return mat;
    }

    static {
        frame = -1;
        ptick = -1.0f;
        renderFrustrum = new Frustrum();
    }

    private static class ScratchScaledResolution
    extends ScaledResolution {
        private final int width;
        private final int height;

        public ScratchScaledResolution(Minecraft mc, int w, int h) {
            super(mc, w, h);
            this.width = w;
            this.height = h;
        }
    }

    public static class ScratchFramebuffer
    extends Framebuffer {
        public ScratchFramebuffer(int w, int h, boolean depth) {
            super(w, h, depth);
        }

        public void func_147613_a(int w, int h) {
            if (w != this.field_147621_c || h != this.field_147618_d) {
                super.func_147613_a(w, h);
            }
        }

        public void clear() {
            this.func_147614_f();
        }

        public void replaceWith(int texture) {
            ReikaRenderHelper.renderTextureToFramebuffer(texture, this);
        }

        public void renderWithAlpha(int width, int height) {
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            GL11.glDisable((int)2929);
            GL11.glDepthMask((boolean)false);
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            GL11.glOrtho((double)0.0, (double)width, (double)height, (double)0.0, (double)1000.0, (double)3000.0);
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
            GL11.glViewport((int)0, (int)0, (int)width, (int)height);
            GL11.glEnable((int)3553);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)3008);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)2903);
            this.func_147612_c();
            float f = width;
            float f1 = height;
            float f2 = (float)this.field_147621_c / (float)this.field_147622_a;
            float f3 = (float)this.field_147618_d / (float)this.field_147620_b;
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78382_b();
            tessellator.func_78378_d(-1);
            tessellator.func_78374_a(0.0, (double)f1, 0.0, 0.0, 0.0);
            tessellator.func_78374_a((double)f, (double)f1, 0.0, (double)f2, 0.0);
            tessellator.func_78374_a((double)f, 0.0, 0.0, (double)f2, (double)f3);
            tessellator.func_78374_a(0.0, 0.0, 0.0, 0.0, (double)f3);
            tessellator.func_78381_a();
            this.func_147606_d();
            GL11.glDepthMask((boolean)true);
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
    }

    public static class RenderTick
    implements TickRegistry.TickHandler {
        @Override
        public void tick(TickRegistry.TickType type, Object ... tickData) {
            frame++;
            ptick = ((Float)tickData[0]).floatValue();
        }

        @Override
        public EnumSet<TickRegistry.TickType> getType() {
            return EnumSet.of(TickRegistry.TickType.RENDER);
        }

        @Override
        public boolean canFire(TickEvent.Phase p) {
            return p == TickEvent.Phase.START;
        }

        @Override
        public String getLabel() {
            return null;
        }
    }

    public static enum RenderDistance {
        FAR,
        NORMAL,
        SHORT,
        TINY;

        private static final RenderDistance[] list;

        static {
            list = RenderDistance.values();
        }
    }
}

