/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries.IO;

import Reika.DragonAPI.APIPacketHandler;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public final class ReikaChatHelper
extends DragonAPICore {
    public static void clearChat() {
        ReikaChatHelper.clearChat(null);
    }

    public static void clearChat(EntityPlayerMP ep) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            ReikaChatHelper.clearChatGui();
        } else if (ep != null) {
            ReikaPacketHelper.sendDataPacket("DragonAPIData", APIPacketHandler.PacketIDs.CLEARCHAT.ordinal(), ep, new int[0]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void clearChatGui() {
        Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146231_a();
    }

    public static void writeItemStack(World world, ItemStack is) {
        String msg = is == null ? "Null Stack!" : String.format("%d, %d, %d", is.func_77973_b(), is.field_77994_a, is.func_77960_j());
        ReikaChatHelper.writeString(msg);
    }

    public static void writeCoords(World world, double x, double y, double z) {
        String msg = String.format("%.2f, %.2f, %.2f", x, y, z);
        ReikaChatHelper.writeString(msg);
    }

    public static void writeBlockAtCoords(World world, int x, int y, int z) {
        StringBuilder sb = new StringBuilder();
        Block id = world.func_147439_a(x, y, z);
        String name = id != Blocks.field_150350_a ? id.func_149732_F() : "Air";
        int meta = world.func_72805_g(x, y, z);
        sb.append(String.format("Block %s (ID %d Metadata %d) @ x=%d, y=%d, z=%d", name, Block.func_149682_b((Block)id), meta, x, y, z) + "\n");
        TileEntity te = world.func_147438_o(x, y, z);
        if (te == null) {
            sb.append("No Tile Entity at this location.");
        } else {
            sb.append("Tile Entity at this location:\n");
            sb.append(te.toString());
        }
        ReikaChatHelper.writeString(sb.toString());
    }

    public static void writeInt(int num) {
        ReikaChatHelper.writeString(String.format("%d", num));
    }

    public static void writeString(String sg) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            ReikaChatHelper.writeChatString(sg);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void writeChatString(String sg) {
        if (Minecraft.func_71410_x().field_71439_g != null) {
            ReikaChatHelper.sendChatToPlayer((EntityPlayer)Minecraft.func_71410_x().field_71439_g, sg);
        }
    }

    public static void writeLocalString(String tag) {
        ReikaChatHelper.writeString(StatCollector.func_74838_a((String)tag));
    }

    public static void write(Object obj) {
        if (obj == null) {
            ReikaChatHelper.writeString("null");
            return;
        }
        String str = obj.getClass() == Double.class ? String.format("%.3f", obj) : String.valueOf(obj);
        ReikaChatHelper.writeString(str);
    }

    public static void writeFormattedString(String str, EnumChatFormatting ... fm) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fm.length; ++i) {
            sb.append(fm[i].toString());
        }
        ReikaChatHelper.writeString(sb.toString() + str);
    }

    public static void writeEntity(World world, Entity ent) {
        if (world == null) {
            return;
        }
        if (ent == null) {
            ReikaChatHelper.writeString("null");
        } else {
            ReikaChatHelper.writeString(ent.func_70005_c_() + " @ " + String.format("%.2f, %.2f, %.2f", ent.field_70165_t, ent.field_70163_u, ent.field_70161_v));
        }
    }

    public static void writeItem(World world, Item id, int dmg) {
        if (id == null) {
            ReikaChatHelper.writeString("Null Item");
        } else {
            ReikaChatHelper.writeString(id + ":" + dmg + " is " + id.func_77653_i(new ItemStack(id, 1, dmg)));
        }
    }

    public static void writeBlock(World world, Block id, int meta) {
        if (id == Blocks.field_150350_a) {
            ReikaChatHelper.writeString("Null Item");
        } else {
            ReikaChatHelper.writeString(id + ":" + meta + " is " + id.func_149732_F());
        }
    }

    public static void writeSide() {
        ReikaChatHelper.writeString(String.valueOf(FMLCommonHandler.instance().getEffectiveSide()));
    }

    public static void sendChatToPlayer(EntityPlayer ep, String sg) {
        if (sg.length() > 16384) {
            for (int idx = 0; idx < sg.length(); idx += 16384) {
                String sg2 = sg.substring(idx, Math.min(idx + 16384, sg.length()));
                ReikaChatHelper.sendChatToPlayer(ep, sg2);
            }
            return;
        }
        String[] parts = sg.split("\\n");
        for (int i = 0; i < parts.length; ++i) {
            ChatComponentTranslation chat = new ChatComponentTranslation(parts[i], new Object[0]);
            ep.func_145747_a((IChatComponent)chat);
        }
    }

    public static void sendChatToAllOnServer(String sg) {
        String[] parts = sg.split("\\n");
        MinecraftServer srv = MinecraftServer.func_71276_C();
        if (srv != null) {
            ServerConfigurationManager cfg = srv.func_71203_ab();
            if (cfg != null) {
                for (int i = 0; i < parts.length; ++i) {
                    ChatComponentTranslation chat = new ChatComponentTranslation(parts[i], new Object[0]);
                    cfg.func_148539_a((IChatComponent)chat);
                }
            } else {
                DragonAPICore.logError("Something tried to send chat to a server with null configurations!");
                ReikaJavaLibrary.dumpStack();
            }
        } else {
            DragonAPICore.logError("Something tried to send chat to a null server!");
            ReikaJavaLibrary.dumpStack();
        }
    }
}

