/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Worldgen;

import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.World.ReikaGenHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class LootController {
    private List<LootStack> items = new ArrayList<LootStack>();

    public void registerToWorldGen(DragonAPIMod mod, int tier) {
        if (tier <= 0) {
            mod.getModLogger().log("Skipping dungeon loot generation, as it has been disabled.");
            return;
        }
        for (LootStack ls : this.items) {
            String itemName = ls.toString();
            if (ls.lootTier <= tier) {
                ReikaGenHelper.addChestLoot(ls.chestLocation.tag, ls.item, ls.minSize, ls.maxSize, ls.weight);
                mod.getModLogger().log("Adding " + itemName + " to " + (Object)((Object)ls.chestLocation));
                continue;
            }
            mod.getModLogger().log("Not adding " + itemName + " to " + (Object)((Object)ls.chestLocation) + ", as its generation tier (" + ls.lootTier + ") is greater than the configured tier of " + tier + ".");
        }
    }

    public void addItem(int tier, Location loc, ItemStack is, int min, int max, int chance) {
        LootStack ls = new LootStack(tier, loc, is, min, max, chance);
        if (!this.items.contains(ls)) {
            this.items.add(ls);
        }
    }

    public void addItem(int tier, Location loc, ItemStack is, int chance) {
        this.addItem(tier, loc, is, 1, 1, chance);
    }

    public void addItems(int tier, Location loc, List<ItemStack> li, int chance) {
        for (int i = 0; i < li.size(); ++i) {
            this.addItem(tier, loc, li.get(i), chance);
        }
    }

    public String toString() {
        return this.items.toString();
    }

    public static enum Location {
        BONUS("bonusChest"),
        VILLAGE("villageBlacksmith"),
        DUNGEON("dungeonChest"),
        MINESHAFT("mineshaftCorridor"),
        STRONGHOLD_LIBRARY("strongholdLibrary"),
        STRONGHOLD_CROSSING("strongholdCrossing"),
        STRONGHOLD_HALLWAY("strongholdCorridor"),
        PYRAMID("pyramidDesertyChest"),
        JUNGLE_DISPENSER("pyramidJungleDispenser"),
        JUNGLE_PUZZLE("pyramidJungleChest");

        public final String tag;

        private Location(String sg) {
            this.tag = sg;
        }
    }

    class LootStack {
        public final int lootTier;
        public final Location chestLocation;
        private final ItemStack item;
        public final int minSize;
        public final int maxSize;
        public final int weight;

        public LootStack(int tier, Location loc, ItemStack is, int min, int max, int chance) {
            this.lootTier = tier;
            this.chestLocation = loc;
            this.item = is;
            this.minSize = min;
            this.maxSize = max;
            this.weight = chance;
        }

        public ItemStack getItemStack() {
            return this.item.func_77946_l();
        }

        public boolean equals(Object o) {
            if (o instanceof LootStack) {
                LootStack ls = (LootStack)o;
                return ls.chestLocation == this.chestLocation && ReikaItemHelper.matchStacks(this.item, ls.item);
            }
            return false;
        }

        public String toString() {
            if (this.maxSize == this.minSize) {
                return this.item.func_82833_r() + " with size " + this.minSize;
            }
            return this.item.func_82833_r() + " with size " + this.minSize + "-" + this.maxSize;
        }
    }
}

