/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable;

import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class TemperatureEffect {
    public static final TemperatureEffect rockMelting = new BlockConversionEffect(1500){

        @Override
        protected void doAction(World world, int x, int y, int z, int temperature) {
            if (ReikaWorldHelper.isMeltable(world, x, y, z, temperature)) {
                super.doAction(world, x, y, z, temperature);
            }
        }

        @Override
        protected Block getBlock(int temperature) {
            return Blocks.field_150356_k;
        }
    };
    public static final TemperatureEffect groundGlassing = new BlockConversionEffect(900){

        @Override
        protected Block getBlock(int temperature) {
            return Blocks.field_150359_w;
        }
    };
    public static final TemperatureEffect snowVaporization = new BlockConversionEffect(0){

        @Override
        protected Block getBlock(int temperature) {
            return Blocks.field_150350_a;
        }
    };
    public static final TemperatureEffect iceMelting = new BlockConversionEffect(0){

        @Override
        protected Block getBlock(int temperature) {
            return Blocks.field_150358_i;
        }
    };
    public static final TemperatureEffect woodIgnition = new IgnitionEffect(450);
    public static final TemperatureEffect woolIgnition = new IgnitionEffect(600);
    public static final TemperatureEffect tntIgnition = new IgnitionEffect(300);
    public static final TemperatureEffect plantIgnition = new IgnitionEffect(230);
    public final int minimumTemperature;

    protected TemperatureEffect(int temp) {
        this.minimumTemperature = temp;
    }

    public final void apply(World world, int x, int y, int z, int temperature, TemperatureCallback call) {
        this.doAction(world, x, y, z, temperature);
        if (call != null) {
            call.onApplyTemperature(world, x, y, z, temperature);
        }
    }

    protected abstract void doAction(World var1, int var2, int var3, int var4, int var5);

    public static interface TemperatureCallback {
        public void onApplyTemperature(World var1, int var2, int var3, int var4, int var5);
    }

    private static abstract class BlockConversionEffect
    extends TemperatureEffect {
        protected BlockConversionEffect(int temp) {
            super(temp);
        }

        @Override
        protected void doAction(World world, int x, int y, int z, int temperature) {
            world.func_147449_b(x, y, z, this.getBlock(temperature));
        }

        protected abstract Block getBlock(int var1);
    }

    private static class IgnitionEffect
    extends TemperatureEffect {
        protected IgnitionEffect(int temp) {
            super(temp);
        }

        @Override
        protected final void doAction(World world, int x, int y, int z, int temperature) {
            if (ReikaWorldHelper.flammable((IBlockAccess)world, x, y, z)) {
                ReikaWorldHelper.ignite(world, x, y, z);
            }
        }
    }
}

