/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Rendering;

import Reika.DragonAPI.Exception.MisuseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;

public class SubdividedProgressBar {
    private final TreeMap<Float, ProgressBarSection> sections = new TreeMap();
    private final HashMap<Integer, ProgressBarSection> lookups = new HashMap();
    private int tick;
    private int duration;

    public SubdividedProgressBar addSection(int len, float f) {
        return this.addSection(new ProgressBarSection(len, f));
    }

    public SubdividedProgressBar addSection(int len) {
        return this.addSection(new ProgressBarSection(len));
    }

    public SubdividedProgressBar addSection(ProgressBarSection p) {
        this.recalculateFractions(p);
        return this;
    }

    private void recalculateFractions(ProgressBarSection add) {
        ArrayList<ProgressBarSection> li = new ArrayList<ProgressBarSection>(this.sections.values());
        if (add != null) {
            li.add(add);
        }
        this.sections.clear();
        this.lookups.clear();
        float total = 0.0f;
        for (ProgressBarSection p : li) {
            total += p.ticksDuration;
        }
        float at = 0.0f;
        for (ProgressBarSection p : li) {
            float start = at / total;
            float end = (at += p.ticksDuration) / total;
            p.startFraction = start;
            p.endFraction = end;
            this.sections.put(Float.valueOf(p.startFraction), p);
            p.index = this.lookups.size();
            this.lookups.put(p.index, p);
        }
    }

    public void setTick(int tick, int duration) {
        if (tick >= duration) {
            throw new MisuseException("You cannot set the time greater than the maximum!");
        }
        this.tick = tick;
        this.duration = duration;
        float f = (float)tick / (float)duration;
        for (ProgressBarSection p : this.sections.values()) {
            if (p.startFraction >= f) {
                p.fraction = 0.0f;
                continue;
            }
            if (p.endFraction <= f) {
                p.fraction = 1.0f;
                continue;
            }
            p.fraction = (f - p.startFraction) / (p.endFraction - p.startFraction);
        }
    }

    public int getScaled(int section) {
        return this.lookups.get(section).getScaled();
    }

    public int barCount() {
        return this.sections.size();
    }

    public static class ProgressBarSection {
        private float startFraction;
        private float endFraction;
        private float fraction;
        private int index;
        public final int pixelLength;
        public final float speedFactor;
        private final float ticksDuration;

        public ProgressBarSection(int len) {
            this(len, 1.0f);
        }

        public int getScaled() {
            return (int)(this.fraction * (float)this.pixelLength);
        }

        public ProgressBarSection(int len, float s) {
            this.pixelLength = len;
            this.speedFactor = s;
            this.ticksDuration = (float)this.pixelLength / this.speedFactor;
        }

        public String toString() {
            return "#" + this.index + " [" + this.startFraction + " - " + this.endFraction + "]";
        }
    }
}

