/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Recipe;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.DragonAPIInit;
import Reika.DragonAPI.Exception.RegistrationException;
import Reika.DragonAPI.Instantiable.Data.KeyedItemStack;
import Reika.DragonAPI.Libraries.ReikaFluidHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.oredict.OreDictionary;

public class ItemMatch {
    private HashSet<KeyedItemStack> items = new HashSet();
    private ArrayList<ItemStack> displayList = new ArrayList();

    private ItemMatch() {
    }

    private ItemMatch(HashSet<KeyedItemStack> set, ArrayList<ItemStack> li) {
        this.items.addAll(set);
        this.displayList.addAll(li);
    }

    public ItemMatch(Block b) {
        this.addItem(new KeyedItemStack(b));
    }

    public ItemMatch(Item i) {
        this.addItem(new KeyedItemStack(i));
    }

    public ItemMatch(ItemStack is) {
        this.addItem(new KeyedItemStack(is));
    }

    public ItemMatch(String s) {
        String[] parts;
        for (String s2 : parts = s.split("/")) {
            this.addAll(OreDictionary.getOres((String)s2));
        }
        if (this.items.isEmpty()) {
            throw new RegistrationException(DragonAPIInit.instance, "This recipe uses an OreDict tag with no registered items!");
        }
    }

    public ItemMatch(Fluid f) {
        this(ReikaFluidHelper.getAllContainersFor(f));
    }

    public ItemMatch(Collection<ItemStack> c) {
        this.addAll(c);
        if (this.items.isEmpty()) {
            throw new RegistrationException(DragonAPIInit.instance, "This recipe uses an list with no items!");
        }
    }

    public static ItemMatch createFromObject(Object o) {
        if (o instanceof Block) {
            return new ItemMatch((Block)o);
        }
        if (o instanceof Item) {
            return new ItemMatch((Item)o);
        }
        if (o instanceof ItemStack) {
            return new ItemMatch((ItemStack)o);
        }
        if (o instanceof String) {
            return new ItemMatch((String)o);
        }
        if (o instanceof Fluid) {
            return new ItemMatch((Fluid)o);
        }
        throw new IllegalArgumentException("Invalid item matching type!");
    }

    private void addAll(Collection<ItemStack> li) {
        for (ItemStack is : li) {
            this.addItem(new KeyedItemStack(is));
        }
    }

    public ItemMatch copy() {
        ItemMatch m = new ItemMatch();
        m.items.addAll(this.items);
        m.displayList.addAll(this.displayList);
        return m;
    }

    public ItemMatch addItem(KeyedItemStack ks) {
        ks = ks.setSimpleHash(true).setIgnoreNBT(ks.getItemStack().field_77990_d == null).lock();
        this.items.add(ks);
        ItemStack is2 = ks.getItemStack();
        this.displayList.add(is2);
        return this;
    }

    public boolean match(ItemStack is) {
        return is != null && this.items.contains(new KeyedItemStack(is).setSimpleHash(true));
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack getCycledItem() {
        if (this.displayList.isEmpty()) {
            DragonAPICore.logError("Could not provide cycled item for " + this + "!");
            return new ItemStack((Block)Blocks.field_150480_ab);
        }
        ItemStack ret = this.displayList.get((int)((System.currentTimeMillis() / 2000L + (long)Math.abs(this.hashCode())) % (long)this.displayList.size()));
        if (ret.func_77960_j() == Short.MAX_VALUE) {
            ArrayList li = new ArrayList();
            ret.func_77973_b().func_150895_a(ret.func_77973_b(), ret.func_77973_b().func_77640_w(), li);
            int idx = (int)(System.currentTimeMillis() / 500L % (long)li.size());
            ret = (ItemStack)li.get(idx);
        }
        return ret;
    }

    public Set<KeyedItemStack> getItemList() {
        return Collections.unmodifiableSet(this.items);
    }

    public String toString() {
        return this.items.toString();
    }

    public int hashCode() {
        return this.items.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof ItemMatch) {
            ItemMatch m = (ItemMatch)o;
            return m.items.equals(this.items);
        }
        return false;
    }

    public void writeToNBT(NBTTagCompound NBT) {
        NBTTagCompound tag;
        NBTTagList li = new NBTTagList();
        for (KeyedItemStack ks : this.items) {
            tag = new NBTTagCompound();
            ks.writeToNBT(tag);
            li.func_74742_a((NBTBase)tag);
        }
        NBT.func_74782_a("items", (NBTBase)li);
        li = new NBTTagList();
        for (ItemStack is : this.displayList) {
            tag = new NBTTagCompound();
            is.func_77955_b(tag);
            li.func_74742_a((NBTBase)tag);
        }
        NBT.func_74782_a("display", (NBTBase)li);
    }

    public static ItemMatch readFromNBT(NBTTagCompound NBT) {
        NBTTagCompound tag;
        ArrayList<ItemStack> dis = new ArrayList<ItemStack>();
        HashSet<KeyedItemStack> set = new HashSet<KeyedItemStack>();
        NBTTagList li = NBT.func_150295_c("items", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
        for (Object o : li.field_74747_a) {
            tag = (NBTTagCompound)o;
            KeyedItemStack ks = KeyedItemStack.readFromNBT(tag);
            set.add(ks);
        }
        li = NBT.func_150295_c("display", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
        for (Object o : li.field_74747_a) {
            tag = (NBTTagCompound)o;
            ItemStack is = ItemStack.func_77949_a((NBTTagCompound)tag);
            dis.add(is);
        }
        return new ItemMatch(set, dis);
    }
}

