/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable;

import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;

public class Orbit {
    public final double semimajorAxis;
    public final double eccentricity;
    public final double inclination;
    public final double RAAN;
    public final double argumentOfPerigee;
    public final double zeroAng;

    public Orbit(double a, double e, double i, double raan, double w, double theta) {
        this.semimajorAxis = a;
        this.eccentricity = e;
        this.inclination = Math.toRadians(i);
        this.RAAN = Math.toRadians(raan);
        this.argumentOfPerigee = Math.toRadians(w);
        this.zeroAng = Math.toRadians(theta);
    }

    public DecimalPosition getPosition(double x0, double y0, double z0, double time, double mu) {
        double dtheta = 0.0;
        return this.getPosition(x0, y0, z0, time, mu);
    }

    public DecimalPosition getPosition(double x0, double y0, double z0, double dtheta) {
        double theta = this.zeroAng + dtheta;
        double dd = this.semimajorAxis * (1.0 - this.eccentricity * this.eccentricity) / (1.0 + this.eccentricity * Math.cos(Math.toRadians(theta)));
        double x = dd * (Math.cos(this.RAAN) * Math.cos(Math.toRadians(theta) + this.argumentOfPerigee) - Math.sin(this.RAAN) * Math.sin(Math.toRadians(theta) + this.argumentOfPerigee) * Math.cos(this.inclination));
        double y = dd * (Math.sin(this.RAAN) * Math.cos(Math.toRadians(theta) + this.argumentOfPerigee) + Math.cos(this.RAAN) * Math.sin(Math.toRadians(theta) + this.argumentOfPerigee)) * Math.cos(this.inclination);
        double z = dd * Math.sin(Math.toRadians(theta) + this.argumentOfPerigee) * Math.sin(this.inclination);
        return new DecimalPosition(x + x0, y + y0, z + z0);
    }
}

