/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Math;

import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Instantiable.Math.SimplexNoiseGenerator;
import net.minecraft.util.MathHelper;

public class Simplex3DGenerator
extends SimplexNoiseGenerator {
    private static final double STRETCH_CONSTANT_3D = (1.0 / Math.sqrt(4.0) - 1.0) / 3.0;
    private static final double SQUISH_CONSTANT_3D = (Math.sqrt(4.0) - 1.0) / 3.0;
    private static final double NORM_CONSTANT_3D = 103.0;
    private final short[] permGradIndex3D = new short[256];
    private static int[] gradients3D = new int[]{-11, 4, 4, -4, 11, 4, -4, 4, 11, 11, 4, 4, 4, 11, 4, 4, 4, 11, -11, -4, 4, -4, -11, 4, -4, -4, 11, 11, -4, 4, 4, -11, 4, 4, -4, 11, -11, 4, -4, -4, 11, -4, -4, 4, -11, 11, 4, -4, 4, 11, -4, 4, 4, -11, -11, -4, -4, -4, -11, -4, -4, -4, -11, 11, -4, -4, 4, -11, -4, 4, -4, -11};

    public Simplex3DGenerator(long seed) {
        super(seed);
        for (int i = 0; i < 256; ++i) {
            this.permGradIndex3D[i] = (short)(this.perm[i] % (gradients3D.length / 3) * 3);
        }
    }

    @Override
    public final double getValue(double x, double z) {
        throw new MisuseException("Use a 2D generator if you want 2D noise!");
    }

    public double getValue(double x, double y, double z) {
        double val = this.calcValue(x *= this.inputFactor, y *= this.inputFactor, z *= this.inputFactor, 1.0, 1.0);
        if (!this.octaves.isEmpty()) {
            for (SimplexNoiseGenerator.Octave o : this.octaves) {
                val += this.calcValue(x + o.phaseShift, y + o.phaseShift, z + o.phaseShift, o.frequency, o.amplitude);
            }
            val = this.clampEdge ? MathHelper.func_151237_a((double)val, (double)-1.0, (double)1.0) : (val /= this.maxRange);
        }
        return val;
    }

    private double calcValue(double x, double y, double z, double f, double a) {
        double attn_ext1;
        double dz_ext1;
        double dz_ext0;
        int zsv_ext1;
        int zsv_ext0;
        double dy_ext0;
        double dy_ext1;
        int ysv_ext0;
        int ysv_ext1;
        double dx_ext1;
        double dx_ext0;
        int xsv_ext1;
        int xsv_ext0;
        if (f != 1.0 && f > 0.0) {
            x *= f;
            y *= f;
            z *= f;
        }
        double stretchOffset = (x + y + z) * STRETCH_CONSTANT_3D;
        double xs = x + stretchOffset;
        double ys = y + stretchOffset;
        double zs = z + stretchOffset;
        int xsb = MathHelper.func_76128_c((double)xs);
        int ysb = MathHelper.func_76128_c((double)ys);
        int zsb = MathHelper.func_76128_c((double)zs);
        double squishOffset = (double)(xsb + ysb + zsb) * SQUISH_CONSTANT_3D;
        double xb = (double)xsb + squishOffset;
        double yb = (double)ysb + squishOffset;
        double zb = (double)zsb + squishOffset;
        double xins = xs - (double)xsb;
        double yins = ys - (double)ysb;
        double zins = zs - (double)zsb;
        double inSum = xins + yins + zins;
        double dx0 = x - xb;
        double dy0 = y - yb;
        double dz0 = z - zb;
        double value = 0.0;
        if (inSum <= 1.0) {
            double dz3;
            double dy3;
            double dx3;
            double attn3;
            double dz2;
            double dy2;
            double dx2;
            double attn2;
            double dz1;
            double dy1;
            double dx1;
            double attn1;
            int c;
            int aPoint = 1;
            double aScore = xins;
            int bPoint = 2;
            double bScore = yins;
            if (aScore >= bScore && zins > bScore) {
                bScore = zins;
                bPoint = 4;
            } else if (aScore < bScore && zins > aScore) {
                aScore = zins;
                aPoint = 4;
            }
            double wins = 1.0 - inSum;
            if (wins > aScore || wins > bScore) {
                int n = c = bScore > aScore ? bPoint : aPoint;
                if ((c & 1) == 0) {
                    xsv_ext0 = xsb - 1;
                    xsv_ext1 = xsb;
                    dx_ext0 = dx0 + 1.0;
                    dx_ext1 = dx0;
                } else {
                    xsv_ext0 = xsv_ext1 = xsb + 1;
                    dx_ext0 = dx_ext1 = dx0 - 1.0;
                }
                if ((c & 2) == 0) {
                    ysv_ext1 = ysb;
                    ysv_ext0 = ysv_ext1--;
                    dy_ext0 = dy_ext1 = dy0;
                    if ((c & 1) == 0) {
                        dy_ext1 += 1.0;
                    } else {
                        --ysv_ext0;
                        dy_ext0 += 1.0;
                    }
                } else {
                    ysv_ext0 = ysv_ext1 = ysb + 1;
                    dy_ext0 = dy_ext1 = dy0 - 1.0;
                }
                if ((c & 4) == 0) {
                    zsv_ext0 = zsb;
                    zsv_ext1 = zsb - 1;
                    dz_ext0 = dz0;
                    dz_ext1 = dz0 + 1.0;
                } else {
                    zsv_ext0 = zsv_ext1 = zsb + 1;
                    dz_ext0 = dz_ext1 = dz0 - 1.0;
                }
            } else {
                c = (byte)(aPoint | bPoint);
                if ((c & 1) == 0) {
                    xsv_ext0 = xsb;
                    xsv_ext1 = xsb - 1;
                    dx_ext0 = dx0 - 2.0 * SQUISH_CONSTANT_3D;
                    dx_ext1 = dx0 + 1.0 - SQUISH_CONSTANT_3D;
                } else {
                    xsv_ext0 = xsv_ext1 = xsb + 1;
                    dx_ext0 = dx0 - 1.0 - 2.0 * SQUISH_CONSTANT_3D;
                    dx_ext1 = dx0 - 1.0 - SQUISH_CONSTANT_3D;
                }
                if ((c & 2) == 0) {
                    ysv_ext0 = ysb;
                    ysv_ext1 = ysb - 1;
                    dy_ext0 = dy0 - 2.0 * SQUISH_CONSTANT_3D;
                    dy_ext1 = dy0 + 1.0 - SQUISH_CONSTANT_3D;
                } else {
                    ysv_ext0 = ysv_ext1 = ysb + 1;
                    dy_ext0 = dy0 - 1.0 - 2.0 * SQUISH_CONSTANT_3D;
                    dy_ext1 = dy0 - 1.0 - SQUISH_CONSTANT_3D;
                }
                if ((c & 4) == 0) {
                    zsv_ext0 = zsb;
                    zsv_ext1 = zsb - 1;
                    dz_ext0 = dz0 - 2.0 * SQUISH_CONSTANT_3D;
                    dz_ext1 = dz0 + 1.0 - SQUISH_CONSTANT_3D;
                } else {
                    zsv_ext0 = zsv_ext1 = zsb + 1;
                    dz_ext0 = dz0 - 1.0 - 2.0 * SQUISH_CONSTANT_3D;
                    dz_ext1 = dz0 - 1.0 - SQUISH_CONSTANT_3D;
                }
            }
            double attn0 = 2.0 - dx0 * dx0 - dy0 * dy0 - dz0 * dz0;
            if (attn0 > 0.0) {
                attn0 *= attn0;
                value += attn0 * attn0 * this.extrapolate(xsb + 0, ysb + 0, zsb + 0, dx0, dy0, dz0);
            }
            if ((attn1 = 2.0 - (dx1 = dx0 - 1.0 - SQUISH_CONSTANT_3D) * dx1 - (dy1 = dy0 - 0.0 - SQUISH_CONSTANT_3D) * dy1 - (dz1 = dz0 - 0.0 - SQUISH_CONSTANT_3D) * dz1) > 0.0) {
                attn1 *= attn1;
                value += attn1 * attn1 * this.extrapolate(xsb + 1, ysb + 0, zsb + 0, dx1, dy1, dz1);
            }
            if ((attn2 = 2.0 - (dx2 = dx0 - 0.0 - SQUISH_CONSTANT_3D) * dx2 - (dy2 = dy0 - 1.0 - SQUISH_CONSTANT_3D) * dy2 - (dz2 = dz1) * dz2) > 0.0) {
                attn2 *= attn2;
                value += attn2 * attn2 * this.extrapolate(xsb + 0, ysb + 1, zsb + 0, dx2, dy2, dz2);
            }
            if ((attn3 = 2.0 - (dx3 = dx2) * dx3 - (dy3 = dy1) * dy3 - (dz3 = dz0 - 1.0 - SQUISH_CONSTANT_3D) * dz3) > 0.0) {
                attn3 *= attn3;
                value += attn3 * attn3 * this.extrapolate(xsb + 0, ysb + 0, zsb + 1, dx3, dy3, dz3);
            }
        } else if (inSum >= 2.0) {
            double attn0;
            double dz1;
            double dy1;
            double dx1;
            double attn1;
            double dz2;
            double dy2;
            double dx2;
            double attn2;
            int c;
            int aPoint = 6;
            double aScore = xins;
            int bPoint = 5;
            double bScore = yins;
            if (aScore <= bScore && zins < bScore) {
                bScore = zins;
                bPoint = 3;
            } else if (aScore > bScore && zins < aScore) {
                aScore = zins;
                aPoint = 3;
            }
            double wins = 3.0 - inSum;
            if (wins < aScore || wins < bScore) {
                int n = c = bScore < aScore ? bPoint : aPoint;
                if ((c & 1) != 0) {
                    xsv_ext0 = xsb + 2;
                    xsv_ext1 = xsb + 1;
                    dx_ext0 = dx0 - 2.0 - 3.0 * SQUISH_CONSTANT_3D;
                    dx_ext1 = dx0 - 1.0 - 3.0 * SQUISH_CONSTANT_3D;
                } else {
                    xsv_ext0 = xsv_ext1 = xsb;
                    dx_ext0 = dx_ext1 = dx0 - 3.0 * SQUISH_CONSTANT_3D;
                }
                if ((c & 2) != 0) {
                    ysv_ext1 = ysb + 1;
                    ysv_ext0 = ysv_ext1++;
                    dy_ext0 = dy_ext1 = dy0 - 1.0 - 3.0 * SQUISH_CONSTANT_3D;
                    if ((c & 1) != 0) {
                        dy_ext1 -= 1.0;
                    } else {
                        ++ysv_ext0;
                        dy_ext0 -= 1.0;
                    }
                } else {
                    ysv_ext0 = ysv_ext1 = ysb;
                    dy_ext0 = dy_ext1 = dy0 - 3.0 * SQUISH_CONSTANT_3D;
                }
                if ((c & 4) != 0) {
                    zsv_ext0 = zsb + 1;
                    zsv_ext1 = zsb + 2;
                    dz_ext0 = dz0 - 1.0 - 3.0 * SQUISH_CONSTANT_3D;
                    dz_ext1 = dz0 - 2.0 - 3.0 * SQUISH_CONSTANT_3D;
                } else {
                    zsv_ext0 = zsv_ext1 = zsb;
                    dz_ext0 = dz_ext1 = dz0 - 3.0 * SQUISH_CONSTANT_3D;
                }
            } else {
                c = (byte)(aPoint & bPoint);
                if ((c & 1) != 0) {
                    xsv_ext0 = xsb + 1;
                    xsv_ext1 = xsb + 2;
                    dx_ext0 = dx0 - 1.0 - SQUISH_CONSTANT_3D;
                    dx_ext1 = dx0 - 2.0 - 2.0 * SQUISH_CONSTANT_3D;
                } else {
                    xsv_ext0 = xsv_ext1 = xsb;
                    dx_ext0 = dx0 - SQUISH_CONSTANT_3D;
                    dx_ext1 = dx0 - 2.0 * SQUISH_CONSTANT_3D;
                }
                if ((c & 2) != 0) {
                    ysv_ext0 = ysb + 1;
                    ysv_ext1 = ysb + 2;
                    dy_ext0 = dy0 - 1.0 - SQUISH_CONSTANT_3D;
                    dy_ext1 = dy0 - 2.0 - 2.0 * SQUISH_CONSTANT_3D;
                } else {
                    ysv_ext0 = ysv_ext1 = ysb;
                    dy_ext0 = dy0 - SQUISH_CONSTANT_3D;
                    dy_ext1 = dy0 - 2.0 * SQUISH_CONSTANT_3D;
                }
                if ((c & 4) != 0) {
                    zsv_ext0 = zsb + 1;
                    zsv_ext1 = zsb + 2;
                    dz_ext0 = dz0 - 1.0 - SQUISH_CONSTANT_3D;
                    dz_ext1 = dz0 - 2.0 - 2.0 * SQUISH_CONSTANT_3D;
                } else {
                    zsv_ext0 = zsv_ext1 = zsb;
                    dz_ext0 = dz0 - SQUISH_CONSTANT_3D;
                    dz_ext1 = dz0 - 2.0 * SQUISH_CONSTANT_3D;
                }
            }
            double dx3 = dx0 - 1.0 - 2.0 * SQUISH_CONSTANT_3D;
            double dy3 = dy0 - 1.0 - 2.0 * SQUISH_CONSTANT_3D;
            double dz3 = dz0 - 0.0 - 2.0 * SQUISH_CONSTANT_3D;
            double attn3 = 2.0 - dx3 * dx3 - dy3 * dy3 - dz3 * dz3;
            if (attn3 > 0.0) {
                attn3 *= attn3;
                value += attn3 * attn3 * this.extrapolate(xsb + 1, ysb + 1, zsb + 0, dx3, dy3, dz3);
            }
            if ((attn2 = 2.0 - (dx2 = dx3) * dx2 - (dy2 = dy0 - 0.0 - 2.0 * SQUISH_CONSTANT_3D) * dy2 - (dz2 = dz0 - 1.0 - 2.0 * SQUISH_CONSTANT_3D) * dz2) > 0.0) {
                attn2 *= attn2;
                value += attn2 * attn2 * this.extrapolate(xsb + 1, ysb + 0, zsb + 1, dx2, dy2, dz2);
            }
            if ((attn1 = 2.0 - (dx1 = dx0 - 0.0 - 2.0 * SQUISH_CONSTANT_3D) * dx1 - (dy1 = dy3) * dy1 - (dz1 = dz2) * dz1) > 0.0) {
                attn1 *= attn1;
                value += attn1 * attn1 * this.extrapolate(xsb + 0, ysb + 1, zsb + 1, dx1, dy1, dz1);
            }
            if ((attn0 = 2.0 - (dx0 = dx0 - 1.0 - 3.0 * SQUISH_CONSTANT_3D) * dx0 - (dy0 = dy0 - 1.0 - 3.0 * SQUISH_CONSTANT_3D) * dy0 - (dz0 = dz0 - 1.0 - 3.0 * SQUISH_CONSTANT_3D) * dz0) > 0.0) {
                attn0 *= attn0;
                value += attn0 * attn0 * this.extrapolate(xsb + 1, ysb + 1, zsb + 1, dx0, dy0, dz0);
            }
        } else {
            double dz6;
            double dy6;
            double dx6;
            double attn6;
            double dz5;
            double dy5;
            double dx5;
            double attn5;
            double dz4;
            double dy4;
            double dx4;
            double attn4;
            double dz3;
            double dy3;
            double dx3;
            double attn3;
            double dz2;
            double dy2;
            double dx2;
            double attn2;
            double score;
            boolean bIsFurtherSide;
            int bPoint;
            double bScore;
            boolean aIsFurtherSide;
            int aPoint;
            double aScore;
            double p1 = xins + yins;
            if (p1 > 1.0) {
                aScore = p1 - 1.0;
                aPoint = 3;
                aIsFurtherSide = true;
            } else {
                aScore = 1.0 - p1;
                aPoint = 4;
                aIsFurtherSide = false;
            }
            double p2 = xins + zins;
            if (p2 > 1.0) {
                bScore = p2 - 1.0;
                bPoint = 5;
                bIsFurtherSide = true;
            } else {
                bScore = 1.0 - p2;
                bPoint = 2;
                bIsFurtherSide = false;
            }
            double p3 = yins + zins;
            if (p3 > 1.0) {
                score = p3 - 1.0;
                if (aScore <= bScore && aScore < score) {
                    aScore = score;
                    aPoint = 6;
                    aIsFurtherSide = true;
                } else if (aScore > bScore && bScore < score) {
                    bScore = score;
                    bPoint = 6;
                    bIsFurtherSide = true;
                }
            } else {
                score = 1.0 - p3;
                if (aScore <= bScore && aScore < score) {
                    aScore = score;
                    aPoint = 1;
                    aIsFurtherSide = false;
                } else if (aScore > bScore && bScore < score) {
                    bScore = score;
                    bPoint = 1;
                    bIsFurtherSide = false;
                }
            }
            if (aIsFurtherSide == bIsFurtherSide) {
                byte c;
                if (aIsFurtherSide) {
                    dx_ext0 = dx0 - 1.0 - 3.0 * SQUISH_CONSTANT_3D;
                    dy_ext0 = dy0 - 1.0 - 3.0 * SQUISH_CONSTANT_3D;
                    dz_ext0 = dz0 - 1.0 - 3.0 * SQUISH_CONSTANT_3D;
                    xsv_ext0 = xsb + 1;
                    ysv_ext0 = ysb + 1;
                    zsv_ext0 = zsb + 1;
                    c = (byte)(aPoint & bPoint);
                    if ((c & 1) != 0) {
                        dx_ext1 = dx0 - 2.0 - 2.0 * SQUISH_CONSTANT_3D;
                        dy_ext1 = dy0 - 2.0 * SQUISH_CONSTANT_3D;
                        dz_ext1 = dz0 - 2.0 * SQUISH_CONSTANT_3D;
                        xsv_ext1 = xsb + 2;
                        ysv_ext1 = ysb;
                        zsv_ext1 = zsb;
                    } else if ((c & 2) != 0) {
                        dx_ext1 = dx0 - 2.0 * SQUISH_CONSTANT_3D;
                        dy_ext1 = dy0 - 2.0 - 2.0 * SQUISH_CONSTANT_3D;
                        dz_ext1 = dz0 - 2.0 * SQUISH_CONSTANT_3D;
                        xsv_ext1 = xsb;
                        ysv_ext1 = ysb + 2;
                        zsv_ext1 = zsb;
                    } else {
                        dx_ext1 = dx0 - 2.0 * SQUISH_CONSTANT_3D;
                        dy_ext1 = dy0 - 2.0 * SQUISH_CONSTANT_3D;
                        dz_ext1 = dz0 - 2.0 - 2.0 * SQUISH_CONSTANT_3D;
                        xsv_ext1 = xsb;
                        ysv_ext1 = ysb;
                        zsv_ext1 = zsb + 2;
                    }
                } else {
                    dx_ext0 = dx0;
                    dy_ext0 = dy0;
                    dz_ext0 = dz0;
                    xsv_ext0 = xsb;
                    ysv_ext0 = ysb;
                    zsv_ext0 = zsb;
                    c = (byte)(aPoint | bPoint);
                    if ((c & 1) == 0) {
                        dx_ext1 = dx0 + 1.0 - SQUISH_CONSTANT_3D;
                        dy_ext1 = dy0 - 1.0 - SQUISH_CONSTANT_3D;
                        dz_ext1 = dz0 - 1.0 - SQUISH_CONSTANT_3D;
                        xsv_ext1 = xsb - 1;
                        ysv_ext1 = ysb + 1;
                        zsv_ext1 = zsb + 1;
                    } else if ((c & 2) == 0) {
                        dx_ext1 = dx0 - 1.0 - SQUISH_CONSTANT_3D;
                        dy_ext1 = dy0 + 1.0 - SQUISH_CONSTANT_3D;
                        dz_ext1 = dz0 - 1.0 - SQUISH_CONSTANT_3D;
                        xsv_ext1 = xsb + 1;
                        ysv_ext1 = ysb - 1;
                        zsv_ext1 = zsb + 1;
                    } else {
                        dx_ext1 = dx0 - 1.0 - SQUISH_CONSTANT_3D;
                        dy_ext1 = dy0 - 1.0 - SQUISH_CONSTANT_3D;
                        dz_ext1 = dz0 + 1.0 - SQUISH_CONSTANT_3D;
                        xsv_ext1 = xsb + 1;
                        ysv_ext1 = ysb + 1;
                        zsv_ext1 = zsb - 1;
                    }
                }
            } else {
                int c2;
                int c1;
                if (aIsFurtherSide) {
                    c1 = aPoint;
                    c2 = bPoint;
                } else {
                    c1 = bPoint;
                    c2 = aPoint;
                }
                if ((c1 & 1) == 0) {
                    dx_ext0 = dx0 + 1.0 - SQUISH_CONSTANT_3D;
                    dy_ext0 = dy0 - 1.0 - SQUISH_CONSTANT_3D;
                    dz_ext0 = dz0 - 1.0 - SQUISH_CONSTANT_3D;
                    xsv_ext0 = xsb - 1;
                    ysv_ext0 = ysb + 1;
                    zsv_ext0 = zsb + 1;
                } else if ((c1 & 2) == 0) {
                    dx_ext0 = dx0 - 1.0 - SQUISH_CONSTANT_3D;
                    dy_ext0 = dy0 + 1.0 - SQUISH_CONSTANT_3D;
                    dz_ext0 = dz0 - 1.0 - SQUISH_CONSTANT_3D;
                    xsv_ext0 = xsb + 1;
                    ysv_ext0 = ysb - 1;
                    zsv_ext0 = zsb + 1;
                } else {
                    dx_ext0 = dx0 - 1.0 - SQUISH_CONSTANT_3D;
                    dy_ext0 = dy0 - 1.0 - SQUISH_CONSTANT_3D;
                    dz_ext0 = dz0 + 1.0 - SQUISH_CONSTANT_3D;
                    xsv_ext0 = xsb + 1;
                    ysv_ext0 = ysb + 1;
                    zsv_ext0 = zsb - 1;
                }
                dx_ext1 = dx0 - 2.0 * SQUISH_CONSTANT_3D;
                dy_ext1 = dy0 - 2.0 * SQUISH_CONSTANT_3D;
                dz_ext1 = dz0 - 2.0 * SQUISH_CONSTANT_3D;
                xsv_ext1 = xsb;
                ysv_ext1 = ysb;
                zsv_ext1 = zsb;
                if ((c2 & 1) != 0) {
                    dx_ext1 -= 2.0;
                    xsv_ext1 += 2;
                } else if ((c2 & 2) != 0) {
                    dy_ext1 -= 2.0;
                    ysv_ext1 += 2;
                } else {
                    dz_ext1 -= 2.0;
                    zsv_ext1 += 2;
                }
            }
            double dx1 = dx0 - 1.0 - SQUISH_CONSTANT_3D;
            double dy1 = dy0 - 0.0 - SQUISH_CONSTANT_3D;
            double dz1 = dz0 - 0.0 - SQUISH_CONSTANT_3D;
            double attn1 = 2.0 - dx1 * dx1 - dy1 * dy1 - dz1 * dz1;
            if (attn1 > 0.0) {
                attn1 *= attn1;
                value += attn1 * attn1 * this.extrapolate(xsb + 1, ysb + 0, zsb + 0, dx1, dy1, dz1);
            }
            if ((attn2 = 2.0 - (dx2 = dx0 - 0.0 - SQUISH_CONSTANT_3D) * dx2 - (dy2 = dy0 - 1.0 - SQUISH_CONSTANT_3D) * dy2 - (dz2 = dz1) * dz2) > 0.0) {
                attn2 *= attn2;
                value += attn2 * attn2 * this.extrapolate(xsb + 0, ysb + 1, zsb + 0, dx2, dy2, dz2);
            }
            if ((attn3 = 2.0 - (dx3 = dx2) * dx3 - (dy3 = dy1) * dy3 - (dz3 = dz0 - 1.0 - SQUISH_CONSTANT_3D) * dz3) > 0.0) {
                attn3 *= attn3;
                value += attn3 * attn3 * this.extrapolate(xsb + 0, ysb + 0, zsb + 1, dx3, dy3, dz3);
            }
            if ((attn4 = 2.0 - (dx4 = dx0 - 1.0 - 2.0 * SQUISH_CONSTANT_3D) * dx4 - (dy4 = dy0 - 1.0 - 2.0 * SQUISH_CONSTANT_3D) * dy4 - (dz4 = dz0 - 0.0 - 2.0 * SQUISH_CONSTANT_3D) * dz4) > 0.0) {
                attn4 *= attn4;
                value += attn4 * attn4 * this.extrapolate(xsb + 1, ysb + 1, zsb + 0, dx4, dy4, dz4);
            }
            if ((attn5 = 2.0 - (dx5 = dx4) * dx5 - (dy5 = dy0 - 0.0 - 2.0 * SQUISH_CONSTANT_3D) * dy5 - (dz5 = dz0 - 1.0 - 2.0 * SQUISH_CONSTANT_3D) * dz5) > 0.0) {
                attn5 *= attn5;
                value += attn5 * attn5 * this.extrapolate(xsb + 1, ysb + 0, zsb + 1, dx5, dy5, dz5);
            }
            if ((attn6 = 2.0 - (dx6 = dx0 - 0.0 - 2.0 * SQUISH_CONSTANT_3D) * dx6 - (dy6 = dy4) * dy6 - (dz6 = dz5) * dz6) > 0.0) {
                attn6 *= attn6;
                value += attn6 * attn6 * this.extrapolate(xsb + 0, ysb + 1, zsb + 1, dx6, dy6, dz6);
            }
        }
        double attn_ext0 = 2.0 - dx_ext0 * dx_ext0 - dy_ext0 * dy_ext0 - dz_ext0 * dz_ext0;
        if (attn_ext0 > 0.0) {
            attn_ext0 *= attn_ext0;
            value += attn_ext0 * attn_ext0 * this.extrapolate(xsv_ext0, ysv_ext0, zsv_ext0, dx_ext0, dy_ext0, dz_ext0);
        }
        if ((attn_ext1 = 2.0 - dx_ext1 * dx_ext1 - dy_ext1 * dy_ext1 - dz_ext1 * dz_ext1) > 0.0) {
            attn_ext1 *= attn_ext1;
            value += attn_ext1 * attn_ext1 * this.extrapolate(xsv_ext1, ysv_ext1, zsv_ext1, dx_ext1, dy_ext1, dz_ext1);
        }
        return value / 103.0;
    }

    private double extrapolate(int xsb, int ysb, int zsb, double dx, double dy, double dz) {
        short index = this.permGradIndex3D[this.perm[this.perm[xsb & 0xFF] + ysb & 0xFF] + zsb & 0xFF];
        return (double)gradients3D[index] * dx + (double)gradients3D[index + 1] * dy + (double)gradients3D[index + 2] * dz;
    }
}

