/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.IO;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public abstract class MapOutput<V> {
    public final String worldName;
    private final int dimensionID;
    private final int originX;
    private final int originZ;
    private final int range;
    private final int resolution;
    private final int gridSize;
    private final boolean fullGrid;
    public final long startTime = System.currentTimeMillis();
    private final int[][] data;

    protected MapOutput(String name, int dim, int x, int z, int r, int res, int grid, boolean fgrid) {
        this.worldName = name;
        this.dimensionID = dim;
        this.originX = x;
        this.originZ = z;
        this.range = r;
        this.resolution = res;
        this.gridSize = grid;
        this.fullGrid = fgrid;
        this.data = new int[this.range * 2 / this.resolution + 1][this.range * 2 / this.resolution + 1];
    }

    public void addGrid() {
        if (this.gridSize > 0) {
            for (int dx = this.originX - this.range; dx <= this.originX + this.range; dx += this.resolution) {
                for (int dz = this.originZ - this.range; dz <= this.originZ + this.range; dz += this.resolution) {
                    boolean flag2;
                    int i = (this.range + (dx - this.originX)) / this.resolution;
                    int k = (this.range + (dz - this.originZ)) / this.resolution;
                    int i2 = dx - this.originX;
                    int k2 = dz - this.originZ;
                    boolean flag1 = i2 % this.gridSize == 0;
                    boolean bl = flag2 = k2 % this.gridSize == 0;
                    if (!flag1 && !flag2 || (!flag1 || !flag2) && !this.fullGrid) continue;
                    this.data[i][k] = ReikaColorAPI.mixColors(this.data[i][k], i2 == 0 && k2 == 0 ? -65536 : -1, 0.25f);
                    if (i - 1 >= 0) {
                        this.data[i - 1][k] = ReikaColorAPI.mixColors(this.data[i - 1][k], -16777216, 0.5f);
                    }
                    if (i + 1 < this.data.length) {
                        this.data[i + 1][k] = ReikaColorAPI.mixColors(this.data[i + 1][k], -16777216, 0.5f);
                    }
                    if (k - 1 >= 0) {
                        this.data[i][k - 1] = ReikaColorAPI.mixColors(this.data[i][k - 1], -16777216, 0.5f);
                    }
                    if (k + 1 >= this.data[i].length) continue;
                    this.data[i][k + 1] = ReikaColorAPI.mixColors(this.data[i][k + 1], -16777216, 0.5f);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public final void addPoint(int x, int z, V data) {
        int c = 0xFF000000 | this.getColor(x, z, data);
        int i = (this.range + (x - this.originX)) / this.resolution;
        int k = (this.range + (z - this.originZ)) / this.resolution;
        this.data[i][k] = c;
    }

    protected abstract int getColor(int var1, int var2, V var3);

    @SideOnly(value=Side.CLIENT)
    public String createImage() throws IOException {
        String name = this.getFilename();
        File f = new File(DragonAPICore.getMinecraftDirectory(), name);
        if (f.exists()) {
            f.delete();
        }
        f.getParentFile().mkdirs();
        f.createNewFile();
        BufferedImage img = new BufferedImage(this.data.length, this.data.length, 2);
        for (int i = 0; i < this.data.length; ++i) {
            for (int k = 0; k < this.data[i].length; ++k) {
                img.setRGB(i, k, this.data[i][k]);
            }
        }
        ImageIO.write((RenderedImage)img, "png", f);
        this.onImageCreate(f);
        return f.getAbsolutePath();
    }

    protected void onImageCreate(File f) throws IOException {
    }

    private String getFilename() {
        String sr = String.valueOf(this.range * 2 + 1);
        String ret = this.getClass().getSimpleName() + "/" + this.worldName + "/DIM" + this.dimensionID + "/" + this.originX + ", " + this.originZ + " (" + sr + "x" + sr + "; [R=" + this.resolution + " b-px, G=" + this.gridSize + "-" + this.fullGrid + "]).png";
        if (this.worldName.contains("SEED=")) {
            ret = this.getClass().getSimpleName() + "/Forced/" + this.worldName + "; " + this.originX + ", " + this.originZ + " (" + sr + "x" + sr + "; [R=" + this.resolution + " b-px, G=" + this.gridSize + "-" + this.fullGrid + "]).png";
        }
        return ret;
    }
}

