/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Formula;

import Reika.DragonAPI.Instantiable.Formula.MathExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class PeriodicExpression
extends MathExpression {
    private final Collection<Wave> waves = new ArrayList<Wave>();

    public PeriodicExpression addWave(double amplitude, double freq, double phase) {
        this.waves.add(new Wave(amplitude, freq, phase));
        return this;
    }

    public PeriodicExpression normalize() {
        double f = 1.0 / this.getTotalAmplitude();
        Iterator<Wave> iterator = this.waves.iterator();
        while (iterator.hasNext()) {
            Wave w;
            Wave wave = w = iterator.next();
            wave.amplitude = wave.amplitude * f;
        }
        return this;
    }

    public double getTotalAmplitude() {
        double tot = 0.0;
        for (Wave w : this.waves) {
            tot += w.amplitude;
        }
        return tot;
    }

    @Override
    public double evaluate(double arg) throws ArithmeticException {
        double val = 0.0;
        for (Wave w : this.waves) {
            val += w.evaluate(arg);
        }
        return val;
    }

    @Override
    public double getBaseValue() {
        return 0.0;
    }

    @Override
    public String toString() {
        return "E sin (N x)";
    }

    private static class Wave {
        private double amplitude;
        private double frequency;
        private double phase;

        public Wave(double a, double f, double p) {
            this.amplitude = a;
            this.frequency = f;
            this.phase = p;
        }

        public double evaluate(double arg) {
            return this.amplitude * Math.sin(this.frequency * arg + this.phase);
        }
    }
}

