/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Event;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Worldgen.LootController;
import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.inventory.IInventory;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.structure.ComponentScatteredFeaturePieces;
import net.minecraft.world.gen.structure.StructureMineshaftPieces;
import net.minecraft.world.gen.structure.StructureNetherBridgePieces;
import net.minecraft.world.gen.structure.StructureStrongholdPieces;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraftforge.common.MinecraftForge;

public class ChestLootEvent
extends Event {
    public final IInventory inventory;
    public final String chestID;

    public ChestLootEvent(IInventory ii, String loc) {
        this.chestID = loc;
        this.inventory = ii;
    }

    public static void fire(Object struct, IInventory ii) {
        String table = ChestLootEvent.calculateTable(struct);
        if (table != null) {
            MinecraftForge.EVENT_BUS.post((Event)new ChestLootEvent(ii, table));
        } else {
            DragonAPICore.logError("Tried to fire an event for chest loot from an unrecognized structure " + struct + "!");
        }
    }

    private static String calculateTable(Object struct) {
        if (struct instanceof WorldGenDungeons) {
            return LootController.Location.DUNGEON.tag;
        }
        if (struct instanceof StructureNetherBridgePieces.Piece) {
            return "netherFortress";
        }
        if (struct instanceof StructureMineshaftPieces.Corridor) {
            return LootController.Location.MINESHAFT.tag;
        }
        if (struct instanceof StructureStrongholdPieces.Crossing || struct instanceof StructureStrongholdPieces.RoomCrossing) {
            return LootController.Location.STRONGHOLD_CROSSING.tag;
        }
        if (struct instanceof StructureStrongholdPieces.Library) {
            return LootController.Location.STRONGHOLD_LIBRARY.tag;
        }
        if (struct instanceof StructureStrongholdPieces.ChestCorridor) {
            return LootController.Location.STRONGHOLD_HALLWAY.tag;
        }
        if (struct instanceof ComponentScatteredFeaturePieces.JunglePyramid) {
            return LootController.Location.JUNGLE_PUZZLE.tag;
        }
        if (struct instanceof ComponentScatteredFeaturePieces.DesertPyramid) {
            return LootController.Location.PYRAMID.tag;
        }
        if (struct instanceof StructureVillagePieces.House2) {
            return LootController.Location.VILLAGE.tag;
        }
        if (struct.getClass().getSimpleName().contains("WizardTower")) {
            return "ThaumVillageTower";
        }
        return null;
    }
}

