/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data;

import Reika.DragonAPI.Instantiable.ReadOnlyIterator;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class PointPath
implements Iterable<PointNode>,
Collection<PointNode> {
    private final ArrayList<PointNode> data = new ArrayList();
    private final HashSet<Point> set = new HashSet();

    @Override
    public boolean add(Point p) {
        PointNode pn = this.getLast();
        if (!this.isEmpty() && !this.validStep(pn.position, p)) {
            throw new IllegalArgumentException("You cannot step between nonadjacent points " + pn + " and " + p + "!");
        }
        this.addPoint(pn, p);
        return true;
    }

    private void addPoint(PointNode from, Point p) {
        PointNode pn = new PointNode(p);
        this.data.add(pn);
        this.set.add(p);
        from.next = pn;
        pn.previous = from;
    }

    @Override
    public int size() {
        return this.data.size();
    }

    public PointNode get(int idx) {
        return this.data.get(idx);
    }

    public boolean removeLast() {
        if (this.isEmpty()) {
            return false;
        }
        PointNode rem = this.data.remove(this.data.size() - 1);
        this.set.remove(rem.position);
        return true;
    }

    @Override
    public boolean contains(Object p) {
        return this.set.contains(p);
    }

    @Override
    public void clear() {
        this.data.clear();
        this.set.clear();
    }

    public String toString() {
        return this.data.toString();
    }

    private boolean validStep(Point p1, Point p2) {
        return ReikaDirectionHelper.getDirectionBetween(p1, p2) != null;
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    private PointNode getLast() {
        return this.data.get(this.data.size() - 1);
    }

    @Override
    public Iterator<PointNode> iterator() {
        return new ReadOnlyIterator<PointNode>(this.data);
    }

    @Override
    public Object[] toArray() {
        return this.data.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.data.toArray(new PointNode[this.data.size()]);
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends PointNode> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(PointNode e) {
        throw new UnsupportedOperationException();
    }

    public static class PointNode {
        private final Point position;
        private PointNode previous;
        private PointNode next;

        private PointNode(Point p) {
            this.position = p;
        }

        public PointNode getPrevious() {
            return this.previous;
        }

        public PointNode getNext() {
            return this.next;
        }

        public Point point() {
            return new Point(this.position.x, this.position.y);
        }

        public int hashCode() {
            return this.position.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof PointNode && ((PointNode)o).position.equals(this.position);
        }
    }
}

