/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Maps;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class AngleMap<V> {
    private final TreeMap<Double, V> data = new TreeMap();

    public void put(double angle, V obj) {
        angle = (angle + 360.0) % 360.0;
        this.data.put(angle, obj);
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public int size() {
        return this.data.size();
    }

    public Map.Entry<Double, V> firstEntry() {
        return this.data.firstEntry();
    }

    public Map.Entry<Double, V> floorEntry(double angle) {
        Map.Entry<Double, V> e = this.data.floorEntry(angle = (angle + 360.0) % 360.0);
        if (e == null) {
            e = this.data.floorEntry(angle + 360.0);
        }
        return e;
    }

    public Map.Entry<Double, V> ceilingEntry(double angle) {
        Map.Entry<Double, V> e = this.data.ceilingEntry(angle = (angle + 360.0) % 360.0);
        if (e == null) {
            e = this.data.ceilingEntry(angle - 360.0);
        }
        return e;
    }

    public V get(double angle) {
        angle = (angle + 360.0) % 360.0;
        return this.data.get(angle);
    }

    public String toString() {
        return this.data.toString();
    }

    public Set<Double> keySet() {
        return this.data.keySet();
    }

    public Collection<V> values() {
        return this.data.values();
    }
}

