/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Immutable;

import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;

public final class RGB {
    public final int red;
    public final int green;
    public final int blue;
    public final int alpha;

    public RGB(int r, int g, int b) {
        this(r, g, b, 255);
    }

    public RGB(int r, int g, int b, int a) {
        this.red = Math.min(255, r);
        this.green = Math.min(255, g);
        this.blue = Math.min(255, b);
        this.alpha = Math.min(255, a);
    }

    public RGB(int color) {
        this(ReikaColorAPI.getRed(color), ReikaColorAPI.getGreen(color), ReikaColorAPI.getBlue(color), ReikaColorAPI.getAlpha(color));
    }

    public int getInt() {
        return ReikaColorAPI.RGBtoHex(this.red, this.green, this.blue, this.alpha);
    }

    public double getDistance(RGB rgb) {
        return ReikaMathLibrary.py3d(this.red - rgb.red, this.green - rgb.green, this.blue - rgb.blue);
    }

    public RGB permute(int dr, int dg, int db, int da) {
        return new RGB(this.red + dr, this.green + dg, this.blue + db, this.alpha + da);
    }

    public boolean equals(Object o) {
        if (o instanceof RGB) {
            RGB c = (RGB)o;
            return c.red == this.red && c.green == this.green && c.blue == this.blue && c.alpha == this.alpha;
        }
        return false;
    }

    public int hashCode() {
        return this.getInt();
    }
}

