/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.IO.Shaders;

import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.DragonAPIInit;
import Reika.DragonAPI.Exception.RegistrationException;
import Reika.DragonAPI.IO.ReikaFileReader;
import Reika.DragonAPI.IO.Shaders.ShaderProgram;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.IO.ReikaRenderHelper;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.shader.Framebuffer;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

@SideOnly(value=Side.CLIENT)
public class ShaderRegistry {
    private static final HashMap<String, ShaderProgram> shaders = new HashMap();
    private static final EnumMap<ShaderDomain, ArrayList<ShaderProgram>> shaderSets = new EnumMap(ShaderDomain.class);
    private static final int GLSL_VERSION = 120;
    private static String BASE_DATA;
    private static ShaderProgram currentlyRunning;

    private ShaderRegistry() {
        throw new RuntimeException("The class " + this.getClass() + " cannot be instantiated!");
    }

    public static ShaderProgram createShader(DragonAPIMod mod, String id, Class root, String pathPre, ShaderDomain dom) {
        if (!OpenGlHelper.field_148824_g) {
            return null;
        }
        if (shaders.containsKey(id)) {
            ShaderRegistry.error(mod, id, "Shader id " + id + " is already in use!", null);
        }
        ShaderProgram sh = new ShaderProgram(mod, root, pathPre, id, dom);
        try {
            sh.load();
        }
        catch (IOException e) {
            ShaderRegistry.error(mod, id, "Shader program data could not be loaded!", null, e);
        }
        shaders.put(sh.identifier, sh);
        ShaderRegistry.addShaderToSet(dom, sh);
        DragonAPICore.log("Registered " + mod.getTechnicalName() + " shader " + sh);
        return sh;
    }

    private static void addShaderToSet(ShaderDomain dom, ShaderProgram s) {
        ArrayList<ShaderProgram> li = shaderSets.get((Object)dom);
        if (li == null) {
            li = new ArrayList();
            shaderSets.put(dom, li);
        }
        li.add(s);
        Collections.sort(li);
    }

    private static void removeShaderFromSet(ShaderDomain dom, ShaderProgram s) {
        ArrayList<ShaderProgram> li = shaderSets.get((Object)dom);
        if (li != null) {
            li.remove(s);
        }
    }

    public static void reloadShader(String id) throws IOException {
        DragonAPICore.log("Reloading shader " + id);
        shaders.get(id).load();
    }

    public static void runShader(String id) {
        ShaderRegistry.runShader(shaders.get(id));
    }

    public static boolean runShader(ShaderProgram sh) {
        if (!OpenGlHelper.field_148824_g || sh == null) {
            return false;
        }
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return false;
        }
        if (currentlyRunning != null && currentlyRunning != sh) {
            ShaderRegistry.error(sh.owner, sh.identifier, "Cannot start one shader while another is running!", null);
        }
        if (ShaderRegistry.reloadKey()) {
            try {
                ShaderRegistry.reloadShader(sh.identifier);
            }
            catch (IOException e) {
                ShaderRegistry.error(sh.owner, sh.identifier, "Shader threw IOException during reload!", null, e);
            }
        }
        currentlyRunning = sh;
        if (GuiScreen.func_146271_m() && Keyboard.isKeyDown((int)56) && Keyboard.isKeyDown((int)46) && ReikaObfuscationHelper.isDeObfEnvironment()) {
            return false;
        }
        if (currentlyRunning.needsErrorChecking()) {
            while (GL11.glGetError() != 0) {
            }
        }
        return sh.run();
    }

    private static boolean reloadKey() {
        return GuiScreen.func_146271_m() && GuiScreen.func_146272_n() && Keyboard.isKeyDown((int)45);
    }

    public static void completeShader() {
        if (!OpenGlHelper.field_148824_g) {
            return;
        }
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        if (currentlyRunning == null) {
            ShaderRegistry.error(DragonAPIInit.instance, null, "Cannot stop a shader when none is running!", null);
        }
        GL20.glUseProgram((int)0);
        currentlyRunning.checkForError();
        currentlyRunning = null;
    }

    static int constructShader(DragonAPIMod mod, String name, InputStream data, ShaderTypes type) throws IOException {
        int id;
        if (data == null) {
            ShaderRegistry.error(mod, name, "Shader has null program data!", type);
        }
        if ((id = GL20.glCreateShader((int)type.glValue)) == 0) {
            ShaderRegistry.error(mod, name, "Shader was not able to be assigned an ID!", type);
        }
        if (BASE_DATA == null) {
            BASE_DATA = ShaderRegistry.readData(DragonAPICore.class.getResourceAsStream("Resources/shaderbase.txt"));
        }
        String sdata = "#version 120\n";
        if (type == ShaderTypes.FRAGMENT) {
            sdata = sdata + "uniform sampler2D bgl_RenderedTexture;\n";
        }
        sdata = sdata + BASE_DATA + "\n";
        sdata = sdata + ShaderRegistry.readData(data);
        GL20.glShaderSource((int)id, (CharSequence)sdata);
        GL20.glCompileShader((int)id);
        if (GL20.glGetShaderi((int)id, (int)35713) == 0) {
            ShaderRegistry.error(mod, name, "Shader was not able to be constructed: " + ShaderRegistry.parseError(id), type);
        }
        return id;
    }

    static void error(DragonAPIMod mod, String id, String msg, ShaderTypes type) {
        ShaderRegistry.error(mod, id, msg, type, null);
    }

    static void error(DragonAPIMod mod, String id, String msg, ShaderTypes type, Exception e) {
        String t;
        ShaderProgram p;
        if (id != null && (p = shaders.get(id)) != null) {
            p.markErrored();
        }
        String string = t = type != null ? type.name() : "";
        if (DragonAPICore.hasGameLoaded()) {
            String s = t + " shader error: " + msg;
            mod.getModLogger().logError(s);
            ReikaChatHelper.write(s);
            if (e != null) {
                e.printStackTrace();
            }
        } else {
            throw new RegistrationException(mod, t + " " + msg, e);
        }
    }

    private static String readData(InputStream data) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> li = ReikaFileReader.getFileAsLines(data, true);
        for (String s : li) {
            sb.append(s);
            sb.append("\n");
        }
        return sb.toString();
    }

    public static void runShaderDomain(Framebuffer fb, int w, int h, ShaderDomain sd) {
        ArrayList<ShaderProgram> li = shaderSets.get((Object)sd);
        if (li != null) {
            for (ShaderProgram s : li) {
                ReikaRenderHelper.renderFrameBufferToItself(fb, w, h, s);
            }
        }
    }

    public static String parseError(int programID) {
        return GL20.glGetShaderInfoLog((int)programID, (int)GL20.glGetShaderi((int)programID, (int)35716));
    }

    public static enum ShaderTypes {
        FRAGMENT(35632, "frag"),
        VERTEX(35633, "vert"),
        TESSELLATION(36487, "tess");

        public final int glValue;
        public final String extension;

        private ShaderTypes(int id, String s) {
            this.glValue = id;
            this.extension = s;
        }
    }

    public static enum ShaderDomain {
        BLOCK,
        WORLD,
        TESR,
        ENTITY,
        GUI,
        GLOBAL,
        GLOBALNOGUI;

    }
}

