/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.IO;

import Reika.DragonAPI.IO.ReikaFileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ReikaXMLBase {
    private ReikaXMLBase() {
        throw new RuntimeException("The class " + this.getClass() + " cannot be instantiated!");
    }

    public static Document getXMLDocument(InputStream in) throws SAXException, IOException {
        ArrayList<String> li = ReikaFileReader.getFileAsLines(in, true);
        while (!li.isEmpty() && !li.get(0).startsWith("<?xml version")) {
            li.remove(0);
        }
        in = ReikaFileReader.convertLinesToStream(li, true);
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(in);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Could not initialize XML Parser!", e);
        }
    }

    public static Node getNamedNode(String name, NodeList li) {
        for (int i = 0; i < li.getLength(); ++i) {
            Node n = li.item(0);
            if (!n.getNodeName().equals(name)) continue;
            return n;
        }
        return null;
    }

    public static String getNodeNameTree(Node n) {
        Node p;
        StringBuilder sb = new StringBuilder();
        ArrayList<Node> parents = new ArrayList<Node>();
        Node c = n;
        while ((p = c.getParentNode()) != null) {
            if (p.getNodeType() == 1) {
                parents.add(p);
            }
            c = p;
        }
        for (int i = parents.size() - 1; i >= 0; --i) {
            sb.append(((Node)parents.get(i)).getNodeName());
            if (i <= 0) continue;
            sb.append(":");
        }
        return sb.toString();
    }
}

