/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.IO;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.AbstractResourcePack;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public final class ReikaImageLoader {
    private static final BufferedImage missingtex = new BufferedImage(64, 64, 2);
    private static final TextureManager eng = Minecraft.func_71410_x().field_71446_o;
    public static final ImageEditor rgbToAlpha = new ImageEditor(){

        @Override
        public int getRGB(int raw) {
            return ReikaColorAPI.additiveBlend(raw);
        }
    };

    private ReikaImageLoader() {
        throw new RuntimeException("The class " + this.getClass() + " cannot be instantiated!");
    }

    public static BufferedImage readImage(Class root, String name, ImageEditor editor) {
        DragonAPICore.log("Pipelining texture from " + root.getCanonicalName() + " to " + name);
        InputStream inputfile = root.getResourceAsStream(name);
        if (inputfile == null) {
            DragonAPICore.logError("Image filepath at " + name + " not found. Loading \"MissingTexture\".");
            return missingtex;
        }
        Object bufferedimage = null;
        try {
            BufferedImage img = ImageIO.read(inputfile);
            if (editor != null) {
                for (int x = 0; x < img.getWidth(); ++x) {
                    for (int y = 0; y < img.getHeight(); ++y) {
                        img.setRGB(x, y, editor.getRGB(img.getRGB(x, y)));
                    }
                }
            }
            return img;
        }
        catch (IOException e) {
            DragonAPICore.logError("Default image filepath at " + name + " not found.");
            e.printStackTrace();
            return missingtex;
        }
    }

    public static BufferedImage getImageFromResourcePack(String path, IResourcePack res, ImageEditor editor) {
        DragonAPICore.log("Loading image at " + path + " from resourcepack " + res.func_130077_b());
        AbstractResourcePack pack = (AbstractResourcePack)res;
        InputStream in = ReikaTextureHelper.getStreamFromTexturePack(path, pack);
        if (in == null) {
            DragonAPICore.logError("Texture pack image at " + path + " not found in " + res.func_130077_b() + ".");
            return null;
        }
        try {
            return ImageIO.read(in);
        }
        catch (IOException e) {
            DragonAPICore.logError("Texture pack image at " + path + " not found in " + res.func_130077_b() + ".");
            return null;
        }
    }

    public static BufferedImage readHardPathImage(String path) {
        try {
            DragonAPICore.log("Loading image at \n" + path);
            FileInputStream in = new FileInputStream(path);
            return ImageIO.read(in);
        }
        catch (IOException e) {
            DragonAPICore.logError("Image filepath at " + path + " not found.");
            e.printStackTrace();
            return missingtex;
        }
    }

    public static boolean imageFileExists(Class root, String name) {
        InputStream inputfile = root.getResourceAsStream(name);
        if (inputfile == null) {
            return false;
        }
        BufferedImage bufferedimage = null;
        try {
            bufferedimage = ImageIO.read(inputfile);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static BufferedImage getMissingTex() {
        return missingtex;
    }

    public static void unstitchIconsFromSheet(IIcon[] icons, IIconRegister ico, String name, int numIcons) {
        IIcon[] icos = ReikaImageLoader.unstitchIcons(ico, name, numIcons);
        System.arraycopy(icos, 0, icons, 0, icos.length);
    }

    public static void unstitchIconsFromSheet(IIcon[][] icons, IIconRegister ico, String name, int cols, int rows) {
        IIcon[][] icos = ReikaImageLoader.unstitchIcons(ico, name, rows, cols);
        for (int i = 0; i < icos.length; ++i) {
            for (int k = 0; k < icos[i].length; ++k) {
                icons[i][k] = icos[i][k];
            }
        }
    }

    private static IIcon[] unstitchIcons(IIconRegister ico, String name, int numIcons) {
        TextureMap textureMap = (TextureMap)ico;
        IIcon[] icons = new IIcon[numIcons];
        for (int i = 0; i < numIcons; ++i) {
            String texName = name + "." + i;
            IconSheet texture = new IconSheet(texName, i, numIcons, 1);
            textureMap.setTextureEntry(texName, (TextureAtlasSprite)texture);
            icons[i] = texture;
        }
        return icons;
    }

    private static IIcon[][] unstitchIcons(IIconRegister ico, String name, int columns, int rows) {
        TextureMap textureMap = (TextureMap)ico;
        IIcon[][] icons = new IIcon[columns][rows];
        for (int i = 0; i < columns; ++i) {
            for (int k = 0; k < rows; ++k) {
                int n = i * rows + k;
                String texName = name + "." + n;
                IconSheet texture = new IconSheet(texName, n, columns, rows);
                textureMap.setTextureEntry(texName, (TextureAtlasSprite)texture);
                icons[i][k] = texture;
            }
        }
        return icons;
    }

    public static BufferedImage copyImage(BufferedImage buf) {
        BufferedImage ret = new BufferedImage(buf.getWidth(), buf.getHeight(), buf.getType());
        for (int i = 0; i < ret.getWidth(); ++i) {
            for (int k = 0; k < ret.getHeight(); ++k) {
                ret.setRGB(i, k, buf.getRGB(i, k));
            }
        }
        return ret;
    }

    static {
        Graphics graphics = missingtex.getGraphics();
        graphics.setColor(new Color(3080260));
        graphics.fillRect(0, 0, 64, 64);
        graphics.setColor(new Color(8350208));
        int i = 10;
        int j = 0;
        while (i < 64) {
            String s = j++ % 2 == 0 ? "missing" : "texture";
            graphics.drawString(s, 1, i);
            i += graphics.getFont().getSize();
            if (j % 2 != 0) continue;
            i += 5;
        }
        graphics.dispose();
    }

    private static class IconSheet
    extends TextureAtlasSprite {
        private int rowCount;
        private int colCount;
        public final int index;

        protected IconSheet(String tex, int index, int cols, int rows) {
            super(tex);
            this.rowCount = rows;
            this.colCount = cols;
            this.index = index;
        }

        public boolean load(IResourceManager manager, ResourceLocation location) {
            BufferedImage subImage;
            BufferedImage image;
            String fileName = location.func_110623_a().replace("." + this.index, "");
            try {
                IResource res = manager.func_110536_a(new ResourceLocation(location.func_110624_b(), fileName));
                image = ImageIO.read(res.func_110527_b());
            }
            catch (IOException ex) {
                DragonAPICore.logError("Failed to load sub-texture from " + fileName + ": " + ex.getLocalizedMessage());
                return true;
            }
            int size = image.getHeight() / this.rowCount;
            int x = this.index % this.colCount;
            int y = this.index / this.colCount;
            try {
                subImage = image.getSubimage(x * size, y * size, size, size);
            }
            catch (RasterFormatException e) {
                DragonAPICore.logError("Failed to load sub-texture from " + fileName + " - " + image.getWidth() + "x" + image.getHeight() + ": " + e.getLocalizedMessage());
                throw e;
            }
            this.field_130224_d = subImage.getHeight();
            this.field_130223_c = subImage.getWidth();
            int[] imageData = new int[this.field_130224_d * this.field_130223_c];
            subImage.getRGB(0, 0, this.field_130223_c, this.field_130224_d, imageData, 0, this.field_130224_d);
            this.field_110976_a.add(imageData);
            return true;
        }
    }

    public static interface ImageEditor {
        public int getRGB(int var1);
    }
}

