/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Extras;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.KeyedItemStack;
import Reika.DragonAPI.Instantiable.Event.AddSmeltingEvent;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.MTInteractionManager;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.common.MinecraftForge;

public class ReplacementSmeltingHandler {
    private static final HashMap<KeyedItemStack, FurnaceRecipe> smeltingList = new HashMap();
    private static final HashMap<KeyedItemStack, Float> outputToExperienceMap = new HashMap();
    private static final Collection<FurnaceRecipe> vanillaRecipes = new ArrayList<FurnaceRecipe>();
    private static final HashMap<KeyedItemStack, FurnaceRecipe> unpermutedSmeltingList = new HashMap();
    private static final ArrayList<MapChange<ItemStack, ItemStack>> MTChanges = new ArrayList();
    private static final HashMap<KeyedItemStack, Float> cachedMTExperience = new HashMap();
    private static boolean isMTRunning;
    private static final Collection<FurnaceRecipe> MTAddedRecipes;
    private static boolean isDeterminingMT;
    private static FurnaceRecipes loadingInstance;
    private static boolean isInitialized;
    private static boolean isCompiled;

    public static void onSmeltingInit(FurnaceRecipes obj) {
        if (isInitialized) {
            return;
        }
        loadingInstance = obj;
        Map map = ReplacementSmeltingHandler.getInstance().func_77599_b();
        for (Map.Entry e : map.entrySet()) {
            ItemStack in = (ItemStack)e.getKey();
            ItemStack out = (ItemStack)e.getValue();
            FurnaceRecipe r = new FurnaceRecipe(in, out, ReplacementSmeltingHandler.getInstance().func_151398_b(out));
            vanillaRecipes.add(r);
        }
        loadingInstance = null;
        isInitialized = true;
    }

    private static FurnaceRecipes getInstance() {
        return isInitialized ? FurnaceRecipes.func_77602_a() : loadingInstance;
    }

    public static void prepareForMinetweakerChanges() {
        DragonAPICore.log("Restoring furnace recipes to pre-Minetweaker state. Contains " + unpermutedSmeltingList.size() + " recipes (from " + smeltingList.size() + ").");
        smeltingList.clear();
        smeltingList.putAll(unpermutedSmeltingList);
        isMTRunning = true;
        DragonAPICore.log("Preparing to read Minetweaker changes to smelting recipes.");
    }

    public static void applyMinetweakerChanges() {
        ReplacementSmeltingHandler.handleDirectMapChanges();
        isMTRunning = false;
        DragonAPICore.log("Successfully applied " + MTChanges.size() + " Minetweaker changes to smelting recipes.");
        MTChanges.clear();
        cachedMTExperience.clear();
    }

    private static void handleDirectMapChanges() {
        if (!MTChanges.isEmpty()) {
            for (MapChange<ItemStack, ItemStack> chg : MTChanges) {
                ReplacementSmeltingHandler.log("Handling Minetweaker recipe change: " + chg);
                switch (((MapChange)chg).operation) {
                    case ADD: {
                        Float xp = cachedMTExperience.get(((MapChange)chg).key);
                        ReplacementSmeltingHandler.registerRecipe((ItemStack)((MapChange)chg).key, (ItemStack)((MapChange)chg).value, xp != null ? xp.floatValue() : 0.0f);
                        break;
                    }
                    case REMOVE: {
                        ReplacementSmeltingHandler.removeRecipe((ItemStack)((MapChange)chg).key);
                    }
                }
            }
        }
    }

    public static void build() {
        if (isCompiled) {
            return;
        }
        Map map = ReplacementSmeltingHandler.getInstance().func_77599_b();
        for (Map.Entry e : map.entrySet()) {
            ItemStack in = (ItemStack)e.getKey();
            ItemStack out = (ItemStack)e.getValue();
            AddSmeltingEvent.isVanillaPass = vanillaRecipes.contains(new FurnaceRecipe(in, out, 0.0f));
            ReplacementSmeltingHandler.registerRecipe(in, out, ReplacementSmeltingHandler.getInstance().func_151398_b(out));
        }
        AddSmeltingEvent.isVanillaPass = false;
        unpermutedSmeltingList.clear();
        unpermutedSmeltingList.putAll(smeltingList);
        ReplacementSmeltingHandler.determineMinetweakerRecipes();
        DragonAPICore.log("Compiled replacement smelting system.");
        isCompiled = true;
    }

    private static void determineMinetweakerRecipes() {
        ReplacementSmeltingHandler.log("Determining which smelting recipes are added by Minetweaker");
        MTAddedRecipes.clear();
        isDeterminingMT = true;
        MTInteractionManager.instance.reloadMT();
        isDeterminingMT = false;
        ReplacementSmeltingHandler.log("Found " + MTAddedRecipes.size() + " recipes: " + MTAddedRecipes.toString());
        for (FurnaceRecipe f : MTAddedRecipes) {
            unpermutedSmeltingList.remove(ReplacementSmeltingHandler.createKey(f.input));
        }
    }

    public static boolean checkRecipe(ItemStack in, ItemStack out, float xp) {
        AddSmeltingEvent evt = new AddSmeltingEvent(in, out, xp);
        if (MinecraftForge.EVENT_BUS.post((Event)evt)) {
            if (evt.isValid()) {
                ReplacementSmeltingHandler.log("Recipe for " + in + " to " + out + " was cancelled by another mod; it will not be added");
            } else {
                ReplacementSmeltingHandler.log("Recipe was marked invalid, it will not be added!");
            }
            return false;
        }
        if (isMTRunning) {
            if (isDeterminingMT) {
                MTAddedRecipes.add(new FurnaceRecipe(in, out, xp));
            } else {
                MTChanges.add(new MapChange(Operations.ADD, in, out));
                cachedMTExperience.put(ReplacementSmeltingHandler.createKey(in), Float.valueOf(xp));
            }
        }
        return true;
    }

    private static void registerRecipe(ItemStack in, ItemStack out, float xp) {
        FurnaceRecipe f = new FurnaceRecipe(in, out, xp);
        KeyedItemStack key = ReplacementSmeltingHandler.createKey(in);
        smeltingList.put(key, f);
        if (xp > 0.0f) {
            outputToExperienceMap.put(ReplacementSmeltingHandler.createKey(out), Float.valueOf(Math.max(ReplacementSmeltingHandler.getSmeltingXPByOutput(out), xp)));
        }
    }

    public static void fireEventsForVanillaRecipes() {
        AddSmeltingEvent.isVanillaPass = true;
        Map map = ReplacementSmeltingHandler.getInstance().func_77599_b();
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            ItemStack out;
            Map.Entry e = it.next();
            ItemStack in = (ItemStack)e.getKey();
            if (!vanillaRecipes.contains(new FurnaceRecipe(in, out = (ItemStack)e.getValue(), 0.0f))) continue;
            float xp = FurnaceRecipes.func_77602_a().func_151398_b(out);
            AddSmeltingEvent evt = new AddSmeltingEvent(in, out, xp);
            MinecraftForge.EVENT_BUS.post((Event)evt);
            if (evt.isCanceled()) {
                it.remove();
                continue;
            }
            if (xp == evt.experienceValue) continue;
            FurnaceRecipes.func_77602_a().field_77605_c.put(out, Float.valueOf(evt.experienceValue));
        }
        AddSmeltingEvent.isVanillaPass = false;
    }

    public static void removeRecipe(ItemStack in) {
        smeltingList.remove(ReplacementSmeltingHandler.createKey(in));
    }

    private static void modifyExperience(ItemStack is, float newXP) {
        FurnaceRecipe rec = smeltingList.get(ReplacementSmeltingHandler.createKey(is));
        if (rec != null) {
            rec.experience = newXP;
        }
    }

    public static ItemStack getResult(ItemStack is) {
        if (!isCompiled) {
            return ReplacementSmeltingHandler.getInstance().func_151395_a(is);
        }
        if (is == null) {
            throw new IllegalArgumentException("You cannot fetch the smelting recipes for null!");
        }
        if (is.func_77973_b() == null) {
            throw new IllegalArgumentException("You cannot fetch the smelting recipes for a stack with a null item!");
        }
        FurnaceRecipe rec = smeltingList.get(ReplacementSmeltingHandler.createKey(is));
        return rec != null ? rec.output.func_77946_l() : null;
    }

    public static float getSmeltingXPByOutput(ItemStack output) {
        if (!isCompiled) {
            return ReplacementSmeltingHandler.getInstance().func_151398_b(output);
        }
        float base = output.func_77973_b().getSmeltingExperience(output);
        if (base != -1.0f) {
            return base;
        }
        Float rec = outputToExperienceMap.get(ReplacementSmeltingHandler.createKey(output));
        return rec != null ? rec.floatValue() : 0.0f;
    }

    public static Map getList() {
        if (isMTRunning) {
            BackWritableHashMap<ItemStack, ItemStack> map = new BackWritableHashMap<ItemStack, ItemStack>();
            for (FurnaceRecipe r : smeltingList.values()) {
                map.put(r.getInput(), r.getOutput());
            }
            ((BackWritableHashMap)map).tracking = true;
            return map;
        }
        if (!isCompiled) {
            return ReplacementSmeltingHandler.getInstance().func_77599_b();
        }
        return ReplacementSmeltingHandler.buildGettableList();
    }

    private static Map buildGettableList() {
        HashMap<ItemStack, ItemStack> map = new HashMap<ItemStack, ItemStack>();
        for (FurnaceRecipe r : smeltingList.values()) {
            map.put(r.getInput(), r.getOutput());
        }
        return map;
    }

    private static KeyedItemStack createKey(ItemStack is) {
        return new KeyedItemStack(is).setSimpleHash(true).setIgnoreNBT(true).setIgnoreMetadata(is.func_77960_j() == Short.MAX_VALUE);
    }

    public static boolean isCompiled() {
        return isCompiled;
    }

    private static void log(String s) {
        DragonAPICore.log("Replacement Smelting System: " + s);
    }

    static {
        MTAddedRecipes = new ArrayList<FurnaceRecipe>();
    }

    private static enum Operations {
        ADD,
        REMOVE;


        public String toString() {
            return ReikaStringParser.capFirstChar(this.name());
        }
    }

    private static class MapChange<K, V> {
        private final Operations operation;
        private final K key;
        private final V value;

        private MapChange(Operations o, K k, V v) {
            this.operation = o;
            this.key = k;
            this.value = v;
        }

        public String toString() {
            return this.operation.toString() + " " + this.key + " > " + this.value;
        }
    }

    private static class BackWritableHashMap<K, V>
    extends HashMap<K, V> {
        private boolean tracking = false;

        private BackWritableHashMap() {
        }

        @Override
        public V put(K key, V val) {
            if (this.tracking) {
                MTChanges.add(new MapChange(Operations.ADD, (ItemStack)key, (ItemStack)val));
            }
            return super.put(key, val);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            if (this.tracking) {
                for (Map.Entry<K, V> e : map.entrySet()) {
                    MTChanges.add(new MapChange(Operations.ADD, (ItemStack)e.getKey(), (ItemStack)e.getValue()));
                }
            }
            super.putAll(map);
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException(".....Why?!");
        }

        @Override
        public V remove(Object key) {
            if (this.tracking) {
                MTChanges.add(new MapChange(Operations.REMOVE, (ItemStack)key, null));
            }
            return super.remove(key);
        }
    }

    public static class FurnaceRecipe
    implements Comparable<FurnaceRecipe> {
        private final ItemStack input;
        private final ItemStack output;
        private float experience;

        private FurnaceRecipe(ItemStack in, ItemStack out) {
            this(in, out, 0.0f);
        }

        private FurnaceRecipe(ItemStack in, ItemStack out, float xp) {
            if (in == null) {
                throw new IllegalArgumentException("You cannot smelt null to anything!");
            }
            if (out == null) {
                throw new IllegalArgumentException("You cannot smelt anything to null!");
            }
            this.input = in;
            this.output = out;
            this.experience = xp;
        }

        public ItemStack getInput() {
            return this.input.func_77946_l();
        }

        public ItemStack getOutput() {
            return this.output.func_77946_l();
        }

        public float getExperience() {
            return this.experience;
        }

        public int hashCode() {
            return ReplacementSmeltingHandler.createKey(this.input).hashCode() ^ ReplacementSmeltingHandler.createKey(this.output).hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof FurnaceRecipe) {
                FurnaceRecipe f = (FurnaceRecipe)o;
                return ReikaItemHelper.matchStacks(this.input, f.input) && ReikaItemHelper.matchStacks(this.output, f.output);
            }
            return false;
        }

        public String toString() {
            return this.input + " > " + this.output + " + " + this.experience + " xp";
        }

        @Override
        public int compareTo(FurnaceRecipe f) {
            return ReikaItemHelper.comparator.compare(this.input, f.input);
        }
    }
}

