/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Auxiliary.Trackers;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.DragonOptions;
import Reika.DragonAPI.Extras.ModifiedPlayerModel;
import Reika.DragonAPI.Extras.ReikaModel;
import Reika.DragonAPI.Extras.ReikaShader;
import Reika.DragonAPI.Extras.SamakiModel;
import Reika.DragonAPI.IO.ReikaFileReader;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Interfaces.PlayerRenderObj;
import Reika.DragonAPI.Libraries.IO.ReikaRenderHelper;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public final class PlayerSpecificRenderer {
    public static final PlayerSpecificRenderer instance = new PlayerSpecificRenderer();
    private final MultiMap<UUID, PlayerRenderObj> renders = new MultiMap().setNullEmpty().setOrdered(new RenderComparator());
    private final HashMap<UUID, String> glows = new HashMap();
    private final HashMap<UUID, String> customGlows = new HashMap();
    private final ReikaModel modelReika = new ReikaModel();
    private final SamakiModel modelSamaki = new SamakiModel();

    private PlayerSpecificRenderer() {
        this.registerRenderer(DragonAPICore.Reika_UUID, new PlayerModelRenderer(this.modelReika));
        this.registerRenderer(UUID.fromString("bca741d8-d934-4785-9c26-f6a4141be124"), new PlayerModelRenderer(this.modelSamaki));
        this.registerGlow(DragonAPICore.Reika_UUID, "reika_glow");
        this.registerGlow(UUID.fromString("bca741d8-d934-4785-9c26-f6a4141be124"), "samaki_glow");
        this.registerGlow(UUID.fromString("d859c5ea-37e9-43d7-b3b9-523e448bfda0"), "frey_glow");
    }

    public void registerIntercept() {
        Map map = RenderManager.field_78727_a.field_78729_o;
        map.put(EntityPlayer.class, new CustomPlayerRenderer((Render)map.get(EntityPlayer.class)));
    }

    public void registerRenderer(UUID uuid, PlayerRenderObj r) {
        this.renders.addValue(uuid, r);
    }

    private void registerGlow(UUID uuid, String s) {
        this.glows.put(uuid, "/Reika/DragonAPI/Resources/" + s + ".png");
    }

    public void loadGlowFiles() {
        File f = new File(DragonAPICore.getMinecraftDirectory(), "config/Reika/glowrenders.dat");
        if (f.exists()) {
            ArrayList<String> li = ReikaFileReader.getFileAsLines(f, true);
            for (String s : li) {
                try {
                    String[] parts = s.split("=");
                    UUID uid = UUID.fromString(parts[0]);
                    File img = new File(DragonAPICore.getMinecraftDirectory(), "config/Reika/glowrenders/" + parts[1]);
                    if (!img.exists()) {
                        throw new FileNotFoundException();
                    }
                    BufferedImage im = ImageIO.read(img);
                    if (im == null) continue;
                    this.customGlows.put(uid, "*" + img.getAbsolutePath());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DragonAPICore.logError("Could not load glow render entry " + s);
                }
            }
        }
    }

    private void renderAdditionalObjects(EntityPlayer ep, float ptick) {
        if (ReikaPlayerAPI.isReika(ep)) {
            ReikaShader.instance.prepareRender(ep);
        }
        if (ep == Minecraft.func_71410_x().field_71439_g && !DragonOptions.CUSTOMRENDER.getState()) {
            return;
        }
        Collection<PlayerRenderObj> c = this.renders.get(ep.func_110124_au());
        if (c != null) {
            for (PlayerRenderObj r : c) {
                r.render(ep, ptick, new PlayerRotationData(ep, ptick));
            }
        }
    }

    public String getGlow(UUID uid) {
        String s = this.glows.get(uid);
        if (s == null) {
            s = this.customGlows.get(uid);
        }
        return s;
    }

    private static class RenderComparator
    implements Comparator<PlayerRenderObj> {
        private RenderComparator() {
        }

        @Override
        public int compare(PlayerRenderObj o1, PlayerRenderObj o2) {
            int p2;
            int p1 = o1.getRenderPriority();
            return p1 < (p2 = o2.getRenderPriority()) ? -1 : (p1 > p2 ? 1 : 0);
        }
    }

    public static class PlayerRotationData {
        public final float rotationYaw;
        public final float rotationYawHead;
        public final float rotationPitch;
        private final float prevRotationYaw;
        private final float prevRotationYawHead;
        private final float prevRotationPitch;
        private final float partialTick;
        private float renderYaw;
        private float renderYawHead;
        private float renderPitch;
        public final float interpYaw;
        public final float interpYawHead;
        public final float interpPitch;

        private PlayerRotationData(EntityPlayer ep, float ptick) {
            this.rotationPitch = ep.field_70125_A;
            this.rotationYaw = ep.field_70177_z;
            this.rotationYawHead = ep.field_70759_as;
            this.partialTick = ptick;
            this.prevRotationPitch = ep.field_70127_C;
            this.prevRotationYaw = ep.field_70126_B;
            this.prevRotationYawHead = ep.field_70758_at;
            this.renderPitch = -ep.field_70125_A;
            this.renderYawHead = -ep.field_70177_z % 360.0f - this.partialTick * (ep.field_70177_z - ep.field_70126_B);
            this.renderYaw = -ep.field_70761_aq % 360.0f - this.partialTick * (ep.field_70761_aq - ep.field_70760_ar) + 180.0f;
            this.interpYaw = this.prevRotationYaw + (this.rotationYaw - this.prevRotationYaw) * this.partialTick;
            this.interpYawHead = this.prevRotationYawHead + (this.rotationYawHead - this.prevRotationYawHead) * this.partialTick;
            this.interpPitch = this.prevRotationPitch + (this.rotationPitch - this.prevRotationPitch) * this.partialTick;
            this.compensateAngles();
        }

        private void compensateAngles() {
            if (this.partialTick == 1.0f) {
                int ySize = 136;
                int xSize = 195;
                Minecraft mc = Minecraft.func_71410_x();
                ScaledResolution scr = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
                int width = scr.func_78326_a();
                int height = scr.func_78328_b();
                int guiLeft = (width - xSize) / 2;
                int guiTop = (height - ySize) / 2;
                float par1 = Mouse.getX() * width / mc.field_71443_c;
                float par2 = height - Mouse.getY() * height / mc.field_71440_d - 1;
                float par3 = (float)(guiLeft + 43) - par1;
                float par4 = (float)(guiTop + 45 - 30) - par2;
                this.renderYaw = -((float)Math.atan(par3 / 40.0f)) * 20.0f;
                this.renderYawHead = -((float)Math.atan(par3 / 40.0f)) * 40.0f;
                this.renderPitch = -((float)Math.atan(par4 / 40.0f)) * 20.0f;
                this.renderYawHead += 180.0f;
                this.renderYaw += 180.0f;
            }
        }

        public float getRenderYaw() {
            return this.renderYaw;
        }

        public float getRenderYawHead() {
            return this.renderYawHead;
        }

        public float getRenderPitch() {
            return this.renderPitch;
        }
    }

    private static final class CustomPlayerRenderer
    extends RenderPlayer {
        private CustomPlayerRenderer(Render original) {
            this.field_76990_c = RenderManager.field_78727_a;
        }

        protected void func_77043_a(EntityLivingBase ep, float par2, float par3, float partialTick) {
            super.func_77043_a(ep, par2, par3, partialTick);
            if (ep.func_70644_a(Potion.field_76441_p)) {
                return;
            }
            if (MinecraftForgeClient.getRenderPass() == 1 || MinecraftForgeClient.getRenderPass() == -1) {
                instance.renderAdditionalObjects((EntityPlayer)ep, partialTick);
            }
        }

        protected void func_77036_a(EntityLivingBase ep, float f1, float f2, float f3, float f4, float f5, float f6) {
            if (MinecraftForgeClient.getRenderPass() == 0 || MinecraftForgeClient.getRenderPass() == -1) {
                super.func_77036_a(ep, f1, f2, f3, f4, f5, f6);
            }
            if (ep.func_70644_a(Potion.field_76441_p)) {
                return;
            }
            String glow = instance.getGlow(ep.func_110124_au());
            if (glow != null) {
                GL11.glPushAttrib((int)1048575);
                GL11.glDisable((int)2896);
                ReikaRenderHelper.disableEntityLighting();
                GL11.glEnable((int)3042);
                ReikaGLHelper.BlendMode.DEFAULT.apply();
                if (glow.charAt(0) == '*') {
                    ReikaTextureHelper.bindRawTexture(glow.substring(1));
                } else {
                    ReikaTextureHelper.bindTexture(DragonAPICore.class, glow);
                }
                this.renderWithoutTextureBind(ep, f1, f2, f3, f4, f5, f6);
                GL11.glPopAttrib();
            }
        }

        public void func_82441_a(EntityPlayer ep) {
            super.func_82441_a(ep);
            String glow = instance.getGlow(ep.func_110124_au());
            if (glow != null) {
                GL11.glPushAttrib((int)1048575);
                GL11.glDisable((int)2896);
                ReikaRenderHelper.disableEntityLighting();
                GL11.glEnable((int)3042);
                ReikaGLHelper.BlendMode.DEFAULT.apply();
                if (glow.charAt(0) == '*') {
                    ReikaTextureHelper.bindRawTexture(glow.substring(1));
                } else {
                    ReikaTextureHelper.bindTexture(DragonAPICore.class, glow);
                }
                super.func_82441_a(ep);
                GL11.glPopAttrib();
            }
        }

        private void renderWithoutTextureBind(EntityLivingBase ep, float f1, float f2, float f3, float f4, float f5, float f6) {
            if (!ep.func_82150_aj()) {
                this.field_77045_g.func_78088_a((Entity)ep, f1, f2, f3, f4, f5, f6);
            } else if (!ep.func_98034_c((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                GL11.glPushMatrix();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.15f);
                GL11.glDepthMask((boolean)false);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glAlphaFunc((int)516, (float)0.003921569f);
                this.field_77045_g.func_78088_a((Entity)ep, f1, f2, f3, f4, f5, f6);
                GL11.glDisable((int)3042);
                GL11.glAlphaFunc((int)516, (float)0.1f);
                GL11.glPopMatrix();
                GL11.glDepthMask((boolean)true);
            } else {
                this.field_77045_g.func_78087_a(f1, f2, f3, f4, f5, f6, (Entity)ep);
            }
        }
    }

    private static class ModelReikaEars
    extends ModelRenderer {
        public ModelReikaEars(ModelBase b, int x, int y) {
            super(b, x, y);
            this.func_78789_a(3.2f, -5.0f, 3.5f, 2, 1, 5);
            this.func_78789_a(-3.2f, -5.0f, 3.5f, 2, 1, 5);
            this.func_78789_a(3.2f, -4.0f, 3.5f, 2, 1, 5);
            this.func_78789_a(-3.2f, -4.0f, 3.5f, 2, 1, 5);
            this.func_78793_a(-1.0f, -0.5f, -0.2f);
            this.field_78795_f = 35.0f;
            this.field_78796_g = 25.0f;
            this.field_78808_h = 30.0f;
            this.func_78787_b(64, 32);
        }
    }

    private class PlayerModelRenderer
    implements PlayerRenderObj {
        private final ModifiedPlayerModel model;

        private PlayerModelRenderer(ModifiedPlayerModel m) {
            this.model = m;
        }

        @Override
        public void render(EntityPlayer ep, float tick, PlayerRotationData dat) {
            if (ep != null) {
                GL11.glPushMatrix();
                this.model.bindTexture();
                GL11.glTranslated((double)0.0, (double)1.6, (double)0.0);
                GL11.glScaled((double)1.0, (double)-1.0, (double)1.0);
                if (ep.func_70093_af()) {
                    GL11.glRotated((double)22.5, (double)1.0, (double)0.0, (double)0.0);
                    GL11.glTranslated((double)-0.02, (double)0.1, (double)-0.05);
                }
                GL11.glPushAttrib((int)1048575);
                GL11.glFrontFace((int)2304);
                this.model.renderBodyParts(ep, tick);
                GL11.glPopAttrib();
                GL11.glPopMatrix();
            }
        }

        @Override
        public int getRenderPriority() {
            return Integer.MIN_VALUE;
        }
    }
}

