/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Auxiliary.Trackers;

import Reika.DragonAPI.APIPacketHandler;
import Reika.DragonAPI.Auxiliary.Trackers.TickRegistry;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Exception.InstallationException;
import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Instantiable.Data.Maps.PlayerMap;
import Reika.DragonAPI.Instantiable.Event.RawKeyPressEvent;
import Reika.DragonAPI.Interfaces.Configuration.StringConfig;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.input.Keyboard;

public class KeyWatcher {
    public static final KeyWatcher instance = new KeyWatcher();
    private final EnumMap<Key, KeyState> keyStates = new EnumMap(Key.class);

    private KeyWatcher() {
        for (int i = 0; i < Key.keyList.length; ++i) {
            this.keyStates.put(Key.keyList[i], new KeyState());
        }
    }

    public boolean isKeyDown(EntityPlayer ep, Key key) {
        return this.keyStates.get((Object)key).getKeyState(ep);
    }

    public void setKey(EntityPlayer ep, Key key, boolean press) {
        this.keyStates.get((Object)key).updateKey(ep, press);
    }

    @SideOnly(value=Side.CLIENT)
    public static class KeyTicker
    implements TickRegistry.TickHandler {
        public static final KeyTicker instance = new KeyTicker();
        private final EnumMap<Keys, Boolean> keyStates = new EnumMap(Keys.class);

        private KeyTicker() {
        }

        @Override
        public void tick(TickRegistry.TickType type, Object ... tickData) {
            EntityClientPlayerMP ep = Minecraft.func_71410_x().field_71439_g;
            if (ep != null) {
                for (int i = 0; i < Keys.keyList.length; ++i) {
                    boolean isPressed;
                    Keys key = Keys.keyList[i];
                    boolean wasPressed = this.keyStates.containsKey((Object)key) && this.keyStates.get((Object)key) != false;
                    if (wasPressed == (isPressed = key.pollKey())) continue;
                    this.keyStates.put(key, isPressed);
                    key.sendPacket();
                    instance.setKey((EntityPlayer)ep, key.getServerKey(), isPressed);
                    MinecraftForge.EVENT_BUS.post((Event)new RawKeyPressEvent(key.getServerKey(), (EntityPlayer)ep));
                }
            }
        }

        @Override
        public EnumSet<TickRegistry.TickType> getType() {
            return EnumSet.of(TickRegistry.TickType.CLIENT);
        }

        @Override
        public String getLabel() {
            return "KeyWatcher";
        }

        @Override
        public boolean canFire(TickEvent.Phase p) {
            return p == TickEvent.Phase.START;
        }
    }

    private static class KeyState {
        private final PlayerMap<Boolean> data = new PlayerMap();

        private KeyState() {
        }

        public boolean getKeyState(EntityPlayer ep) {
            return this.data.containsKey(ep) && this.data.get(ep) != false;
        }

        public void updateKey(EntityPlayer ep, boolean key) {
            this.data.put(ep, key);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static enum Keys {
        JUMP(Minecraft.func_71410_x().field_71474_y.field_74314_A),
        SNEAK(Minecraft.func_71410_x().field_71474_y.field_74311_E),
        FOWARD(Minecraft.func_71410_x().field_71474_y.field_74351_w),
        BACK(Minecraft.func_71410_x().field_71474_y.field_74368_y),
        LEFT(Minecraft.func_71410_x().field_71474_y.field_74370_x),
        RIGHT(Minecraft.func_71410_x().field_71474_y.field_74366_z),
        INVENTORY(Minecraft.func_71410_x().field_71474_y.field_151445_Q),
        DROPITEM(Minecraft.func_71410_x().field_71474_y.field_74316_C),
        ATTACK(Minecraft.func_71410_x().field_71474_y.field_74312_F),
        USE(Minecraft.func_71410_x().field_71474_y.field_74313_G),
        CHAT(Minecraft.func_71410_x().field_71474_y.field_74310_D),
        LCTRL(Minecraft.field_142025_a ? 219 : 29),
        PGUP(201),
        PGDN(209),
        TAB(15),
        TILDE(41),
        BACKSPACE(14),
        HOME(199),
        END(207),
        INSERT(210),
        DELETE(211),
        ENTER(28),
        MINUS(12),
        PLUS(13),
        PRTSCRN(183),
        PAUSE(197);

        private KeyBinding key;
        private int keyInt;
        public static final Keys[] keyList;

        private Keys(KeyBinding key) {
            this.key = key;
        }

        private Keys(int key) {
            this.keyInt = key;
        }

        public boolean pollKey() {
            return this.key != null ? this.key.func_151470_d() : Keyboard.isKeyDown((int)this.keyInt);
        }

        public int keyID() {
            return this.key.func_151463_i();
        }

        public Key getServerKey() {
            return Key.keyList[this.ordinal()];
        }

        private void sendPacket() {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream(8);
            DataOutputStream data = new DataOutputStream(bytes);
            boolean flag = false;
            try {
                data.writeInt(APIPacketHandler.PacketIDs.KEYUPDATE.ordinal());
                data.writeInt(this.ordinal());
                data.writeInt(this.pollKey() ? 1 : 0);
                flag = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (flag) {
                ReikaPacketHelper.sendRawPacket("DragonAPIData", bytes);
            } else {
                DragonAPICore.log("Could not send key " + (Object)((Object)this) + " packet, as it was malformed.");
            }
        }

        static {
            keyList = Keys.values();
        }
    }

    public static enum Key {
        JUMP,
        SNEAK,
        FORWARD,
        BACK,
        LEFT,
        RIGHT,
        INVENTORY,
        DROPITEM,
        ATTACK,
        USE,
        CHAT,
        LCTRL,
        LALT,
        PGUP,
        PGDN,
        TAB,
        TILDE,
        BACKSPACE,
        HOME,
        END,
        INSERT,
        DELETE,
        ENTER,
        MINUS,
        PLUS,
        PRTSCRN,
        PAUSE;

        public static final Key[] keyList;

        public static Key readFromConfig(DragonAPIMod mod, StringConfig cfg) {
            if (!cfg.isString()) {
                throw new MisuseException(mod, "Cannot read a key from a non-string config!");
            }
            String s = cfg.getString().toUpperCase(Locale.ENGLISH);
            try {
                return Key.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw new InstallationException(mod, "Invalid specified keybind for config entry '" + cfg.getLabel() + "'; no such key '" + s + "' exists! Valid options: " + Arrays.toString((Object[])Key.values()));
            }
        }

        static {
            keyList = Key.values();
        }
    }
}

