/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity.multiblock.controllers;

import com.cout970.magneticraft.api.electricity.IElectricConductor;
import com.cout970.magneticraft.api.electricity.IElectricTile;
import com.cout970.magneticraft.api.electricity.prefab.ElectricConductor;
import com.cout970.magneticraft.api.util.EnergyConverter;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.MgUtils;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.api.util.VecIntUtil;
import com.cout970.magneticraft.client.gui.component.IBarProvider;
import com.cout970.magneticraft.client.gui.component.IGuiSync;
import com.cout970.magneticraft.tileentity.TileCopperTank;
import com.cout970.magneticraft.tileentity.multiblock.TileMB_Base;
import com.cout970.magneticraft.util.fluid.TankMg;
import com.cout970.magneticraft.util.multiblock.Multiblock;
import com.cout970.magneticraft.util.tile.AverageBar;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TileSteamTurbineControl
extends TileMB_Base
implements IGuiSync {
    private static final int MAX_STEAM = 1200;
    public TankMg[] in = new TankMg[4];
    public IElectricConductor out;
    public AverageBar energy = new AverageBar(20);
    public AverageBar steam = new AverageBar(20);
    public int drawCounter;
    public float animation;
    public float speed;
    private long time;
    private double[] flow = new double[1];
    public IElectricConductor cond = new ElectricConductor(this, 1, 0.01){

        @Override
        public double getVoltageCapacity() {
            return 10.0;
        }
    };

    private void updateConductor() {
        if (this.out == null) {
            return;
        }
        ElectricConductor.valance(this.cond, this.out, this.flow, 0);
    }

    public boolean isActive() {
        return this.func_145832_p() > 6;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.drawCounter > 0) {
            --this.drawCounter;
        }
        if (!this.isActive()) {
            return;
        }
        if (this.in[0] == null || this.out == null || this.field_145850_b.func_82737_E() % 200L == 0L) {
            this.search();
            return;
        }
        float activity = 0.5f * ((float)this.getFluidAmount() / 64000.0f);
        if (activity < 0.01f) {
            activity = 0.0f;
        }
        if (this.speed < activity) {
            this.speed += 0.03125f;
        } else if (this.speed > activity) {
            this.speed -= 0.03125f;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.energy.tick();
        this.steam.tick();
        this.updateConductor();
        this.balanceTanks();
        double miss = (100.0 - this.cond.getVoltage() / this.cond.getVoltageMultiplier()) * 200.0;
        int steam = (int)Math.min(Math.min(this.getFluidAmount() > 1000 ? (double)(this.getFluidAmount() + 1000) : (double)this.getFluidAmount(), miss), 1200.0);
        steam = (int)Math.min((float)steam, (float)(this.getFluidAmount() + 1000) / 64000.0f * 1200.0f);
        if (steam > 0 && this.cond.getVoltage() < 10000.0) {
            this.drain(steam, true);
            double power = EnergyConverter.STEAMtoW(steam);
            this.cond.applyPower(power);
            this.energy.addValue((float)power);
            this.steam.addValue(steam);
        }
    }

    private void balanceTanks() {
        int sum = this.getFluidAmount();
        int rest = sum % 4;
        for (TankMg t : this.in) {
            if (t == null) continue;
            t.setFluid(null);
            t.fill(FluidRegistry.getFluidStack((String)"steam", (int)(sum / 4)), true);
            if (rest <= 0) continue;
            rest -= t.fill(FluidRegistry.getFluidStack((String)"steam", (int)rest), true);
        }
    }

    public void drain(int steam, boolean b) {
        for (int i = 0; i < 4; ++i) {
            if (this.in[i].getFluid() == null || this.in[i].getFluid().getFluid() != FluidRegistry.getFluid((String)"steam")) continue;
            int extract = Math.min(this.in[i].getFluidAmount(), steam);
            this.in[i].drain(extract, b);
            steam -= extract;
        }
    }

    public int getFluidAmount() {
        int steam = 0;
        for (int i = 0; i < 4; ++i) {
            if (this.in[i] == null || this.in[i].getFluid() == null || this.in[i].getFluid().getFluid() != FluidRegistry.getFluid((String)"steam")) continue;
            steam += this.in[i].getFluidAmount();
        }
        return steam;
    }

    private void search() {
        VecInt vec = this.getDirection().toVecInt().getOpposite();
        TileEntity t = MgUtils.getTileEntity((TileEntity)this, vec.copy().add(this.getDirection().opposite().step(MgDirection.UP).toVecInt()));
        if (t instanceof TileCopperTank) {
            this.in[0] = ((TileCopperTank)t).getTank();
        }
        if ((t = MgUtils.getTileEntity((TileEntity)this, vec.copy().add(this.getDirection().opposite().step(MgDirection.DOWN).toVecInt()))) instanceof TileCopperTank) {
            this.in[1] = ((TileCopperTank)t).getTank();
        }
        if ((t = MgUtils.getTileEntity((TileEntity)this, vec.copy().multiply(2).add(this.getDirection().opposite().step(MgDirection.UP).toVecInt()))) instanceof TileCopperTank) {
            this.in[2] = ((TileCopperTank)t).getTank();
        }
        if ((t = MgUtils.getTileEntity((TileEntity)this, vec.copy().multiply(2).add(this.getDirection().opposite().step(MgDirection.DOWN).toVecInt()))) instanceof TileCopperTank) {
            this.in[3] = ((TileCopperTank)t).getTank();
        }
        if ((t = MgUtils.getTileEntity((TileEntity)this, vec.copy().add(new VecInt(0, 1, 0)))) instanceof IElectricTile) {
            this.out = ((IElectricTile)t).getConds(vec.getOpposite(), 1)[0];
        }
    }

    @Override
    public void onDestroy(World w, VecInt p, Multiblock c, MgDirection e) {
        this.setActive(false);
        this.in = new TankMg[4];
        this.out = null;
    }

    @Override
    public void onActivate(World w, VecInt p, Multiblock c, MgDirection e) {
        this.setActive(true);
    }

    private void setActive(boolean b) {
        if (b) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145832_p() % 6 + 6, 2);
        } else {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145832_p() % 6, 2);
        }
    }

    public int getCapacity() {
        return 64000;
    }

    @Override
    public void sendGUINetworkData(Container cont, ICrafting craft) {
        if (this.out != null) {
            craft.func_71112_a(cont, 0, (int)this.cond.getVoltage());
        }
        craft.func_71112_a(cont, 1, (int)this.energy.getAverage() * 16);
        for (int i = 0; i < 4; ++i) {
            if (this.in[i] == null) continue;
            if (this.in[i].getFluidAmount() > 0) {
                craft.func_71112_a(cont, i * 2 + 2, this.in[i].getFluid().getFluidID());
                craft.func_71112_a(cont, i * 2 + 3, this.in[i].getFluidAmount());
                continue;
            }
            craft.func_71112_a(cont, i * 2 + 2, -1);
        }
        craft.func_71112_a(cont, 10, (int)this.steam.getAverage() * 16);
    }

    @Override
    public void getGUINetworkData(int id, int value) {
        switch (id) {
            case 0: {
                this.cond.setVoltage(value);
                break;
            }
            case 1: {
                this.energy.setStorage((float)value / 16.0f);
                break;
            }
            case 10: {
                this.steam.setStorage((float)value / 16.0f);
                break;
            }
            default: {
                int i;
                if (id < 2 || id > 9 || this.in[i = (id - 2) / 2] == null) break;
                if (id - i * 2 + 2 != 0) {
                    if (this.in[i].getFluid() == null) break;
                    this.in[i].setFluid(new FluidStack(this.in[i].getFluid(), value));
                    break;
                }
                if (value == -1) {
                    this.in[i].setFluid(null);
                    break;
                }
                this.in[i].setFluid(new FluidStack(FluidRegistry.getFluid((int)value), 1));
            }
        }
    }

    @Override
    public MgDirection getDirection() {
        return MgDirection.getDirection(this.func_145832_p() % 6);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        VecInt v1 = VecIntUtil.getRotatedOffset(this.getDirection().opposite(), -1, -1, 0);
        VecInt v2 = VecIntUtil.getRotatedOffset(this.getDirection().opposite(), 1, 1, 4);
        VecInt block = new VecInt(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return VecIntUtil.getAABBFromVectors(v1.add(block), v2.add(block));
    }

    public float getDelta() {
        long aux = this.time;
        this.time = System.nanoTime();
        return this.time - aux;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList conduit = nbt.func_150295_c("Capacity_cond", 10);
        NBTTagCompound conduit_nbt = conduit.func_150305_b(0);
        this.cond.load(conduit_nbt);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagList conduit = new NBTTagList();
        NBTTagCompound conduit_nbt = new NBTTagCompound();
        this.cond.save(conduit_nbt);
        conduit.func_74742_a((NBTBase)conduit_nbt);
        nbt.func_74782_a("Capacity_cond", (NBTBase)conduit);
    }

    public IBarProvider getProductionBar() {
        return new IBarProvider(){

            @Override
            public String getMessage() {
                return String.format("Generating: %.3f kW", (double)TileSteamTurbineControl.this.energy.getStorage() / 1000.0);
            }

            @Override
            public float getMaxLevel() {
                return (float)EnergyConverter.STEAMtoW(1200.0);
            }

            @Override
            public float getLevel() {
                return Math.min(TileSteamTurbineControl.this.energy.getStorage(), this.getMaxLevel());
            }
        };
    }

    public IBarProvider getSteamConsumptionBar() {
        return new IBarProvider(){

            @Override
            public String getMessage() {
                return String.format("Consuming %.1f mB/t", Float.valueOf(TileSteamTurbineControl.this.steam.getStorage()));
            }

            @Override
            public float getMaxLevel() {
                return 1200.0f;
            }

            @Override
            public float getLevel() {
                return Math.min(TileSteamTurbineControl.this.steam.getStorage(), this.getMaxLevel());
            }
        };
    }
}

