/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.parts.fluid;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.ISidedHollowConnect;
import com.cout970.magneticraft.ManagerItems;
import com.cout970.magneticraft.api.pressure.IExplodable;
import com.cout970.magneticraft.api.pressure.IPressureConductor;
import com.cout970.magneticraft.api.pressure.PressureUtils;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.MgUtils;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.client.tilerender.TileRenderBrassPipe;
import com.cout970.magneticraft.parts.fluid.PartPressurePipe;
import com.cout970.magneticraft.util.network.BasicNetwork;
import com.cout970.magneticraft.util.network.pressure.NodePressureConductor;
import com.cout970.magneticraft.util.network.pressure.PressureNetwork;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class PartBrassPipe
extends PartPressurePipe
implements ISidedHollowConnect,
IExplodable {
    public byte connections = (byte)-1;
    public int interactions;
    public static List<Cuboid6> boxes = new ArrayList<Cuboid6>();
    public NodePressureConductor pressure;
    public NBTTagCompound tempNBT;
    private static TileRenderBrassPipe render;

    public PartBrassPipe() {
        super(ManagerItems.part_brass_pipe);
    }

    public void update() {
        super.update();
        if (this.pressure == null && this.tile() != null) {
            this.create();
        }
        if ((this.connections == -1 || this.W().field_72995_K) && this.W().func_82737_E() % 20L == 0L) {
            this.recache();
        }
        if (this.W().field_72995_K) {
            return;
        }
        if (this.tempNBT != null) {
            this.pressure.load(this.tempNBT);
            this.tempNBT = null;
        }
        this.pressure.iterate();
        if (this.W().func_82737_E() % 200L == 0L && !this.W().field_72995_K) {
            this.sendDescUpdate();
        }
    }

    public void onRemoved() {
        if (this.network != null) {
            this.network.removeNode(this);
        }
    }

    private void create() {
        this.pressure = new NodePressureConductor((TileEntity)this.tile(), 360.0, this);
    }

    public void recache() {
        this.connections = 0;
        for (MgDirection dir : MgDirection.values()) {
            TileEntity t = MgUtils.getTileEntity((TileEntity)this.tile(), dir);
            List<IPressureConductor> conds = PressureUtils.getPressureCond(t, dir.opposite().toVecInt());
            if (conds.isEmpty()) continue;
            this.connections = (byte)(this.connections | 1 << dir.ordinal());
        }
    }

    @Override
    public List<Cuboid6> getOcclusionCubes() {
        return Collections.singletonList(boxes.get(6));
    }

    @Override
    public List<Cuboid6> getCollisionCubes() {
        ArrayList<Cuboid6> t2 = new ArrayList<Cuboid6>();
        t2.add(boxes.get(6));
        for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
            if ((this.connections & 1 << i) <= 0) continue;
            t2.add(boxes.get(i));
        }
        return t2;
    }

    public int getHollowSize(int arg0) {
        return 4;
    }

    @Override
    public void renderPart(Vector3 pos) {
        if (render == null) {
            render = new TileRenderBrassPipe();
        }
        render.render(this, pos);
    }

    @Override
    public void explode(World world, int x, int y, int z, boolean explodeNeighbors) {
        if (!world.field_72995_K) {
            world.func_147449_b(x, y, z, Blocks.field_150350_a);
            if (explodeNeighbors) {
                for (MgDirection dir : MgDirection.values()) {
                    VecInt pos = new VecInt((TileEntity)this.tile()).add(dir);
                    IExplodable exp = PressureUtils.getExplodable(world, pos);
                    if (exp == null) continue;
                    exp.explode(world, pos.getX(), pos.getY(), pos.getZ(), explodeNeighbors);
                }
            }
            Explosion e = world.func_72876_a(null, (double)x, (double)y, (double)z, 1.0f, true);
            e.func_77278_a();
        }
    }

    @Override
    public IPressureConductor getPressureConductor() {
        return this.pressure;
    }

    public void save(NBTTagCompound nbt) {
        super.save(nbt);
        if (this.tile() == null) {
            return;
        }
        if (this.pressure != null) {
            this.pressure.save(nbt);
        }
    }

    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        this.tempNBT = nbt;
    }

    public void writeDesc(MCDataOutput p) {
        super.writeDesc(p);
        if (this.pressure == null) {
            p.writeDouble(0.0);
            p.writeDouble(0.0);
            p.writeDouble(0.0);
            p.writeString("null");
        } else {
            p.writeDouble(this.pressure.getVolume());
            p.writeDouble(this.pressure.getTemperature());
            p.writeDouble(this.pressure.getMoles());
            if (this.pressure.getFluid() != null) {
                p.writeString(FluidRegistry.getFluidName((Fluid)this.pressure.getFluid()));
            } else {
                p.writeString("null");
            }
        }
    }

    public void readDesc(MCDataInput p) {
        super.readDesc(p);
        if (this.pressure == null) {
            p.readDouble();
            p.readDouble();
            p.readDouble();
            p.readString();
        } else {
            this.pressure.setVolume(p.readDouble());
            this.pressure.setTemperature(p.readDouble());
            this.pressure.setMoles(p.readDouble());
            String s = p.readString();
            if (!s.equals("null")) {
                Fluid f = FluidRegistry.getFluid((String)s);
                if (f != null) {
                    this.pressure.setFluid(f);
                }
            } else {
                this.pressure.setFluid(null);
            }
        }
    }

    @Override
    public NodePressureConductor getConductor() {
        return this.pressure;
    }

    @Override
    public BasicNetwork createNetwork() {
        return new PressureNetwork(this);
    }

    @Override
    public BasicNetwork getNetwork() {
        if (this.network == null) {
            this.network = this.createNetwork();
            ((PressureNetwork)this.network).getPressureCond().network = (PressureNetwork)this.network;
            this.network.refresh();
        }
        return this.network;
    }

    static {
        double w = 0.125;
        boxes.add(new Cuboid6(0.5 - w, 0.0, 0.5 - w, 0.5 + w, 0.5 - w, 0.5 + w));
        boxes.add(new Cuboid6(0.5 - w, 0.5 + w, 0.5 - w, 0.5 + w, 1.0, 0.5 + w));
        boxes.add(new Cuboid6(0.5 - w, 0.5 - w, 0.0, 0.5 + w, 0.5 + w, 0.5 - w));
        boxes.add(new Cuboid6(0.5 - w, 0.5 - w, 0.5 + w, 0.5 + w, 0.5 + w, 1.0));
        boxes.add(new Cuboid6(0.0, 0.5 - w, 0.5 - w, 0.5 - w, 0.5 + w, 0.5 + w));
        boxes.add(new Cuboid6(0.5 + w, 0.5 - w, 0.5 - w, 1.0, 0.5 + w, 0.5 + w));
        boxes.add(new Cuboid6(0.5 - w, 0.5 - w, 0.5 - w, 0.5 + w, 0.5 + w, 0.5 + w));
    }
}

