/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.client.gui;

import com.cout970.magneticraft.api.electricity.IElectricConductor;
import com.cout970.magneticraft.client.gui.GuiBasic;
import com.cout970.magneticraft.client.gui.component.CompBackground;
import com.cout970.magneticraft.client.gui.component.CompButtonRedstoneControl;
import com.cout970.magneticraft.client.gui.component.CompEnergyBar;
import com.cout970.magneticraft.client.gui.component.GuiPoint;
import com.cout970.magneticraft.client.gui.component.IGuiComp;
import com.cout970.magneticraft.tileentity.TileBattery;
import com.cout970.magneticraft.util.RenderUtil;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;

public class GuiBattery
extends GuiBasic {
    public GuiBattery(Container c, TileEntity tile) {
        super(c, tile);
    }

    @Override
    public void initComponents() {
        this.comp.add(new CompBackground(new ResourceLocation("Magneticraft".toLowerCase(Locale.US) + ":textures/gui/battery.png")));
        this.comp.add(new CompEnergyBar(new ResourceLocation("Magneticraft".toLowerCase(Locale.US) + ":textures/gui/energybar.png"), new GuiPoint(47, 16), ((TileBattery)this.tile).cond));
        this.comp.add(new CompBatteryBar(new ResourceLocation("Magneticraft".toLowerCase(Locale.US) + ":textures/gui/energybar.png"), new GuiPoint(69, 16)));
        this.comp.add(new CompButtonRedstoneControl(new GuiPoint(150, 8)));
    }

    public class CompBatteryBar
    implements IGuiComp {
        public ResourceLocation texture;
        public GuiPoint pos;

        public CompBatteryBar(ResourceLocation tex, GuiPoint p) {
            this.texture = tex;
            this.pos = p;
        }

        @Override
        public void render(int mx, int my, TileEntity tile, GuiBasic gui) {
            if (tile instanceof TileBattery) {
                TileBattery bat = (TileBattery)tile;
                IElectricConductor c = bat.cond;
                int scale = c.getStorage() * 50 / c.getMaxStorage();
                gui.field_146297_k.field_71446_o.func_110577_a(this.texture);
                RenderUtil.drawTexturedModalRectScaled(gui.xStart + this.pos.x, gui.yStart + this.pos.y + (50 - scale), 30, 50 - scale, 16, scale, 70, 50);
                if (c.getVoltage() > 85.0 && c.getStorage() < c.getMaxStorage() && bat.getChargeRate() > 0.0) {
                    gui.field_146297_k.field_71446_o.func_110577_a(RenderUtil.MISC_ICONS);
                    RenderUtil.drawTexturedModalRectScaled(gui.xStart + 57, gui.yStart + 21, 10, 0, 7, 6, 50, 20);
                }
                if (c.getVoltage() < 75.0 && c.getStorage() > 0 && bat.getDischargeRate() > 0.0) {
                    gui.field_146297_k.field_71446_o.func_110577_a(RenderUtil.MISC_ICONS);
                    RenderUtil.drawTexturedModalRectScaled(gui.xStart + 57, gui.yStart + 53, 10, 6, 7, 6, 50, 20);
                }
            }
        }

        @Override
        public void onClick(int mx, int my, int button, GuiBasic gui) {
        }

        @Override
        public boolean onKey(int n, char key, GuiBasic gui) {
            return false;
        }

        @Override
        public void renderTop(int mx, int my, TileEntity tile, GuiBasic gui) {
            if (tile instanceof TileBattery) {
                IElectricConductor c = ((TileBattery)tile).cond;
                if (GuiBasic.isIn(mx, my, gui.xStart + this.pos.x, gui.yStart + this.pos.y, 16, 50)) {
                    ArrayList<String> data = new ArrayList<String>();
                    data.add(String.format("%.3fkJ", Float.valueOf((float)c.getStorage() / 1000.0f)));
                    gui.drawHoveringText2(data, mx - gui.xStart, my - gui.yStart);
                    RenderHelper.func_74520_c();
                } else if (GuiBasic.isIn(mx, my, gui.xStart + 57, gui.yStart + 20, 8, 8)) {
                    ArrayList<String> data = new ArrayList<String>();
                    data.add(String.format(EnumChatFormatting.DARK_GREEN + "+%.3fkW", ((TileBattery)tile).getChargeRate() / 1000.0));
                    gui.drawHoveringText2(data, mx - gui.xStart, my - gui.yStart);
                    RenderHelper.func_74520_c();
                } else if (GuiBasic.isIn(mx, my, gui.xStart + 57, gui.yStart + 53, 8, 8)) {
                    ArrayList<String> data = new ArrayList<String>();
                    data.add(String.format(EnumChatFormatting.DARK_RED + "-%.3fkW", ((TileBattery)tile).getDischargeRate() / 1000.0));
                    gui.drawHoveringText2(data, mx - gui.xStart, my - gui.yStart);
                    RenderHelper.func_74520_c();
                }
            }
        }
    }
}

